include	clib.inc
include	clip.inc
include	conio.inc
include	tinfo.inc
include	keyb.inc
include	mouse.inc
include	string.inc
include	dos.inc
include	ctype.inc

ifdef __TE__
tienter		proto
tienterni	proto
tigetline	proto 		; AX line
tiexpand	proto
tistrip		proto
tistripl	proto
tistripline	proto
tiremline	proto
tistyle		proto
endif
	.data

ti_keytable label size_t
	d? _TI_CONTINUE
	d? KEY_ESC
	d? KEY_LEFT
	d? KEY_RIGHT
	d? KEY_HOME
	d? KEY_END
	d? KEY_BKSP
	d? KEY_TAB
	d? KEY_DEL
	d? MOUSECMD
	d? KEY_CTRLRIGHT
	d? KEY_CTRLLEFT
	d? KEY_ENTER
	d? KEY_KPENTER
	d? KEY_UP
	d? KEY_DOWN
ifdef __TE__
	d? KEY_PGUP
	d? KEY_PGDN
	d? KEY_CTRLPGUP
	d? KEY_CTRLPGDN
	d? KEY_CTRLHOME
	d? KEY_CTRLEND
	d? KEY_CTRLUP	; Scroll up one line
	d? KEY_CTRLDN	; Scroll down one line
endif

ti_proctab label size_t
	d? ticontinue
	d? tiesc
	d? tileft
	d? tiright
	d? tihome
	d? titoend
	d? tibacksp
	d? titab
	d? tidelete
	d? timouse
	d? tinextword
	d? tiprevword
  ifdef __TE__
	d? tienter
	d? tienter
	d? tiup
	d? tidown
	d? tipgup
	d? tipgdn
	d? tictrlhome
	d? tictrlend
	d? tictrlpgup
	d? tictrlpgdn
	d? tiscrollup
	d? tiscrolldn
  else
	d? tiesc
	d? tiesc
	d? tiesc
	d? tiesc
  endif

ti_key_count = (($ - offset ti_proctab) / size_l)

	cp_linetolong db 'Line too long, was truncated',0
public	cp_linetolong

	.code

tinocando proc public
	invoke	beep,9,1
	mov	rax,_TI_CMFAILED	; end of line/buffer
	ret
tinocando endp

ticurlp proc public uses rbx
	mov	rbx,tinfo
    ifdef __TE__
	mov	rax,[rbx].S_TINFO.ti_loff	; this return ZF set if	NULL
	add	rax,[rbx].S_TINFO.ti_yoff
	call	tigetline
	jz	@F
	call	tistrlen
	test	rdx,rdx
      @@:
    else
	lodm	[rbx].S_TINFO.ti_bp
    endif
	ret
ticurlp endp

ticurcp proc public uses rbx
	mov	rbx,tinfo
	call	ticurlp
	add	rax,[rbx].S_TINFO.ti_boff	; no ZF flag if	__TE__
	add	rax,[rbx].S_TINFO.ti_xoff
	ret
ticurcp endp

ticontinue proc public
	sub rax,rax
	ret
ticontinue endp

tiretevent proc public
	mov rax,_TI_RETEVENT
	ret
tiretevent endp

tiesc proc public
	jmp tiretevent
tiesc endp

tileft proc uses rbx
	mov rbx,tinfo
	sub rax,rax
	.if rax == [rbx].S_TINFO.ti_xoff
	    .if rax == [rbx].S_TINFO.ti_boff
		mov rax,_TI_CMFAILED
	    .else
		dec [rbx].S_TINFO.ti_boff
	    .endif
	.else
	    dec [rbx].S_TINFO.ti_xoff
	.endif
	ret
tileft	endp

tiincvalue proc pascal uses rsi rdi rdx boff:dword, soff:dword,
	bmax:size_t, smax:size_t
	mov rsi,word_ptr boff
	mov rdi,word_ptr soff
	mov rax,[rsi]
	add rax,[rdi]
	inc rax
	.if rax >= bmax
	    sub rax,rax
	.else
	    mov rdx,[rsi]
	    mov rax,[rdi]
	    inc rax
	    .if rax >= smax
		mov rax,smax
		dec rax
		inc rdx
	    .endif
	    mov [rdi],rax
	    mov [rsi],rdx
	.endif
	ret
tiincvalue endp

tiincx proc uses rbx rax
	mov rbx,tinfo
	invoke tiincvalue,addr [rbx].S_TINFO.ti_boff,addr [rbx].S_TINFO.ti_xoff,
		[rbx].S_TINFO.ti_bcol,[rbx].S_TINFO.ti_cols
	ret
tiincx endp

tiright	proc uses rdi rbx
	mov	rbx,tinfo
    ifdef __TE__
	test	[rbx].S_TINFO.ti_flag,_T_LINEBUF
	jz	@F
	call	tiincx
	jmp	tiright_ok
      @@:
    endif
	call	ticurcp
	mov16	es,dx
	mov	rdi,rax
	mov	al,PEDI
	sub	rdi,[rbx].S_TINFO.ti_xoff
	test	al,al
	jz	tiright_00
	mov	rax,[rbx].S_TINFO.ti_cols
	dec	rax
	cmp	rax,[rbx].S_TINFO.ti_xoff
	jbe	tiright_00
	inc	[rbx].S_TINFO.ti_xoff
    tiright_ok:
	call	ticontinue
    tiright_end:
	ret
    tiright_00:
	invoke	strlen,esdi
	cmp	rax,[rbx].S_TINFO.ti_cols
	jb	tiright_eof
	inc	[rbx].S_TINFO.ti_boff
	jmp	tiright_ok
    tiright_eof:
	call	tinocando
	jmp	tiright_end
tiright	endp

tihome proc public uses rbx
    ifdef __TE__
	call	tistripline
    endif
	mov	rbx,tinfo
	sub	rax,rax
	mov	[rbx].S_TINFO.ti_xoff,rax
	mov	[rbx].S_TINFO.ti_boff,rax
	ret
tihome endp

titoend proc public uses rbx
    ifdef __TE__
	call	tistripline
    endif
	mov	rbx,tinfo
	mov	rdx,[rbx].S_TINFO.ti_cols
	dec	rdx
	mov	rax,[rbx].S_TINFO.ti_bcnt
	cmp	rax,rdx
	jle	@F
	mov	rax,rdx
      @@:
	mov	[rbx].S_TINFO.ti_xoff,rax
	mov	rdx,[rbx].S_TINFO.ti_bcnt
	sub	rdx,[rbx].S_TINFO.ti_cols
	inc	rdx
	xor	rax,rax
	cmp	rax,rdx
	jg	@F
	mov	rax,rdx
      @@:
	mov	[rbx].S_TINFO.ti_boff,rax
	add	rax,[rbx].S_TINFO.ti_xoff
	cmp	rax,[rbx].S_TINFO.ti_bcnt
	jbe	@F
	dec	[rbx].S_TINFO.ti_boff
      @@:
	call	ticontinue
	ret
titoend endp

; set byte count in line to .ti_bcnt
; set line[size-1]=0
; return CX strlen(DX:AX)

tistrlen proc uses rsi rdi rbx
	mov	rbx,tinfo
	push16	es
	mov16	es,dx
	mov	rsi,rax
	mov	rdi,rax
	xor	rax,rax
	add	rdi,[rbx].S_TINFO.ti_bcol
	dec	rdi
	mov	PEDI,al
	mov	rdi,rsi
	mov	rcx,rax
	dec	rcx
	cld?
	repnz	scasb
	not	rcx
	dec	rcx
	mov	[rbx].S_TINFO.ti_bcnt,rcx
	mov	rax,rsi
	pop16	es
	ret
tistrlen endp

tidecvalue proc pascal uses rsi rdi rdx boff:dword, soff:dword,
	bmax:size_t, smax:size_t
	mov rsi,word_ptr boff
	mov rdi,word_ptr soff
	mov rax,[rsi]
	add rax,[rdi]
	.if rax
	    mov rdx,[rsi]
	    mov rax,[rdi]
	    .if rax
		dec rax
		and rsi,rsi
		stc
	    .else
		dec rdx
		and rsi,rsi
		clc
	    .endif
	    mov [rdi],rax
	    mov [rsi],rdx
	.endif
	ret
tidecvalue endp

tidecx proc uses rax rbx
	mov	rbx,tinfo
	invoke	tidecvalue,addr [rbx].S_TINFO.ti_boff,addr [rbx].S_TINFO.ti_xoff,
		[rbx].S_TINFO.ti_bcol,[rbx].S_TINFO.ti_cols
	ret
tidecx endp

tialignx proc public uses rbx rcx
	mov	rbx,tinfo
	mov	rcx,[rbx].S_TINFO.ti_xoff
	add	rcx,[rbx].S_TINFO.ti_boff
	cmp	rcx,rax
	jb	tialignx_inc
	je	tialignx_end
    tialignx_dec:
	call	tidecx
	jz	tialignx_end
	dec	rcx
	cmp	rax,rcx
	jne	tialignx_dec
	jmp	tialignx_ok
    tialignx_inc:
	call	tiincx
	jz	tialignx_end
	inc	rcx
	cmp	rax,rcx
	jne	tialignx_inc
    tialignx_ok:
	inc	rcx
    tialignx_end:
	ret
tialignx endp

ifdef __TE__

tidoiflines proc public
	mov	rax,tinfo
    ifdef __f__
	test	[eax].S_TINFO.ti_flag,_T_LINEBUF
    else
	xchg	ax,bx
	test	[bx].S_TINFO.ti_flag,_T_LINEBUF
	xchg	ax,bx
    endif
	jnz	@F
	pop	rax
	jmp	tiretevent
      @@:
    ifdef __TE__
	push	rax
	call	tistripline
	pop	rax
    endif
	ret
tidoiflines endp

tiup	proc public
	call tidoiflines
	push rbx
	mov rbx,rax
	sub rax,rax
	.if rax != [rbx].S_TINFO.ti_yoff
	    dec [rbx].S_TINFO.ti_yoff
	.elseif rax != [rbx].S_TINFO.ti_loff
	    dec [rbx].S_TINFO.ti_loff
	.endif
    	pop rbx
	ret
tiup	endp

tidown	proc public
	call	tidoiflines
	push	rbx
	mov	rbx,rax
	mov	rdx,[rbx].S_TINFO.ti_loff
	mov	rcx,[rbx].S_TINFO.ti_yoff
	mov	rax,rdx
	add	rax,rcx
	inc	rax
	cmp	rax,[rbx].S_TINFO.ti_brow
	jae	tidown_retevent
	cmp	rax,[rbx].S_TEDIT.ti_lcnt
	jae	tidown_continue
	mov	rax,[rbx].S_TINFO.ti_rows
	dec	rax
	cmp	rcx,rax
	jae	@F
	inc	[rbx].S_TINFO.ti_yoff
	jmp	tidown_continue
      @@:
	mov	rax,[rbx].S_TINFO.ti_brow
	sub	rax,rdx
	sub	rax,rcx
	jz	tidown_retevent
	dec	rax
	jz	tidown_retevent
	inc	[rbx].S_TINFO.ti_loff
    tidown_continue:
    	pop	rbx
	jmp	ticontinue
    tidown_retevent:
    	pop	rbx
	jmp	tiretevent
tidown	endp

tipgup	proc
	call	tidoiflines
	push	rbx
	mov	rbx,rax
	mov	rax,[rbx].S_TINFO.ti_loff
	test	rax,rax
	jz	tipgup_tictrlhome
	cmp	rax,[rbx].S_TINFO.ti_rows
	jb	tipgup_tictrlhome
	sub	rax,[rbx].S_TINFO.ti_rows
	mov	[rbx].S_TINFO.ti_loff,rax
    tipgup_continue:
    	pop	rbx
	jmp	ticontinue
    tipgup_tictrlhome:
    	pop	rbx
	jmp	tictrlhome
tipgup	endp

tipgdn	proc
	call	tidoiflines
	push	rbx
	mov	rbx,rax
	mov	rax,[rbx].S_TINFO.ti_rows
	add	rax,rax
	add	rax,[rbx].S_TINFO.ti_loff
	cmp	rax,[rbx].S_TEDIT.ti_lcnt
	jnb	tipgdn_ctrlend
	mov	rax,[rbx].S_TINFO.ti_loff
	add	rax,[rbx].S_TINFO.ti_rows
	mov	[rbx].S_TINFO.ti_loff,rax
    tipgdn_continue:
    	pop	rbx
	jmp	ticontinue
    tipgdn_ctrlend:
    	pop	rbx
	jmp	tictrlend
tipgdn	endp

tictrlpgup proc
	call	tidoiflines
	push	rbx
	mov	rbx,rax
	sub	rax,rax
	mov	[rbx].S_TINFO.ti_yoff,rax
	pop	rbx
	ret
tictrlpgup endp

tictrlpgdn proc
	call	tidoiflines
	push	rbx
	mov	rbx,rax
	mov	rax,[rbx].S_TINFO.ti_rows
	dec	rax
	mov	[rbx].S_TINFO.ti_yoff,rax
	add	rax,[rbx].S_TINFO.ti_loff
	cmp	rax,[rbx].S_TEDIT.ti_lcnt
	pop	rbx
	jb	@F
	ret
      @@:
	jmp	tictrlend
tictrlpgdn endp

tictrlend proc
	call	tidoiflines
    ifdef __f__
	mov	eax,[eax].S_TEDIT.ti_lcnt
    else
	xchg	rbx,rax
	mov	rbx,[rbx].S_TEDIT.ti_lcnt
	xchg	rbx,rax
    endif
	dec	rax
	call	tialigny
	jmp	ticontinue
tictrlend endp

tictrlhome proc
	call	tictrlpgup
	push	rbx
	mov	rbx,tinfo
	mov	[rbx].S_TINFO.ti_loff,rax
	pop	rbx
	ret
tictrlhome endp

tiscrollup proc
	call	tidoiflines
	push	rbx
	mov	rbx,rax
	sub	rax,rax
	cmp	rax,[rbx].S_TINFO.ti_loff
	je	@F
	dec	[rbx].S_TINFO.ti_loff
      @@:
      	pop	rbx
	ret
tiscrollup endp

tiscrolldn proc
	call	tidoiflines
	push	rbx
	mov	rbx,rax
	mov	rax,[rbx].S_TINFO.ti_loff
	add	rax,[rbx].S_TINFO.ti_yoff
	inc	rax
	cmp	rax,[rbx].S_TEDIT.ti_lcnt
	jae	@F
	inc	[rbx].S_TINFO.ti_loff
      @@:
      	pop	rbx
	jmp	ticontinue
tiscrolldn endp

tidecy proc uses rbx rax
	mov	rbx,tinfo
	invoke	tidecvalue,addr [rbx].S_TINFO.ti_loff,addr [rbx].S_TINFO.ti_yoff,
		[rbx].S_TINFO.ti_brow,[rbx].S_TINFO.ti_rows
	ret
tidecy endp

tiincy proc uses rsi rbx rax
	mov	rbx,tinfo
	mov	rsi,[rbx].S_TINFO.ti_rows
	test	[rbx].S_TINFO.ti_flag,_T_USEMENUS
	jz	@F
	dec	rsi
      @@:
	invoke	tiincvalue,addr [rbx].S_TINFO.ti_loff,addr [rbx].S_TINFO.ti_yoff,
		[rbx].S_TINFO.ti_brow,rsi
	ret
tiincy endp

tialigny proc public uses rbx rcx
	mov	rbx,tinfo	; Align yoff and loff to AX
	mov	rcx,[rbx].S_TINFO.ti_yoff
	add	rcx,[rbx].S_TINFO.ti_loff
	cmp	rcx,rax
	jb	tialigny_inc
	je	tialigny_end
      @@:
	call	tidecy
	jz	tialigny_end
	dec	rcx
	cmp	rax,rcx
	jne	@B
	jmp	tialigny_ok
    tialigny_inc:
	call	tiincy
	jz	tialigny_end
	inc	rcx
	cmp	rax,rcx
	jne	tialigny_inc
    tialigny_ok:
	inc	rcx
    tialigny_end:
	ret
tialigny endp

endif

tiseto proc public uses rsi rdi rbx
	call	ticurlp
	mov	rdi,rax
  ifdef __TE__
	jz	tiseto_00
	mov	rbx,2020h
	call	tistripl
	mov	rbx,tinfo
	mov	rax,[rbx].S_TINFO.ti_boff	; test if char is visible
	add	rax,[rbx].S_TINFO.ti_xoff
	cmp	rax,rcx
	jbe	tiseto_00
	test	[rbx].S_TINFO.ti_flag,_T_LINEBUF
	jz	tiseto_01
	add	rdi,rcx			; length of line
	mov16	es,dx			; ES to segment
	mov	rcx,rax
	sub	rcx,[rbx].S_TINFO.ti_bcnt	; CX to pad count
   ifdef _PADD_WITH_TABS
	test	[rbx].S_TINFO.ti_flag,_T_OPTIMALFILL
	jz	tiseto_space
    tiseto_tab:
	mov	rdx,rdi			; insert '\t' if possible
	add	rdx,rcx
	mov	rax,rdi
	and	rax,not 7
	add	rax,8
	cmp	rax,rdx
	ja	tiseto_space
	sub	rax,rdi
	mov	ah,al
	mov	al,9
      @@:
	stosb
	mov	al,TITABCHAR
	dec	rcx
	dec	ah
	jnz	@B
	jmp	tiseto_tab
    tiseto_space:			; padd the rest with ' '
   endif
	mov	rax,' '
	cld?
	rep	stosb
	mov	al,ah
	stosb
	jmp	tiseto_01
  else
	mov	rbx,tinfo
	mov	rcx,rax
	add	rcx,[rbx].S_TINFO.ti_bcol
	dec	rcx
	mov16	es,dx
	mov	rbx,rcx
	mov	byte ptr PEBX,0
	invoke	strlen,dxax
	mov	rdx,rax
	mov	rbx,tinfo
	mov	[rbx].S_TINFO.ti_bcnt,rax
	mov	rax,[rbx].S_TINFO.ti_boff	; test if char is visible
	add	rax,[rbx].S_TINFO.ti_xoff
	cmp	rax,rdx
	jb	tiseto_00
  endif
    tiseto_toend:
	call	titoend			; if not --> to end of line
    tiseto_01:
	mov	rax,1
    tiseto_end:
	ret
    tiseto_00:
	xor	rax,rax
	jmp	tiseto_end
	ret
tiseto endp

ifdef __TE__
tigetindent proto
tibacksp proc uses rsi rdi rbx
else
tibacksp proc uses rbx
endif
	mov rbx,tinfo
	xor rcx,rcx
	mov rax,[rbx].S_TINFO.ti_boff
	add rax,[rbx].S_TINFO.ti_xoff
	.if rax
  ifdef __TE__
	    .if [rbx].S_TINFO.ti_flag & _T_USEINDENT
		mov rdi,rax
		mov rax,[rbx].S_TINFO.ti_loff
		add rax,[rbx].S_TINFO.ti_yoff
		mov rsi,rax
		call tigetindent
		.if rax == rdi
		    .while rsi
			dec rsi
			mov rax,rsi
			call tigetindent
			.break .if rax < rdi
			mov rax,rdi
		    .endw
		    .if rax < rdi
			sub rdi,rax
			.repeat
			    call tileft
			    call tidelete
			    dec rdi
			.until !rdi
			jmp tibacksp_end
		    .endif
		.endif
	    .endif
	    call tileft
  else
	    call tileft
  endif
	    jmp tibacksp_delete
	.else
  ifdef __TE__
	    .if [rbx].S_TINFO.ti_flag & _T_LINEBUF
		mov rax,[rbx].S_TINFO.ti_loff
		add rax,[rbx].S_TINFO.ti_yoff
		.if rax
		    .if [rbx].S_TINFO.ti_yoff
			dec [rbx].S_TINFO.ti_yoff
		    .else
			dec [rbx].S_TINFO.ti_loff
		    .endif
		    jmp @F
		.endif
	    .endif
  endif
	    call tinocando
	    jmp tibacksp_end
	.endif
      @@:
	call tiseto
	call titoend
    tibacksp_delete:
	call tidelete
    tibacksp_end:
	ret
tibacksp endp

ifdef	__TE__

tistr0B proc uses rdi rbx rax
	mov	rdi,rax
	mov	rbx,rax
	mov	rax,2000h+TITABCHAR
	cmp	PEDI,al
	jne	tistr0B_end
	mov	PEDI,ah
	cmp	PEDI+1,al
	jne	@F
	mov	byte ptr PEDI,9
      @@:
	test	rdi,rdi
	jz	tistr0B_end
      @@:
	dec	rdi
	cmp	PEDI,al
	jne	@F
	mov	PEDI,ah
	or	rdi,rdi
	jnz	@B
      @@:
	cmp	byte ptr PEDI,9
	jne	tistr0B_end
	mov	PEDI,ah
    tistr0B_end:
	ret
tistr0B endp

endif

tiputc_add:
	mov	rax,[rbx].S_TINFO.ti_bcnt
	inc	rax
	cmp	rax,[rbx].S_TINFO.ti_bcol
	jae	tiputc_eof
  ifdef __TE__
	call	tiincx
	jz	tiputc_eof
	inc	[rbx].S_TINFO.ti_bcnt
	push	rcx
	call	ticurlp
	pop	rcx
	jz	tiputc_eof
	or	[rbx].S_TINFO.ti_flag,_T_MODIFIED
	mov16	es,dx
	add	rax,[rbx].S_TINFO.ti_xoff
	add	rax,[rbx].S_TINFO.ti_boff
	test	[rbx].S_TINFO.ti_flag,_T_LINEBUF
	jnz	tiputc_lbuf
    tiputc_insert:
	dec	rax
	mov	rbx,rax
	mov	ah,cl
    tiputc_addcl:
	mov	al,PEBX
	mov     PEBX,ah
	mov	ah,al
	inc	rbx
	test	al,al
	jnz	tiputc_addcl
	mov     PEBX,al
	jmp	tiputc_CONTINUE
    tiputc_lbuf:
	dec	rax
	push	rax
	test	[rbx].S_TINFO.ti_flag,_T_USETABS
	jz	@F
	call	tistr0B
	call	tistrip
      @@:
	inc	rax
	call	tiputc_insert
	pop	rax
	push	rcx
	call	tiexpand
	push	rax
	call	ticurlp
	pop	rcx
	mov	rbx,rax
	mov	ah,' '
      @@:
	cmp	rbx,rcx
	je	@F
	mov	al,PEBX
	inc	rbx
	or	al,al
	jnz	@B
	mov	PEBX-1,ah
	jmp	@B
      @@:
	pop	rcx
	mov	rbx,tinfo
	cmp	cl,9
	jne	tiputc_CONTINUE
	mov	rax,[rbx].S_TINFO.ti_xoff	; Align xoff and boff to next TAB
	add	rax,[rbx].S_TINFO.ti_boff
	mov	rcx,rax
	mov	dl,tetabsize
	dec	dl
	and	dl,TIMAXTABSIZE-1
	test	al,dl
	jz	tiputc_CONTINUE
	not	dl
	and	al,dl
	add	al,tetabsize
	cmp	rcx,rax			; Align xoff and boff to AX
	jb	tiputc_inc
	je	tiputc_CONTINUE
    tiputc_dec:
	call	tidecx
	jz	tiputc_CONTINUE
	dec	rcx
	cmp	rax,rcx
	jne	tiputc_dec
	jmp	tiputc_CONTINUE
    tiputc_inc:
	call	tiincx
	jz	tiputc_CONTINUE
	inc	rcx
	cmp	rax,rcx
	jne	tiputc_inc
  else
	push	rcx
	call	ticurcp
	push	rsi
	push	rdi
	mov	rcx,[rbx].S_TINFO.ti_bcol
	sub	rcx,[rbx].S_TINFO.ti_xoff
	sub	rcx,[rbx].S_TINFO.ti_boff
	dec	rcx
	mov16	ds,dx
	mov16	es,dx
	mov	rdi,rax
	mov	rsi,rax
	inc	rdi
	dec	rcx
	mov	rax,rsi
	add	rsi,rcx
	add	rdi,rcx
	inc	rcx
	std
	rep	movsb
	cld
	mov	rbx,rax
	pop	rdi
	pop	rsi
	pop	rax
	mov	[rbx],al
	mov16	ax,ss
	mov16	ds,ax
	mov	rbx,tinfo
	inc	[rbx].S_TINFO.ti_bcnt
	inc	[rbx].S_TINFO.ti_xoff
	mov	rax,[rbx].S_TINFO.ti_cols
	cmp	[rbx].S_TINFO.ti_xoff,rax
	jl	tiputc_CONTINUE
	dec	rax
	mov	[rbx].S_TINFO.ti_xoff,rax
	add	rax,[rbx].S_TINFO.ti_boff
	cmp	[rbx].S_TINFO.ti_bcnt,rax
	jbe	tiputc_CONTINUE
	inc	[rbx].S_TINFO.ti_boff
  endif
    tiputc_CONTINUE:
	mov	rax,_TI_CONTINUE
	ret
  ifdef __TE__
    tiputc_strbuf:
  else
    tiputc_CONTROL:
  endif
	test	al,al
	jz	tiputc_ret
	test	[rbx].S_TINFO.ti_flag,_T_USECONTROL
	jnz	tiputc_add
    tiputc_ret:
	mov	rax,_TI_RETEVENT
	ret
    tiputc_eof:
  ifdef __TE__
	mov	rax,[rbx].S_TINFO.ti_bcol
	dec	rax
	mov	[rbx].S_TINFO.ti_bcnt,rax
	invoke	ermsg,0,addr cp_linetolong
    tiputc_nocando:
  endif
	jmp	tinocando
  ifdef __TE__
    tiputc_ENTER:
	jmp	tienterni
    tiputc_CONTROL:
	test	[rbx].S_TINFO.ti_flag,_T_LINEBUF
	jz	tiputc_strbuf
	cmp	al,9
	je	tiputc_TAB
	cmp	al,0Ah
	je	tiputc_ENTER
	cmp	al,0Dh
	je	tiputc_CONTINUE
	jmp	tiputc_ret
    tiputc_TAB:
	.if [rbx].S_TINFO.ti_flag & _T_USETABS
	    call tiputc_add
	.else
	    call ticurcp
	    push rdi
	    mov  rdi,rax
	    mov  rcx,rax
	    ZXAX tetabsize
	    add  rdi,rax
	    dec  rax
	    not  rax
	    and  rdi,rax
	    sub  rdi,rcx
	    .while rdi
		mov cl,' '
		call tiputc_add
		.break .if rax != _TI_CONTINUE
		dec rdi
	    .endw
	    pop rdi
	.endif
	cmp rax,_TI_CONTINUE
	jne tiputc_nocando
	jmp tiputc_CONTINUE
  endif

tiputc proc public uses rbx
	mov rbx,tinfo
	mov rcx,rax
	call getctype
	.if ah & _CONTROL
	    call tiputc_CONTROL
	.else
	    call tiputc_add
	.endif
	ret
tiputc endp

titab proc public uses rbx
	mov rbx,tinfo
	.if [rbx].S_TINFO.ti_flag & _T_LINEBUF
	    call tiputc
	    call ticontinue
	.else
	    call tiretevent
	.endif
	ret
titab endp

tidelete proc public uses rsi rdi rbp rbx
	mov  rbx,tinfo
	call ticurcp
	mov16 es,dx
	mov  rdi,rax
	or   [rbx].S_TINFO.ti_flag,_T_MODIFIED
	.if  byte ptr PEDI == 0
    ifdef __TE__
	    .if [rbx].S_TINFO.ti_flag & _T_LINEBUF
		mov rax,[rbx].S_TINFO.ti_loff
		add rax,[rbx].S_TINFO.ti_yoff
		inc rax
		.if rax < [rbx].S_TINFO.ti_brow && rax < [rbx].S_TEDIT.ti_lcnt
		    call tigetline
		    .if !CARRY?
			push rax
			invoke strlen,dxax
			add rax,[rbx].S_TINFO.ti_bcnt
			mov rcx,rax
			pop rax
			.if rcx < [rbx].S_TINFO.ti_bcol
			    sub rsp,[rbx].S_TINFO.ti_bcol	; add next line to this
			    mov rbp,rsp
			  ifdef __f__
			    invoke strcpy,ebp,eax
			  else
			    invoke strcpy,ss::bp,dx::ax
			  endif
			    mov rax,[rbx].S_TINFO.ti_loff
			    add rax,[rbx].S_TINFO.ti_yoff
			    mov rsi,rax
			    call tigetline
			    .if !CARRY?
			      ifdef __f__
				invoke strcat,eax,ebp
			      else
				invoke strcat,dx::ax,ss::bp
			      endif
				add rsp,[rbx].S_TINFO.ti_bcol
				inc rsi
				mov rax,rsi
				mov rdx,1
				call tiremline
			    .endif
			.endif
		    .endif
		.endif
	    .endif
    endif
	.else
    ifdef __TE__
	    mov rcx,[rbx].S_TINFO.ti_flag
	    .if rcx & _T_LINEBUF && rcx & _T_USETABS
		call tistrip
		mov rbx,rax
		mov ah,tetabsize
		dec ah
		and ah,TIMAXTABSIZE-1
		.if al & ah
		    mov ah,PEBX
		    mov al,PEBX[-1]
		    .if al == 9
			mov byte ptr PEBX[-1],' '
			jmp @F
		    .elseif al == TITABCHAR
			mov rdi,rbx
			mov ah,' '
			.repeat
			    dec rdi
			    .break .if PEDI != al
			    mov PEDI,ah
			.until !rdi
			mov PEDI,ah
			jmp @F
		    .endif
		.endif
		.repeat
		    mov   rax,rbx
		    push16 dx
		    push  rax
		    inc   rax
		    push16 dx
		    push  rax
		    call  strcpy
		.until byte ptr PEBX != TITABCHAR
	      @@:
		mov  rax,rbx
		call tiexpand
		mov  rbx,tinfo
		or   [rbx].S_TINFO.ti_flag,_T_MODIFIED
		jmp  @F
	    .endif
    endif
	    dec [rbx].S_TINFO.ti_bcnt
	    mov rcx,rax
	    inc rcx
	  ifdef __f__
	    invoke strcpy,eax,ecx
	  else
	    invoke strcpy,dx::ax,dx::cx
	  endif
	.endif
      @@:
	call ticontinue
	ret
tidelete endp

tiisword proc
	call	getctype
	and	ah,_UPPER or _LOWER or _DIGIT
	jnz	@F
	cmp	al,'_'
	jne	tiisword_nul
	test	al,al
      @@:
	ret
    tiisword_nul:
	cmp	al,al
	ret
tiisword endp

tinextword proc public uses rsi rbp
	push16	ds
	call	ticurcp
	mov	rbp,tinfo
	mov16	ds,dx
	mov	rsi,rax
	mov	rdx,rax
	cld?
      @@:
	lodsb
	call	tiisword
	jnz	@B
	test	al,al
	jz      tinextword_eof
      @@:
	lodsb
	test	al,al
	jz      tinextword_eof
	call	tiisword
	jz	@B
	dec	rsi
	sub	rsi,rdx
	mov	rax,[rbp].S_TINFO.ti_boff
	add	rax,[rbp].S_TINFO.ti_xoff
	add	rax,rsi
	cmp	rax,[rbp].S_TINFO.ti_bcnt
	ja	tinextword_eof
	mov	rax,rsi
	add	rax,[rbp].S_TINFO.ti_xoff
	mov	rdx,[rbp].S_TINFO.ti_cols
	cmp	rax,rdx
	jb	@F
	dec	rdx
	sub	rax,rdx
	add	[rbp].S_TINFO.ti_boff,rax
	mov	rax,rdx
     @@:
	mov	[rbp].S_TINFO.ti_xoff,rax
	pop16	ds
	call	ticontinue
    tinextword_end:
	ret
    tinextword_eof:
	; next line..
	pop16	ds
	call	titoend
	jmp	tinextword_end
tinextword endp

tiprevword proc public uses rsi rdi rbp rbx
	mov16	di,ds
	mov	rbp,tinfo
	mov	rax,[rbp].S_TINFO.ti_boff
	add	rax,[rbp].S_TINFO.ti_xoff
	test	rax,rax
	jz	tiprevword_eof
	mov	rsi,rax
	mov	rcx,rax
	call	ticurlp
	mov16	ds,dx
	add	rsi,rax
	mov	rbx,rsi
	mov	rdx,rax
	std
	lodsb
	inc	rsi
	call	tiisword
	jnz	tiprevword_start
	test	al,al
	jnz	tiprevword_l1
	dec	rsi
    tiprevword_l1:
	lodsb
	cmp	rsi,rdx
	jbe	tiprevword_eof
	test	al,al
	jz	tiprevword_eof
	call	tiisword
	jz	tiprevword_l1
    tiprevword_l2:
	lodsb
	cmp	rsi,rdx
	jbe	tiprevword_eof
	test	al,al
	jz	tiprevword_eof
	call	tiisword
	jnz	tiprevword_l2
	cld
	add rsi,2
	mov16 ds,di
	mov rax,rsi
	sub rax,rdx
	.if rax < [rbp].S_TINFO.ti_cols
	    mov [rbp].S_TINFO.ti_xoff,rax
	    mov [rbp].S_TINFO.ti_boff,0
	.else
	    sub rax,[rbp].S_TINFO.ti_xoff
	    mov [rbp].S_TINFO.ti_boff,rax
	.endif
	jmp tiprevword_continue
    tiprevword_start:
	mov	al,[rsi-1]
	call	tiisword
	jnz	tiprevword_l2
	dec	rsi
	jmp	tiprevword_l1
    tiprevword_continue:
	call ticontinue
    tiprevword_end:
	ret
    tiprevword_eof:
	cld
	mov16 ds,di
	call tihome
	jmp tiprevword_end
tiprevword endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

tiinitcursor proc public
	push	rbx
	mov	rbx,tinfo
	mov     [rbx].S_TINFO.ti_cursor.cr_type,CURSOR_NORMAL
    ifdef __f__
	mov	[ebx].S_TINFO.ti_cursor.cr_size,CURSOR_SIZE
    endif
	pop	rbx
tiinitcursor endp

tisetcursor proc public uses rbx
	mov	rbx,tinfo
	mov	rax,[rbx].S_TINFO.ti_xpos
	add	rax,[rbx].S_TINFO.ti_xoff
    ifdef __f__
	mov	edx,[ebx].S_TINFO.ti_ypos
    else ; v2.47 - Win32
	mov	ah,byte ptr [rbx].S_TINFO.ti_ypos
    endif
    ifdef __TE__
	test	[rbx].S_TINFO.ti_flag,_T_LINEBUF
	jz	@F
    ifndef __f__
	add	ah,byte ptr [rbx].S_TINFO.ti_yoff
    else
	add	edx,[rbx].S_TINFO.ti_yoff
    endif
      @@:
    endif
    ifdef __f__
	shl	edx,16
	or	eax,edx
    endif
	mov	[rbx].S_TINFO.ti_cursor.cr_xy,rax
	mov	[rbx].S_TINFO.ti_cursor.cr_type,CURSOR_NORMAL
	invoke	cursorset,addr [rbx].S_TINFO.ti_cursor
	ret
tisetcursor endp

timouse proc uses rbx
  ifdef __MOUSE__
	mov	rbx,tinfo
	call	mousey
   ifdef __TE__
	mov	rdx,rax
	call	mousex
	mov	rcx,rax
	mov	rax,[rbx].S_TINFO.ti_xpos
	cmp	rcx,rax
	jb	timouse_esc
	add	rax,[rbx].S_TINFO.ti_cols
	cmp	rcx,rax
	jae	timouse_esc
	mov	rax,[rbx].S_TINFO.ti_ypos
	cmp	rdx,rax
	jb	timouse_esc
	add	rax,[rbx].S_TINFO.ti_rows
	cmp	rdx,rax
	jae	timouse_esc
	sub	rdx,[rbx].S_TINFO.ti_ypos
	mov	[rbx].S_TINFO.ti_yoff,rdx
	push	rcx
	call	ticurlp
	jz	@F
	invoke	strlen,dxax
     @@:
	pop	rcx
	sub	rcx,[rbx].S_TINFO.ti_xpos
	cmp	rcx,rax
	jg	@F
	mov	rax,rcx
     @@:
	mov	[rbx].S_TINFO.ti_xoff,rax
	call	tisetcursor
	call	msloop
   else
	cmp	rax,[rbx].S_TINFO.ti_ypos
	jne	timouse_esc
	call	mousex
	mov	rdx,[rbx].S_TINFO.ti_xpos
	cmp	al,dl
	jb	timouse_esc
	add	rdx,[rbx].S_TINFO.ti_cols
	cmp	rax,rdx
	jnb	timouse_esc
	sub	rax,[rbx].S_TINFO.ti_xpos
	mov	[rbx].S_TINFO.ti_xoff,rax
	lodm	[rbx].S_TINFO.ti_bp
	add	rax,[rbx].S_TINFO.ti_boff
	invoke	strlen,dxax
	cmp	rax,[rbx].S_TINFO.ti_xoff
	jnb	@F
	mov	[rbx].S_TINFO.ti_xoff,rax
      @@:
	mov	rax,[rbx].S_TINFO.ti_xpos
	add	rax,[rbx].S_TINFO.ti_xoff
	invoke	gotoxy,rax,[rbx].S_TINFO.ti_ypos
	call	msloop
   endif ; __TE__
	call	ticontinue
    timouse_end:
	ret
    timouse_esc:
	call	tiesc
	jmp	timouse_end
  else
	call	ticontinue
	ret
  endif ; __MOUSE__
timouse endp

tievent	proc public
	mov	rdx,rbx
	mov	rcx,ti_key_count
	xor	rbx,rbx
    tievent_loop:
    	test	cx,cx
	jz	tievent_break
	cmp	rax,ti_keytable[rbx]
	jne	tievent_next
	mov	rbx,ti_proctab[rbx]
	xchg	rbx,rdx
	jmp	rdx
    tievent_next:
	add	rbx,size_l
	dec	rcx
	jnz	tievent_loop
    tievent_break:
	mov	rbx,rdx
	call	tiputc
	ret
tievent	endp

tiputl	proc uses rsi rdi rbx
local	lb[2+TIMAXSCRLINE]:byte
local	wc[2*TIMAXSCRLINE]:byte
local	line:size_t	; current line 0..max
local	loff:size_t	; adress of line
local	lseg:size_t
local	llen:size_t	; length of line
local	clst:size_t	; clip start
local	clen:size_t	; clip end
	mov rsi,tinfo
  ifdef __TE__
	mov	line,rax
	mov	ah,[rsi].S_TINFO.ti_clat
	mov	al,[rsi].S_TINFO.ti_clch
	test	[rsi].S_TINFO.ti_flag,_T_USESTYLE
	jz	@F
	mov	ah,[rsi].S_TEDIT.ti_stat
	mov	al,[rsi].S_TEDIT.ti_stch
      @@:
  else
	mov	ah,[rsi].S_TINFO.ti_clat
	mov	al,[rsi].S_TINFO.ti_clch
  endif
	push16	ss
	pop16	es
	lea	rdx,wc
	mov	rdi,rdx
	mov	rcx,TIMAXSCRLINE
	cld?
	rep	stosw
	mov	rdi,rdx
  ifdef __TE__
	mov	rax,line
	call	tigetline
	mov	loff,rax
	mov16	lseg,dx
	jz	tiputl_screen
  else
	lodm	[rsi].S_TINFO.ti_bp
	mov	loff,rax
	mov16	lseg,dx
  endif
      ifndef __f__
	push	dx
	push	ax
      endif
	lea	rbx,lb
	add	rax,[rsi].S_TINFO.ti_boff
      ifdef __f__
	invoke	memcpy,ebx,eax,TIMAXSCRLINE
	mov	[ebx+TIMAXSCRLINE],cl
	invoke	strlen,loff
      else
	invoke	memcpy,ss::bx,dx::ax,TIMAXSCRLINE
	mov	[bx+TIMAXSCRLINE],cl
	call	strlen
	mov	es,dx
      endif
	mov	llen,rax
	cmp	rax,[rsi].S_TINFO.ti_boff
	jbe	tiputl_color
	xchg	rsi,rbx
	mov	rcx,TIMAXSCRLINE
    tiputl_cl:
	lodsb
	or	al,al
	jz	tiputl_break
	cmp	al,TITABCHAR
	jne	@F
	mov	al,' '
    @@:
	cmp	al,9
	jne	@F
	test	[rbx].S_TINFO.ti_flag,_T_SHOWTABS
	jnz	@F
	mov	al,' '
    @@:
	stosb
	inc	rdi
	dec	rcx
	jnz	tiputl_cl
    tiputl_break:
	mov	rsi,rbx
  ifdef __TE__
	test	[rsi].S_TINFO.ti_flag,_T_USESTYLE
	jz	tiputl_color
	push16	es
	mov	rax,loff
	mov16	di,lseg
	lea	rdx,wc
	mov	rcx,llen
	mov	rbx,line
	call	tistyle
	pop16	es
  endif
    tiputl_color:
  ifdef __CLIP__
	xor	rax,rax
	mov	clen,rax	; clip end to   0000
	dec	rax		; clip start to FFFF
	mov	clst,rax
	call	tiselected
	jz	tiputl_screen
  ifdef __TE__
	xor	rdx,rdx
	cmp	word_ptr [rsi].S_TINFO.ti_bp,rdx
	jne	tiputl_local
	mov	rax,line
	cmp	rax,[rsi].S_TINFO.ti_clsl
	jb	tiputl_screen
	je	tiputl_clst
	cmp	rax,[rsi].S_TINFO.ti_clel
	ja	tiputl_screen
	mov	clst,rdx
	je      tiputl_clen
	dec	rdx
	mov	clen,rdx
	jmp	tiputl_clput
    tiputl_clen:
	mov	rax,[rsi].S_TINFO.ti_cleo
	mov	clen,rax
	jmp	tiputl_clput
    tiputl_clst:
	dec	rdx
	mov	clen,rdx
	cmp	rax,[rsi].S_TINFO.ti_clel
	mov	rax,[rsi].S_TINFO.ti_clso
	mov	clst,rax
	je	tiputl_clen
	jmp	tiputl_clput
    tiputl_local:
  endif
	mov	rax,[rsi].S_TINFO.ti_clso
	add	rax,word_ptr [rsi].S_TINFO.ti_bp
	mov	clst,rax
	mov	rax,[rsi].S_TINFO.ti_cleo
	add	rax,word_ptr [rsi].S_TINFO.ti_bp
	mov	clen,rax
    tiputl_clput:
	mov	rcx,TIMAXSCRLINE
	lea	rdi,wc+1
	mov	al,at_background[B_Inverse]
	mov	rbx,loff
	add	rbx,[rsi].S_TINFO.ti_boff
	mov	rdx,clst
    tiputl_cloop:
	cmp	rbx,rdx
	jb	@F
	cmp	rbx,clen
	jae	tiputl_screen
	stosb
	jmp	tiputl_inc
    @@:
	inc	rdi
    tiputl_inc:
	inc	rbx
	inc	rdi
	dec	rcx
	jnz	tiputl_cloop
  endif
    tiputl_screen:
	mov	rax,[rsi].S_TINFO.ti_xpos
	mov	rdx,[rsi].S_TINFO.ti_ypos
    ifdef __TE__
	add	rdx,line
	sub	rdx,[rsi].S_TINFO.ti_loff
    endif
    ifdef __f__
    ;
	mov	ecx,[esi].S_TINFO.ti_cols
	lea	esi,wc
	mov	ebx,eax
      @@:
	mov	eax,[esi]
	add	esi,2
	invoke	scputw,ebx,edx,1,eax
	inc	ebx
	dec	ecx
	jnz	@B
    else
	HideMouseCursor
	invoke	getxyp,ax,dx
	mov	es,dx
	mov	di,ax
	mov	cx,[si].S_TINFO.ti_cols
	lea	si,wc
	assert	cx,TIMAXSCRLINE,jna,"tiputl"
	rep	movsw
	ShowMouseCursor
    endif
	xor	rax,rax
	ret
tiputl	endp

tiputs proc public
	call	tisetcursor
    ifdef __TE__
	push	rsi
	push	rdi
	mov	rdi,tinfo
	mov	rsi,[rdi].S_TINFO.ti_rows
	mov	rdi,[rdi].S_TINFO.ti_loff
	.if !rsi
	    inc rsi
	.endif
	.while rsi
	    mov  rax,rdi
	    call tiputl
	    inc  rdi
	    dec  rsi
	.endw
	pop	rdi
	pop	rsi
    else
	sub	rax,rax
	call	tiputl
    endif
	ret
tiputs endp


timodal proc public uses rsi rdi
	mov rsi,_TI_CONTINUE
	.while rsi != _TI_RETEVENT
	    call tiseto
	    call tiputs
	    call tgetevent
	  ifdef __CLIP__
	    call ticlipevent
	  endif
	    mov  rdi,rax
	    call tievent
	    mov  rsi,rax
	.endw
	call	ticurlp
	invoke	strlen,dxax
	mov	rsi,tinfo
	mov	[rsi].S_TINFO.ti_bcnt,rax
	mov	rax,rdi
	ret
timodal endp

	end
