#ifndef __INC_IOST
#define __INC_IOST
#if !defined(__INC_DEFS)
 #include <defs.h>
#endif

#define SEEK_CUR	1
#define SEEK_END	2
#define SEEK_SET	0

#define ISIZE		0x800000
#define OSIZE		0x800000

#define IO_SEARCHCASE	0x0001  /* Case sensitive search	*/
#define IO_SEARCHHEX	0x0002  /* Search hex string/ascii	*/
#define IO_SEARCHSET	0x0004  /* Search entire scope		*/
#define IO_SEARCHCUR	0x0008  /* Search from cursor/set	*/
#define IO_SEARCHMASK	0x000F
#define IO_SEARCHSUB	0x0020
#define IO_STRINGB	0x0080  /* String buffer		*/
#define IO_CRYPT	0x0100  /* Crypted file			*/
#define IO_USEUPD	0x0200  /* Progress			*/
#define IO_UPDTOTAL	0x0400  /* Add Read/Write size to total */
#define IO_USECRC	0x0800  /* Update CRC on read/write	*/
#define IO_USEBITS	0x1000  /* Align bits on read/write	*/
#define IO_CLIPBOARD	0x2000  /* Flush to clipboard		*/
#define IO_MEMREAD	0x4000  /* Read from memory		*/
#define IO_ERROR	0x8000  /* Write fault			*/

#ifdef __cplusplus
 extern "C" {
#endif

typedef struct IOBS {
	char *		bp;	/* buffer */
	unsigned int	i;	/* index in buffer */
	unsigned int	c;	/* byte count */
	unsigned int	bsize;  /* alloc size */
	unsigned int	flag;
	int		file;
	int		l;	/* number of bits in bit buffer */
	unsigned int	bb;	/* bit buffer | CRC value */
	unsigned int	total;  /* total bytes in/out | filesize */
	unsigned int	offs;	/* file offset | loop count */
	unsigned int	fsize;  /* file size */
      } IOST;
extern  IOST STDI;
extern  IOST STDO;

int _CType oinitst(IOST *, int __size);
int _CType oopenst(IOST *, char *__file, int __mode, int __bsize);
int _CType oseekst(IOST *, DWORD __offset, int __from);
int _CType ocopyst(IOST *__des, IOST *__src, long __len);
int _CType oflushst(IOST *);
int _CType ofreadst(IOST *);
void _CType oclose(IOST *);
void _CType ofreest(IOST *);
int _CType owritest(IOST *, void *__buf, int __len);
int _CType otellst(IOST *);
int _fastcall ogetcst(IOST *);
int _fastcall oputcst(int __c, IOST *);

int _CType otell(void);
void *_fastcall oread(int __size);
int _fastcall oputc(int __c);
int _CType ogetc(void);
int _CType continuesearch(void);
int _CType osearch(void);
int _CType oflush(void);
int _CType ofread(void);
int _CType oreadb(void *__buf, int __len);
int _CType oungetc(void);
int _CDecl oprintf(char *__format, ...);

int _CType ogetl(char *__file, void *__buf, int __bsize);
char *_CType ogets(void);
int _CType oputs(char *);
int _CType oopen(char *__file, int __mode, int __bsize);
int _CType ogetouth(char *__file, int __mode);
int _CType openfile(char *__file, int __mode, int __action);
int _CType oseek(DWORD __offset, int __from);
int _CType oseekl(DWORD __offset, int __from);

#ifdef __cplusplus
 }
#endif
#endif
