; DZIDD.ASM--
; Copyright (c) 2013 Hjort Nidudsson
;
; Change history:
; 2013-11-03 - created

include io.inc
include ini.inc
include string.inc
include stdlib.inc
include keyb.inc
include version.inc
include dll.inc
include dzdata.inc

public  heaplen
public  programpath
public  configpath
public  configfile
public  envtemp
public  envpath

public  IDD_RCDesktop
public  IDD_RCExternEvent
public  IDD_RCQuickMenu
public  IDD_RCExit
public  IDD_RCChild
public  IDD_RCSave
public  IDD_RCHelp
public  IDD_RCDOBJ
public  IDD_RCBackground
public  IDD_RCForeground
public  IDD_RCAddFrame
public  IDD_RCTOBJ
public  IDD_RCOpenFile

dzidd	proto :dword

.data

M1	macro v,n
	exitm<0F0h or ((n and 0FF00h) shr 8),n and 00FFh,v>
	endm

IDDABOUT label word
	dw 3000,005Ch
	db 1,0,15,6,45,11, 0,0,0,'O',4,9,8,1
	db M1(50h,45),M1(29h,45*8+4),M1(0E0h,3),0EDh,M1(0E0h,4),M1(25h,45*2+38)
	db M1(" About",20)
	db M1(" RCEDIT Version 2.04",70)
	db M1(" Doszip plugin for *.IDD",26)
	db M1(' ',22),M1('',35)
%	db M1(" Build:   &@Date &@Time, DZ ",55),VERSSTR
	db M1(" License: GNU General Public License",10)
	db M1(" OK   ",57),'',M1(' ',37),M1('',8),M1(' ',32)

RCDesktop	LABEL WORD
incbin		<res\RCDesktop.IDD>
RCExternEvent	LABEL WORD
incbin		<res\RCExternEvent.IDD>
RCQuickMenu	LABEL WORD
incbin		<res\RCQuickMenu.IDD>
RCExit		LABEL WORD
incbin		<res\RCExit.IDD>
RCChild		LABEL WORD
incbin		<res\RCChild.IDD>
RCSave		LABEL WORD
incbin		<res\RCSave.IDD>
RCHelp		LABEL WORD
incbin		<res\RCHelp.IDD>
RCDOBJ		LABEL WORD
incbin		<res\RCDOBJ.IDD>
RCBackground	LABEL WORD
incbin		<res\RCBackground.IDD>
RCForeground	LABEL WORD
incbin		<res\RCForeground.IDD>
RCAddFrame	LABEL WORD
incbin		<res\RCAddFrame.IDD>
RCTOBJ		LABEL WORD
incbin		<res\RCTOBJ.IDD>
RCOpenFile	LABEL WORD
incbin		<res\RCOpenFile.IDD>

IDD_RCDesktop		dd offset RCDesktop
IDD_RCExternEvent	dd offset RCExternEvent
IDD_RCQuickMenu		dd offset RCQuickMenu
IDD_RCExit		dd offset RCExit
IDD_RCChild		dd offset RCChild
IDD_RCSave		dd offset RCSave
IDD_RCHelp		dd offset RCHelp
IDD_RCDOBJ		dd offset RCDOBJ
IDD_RCBackground	dd offset RCBackground
IDD_RCForeground	dd offset RCForeground
IDD_RCAddFrame		dd offset RCAddFrame
IDD_RCTOBJ		dd offset RCTOBJ
IDD_RCOpenFile		dd offset RCOpenFile

;------------------------------------------------------------------------------

heaplen		dd 0
programpath	db WMAXPATH dup (?)
configpath	db WMAXPATH dup (?)
configfile	db WMAXPATH dup (?)
temppath	db WMAXPATH dup (?)
pathbuf		db 1024 dup (?)
envtemp		dd temppath
envpath		dd pathbuf

dll_count	dd 0	; offset dll_count	plugins.asm
dz_memseg	dd 0	; offset memseg		alloc.asm
dz_conio	dd 0	; offset keyshift	conio.asm
dz_data		dd 0	; offset programpath	config.asm
dz_ti_keytable  dd 0	; offset ti_keytable	tievent.asm
dz_global_key	dd 0	; offset global_key
dz_topen	dd 0
dz_tmodal	dd 0
dz_tclose	dd 0
dz_tview	dd 0
dz_mousep	dd 0

.code

mousep  proc
	call dz_mousep
	ret
mousep  endp

mousex  proc
	mov eax,dz_conio
	mov eax,[eax].S_CONIO.co_keybmouse_x
	ret
mousex  endp

mousey  proc
	mov eax,dz_conio
	mov eax,[eax].S_CONIO.co_keybmouse_y
	ret
mousey  endp


;-------------------------------------------------------------------------
; Function 0 - get version
;-------------------------------------------------------------------------

dll_version:
	mov eax,VERSION
	ret

;-------------------------------------------------------------------------
; Function 1 - init
;-------------------------------------------------------------------------

dll_init:
	push	esi
	push	edi
	mov	esi,eax
	lea	edi,dll_count
	mov	ecx,sizeof(S_DLLARGS)/4
	rep	movsd
	mov	esi,dz_memseg
	lea	edi,memseg
	mov	ecx,3
	rep	movsd
	mov	esi,dz_conio
	lea	edi,keyshift
	mov	ecx,S_CONIO.co_tdialog/4
	rep	movsd
	pop	edi
	pop	esi
	invoke  memcpy,addr at_background,tdcolor,sizeof(S_COLOR)
	invoke  memcpy,addr programpath,dz_data,WMAXPATH*3
	.if !GetEnvironmentVariable("PATH",addr pathbuf,1024)
	    invoke strcpy,addr pathbuf,addr programpath
	.endif
	.if !GetEnvironmentVariable("TEMP",addr temppath,WMAXPATH)
	    invoke strcpy,addr temppath,addr configpath
	.endif
	mov eax,_DLLF_TEST
	ret

;-------------------------------------------------------------------------
; Function 11 - Test
;-------------------------------------------------------------------------

rcupdate proto

dll_test:; fblk, sign
	lea edx,[eax].S_FBLK.fb_name
	.if strext(edx)
	    .if !stricmp(eax,".idd")
		invoke memcpy,addr at_background,tdcolor,sizeof(S_COLOR)
		mov eax,dz_conio
		push [eax].S_CONIO.co_tupdate
		mov [eax].S_CONIO.co_tupdate,rcupdate
		invoke dzidd,edx
		pop eax
		mov edx,dz_conio
		mov [edx].S_CONIO.co_tupdate,eax
		mov eax,2
	    .else
		sub eax,eax
	    .endif
	.endif
	ret

;-------------------------------------------------------------------------
; Function 15 - about
;-------------------------------------------------------------------------

dll_about:
	invoke rsmodal,addr IDDABOUT
	ret

;-------------------------------------------------------------------------
; Functions not implemented
;-------------------------------------------------------------------------

dll_read:
dll_copy:
dll_add:
dll_delete:
dll_view:
dll_move:	; dest, wsub, fblk
dll_mkdir:	; wsub, directory
dll_rename:	; wsub, fblk, copy
dll_edit:	; wsub, fblk
dll_attrib:	; wsub, fblk
dll_enter:	; wsub, fblk
	invoke notsup
dll_exit:
dll_link:
	sub eax,eax
	ret

.data

proc_label label dword
	dd dll_version
	dd dll_init
	dd dll_read
	dd dll_copy
	dd dll_add
	dd dll_move
	dd dll_mkdir
	dd dll_delete
	dd dll_rename
	dd dll_edit
	dd dll_view
	dd dll_attrib
	dd dll_enter
	dd dll_test
	dd dll_exit
	dd dll_link
	dd dll_about

.code

dll_call proc pascal export a0, a1, a2, a3, a4
	mov eax,a0
	cmp eax,_DLL_ABOUT
	ja  error
	mov ecx,proc_label[eax*4]
	mov eax,a1
	mov edx,a2
	call ecx
  toend:
	ret
  error:
	sub eax,eax
	jmp toend
dll_call endp

	end
