; IDLE.ASM--
;
; Template for a pop-up plugin using tdidle
;

.data

heaplen		dd 0	; set to 0 -- use dz's heap
public		heaplen
idleh		dd 0	; current idle() pointer
active		dd 0
dll_count	dd 0	; offset dll_count	plugins.asm
dz_memseg	dd 0	; offset memseg		alloc.asm
dz_conio	dd 0	; offset keyshift	conio.asm
dz_data		dd 0	; offset programpath	config.asm
dz_ti_keytable  dd 0	; offset ti_keytable	tievent.asm
dz_global_key	dd 0	; offset global_key
dz_topen	dd 0
dz_tmodal	dd 0
dz_tclose	dd 0
dz_tview	dd 0
dz_mousep	dd 0

.code

DLLPROC		proto

considle proc
	mov	eax,keyshift
	mov	eax,[eax]
	and	eax,POPUPKEY
	cmp	eax,POPUPKEY
	je	@F
	mov	active,0
	jmp	idle
     @@:
	cmp	active,1
	je	toend
	mov	active,1
	invoke  memcpy,addr at_background,tdcolor,sizeof(S_COLOR)
	invoke  DLLPROC
	jmp	toend
   idle:
	call	idleh
  toend:
	ret
considle endp

mousep proc
	call dz_mousep
	ret
mousep endp

mousex  proc
	mov eax,dz_conio
	mov eax,[eax].S_CONIO.co_keybmouse_x
	ret
mousex  endp

mousey  proc
	mov eax,dz_conio
	mov eax,[eax].S_CONIO.co_keybmouse_y
	ret
mousey  endp

getkey proc
	mov eax,KEY_ESC
	ret
getkey endp

;-------------------------------------------------------------------------
; Install
;-------------------------------------------------------------------------

dll_install:
	push	esi
	push	edi
	mov	esi,eax
	lea	edi,dll_count
	mov	ecx,sizeof(S_DLLARGS)/4
	rep	movsd
	mov	esi,dz_memseg
	lea	edi,memseg
	mov	ecx,3
	rep	movsd
	mov	esi,dz_conio
	lea	edi,keyshift
	mov	ecx,S_CONIO.co_tdialog/4
	rep	movsd
	pop	edi
	pop	esi
	mov	eax,_diskflag
	mov	byte ptr [eax],0
	mov	edx,dz_conio
	mov	eax,[edx].S_CONIO.co_tdidle
	mov	[edx].S_CONIO.co_tdidle,considle
	mov	idleh,eax
	invoke  memcpy,addr at_background,tdcolor,sizeof(S_COLOR)
	mov	eax,_DLLF_GLOBAL
	ret

;-------------------------------------------------------------------------
; Function 0 - get version
;-------------------------------------------------------------------------

dll_version:
	mov	eax,VERSION
	ret

;-------------------------------------------------------------------------
; Function 14 - Exit
;-------------------------------------------------------------------------

dll_exit:
	;
	; idleh may point to a second DLL that is deleted
	; tdidle[1] holds the address of the local idle()
	;
	; this will break the chain -- call dll_link(_DLLEXIT_IDLE)
	;
	mov	edx,dz_conio
	mov	eax,[edx].S_CONIO.co_tdidle[4]
	mov	[edx].S_CONIO.co_tdidle,eax
	mov	eax,_DLLEXIT_IDLE
	ret

;-------------------------------------------------------------------------
; Function 15 - link
;-------------------------------------------------------------------------

dll_link:
	mov ecx,eax	; exit-flag
	sub eax,eax
	.if cl & _DLLEXIT_IDLE
	    mov ecx,dz_conio
	    mov eax,[ecx].S_CONIO.co_tdidle
	    mov [ecx].S_CONIO.co_tdidle,considle
	    mov idleh,eax
	    mov eax,1
	.endif
	ret

;-------------------------------------------------------------------------
; Function 16 - about
;-------------------------------------------------------------------------

dll_about:
	invoke rsmodal,addr IDDABOUT
	ret

;-------------------------------------------------------------------------
; Functions not implemented
;-------------------------------------------------------------------------

dll_copy:
dll_add:
dll_delete:
dll_view:
dll_read:
dll_move:	; dest, wsub, fblk
dll_mkdir:	; wsub, directory
dll_rename:	; wsub, fblk, copy
dll_edit:	; wsub, fblk
dll_attrib:	; wsub, fblk
dll_enter:	; wsub, fblk
	invoke notsup
dll_test:
	sub eax,eax
	ret

.data

proc_label label dword
	dd dll_version
	dd dll_init
	dd dll_read
	dd dll_copy
	dd dll_add
	dd dll_move
	dd dll_mkdir
	dd dll_delete
	dd dll_rename
	dd dll_edit
	dd dll_view
	dd dll_attrib
	dd dll_enter
	dd dll_test
	dd dll_exit
	dd dll_link
	dd dll_about

.code

dll_call proc pascal export a0, a1, a2, a3, a4
	mov	eax,a0
	cmp	eax,_DLL_ABOUT
	ja	error
	mov	edx,proc_label[eax*4]
	mov	eax,a1
	call	edx
  toend:
	ret
  error:
	sub	eax,eax
	jmp	toend
dll_call endp

