include doszip.inc
include iost.inc
include tview.inc
include tinfo.inc
include io.inc
include stdio.inc
include string.inc
include alloc.inc
include confirm.inc

public  searchstring
public  replacestring
public  findfilemask
public  findfilepath
public  filelist_bat
public  format_lst
public  mklist
public  cp_selectmask

.data

;-S_DZDATA-(DLL)------------------------------------------------

programpath	db WMAXPATH dup(0)	; %doszip%
configpath	db WMAXPATH dup(0)	; %doszip% | %dz% | /C<path>
configfile	db WMAXPATH dup(0)	; %dz%.cfg | .ini | .cmd
__srcfile	db 384 dup(0)
__srcpath	db WMAXPATH dup(0)
__outfile	db 384 dup(0)
__outpath	db WMAXPATH dup(0)
entryname	db 512 dup(0)

mainswitch	dd 0			; program switch
dzexitcode	dd 0			; return code (23 if exec)
numfblock	dd MAXFBLOCK		; number of file pointers allocated

;;;;;;;;;-------------------------------
	; Configuration file (DZ.CFG)
	;-------------------------------
config  label	S_CONFIG
version		dd VERSION
cflag		dd _C_DEFAULT
console		dd CON_MOUSE or CON_IOLFN or CON_CLIPB or CON_NTCMD or CON_UTIME or CON_IMODE
fsflag		dd IO_SEARCHSUB
tvflag		dd _TV_HEXOFFSET or _TV_USEMLINE
teflag		dd _T_TEDEFAULT
telsize		dd 1	; 0:128,1:256,2:512,...
telcount	dd 10000h
titabsize	dd 8
ffflag		dd 2
compresslevel	dd 9
panelsize	dd 0	; Alt-Up/Down
fcb_indexa	dd 0
cel_indexa	dd 0
fcb_indexb	dd 0
cel_indexb	dd 0
path_a		S_PATH  <_W_DEFAULT,"*.*">
path_b		S_PATH  <_W_DEFAULT or _W_PANELID,"*.*">
opfilter	S_FILT  <-1,0,0,0,0,'*.*'>
at_background	db 00h,10h,70h,70h,40h,30h,30h,70h
at_foreground	db 00h,0Fh,0Fh,07h,08h,00h,30h,07h
		db 08h,00h,0Ah,0Bh,00h,0Fh,0Fh,0Fh
pending_file	db WMAXPATH dup(0)
mklist		S_MKLST <0,0,0,0,0,0,0,-1,0>

history		dd 0
searchstring	db 128 dup(0)
replacestring	db 128 dup(0)
cp_selectmask	db 128 dup(0)
filelist_bat	db "filelist.bat"
		db WMAXPATH-12 dup(0)
format_lst	db "%f\n"
		db 256-4 dup(0)
findfilemask	db "*.*"
		db WMAXPATH-3 dup(0)
findfilepath	db WMAXPATH dup(0)

cpanel		dd spanela
panela		dd spanela
panelb		dd spanelb

;-S_DZDATA-END--------------------------------------------------

cp_cfgfile	db "config",0

_bufin		label byte
;;;;;;;;;;;;;;;;;-----------------------------------------------
		; _bufin 4096 byte. Includes a default .INI file
		;-----------------------------------------------
	db 128 dup(0)

default_ini label byte
incbin  <dz.ini>
	db 0
style_default label byte
incbin  <default.ini>
	db 0
style_asm label byte
incbin  <asm.ini>
	db 0
style_c label byte
incbin  <c.ini>
	db 0

cp_asm		db "asm",0
cp_c		db "c",0
cp_style	db "style",0
cp_default	db "default",0
cp_inifile	db "dz.ini",0

if ($ - _bufin) LE 1000h
	db 1000h - ($ - _bufin) dup('x')
endif

.code

getcfgfile proc
	invoke strfcat,addr __srcfile,addr configpath,addr cp_cfgfile
	ret
getcfgfile endp

create_stfile proc private uses esi file, style:dword
	invoke strfcat,addr __srcfile,addr __srcpath,file
	.if osopen(eax,0,M_WRONLY,A_CREATETRUNC) != -1
	    mov esi,eax
	    or _osfile[eax],FH_TEXT
	    invoke strlen,style
	    invoke write,esi,style,eax
	    invoke close,esi
	.endif
	ret
create_stfile endp

create_user proc
	mov	config.c_cel_indexa,5
	invoke  strcpy,addr __srcpath,addr configpath
	invoke  create_stfile,addr cp_inifile,addr default_ini
	invoke  strfcat,addr __srcpath,addr configpath,addr cp_style
	invoke  mkdir,eax
	invoke  create_stfile,addr cp_default,addr style_default
	invoke  create_stfile,addr cp_asm,addr style_asm
	invoke  create_stfile,addr cp_c,addr style_c
	ret
create_user endp

config_read proc uses esi edi ebx
	sub edi,edi
	invoke getcfgfile
	.if osopen(eax,_A_NORMAL,M_RDONLY,A_OPEN) != -1
	    mov esi,eax
	    .if osread(esi,addr config,4) == 4
		mov eax,config.c_version
		mov config.c_version,VERSION
		.if eax <= VERSION && eax >= MINVERS
		    .if osread(esi,addr config.c_cflag,SIZE S_CONFIG-4) == SIZE S_CONFIG-4
			mov edi,1
		    .endif
		.endif
	    .endif
	    invoke close,esi
	.endif
	mov eax,edi
	ret
config_read endp

config_save proc uses esi edi
	mov eax,spanela.pn_fcb_index
	mov config.c_fcb_indexa,eax
	mov eax,spanela.pn_cel_index
	mov config.c_cel_indexa,eax
	mov eax,spanelb.pn_fcb_index
	mov config.c_fcb_indexb,eax
	mov eax,spanelb.pn_cel_index
	mov config.c_cel_indexb,eax
	and config.c_apath.wp_flag,not _W_VISIBLE
	.if prect_a.xl_flag & _D_DOPEN
	    or config.c_apath.wp_flag,_W_VISIBLE
	.endif
	and config.c_bpath.wp_flag,not _W_VISIBLE
	.if prect_b.xl_flag & _D_DOPEN
	    or config.c_bpath.wp_flag,_W_VISIBLE
	.endif
	sub edi,edi
	invoke getcfgfile
	.if osopen(eax,_A_NORMAL,M_WRONLY,A_CREATETRUNC) != -1
	    mov esi,eax
	    .if oswrite(esi,addr config,SIZE S_CONFIG) == SIZE S_CONFIG
		inc edi
	    .endif
	    invoke close,esi
	.endif
	mov eax,edi
	ret
config_save endp

setconfirmflag proc
	mov	edx,CFSELECTED
	mov	eax,config.c_cflag
	test	eax,_C_CONFDELETE
	jz	@F
	or	edx,CFDELETEALL
      @@:
	test	eax,_C_CONFDELSUB
	jz	@F
	or	edx,CFDIRECTORY
      @@:
	test	eax,_C_CONFSYSTEM
	jz	@F
	or	edx,CFSYSTEM
      @@:
	test	eax,_C_CONFRDONLY
	jz	@F
	or	edx,CFREADONY
      @@:
	mov	confirmflag,edx
	ret
setconfirmflag endp

	END
