include doszip.inc
include stdio.inc
include stdlib.inc
include string.inc
include io.inc
include iost.inc
include progress.inc
include process.inc
include ini.inc
ifdef __DLL__
include dll.inc
endif

menusinit	proto
MakeDirectory	proto :dword
create_user	proto

.data
externdef	comspec:dword	; %COMSPEC%
externdef	comspex:dword	; /C

cp_title	db "Doszip Commander",0
dz_comspec	db 'COMMAND.COM',0
envcfgp		dd 0
cp_user		db "doc",0
panel_A		dd 0
panel_B		dd 0

.code

ioupdate proc private stream:byte
	mov eax,STDO.ios_total
	.if !stream
	    mov eax,STDI.ios_total
	.endif
	.if progress_update(eax)
	    xor eax,eax ; User break (ESC)
	.else
	    mov eax,1
	.endif
	ret
ioupdate endp

chdir_argvfile:
	and cflag,not _C_PANELID
	mov eax,':'
	.if [ebx+1] == al
	    mov al,[ebx]
	    or  al,20h
	    sub al,'a' - 1
	    invoke chdrive,eax
	.endif
	invoke chdir,ebx
	ret

doszip_init proc uses esi edi ebx argv:dword
	invoke  SetConsoleTitle,addr cp_title
	invoke  menusinit
	invoke  getenvp,"DZ"
	mov	envcfgp,eax
	;
	; Test environ %TEMP%
	;
	.if !envtemp	; set TEMP to .EXE dir
	    mov envtemp,offset programpath
	.endif
;;;;;;;;;----------------------------------------------------
	; Set program path (%doszip%) and config path (%dz%):
	;	(1) to program path
	;	(2) from program path\dz.ini: [.]->00=<path>
	;	(3) from environ %DZ%
	;	(4) from command line /C<path>
	;
	mov	eax,_argv
	mov	eax,[eax]
	invoke  strcpy,addr programpath,eax
	invoke  strpath,eax
	lea	ebx,configpath
	mov	eax,envcfgp	; The option /C<path> overrides %DZ%
	.if eax && !configpath
	    ;--------------------------------
	    ; Test environ (%DZ%) config path
	    ;--------------------------------
	    .if filexist(eax) == 2	; directory ?
		invoke strcpy,ebx,envcfgp
	    .else
		;-----------------------------
		; Warning: missing config path
		;-----------------------------
		invoke _print,"Error open config path: %s",envcfgp
	    .endif
	.endif
	.if !configpath
	    invoke strfcat,ebx,addr programpath,addr cp_user
	.endif
	.if filexist(ebx) != 2  ; exist ?
	    .if !MakeDirectory(ebx)
		inc eax
		jmp toend
	    .endif
	.endif
;;;;;;;;;----------------------------------------------------
	; Create and read DZ.INI file
	;----------------------------------------------------
	invoke strfcat,addr configfile,addr configpath,"dz.ini"
;;;;;;;;;----------------------------------------------------
	; Create .\dzip directory if not exist
	;----------------------------------------------------
	.if !filexist(eax)
	    ;
	    ; virgin call..
	    ;
	    invoke create_user
	.endif
	invoke iniopen,addr configfile
;;;;;;;;;----------------------------------------------------
	; Read DZ.CFG
	;----------------------------------------------------
	invoke config_read
;;;;;;;;;----------------------------------------------------
	; Init COMSPEC
	;----------------------------------------------------
	.if !getcomspec()	; Warning: missing COMSPEC
	    invoke _print,"Error loading COMMAND.COM\n"
	    lea eax,dz_comspec  ; Use default -- this will fail..
	    mov comspec,eax
	.endif
	invoke historyread
;;;;;;;;;----------------------------------------------------
	; argv is .ZIP or directory
	;----------------------------------------------------
	mov ebx,argv
	.if ebx
	    .if filexist(ebx)
		.if eax == 2 ; directory ?
		    call chdir_argvfile
		.else
ifdef __ZIP__
		    invoke readword,ebx
		    .if ax == 4B50h
			and config.c_apath.wp_flag,not (_W_ARCHIVE or _W_ROOTDIR)
			and config.c_bpath.wp_flag,not (_W_ARCHIVE or _W_ROOTDIR)
			or  config.c_apath.wp_flag,_W_ARCHZIP or _W_VISIBLE
			mov config.c_apath.wp_arch,0
			invoke strfn,ebx
			push eax
			invoke strcpy,addr config.c_apath.wp_file,eax
			pop eax
			.if eax != ebx
			    mov byte ptr [eax-1],0
			    call chdir_argvfile
			.else
			    and cflag,not _C_PANELID
			    invoke getcwd,addr config.c_apath.wp_path,WMAXPATH
			.endif
		    .else
			sub eax,eax
		    .endif
endif
		.endif
	    .endif
	.endif
  ifdef __INI_LOAD__
	invoke  ExecuteSection,"Load"
  endif
	mov	thelp,cmhelp
	mov	oupdate,ioupdate
	mov	eax,numfblock
	mov	wsmaxfbb,eax
	mov	wsmaxfba,eax
	invoke  consinit
	mov	eax,considle
	mov	tdidle,eax
	mov	tdidle[4],eax
	sub	eax,eax
  toend:
	ret
doszip_init endp

test_path:
	mov	ax,[esi]
	test	al,al
	jz	test_path_0
	cmp	ah,'\'
	jne	@F
	cmp	al,'\'
	je	test_path_1
      @@:
	cmp	ah,':'
	jne	test_path_0
	or	al,20h
	sub	al,'a' - 1
	movzx	eax,al
	invoke  _disk_exist,eax
	test	eax,eax
	jz	test_path_0
	invoke  filexist,esi
	cmp	eax,2
	jne	test_path_0
	invoke  strrchr,esi,'\'
	jz	test_path_1
	mov	edx,'\'
	cmp	[eax],dx
	jne	test_path_1
	cmp	byte ptr [eax-1],':'
	je	test_path_1
	mov	[eax],dh
	jmp	test_path_1
    test_path_0:
	invoke  strcpy,esi,edi
	sub	eax,eax
	ret
    test_path_1:
	xor	eax,eax
	inc	eax
	ret

ifdef __DLL__
test_dll:
	invoke  strfcat,addr __srcpath,addr [esi].S_PATH.wp_path,addr [esi].S_PATH.wp_file
	mov	edi,eax
	invoke  readword,eax
	add	edi,S_FBLK.fb_name
	invoke  dll_test,edi,eax
	ret
endif

doszip_open proc uses esi edi ebx
	sub eax,eax
	mov dzexitcode,eax
	mov mainswitch,eax
	invoke setconfirmflag
	.if config.c_pending_file
	    invoke removefile,addr config.c_pending_file
	    mov config.c_pending_file,0
	.endif
	.if cflag & _C_DELTEMP
	    invoke removetemp,addr cp_ziplst
	    and cflag,not _C_DELTEMP
	.endif
	;
	; Init panels
	;
	mov eax,config.c_fcb_indexa
	mov spanela.pn_fcb_index,eax
	mov eax,config.c_fcb_indexb
	mov spanelb.pn_fcb_index,eax
	mov eax,config.c_cel_indexa
	mov spanela.pn_cel_index,eax
	mov eax,config.c_cel_indexb
	mov spanelb.pn_cel_index,eax
	sub eax,eax
	mov edx,offset cp_stdmask
	.if config.c_apath.wp_mask == al
	    invoke strcpy,wspanela.ws_mask,edx
	.endif
	.if config.c_bpath.wp_mask == 0
	    invoke strcpy,wspanelb.ws_mask,edx
	.endif
	.if !(console & CON_IOLFN)
	    and config.c_apath.wp_flag,not _W_LONGNAME
	    and config.c_bpath.wp_flag,not _W_LONGNAME
	.endif
	;
	; Init Desktop
	;
	.if console & CON_IMODE || _scrcol < 80
	    invoke apimode
	.endif
	invoke apiopen
	mov tupdate,apiidle
	invoke apiidle
	or console,CON_SLEEP
	invoke cursoroff
  ifdef __DLL__
	invoke readplugins
  endif
	invoke prect_open_ab
	mov eax,offset spanelb
	.if cpanel == eax
	    mov eax,offset spanela
	.endif
	invoke panel_openmsg
	mov edi,offset programpath
	mov esi,offset path_a.wp_path
	.if !test_path()
	    and path_a.wp_flag,not _W_ARCHIVE
	.endif
	mov esi,offset path_b.wp_path
	.if !test_path()
	    and path_b.wp_flag,not _W_ARCHIVE
	.endif
  ifdef __DLL__
	.if path_a.wp_flag & _W_ARCHEXT
	    lea esi,path_a
	    call test_dll
	.elseif path_b.wp_flag & _W_ARCHEXT
	    lea esi,path_b
	    call test_dll
	.endif
  endif
	.if cflag & _C_COMMANDLINE
	    invoke cursoron
	.endif
	invoke panel_open_ab
	ret
doszip_open endp

doszip_hide proc
	test	cflag,_C_AUTOSAVE
	jz	@F
	invoke  config_save
      @@:
	invoke  apiclose
	mov	eax,panelb
	invoke  prect_hide
	mov	panel_B,eax
	mov	eax,panela
	invoke  prect_hide
	mov	panel_A,eax
	ret
doszip_hide endp

doszip_show proc
	invoke  apiopen
	cmp	panel_A,0
	jz	@F
	mov	eax,panela
	invoke  redraw_panel
     @@:
	cmp	panel_B,0
	jz	@F
	mov	eax,panelb
	invoke  redraw_panel
     @@:
	ret
doszip_show endp

tdummy:
	ret

doszip_close proc
	mov	tupdate,tdummy
	test	cflag,_C_AUTOSAVE
	jz	@F
	invoke  config_save
      @@:
	mov	eax,panela
	invoke  panel_close
	mov	eax,panelb
	invoke  panel_close
  ifdef __DLL__
	invoke  freeplugins
  endif
	invoke  apiclose
	invoke  gotoxy,0,com_info.ti_ypos
	ret
doszip_close endp

	END
