include iost.inc
include io.inc
include string.inc
include conio.inc
include ctype.inc

externdef	searchstring:byte
cmsearchidd	proto :dword

.data
cp_search	db 'Search',0
cp_notfoundmsg  db "Search string not found: '%s'",0
cp_stlsearch	db 'Search for the string:',0
hexstring	db 128 dup(0)
hexstrlen	dd 0

.code

memsearch proc private uses esi edi ebx
local string[128]:byte
local slen:dword
local upper:byte
local lower:byte
	invoke  strcpy,addr string,addr searchstring
	invoke  strlen,eax
	test	eax,eax
	jz	toend
	mov	slen,eax
	test	STDI.ios_flag,IO_SEARCHHEX
	jz	@F
	invoke  hextoa,addr string
	mov	slen,ecx
     @@:
	mov	ebx,STDI.ios_c
	sub	ebx,STDI.ios_bb
	cmp	ebx,slen
	jb	fail
	mov	eax,STDI.ios_bp
	add	eax,STDI.ios_bb
	jz	fail
	inc	eax
	mov	edi,eax
	test	STDI.ios_flag,IO_SEARCHCASE
	jz	nocase
   scan:
	mov	ecx,ebx
	mov	al,string
	repnz	scasb
	jne	fail
	cmp	ecx,slen
	jl	fail
	mov	ebx,ecx
	mov	edx,edi
	dec	edi
	lea	esi,string
	mov	ecx,slen
	repz	cmpsb
	mov	edi,edx
	jnz	scan
  found:
	dec	edi
	sub	edi,STDI.ios_bp
	mov	eax,edi
	test	STDI.ios_flag,IO_RETURNLF
	jz	done
	mov	ecx,edi
	mov	ebx,eax
	sub	edx,edx
	mov	eax,10
	mov	edi,STDI.ios_bp
     @@:
	repnz	scasb
	jnz	@F
	inc	edx
	jmp	@B
     @@:
	mov	eax,ebx
	mov	ecx,edx
   done:
	inc	edi
  toend:
	ret
   fail:
	sub	eax,eax
	jmp	toend
 nocase:
	mov	al,string
	invoke  tolower,eax
	mov	lower,al
	invoke  toupper,eax
	mov	upper,al
   scan2:
	mov	ecx,ebx
	mov	edx,-1
	mov	al,lower
	push	edi
	repnz	scasb
	jne	@F
	mov	edx,edi
	mov	esi,ecx
     @@:
	pop	edi
	mov	al,upper
	mov	ecx,ebx
	repnz	scasb
	jne	@F
	cmp	edx,edi
	ja	nctest
	mov	edi,edx
	mov	ecx,esi
	jmp	nctest
     @@:
	cmp	edx,-1
	je	fail
	mov	edi,edx
	mov	ecx,esi
 nctest:
	cmp	ecx,slen
	jl	fail
	mov	ebx,ecx
	invoke  strnicmp,addr string,addr [edi-1],slen
	jnz	scan2
	jmp	found
memsearch endp

ioseek:
	mov	eax,STDI.ios_bb ; current offset | line:offset
	mov	ecx,STDI.ios_flag
	and	STDI.ios_flag,not (IO_SEARCHSET or IO_SEARCHCUR)
	test	ecx,IO_SEARCHSET
	jz	@F
	sub	eax,eax
	mov	edx,eax
	jmp	ioseek_set
      @@:
	test	ecx,IO_SEARCHCUR
	jnz	ioseek_set
	add	eax,1		; offset++ (continue)
	adc	edx,0
    ioseek_set:
	mov	edi,eax
	mov	ebp,edx
	invoke  oseek,eax,SEEK_SET
	ret

seekbx:
	cmp	ebx,STDI.ios_i
	ja	@F
	sub	edi,ebx
	sbb	ebp,0
	sub	STDI.ios_i,ebx
	ret
      @@:
	push	esi
	mov	esi,ebx
      @@:
	call	oungetc
	sub	edi,1
	sbb	ebp,0
	dec	esi
	jnz	@B
	pop	esi
	ret

lodhex:
	mov	al,[esi]
	test	al,al
	jz	lodhex_end
	inc	esi
	cmp	al,'0'
	jb	lodhex
	cmp	al,'9'
	jbe	lodhex_ok
	or	al,20h
	cmp	al,'f'
	ja	lodhex
	sub	al,27h
    lodhex_ok:
	sub	al,'0'
	test	esi,esi
    lodhex_end:
	ret

searchfound:
	mov	eax,esi
	sub	eax,edx
	inc	eax
	sub	edi,eax
	sbb	ebp,0
	mov	eax,edi
	mov	edx,ebp
	or	edi,1
	ret

searchhex:
	push	ebp
	push	esi
	push	edi
	push	ebx
	mov	edx,0
	call	ioseek
	jz	searchhex_end
	xor	ecx,ecx
	mov	esi,offset searchstring
	mov	ebx,offset hexstring
    searchhex_xtol:
	call	lodhex
	jz	searchhex_hexl
	mov	ah,al
	call	lodhex
	jnz	searchhex_mkb
	xchg	al,ah
    searchhex_mkb:
	shl	ah,4
	or	al,ah
	mov	[ebx],al
	inc	ebx
	inc	ecx
	jmp	searchhex_xtol
    searchhex_found:
	call	searchfound
    searchhex_end:
	pop	ebx
	pop	edi
	pop	esi
	pop	ebp
	ret
    searchhex_hexl:
	mov	hexstrlen,ecx
    searchhex_scan:
	mov	dl,hexstring
	mov	ecx,STDI.ios_l
      @@:
	call	ogetc
	jz	searchhex_end
	add	edi,1	; inc offset
	adc	ebp,0
	mov	ah,al
	sub	ah,10
	cmp	ah,1
	adc	ecx,0	; inc line
	cmp	al,dl
	jne	@B
	mov	STDI.ios_l,ecx
	mov	esi,offset hexstring
    searchhex_cmp:
	call	ogetc
	jz	searchhex_end
	add	edi,1
	adc	ebp,0
	inc	esi
	mov	edx,offset hexstring
	mov	ecx,esi
	sub	ecx,edx
	cmp	ecx,hexstrlen
	je	searchhex_found
	cmp	al,[esi]
	je	searchhex_cmp
	mov	ebx,esi
	sub	ebx,edx
	call	seekbx
	jmp	searchhex_scan

searchtxt:
	push ebp
	push esi
	push edi
	sub edx,edx
	call ioseek
	jz   searchtxt_end
    searchtxt_scan:
	sub ecx,ecx
	.if STDI.ios_flag & IO_SEARCHCASE
	    mov dl,searchstring
	  @@:
	    call ogetc
	    jz searchtxt_end
	    add edi,1	; inc offset
	    adc ebp,0
	    cmp al,10
	    je searchtxt_l12
	searchtxt_l11:
	    cmp al,dl
	    jne @B
	.else
	    mov al,searchstring
	    sub al,'A'
	    cmp al,'Z'-'A'+1
	    sbb ah,ah
	    and ah,'a'-'A'
	    add al,ah
	    add al,'A'
	    mov dl,al	; tolower(*searchstring)
	  @@:
	    call ogetc
	    jz searchtxt_end
	    add edi,1
	    adc ebp,0
	    cmp al,10
	    je searchtxt_l22
	searchtxt_l21:
	    sub al,'A'
	    cmp al,'Z'-'A'+1
	    sbb ah,ah
	    and ah,'a'-'A'
	    add al,ah
	    add al,'A'  ; tolower(AL)
	    cmp al,dl
	    jne @B
	.endif
	add	STDI.ios_l,ecx
	mov	esi,offset searchstring
    searchtxt_cmp:
	call	ogetc
	jz	searchtxt_end
	add	edi,1
	adc	ebp,0
	inc	esi
	mov	edx,offset searchstring
	mov	cl,al
	mov	al,[esi]
	test	al,al
	jz	searchtxt_found
	cmp	al,cl
	je	searchtxt_cmp
	.if !(STDI.ios_flag & IO_SEARCHCASE)
	    sub al,'A'
	    cmp al,'Z'-'A'+1
	    sbb ah,ah
	    and ah,'a'-'A'
	    add al,ah
	    add al,'A'  ; tolower(AL)
	    xchg al,cl
	    sub al,'A'
	    cmp al,'Z'-'A'+1
	    sbb ah,ah
	    and ah,'a'-'A'
	    add al,ah
	    add al,'A'  ; tolower(CL)
	    cmp al,cl
	    je searchtxt_cmp
	.endif
	mov	ebx,esi
	sub	ebx,edx
	call	seekbx
	jmp	searchtxt_scan
    searchtxt_found:
	call	searchfound
    searchtxt_end:
	pop	edi
	pop	esi
	pop	ebp
	ret
    searchtxt_l12:
	inc	ecx
	jmp	searchtxt_l11
    searchtxt_l22:
	inc	ecx
	jmp	searchtxt_l21

osearch proc
	.if STDI.ios_flag & IO_MEMBUF
	    call memsearch
	.elseif STDI.ios_flag & IO_SEARCHHEX
	    call searchhex
	.else
	    call searchtxt
	.endif
	ret
osearch endp

notfoundmsg proc
	mov	cp_notfoundmsg+24,' '
	invoke  strlen,addr searchstring
	cmp	eax,29
	jb	@F
	mov	cp_notfoundmsg+24,10
     @@:
	invoke  stdmsg,addr cp_search,addr cp_notfoundmsg,addr searchstring
	sub	eax,eax
	ret
notfoundmsg endp

continuesearch proc
local StatusLine[512]:byte
	sub eax,eax
	.if searchstring
	    invoke wcpushst,addr StatusLine,addr cp_stlsearch
	    mov eax,_scrrow
	    mov edx,_scrcol
	    sub edx,24
	    invoke scputs,24,eax,0,edx,addr searchstring
	    invoke oseekl,STDI.ios_bb,SEEK_SET
	    .if !ZERO?
		call osearch
		.if !ZERO?
		    mov STDI.ios_bb,eax
		    mov eax,1
		.else
		    call notfoundmsg
		.endif
	    .else
		call notfoundmsg
	    .endif
	    push eax
	    invoke wcpopst,addr StatusLine
	    pop eax
	.endif
	ret
continuesearch endp

	END
