include time.inc
include conio.inc
include keyb.inc

STARTDAY	equ 5
STARTYEAR	equ 0
MAXYEAR		equ 3000

USE_MDALTKEYS	equ 1

.data

;******** Resource begin CALENDAR *
;	{ 0x005C,   0,	 0, {42, 2,29,10} },
;******** Resource data  *******************
CALENDAR_RC label word
	dw	00283h  ; Alloc size
	dw	0005Ch,00000h,0022Ah,00A1Dh,03AF0h,0F02Fh,0293Ah,01DF0h
	dw	0F02Fh,02974h,01DF0h,0F02Fh,0DF1Dh,04D20h,06E6Fh,05420h
	dw	06575h,05720h,06465h,05420h,07568h,04620h,06972h,05320h
	dw	07461h,05320h,06E75h,02020h,01BF0h,0F0C4h,020AFh,01DF0h
	dw	02FDCh
;	68 byte
IDD_CALENDAR dd _DATA:CALENDAR_RC

;	public  IDD_CALENDAR

;******** Resource end	 CALENDAR *

;******** Resource begin CALENDAR2 *
;	{ 0x0010,   0,	 0, {45,12,14, 1} },
;******** Resource data  *******************
CALENDAR2_RC label word
	dw	0002Ch  ; Alloc size
	dw	00010h,00000h,00C2Dh,0010Eh,00EF0h,0F007h,0200Eh,00707h
;	18 byte
;******** Resource end	 CALENDAR2 *

	cp_jan  db "January",0
	cp_feb  db "February",0
	cp_mar  db "March",0
	cp_apr  db "April",0
	cp_may  db "May",0
	cp_jun  db "June",0
	cp_jul  db "July",0
	cp_aug  db "August",0
	cp_sep  db "September",0
	cp_oct  db "October",0
	cp_nov  db "November",0
	cp_dec  db "December",0
cp_month label dword
	dd offset cp_jan
	dd offset cp_feb
	dd offset cp_mar
	dd offset cp_apr
	dd offset cp_may
	dd offset cp_jun
	dd offset cp_jul
	dd offset cp_aug
	dd offset cp_sep
	dd offset cp_oct
	dd offset cp_nov
	dd offset cp_dec
keylocal label dword
	dd MOUSECMD
	dd KEY_ESC
	dd KEY_HOME
	dd KEY_RIGHT
	dd KEY_LEFT
	dd KEY_UP
	dd KEY_DOWN
	dd KEY_PGUP
	dd KEY_PGDN
	dd KEY_CTRLPGUP
	dd KEY_CTRLPGDN
	dd KEY_ENTER
	dd KEY_ALTX
ifdef USE_MDALTKEYS
	dd KEY_ALTUP
	dd KEY_ALTDN
	dd KEY_ALTLEFT
	dd KEY_ALTRIGHT
endif
keyproc label dword
	dd event_mouse
	dd event_ESC
	dd event_HOME
	dd event_nextday
	dd event_prevday
	dd event_UP
	dd event_DOWN
	dd event_prevmnd
	dd event_nextmnd
	dd event_prevyear
	dd event_nextyear
	dd event_ENTER
	dd event_ESC
ifdef USE_MDALTKEYS
	dd event_ALTUP
	dd event_ALTDN
	dd event_ALTLEFT
	dd event_ALTRIGHT
endif
	keycount = (($ - offset keyproc) / size_l)
	mtable	   db 31,28,31,30,31,30,31,31,30,31,30,31
	keypos	   db 1,5,9,13,17,21,25
	format_s_d db '%s %d',0
	format_2d  db '%2d',0

	DLG_Calendar	dd 0
	DLG_Calendar2	dd 0
	xpos		dd 0
	ypos		dd 0
	curyear		dd 0
	curmonth	dd 0
	curday		dd 0
	year		dd 0
	month		dd 0
	day		dd 0
	week_day	dd 0
	days_in_month	dd 0
	current_year	dd 0
	current_month	dd 0
	calender	dd 0
	result		dd 0


.code

days_in_feb:
	push	edx
	push	ebx
	test	ecx,ecx
	jz	days_in_feb_29
	mov	eax,ecx
	and	al,3
	jnz	@F
	mov	eax,ecx
	mov	ebx,100
	xor	edx,edx
	div	ebx
	or	edx,edx
	jnz	days_in_feb_29
      @@:
	mov	ebx,400
	mov	eax,ecx
	xor	edx,edx
	div	ebx
	test	edx,edx
	jz	days_in_feb_29
	mov	eax,28
    days_in_feb_end:
	pop	ebx
	pop	edx
	ret
    days_in_feb_29:
	mov	eax,29
	jmp	days_in_feb_end

days_in_mnd:
	cmp	ebx,2
	je	days_in_feb
	movzx	eax,mtable[ebx-1]
	ret

weekday_jan1:
	push	ebp
	push	esi
	push	edi
	xor	ebp,ebp
	mov	esi,STARTDAY
	mov	edi,ecx
	mov	ecx,STARTYEAR
    weekday_jan1_loop:
	cmp	ecx,edi
	jnb	weekday_jan1_break
	call	days_in_feb
	cmp	eax,29
	jne	@F
	add	esi,1
	adc	ebp,0
      @@:
	inc	ecx
	add	esi,1
	adc	ebp,0
	jmp	weekday_jan1_loop
    weekday_jan1_break:
	push	edx
	mov	edx,ebp
	mov	eax,esi
	mov	esi,7
	div	esi
	mov	eax,edx
	pop	edx
	mov	ecx,edi
	pop	edi
	pop	esi
	pop	ebp
	ret

getweekday:
	call	weekday_jan1
	push	esi
	push	edi
	mov	esi,eax
	mov	edi,ebx
	mov	ebx,1
      @@:
	cmp	ebx,edi
	jnb	@F
	call	days_in_mnd
	add	esi,eax
	inc	ebx
	jmp	@B
      @@:
	push	edx
	mov	edi,7
	xor	edx,edx
	mov	eax,esi
	div	edi
	mov	eax,edx
	pop	edx
	pop	edi
	pop	esi
	ret

getcurdate:	; GET SYSTEM DATE
	mov	eax,curday
	mov	day,eax
	mov	eax,curmonth
	mov	month,eax
	mov	eax,curyear
	mov	year,eax
	mov	edx,day
	mov	ecx,eax
	mov	eax,month
	mov	ebx,eax
	call	getweekday
	mov	week_day,eax
	call	days_in_mnd
	mov	days_in_month,eax
	ret

incyear:
	mov	ecx,year
	cmp	ecx,MAXYEAR
	je	@F
	inc	ecx
	ret
      @@:
	mov	ecx,STARTYEAR
	ret

decyear:
	mov	ecx,year
	test	ecx,ecx
	jz	@F
	dec	ecx
	ret
      @@:
	mov	ecx,MAXYEAR
	ret

putdate:
	push	esi
	push	edi
	mov	eax,year
	mov	edx,month
	cmp	eax,current_year
	jne	@F
	cmp	edx,current_month
	je	putdate_day
      @@:
	mov	current_month,edx
	mov	current_year,eax
	mov	eax,xpos
	mov	edx,ypos
	add	al,3
	add	dl,10
	invoke  scputw,eax,edx,14,0020h
	mov	ebx,month
	mov	ebx,cp_month[ebx*4-4]
	invoke  scputf,eax,edx,0,0,addr format_s_d,ebx,year
	mov	ebx,xpos
	mov	edx,ypos
	add	dl,3
	mov	ecx,6
	mov	eax,20h
	mov	ah,at_background[B_Dialog]
	or	ah,at_foreground[F_Dialog]
      @@:
	invoke  scputw,ebx,edx,29,eax
	inc	dl
	dec	ecx
	jnz	@B
    putdate_day:
	xor	esi,esi
	mov	edi,3
    putdate_loop:
	cmp	esi,days_in_month
	jnb	putdate_end
	xor	ecx,ecx
    putdate_xloop:
	cmp	ecx,7
	jnb	putdate_yloop
	mov	eax,3		; first line
	cmp	week_day,ecx	; week day
	ja	@F
	cmp	edi,eax
	je	putdate_putday
      @@:
	cmp	edi,eax
	jna	putdate_next
	cmp	esi,days_in_month	; days in month
	jae	putdate_next
    putdate_putday:
	inc	esi
	push	ecx
	push	edi
	mov	ebx,ecx
	mov	cl,at_background[B_Dialog]
	mov	al,at_foreground[F_DialogKey]
	cmp	esi,day
	je	@F
	mov	al,at_foreground[F_Dialog]
      @@:
	or	cl,al
	mov	al,keypos[ebx]
	mov	ebx,edi
	add	ebx,ypos
	add	eax,xpos
	mov	edi,eax
	invoke  scputf,eax,ebx,ecx,2,addr format_2d,esi
	cmp	curday,esi
	jne	@F
	mov	eax,curmonth
	cmp	eax,month
	jne	@F
	mov	eax,curyear
	cmp	eax,year
	jne	@F
	mov	al,4;at_foreground[B_Error]
	or	al,at_background[B_Dialog]
	invoke  scputa,edi,ebx,2,eax
      @@:
	pop	edi
	pop	ecx
    putdate_next:
	inc	ecx
	jmp	putdate_xloop
    putdate_yloop:
	add	edi,1
	cmp	edi,10
	jb	putdate_loop
    putdate_end:
	pop	edi
	pop	esi
	ret

setdate:
	mov	day,edx
	mov	month,ebx
	mov	year,ecx
	call	getweekday
	mov	week_day,eax
	call	days_in_mnd
	mov	days_in_month,eax
	call	putdate
	ret

ifdef USE_MDALTKEYS
event_ALTUP:
	mov	eax,rcmoveup
	jmp	DLMOVE_MOVE
event_ALTDN:
	mov	eax,rcmovedn
	jmp	DLMOVE_MOVE
event_ALTLEFT:
	mov	eax,rcmoveleft
	jmp	DLMOVE_MOVE
event_ALTRIGHT:
	mov	eax,rcmoveright
DLMOVE_MOVE:
	push	eax
	invoke  dlhide,DLG_Calendar2
	pop	eax
	mov	ebx,DLG_Calendar
	push	[ebx].S_DOBJ.dl_rect
	push	[ebx].S_DOBJ.dl_wp
	push	dword ptr [ebx].S_DOBJ.dl_flag
	call	eax
	mov	ebx,DLG_Calendar
	mov	word ptr [ebx].S_DOBJ.dl_rect,ax
	mov	byte ptr xpos,al
	mov	byte ptr ypos,ah
	add	eax,0A03h
	mov	ebx,DLG_Calendar2
	mov	word ptr [ebx].S_DOBJ.dl_rect,ax
	invoke  dlshow,DLG_Calendar2
	ret
endif

event_ENTER:
	mov	eax,1
	mov	result,eax

event_ESC:
	inc	byte ptr calender
	ret

event_HOME:
	call	getcurdate
	jmp	putdate

event_nextday:
	mov	edx,day
	inc	edx
	cmp	edx,days_in_month
	ja	event_nextmnd
	mov	day,edx
	jmp	putdate

event_prevday:
	mov	edx,day
	cmp	edx,1
	je	@F
	mov	ecx,year
	mov	ebx,month
	dec	edx
	jmp	setdate
      @@:
	call	event_prevmnd
	mov	eax,days_in_month
	mov	day,eax
	jmp	putdate

event_UP:
	mov	eax,7
	cmp	day,eax
	jbe	event_prevday
	sub	day,eax
	jmp	putdate

event_DOWN:
	mov	eax,day
	add	eax,7
	cmp	eax,days_in_month
	ja	event_nextday
	mov	day,eax
	jmp	putdate

event_prevmnd:
	mov	edx,1
	mov	ebx,month
	mov	ecx,year
	cmp	ebx,1
	je	@F
	dec	ebx
	jmp	setdate
    @@:
	mov	ebx,12
	call	decyear
	jmp	setdate

event_nextmnd:
	mov	ebx,month
	cmp	ebx,12
	je	event_nextyear
	mov	edx,1
	mov	ecx,year
	inc	ebx
	jmp	setdate

event_prevyear:
	mov	edx,1
	mov	ebx,edx
	call	decyear
	jmp	setdate

event_nextyear:
	mov	edx,1
	mov	ebx,edx
	call	incyear
	jmp	setdate

event_mouse:
	call	mousex
	mov	edx,eax
	call	mousey
	mov	ebx,DLG_Calendar
	invoke  rcxyrow,dword ptr [ebx].S_DOBJ.dl_rect,edx,eax
	test	eax,eax
	jz	event_ESC
	invoke  dlhide,DLG_Calendar2
	invoke  dlmove,DLG_Calendar
	mov	ebx,DLG_Calendar
	sub	eax,eax
	mov	al,[ebx+4]
	mov	dl,al
	mov	xpos,eax
	mov	al,[ebx+5]
	mov	ypos,eax
	mov	ah,al
	mov	al,dl
	add	ax,0A03h
	mov	ebx,DLG_Calendar2
	mov	[ebx+4],ax
	invoke  dlshow,DLG_Calendar2
	ret

modal:  cmp	byte ptr calender,0
	je	@F
	ret
      @@:
	call	tgetevent
	mov	ecx,keycount
	xor	ebx,ebx
      @@:
	cmp	eax,keylocal[ebx]
	je	@F
	add	ebx,size_l
	dec	ecx
	jnz	@B
	jmp	modal
      @@:
	call	keyproc[ebx]
	jmp	modal

cmcalendar proc uses ebx
local t:S_STIME
	invoke  GetLocalTime,addr t
	movzx	eax,t.wDay
	mov	curday,eax
	movzx	eax,t.wMonth
	mov	curmonth,eax
	movzx	eax,t.wYear
	mov	curyear,eax
	xor	eax,eax
	mov	calender,eax
	mov	current_year,eax
	mov	current_month,eax
	mov	result,eax
	invoke  rsopen,addr CALENDAR_RC
	mov	DLG_Calendar,eax
	jz	toend
	mov	ebx,eax
	sub	eax,eax
	mov	al,[ebx][4]
	mov	xpos,eax
	mov	al,[ebx][5]
	mov	ypos,eax
	invoke  dlshow,DLG_Calendar
	invoke  rsopen,addr CALENDAR2_RC
	mov	DLG_Calendar2,eax
	invoke  dlshow,eax
	call	getcurdate
	mov	edx,day
	mov	ebx,month
	mov	ecx,year
	call	setdate
	call	msloop
	call	modal
	invoke  dlclose,DLG_Calendar2
	invoke  dlclose,DLG_Calendar
	mov	edx,day
	mov	ebx,month
	mov	ecx,year
	mov	eax,result
	test	eax,eax
	jz	toend
	mov	eax,ebx
  toend:
	ret
cmcalendar endp

	END
