include dir.inc
include alloc.inc
include conio.inc
include tinfo.inc
include ctype.inc
include string.inc
include stdlib.inc
include ini.inc

tigetline	proto

ST_COUNT	equ 9

S_STYLE		STRUC
st_line		dd ?	; current line index
st_bp		dd ?	; current line adress
st_boff		dd ?	; offset start of visible line
st_bend		dd ?	; end of visible line
st_wbuf		dd ?	; screen buffer (int *)
st_type		db ?	; current type
st_attr		db ?	; current attrib
st_slen		dd ?	; length of line
st_string	dd ?	; offset of first word
st_quote_start  dd ?	; first " or ' in line
st_quote_end	dd ?	; last " or ' in line
S_STYLE		ENDS

	.data

format_label label dword
	dd tidoattrib	; 1. A Attrib
	dd tidocontrol  ; 2. O Control
	dd tidoquote	; 3. Q Quote
	dd tidonumber	; 4. D Digit
	dd tidochar	; 5. C Char
	dd tidostring	; 6. S String
	dd tidostart	; 7. B Begin
	dd tidoword	; 8. W Word
	dd tidonested	; 9. N Nested

	.code

tisetat:
	push	eax
	push	ebx
	mov	eax,edi
	dec	eax		; = offset in text line
	cmp	eax,[ebp].S_STYLE.st_boff
	jb	@F
	cmp	eax,[ebp].S_STYLE.st_bend
	ja	@F
	sub	eax,[ebp].S_STYLE.st_boff
	add	eax,eax
	add	eax,[ebp].S_STYLE.st_wbuf ; = offset in screen line (*int)
	mov	bl,[ebp].S_STYLE.st_attr
	mov	[eax+1],bl	; set attrib for this char
     @@:
	pop	ebx
	pop	eax
	ret

tisetlen:			; Set length of string in SI to BX
	push	esi		; Increase SI if string[0] == '"'
	sub	eax,eax		; if string[0] == '"' AH = '"' on return
	mov	ebx,eax
	lodsb
	cmp	al,'"'
	jne	tisetlen_noquote
	mov	ah,al
    tisetlen_loop:
	lodsb
    tisetlen_noquote:
	test	al,al
	jz	@F
	cmp	al,'"'
	je	@F
	inc	ebx
	jmp	tisetlen_loop
      @@:
	pop	esi
	cmp	ah,'"'
	jne	@F
	inc	esi
      @@:
	test	ebx,ebx
	ret

tistrchr:			; scan for next char
	lodsb
	test	al,al
	jz	tistrchr_end
	repne	scasb
	je	@F
	test	ecx,ecx
	ret
      @@:
	test	al,al
    tistrchr_end:
	ret

ticmpi:			; scan for next char no case
	push	ebx
	lodsb
	test	al,al
	jz	ticmpi_nul
	call	isupper
	mov	bl,al
	jz	@F
	or	bl,20h
      @@:
	mov	al,[edi]
	inc	edi
	call	isupper
	jz	@F
	or	al,20h
      @@:
	cmp	al,bl
    ticmpi_end:
	pop	ebx
	ret
    ticmpi_nul:
	or	bl,1
	jmp	ticmpi_end

tistrchri:			; scan for next char no case
	push	ebx
	lodsb
	test	al,al
	jz	tistrchri_end
	push	eax
	call	isupper
	mov	bl,al
	jz	tistrchri_scan
	or	bl,20h
    tistrchri_scan:
	mov	al,[edi]
	inc	edi
	call	isupper
	jz	@F
	or	al,20h
      @@:
	cmp	al,bl
	je	@F
	dec	ecx
	jnz	tistrchri_scan
	pop	eax
	pop	ebx
	ret
      @@:
	pop	eax
	test	al,al
    tistrchri_end:
	pop	ebx
	ret

ticmpsbi:
	push	ecx
	push	esi
	push	edi
	push	ebx
	mov	ecx,ebx
    ticmpsbi_lup:
	lodsb
	mov	bl,[edi]
	inc	edi
	cmp	ah,al		; AH == '"' or 0
	je	ticmpsbi_equal
	dec	ecx
	jz	ticmpsbi_end
	or	bl,20h
	or	al,20h
	cmp	al,bl
	je	ticmpsbi_lup
	xor	ecx,ecx
	jmp	ticmpsbi_end
    ticmpsbi_equal:
	inc	ecx
    ticmpsbi_end:
	pop	ebx
	pop	edi
	pop	esi
	pop	ecx
	ret

ticmpsb:
	push	ecx
	push	esi
	push	edi
	mov	ecx,ebx
	repe	cmpsb
	cmp	ah,[esi-1]	; AH == '"' or 0
	je	ticmpsb_equal
	xor	ecx,ecx
	jmp	ticmpsb_end
    ticmpsb_equal:
	inc	ecx
    ticmpsb_end:
	pop	edi
	pop	esi
	pop	ecx
	ret

tistrstr:
	mov	edi,edx
	mov	ecx,[ebp].S_STYLE.st_slen

tistrstrdi:
	call	tisetlen
	jz	tistrstr_fail
	lodsb

tistrnext:
	repne	scasb
	je	@F
	test	ecx,ecx
	jz	tistrstr_fail
      @@:
	test	ecx,ecx
	jnz	@F
	mov	ecx,ebx
      @@:
	call	ticmpsb
	jz	tistrnext
	call	isquote
	jnz	tistrstr_fail
	test	al,al
	ret

tigetquote:
	mov	al,[esi]
	inc	esi
	test	al,al
	jz	tigetquote_end
	cmp	al,"'"
	je	tigetquote_quote
	cmp	al,'"'
	jne	tigetquote
    tigetquote_quote:
	test	al,al
    tigetquote_end:
	ret

isquote:
	push	esi
	push	eax
	mov	eax,edi
	dec	eax
	cmp	eax,[ebp].S_STYLE.st_quote_end
	ja	isquote_00
	mov	esi,[ebp].S_STYLE.st_quote_start
	cmp	esi,edi
	jae	isquote_00
    isquote_l1:
	call	tigetquote
	jz	isquote_00
	cmp	edi,esi
	jb	isquote_00
	mov	ah,al
    isquote_l2:
	call	tigetquote
	jz	isquote_01
	cmp	ah,al
	jne	isquote_l2
	cmp	edi,esi
	ja	isquote_l1
    isquote_01:
	test	esi,esi
	jmp	isquote_end
    isquote_00:
	xor	eax,eax
    isquote_end:
	pop	eax
	pop	esi
	ret

; 01,attrib[,0,char],0,0

tidoattrib:
	mov	al,[esi-1]
	mov	ebx,tinfo
	mov	byte ptr [ebx+1].S_TINFO.ti_stat,al
	mov	al,[esi]
	test	al,al
	jz	tidoattrib_end
	mov	byte ptr [ebx].S_TINFO.ti_stat,al
    tidoattrib_end:
	ret

; 05: <attrib>,<'chars'>,0,0

tidochar:
	mov	edi,edx
	mov	ecx,[ebp].S_STYLE.st_slen
	call	tistrchr
	jnz	tidochar_set
	or	al,al
	jnz	tidochar
	ret
    tidochar_scan:
	repne	scasb
	je	tidochar_set
	test	ecx,ecx
	jz	tidochar
    tidochar_set:
	call	isquote
	jnz	tidochar_scan
	call	tisetat
	jmp	tidochar_scan

tistrstr_fail:
	xor	al,al
	ret

; 03ATstring,0

tidostart:
	call	tistrstr
	jz	tidostart_end
    tidostart_set:
	call	tisetat
	mov	al,[edi]
	inc	edi
	test	al,al
	jnz	tidostart_set
    tidostart_end:
	lodsb
	test	al,al
	jnz	tidostart_end
	cmp	[esi],al
	jne	tidostart
	ret

; 04ATstring1,0,string2,0,0

MAXNLINES equ 3000

tifind  proc pascal private string:size_t, line:size_t, max:size_t
	push	esi
	push	edi
	push	ebx
	call	tisetlen
	jz	tifind_end
	dec	line
    tifind_line:
	mov	esi,string
	mov	al,[esi]
	mov	eax,line
	call	tigetline
    tifind_notfound:
	jz	tifind_end
	push	eax
	mov	edi,eax
	call	strlen
	jz	tifind_next
	mov	ecx,eax
	add	edi,eax
	dec	edi
    tifind_scan:
	lodsb
	test	al,al
	jz	tifind_next
	std
	repne	scasb
	cld
	jne	tifind_next
	add	edi,2
	mov	ah,0
	call	ticmpsb
	jnz	tifind_found
	sub	edi,2
	dec	esi
	jmp	tifind_scan
    tifind_next:
	dec	max
	jz	tifind_end
	dec	line
	jmp	tifind_line
    tifind_end:
	pop	ebx
	pop	edi
	pop	esi
	ret
    tifind_found:
	mov	eax,line
	mov	edx,edi
	dec	edx
	inc	ebx
	jmp	tifind_end
tifind  endp

tinested:
	mov	edi,edx			; .st_bp
	push	esi
	push	edi
	push	ebx
	mov	eax,[ebp].S_STYLE.st_line
	test	eax,eax			; line index
	jz	tinested_end
	push	esi			; find last start-string
	push	eax
	push	MAXNLINES
	call	tifind
	jz	tinested_notfound
	mov	edi,eax			; match line
	mov	ebx,edx			; match offset
    tinested_endword:
	lodsb
	test	al,al
	jnz	tinested_endword
	cmp	[esi],al		; second word ?
	je	tinested_found		; start, no end - ok
	push	esi			; DI end-string
	push	[ebp].S_STYLE.st_line
	push	MAXNLINES
	call	tifind
	jz	tinested_found		; start+end
	cmp	eax,edi
	ja	tinested_notfound
	jb	tinested_found
	cmp	edx,ebx
	ja	tinested_notfound
    tinested_found:			; open, find end..
	mov	ebx,1
	jmp	tinested_popl
    tinested_notfound:
	xor	ebx,ebx
    tinested_popl:
	mov	eax,[ebp].S_STYLE.st_line	; back to this line
	call	tigetline
	mov	edx,eax
	test	ebx,ebx
    tinested_end:
	pop	ebx
	pop	edi
	pop	esi
	ret

stgetnextarg:
	lodsb
	test	al,al
	jnz	stgetnextarg
	ret

tidonested:
	call	tisetlen		; BX to length of first arg
	jz	tistrstr_fail
	call	tinested		; find start condition
	mov	ecx,[ebp].S_STYLE.st_slen	; CX to length of line
	jz	tidonested_line
	call	stgetnextarg
	jmp	tidonested_seek
    tidonested_next:
	mov	esi,[ebp].S_STYLE.st_string
	mov	ecx,[ebp].S_STYLE.st_slen
	mov	eax,edi
	sub	eax,[ebp].S_STYLE.st_bp
	sub	ecx,eax
	jle	tidonested_end
	call	tistrstrdi
	jz	tidonested_end
	jmp	tidonested_first
    tidonested_line:
	mov	esi,[ebp].S_STYLE.st_string
	call	tistrstr
	jz	tidonested_end
    tidonested_first:
	call	tisetat
	lodsb
	test	al,al
	jz	tidonested_seek
	inc	edi
	assert  cx,0,jne,"nested"
	dec	ecx
	jnz	tidonested_first
	call	tisetat
    tidonested_seek:
	test	ecx,ecx
	jz	tidonested_end
	lodsb
	test	al,al
	jz	tidonested_end
	push	esi
	push	edi
	call	tistrnext
	mov	ecx,edi
	pop	edi
	pop	esi
	jz	tidonested_null
	sub	ecx,edi
	jle	tidonested_end
    tidonested_pad:
	call	tisetat
	inc	edi
	dec	ecx
	jnz	tidonested_pad
	add	ecx,ebx
	jz	tidonested_end
	dec	edi
    tidonested_endtag:
	inc	edi
	call	tisetat
	dec	ecx
	jnz	tidonested_endtag
    tidonested_end:
	mov	eax,edi
	sub	eax,[ebp].S_STYLE.st_bp
	cmp	eax,[ebp].S_STYLE.st_slen
	jb	tidonested_next
	ret
    tidonested_null:
	dec	edi
	mov	eax,edi
	sub	eax,[ebp].S_STYLE.st_bp
	mov	ecx,[ebp].S_STYLE.st_slen
	sub	ecx,eax
	jg	tidonested_endtag
	jmp	tidonested_end

; 02FBstring1,0,string2,0,..,0

tiistart:		; test if di is the first char in a word
	push	eax	; di is match + 1, di-2 is char in front
	mov	eax,edi
	dec	eax
	cmp	eax,[ebp].S_STYLE.st_bp
	je	tiistart_ok	; start of line
	assertf jnb,"tiistart"
	mov	al,[edi][-2]
	cmp	al,'_'
	je	@F
	call	getctype
	jz	tiistart_end
	and	ah,_UPPER or _LOWER or _DIGIT
	jz	tiistart_ok
      @@:
	sub	al,al
	jmp	tiistart_end
    tiistart_ok:
	inc	eax
    tiistart_end:
	pop	eax
	ret

tidoword:		; match on all equal words if not inside quote
	mov	edi,edx
	mov	ecx,[ebp].S_STYLE.st_slen
	call	tisetlen
	jz	tidoword_end
    tidoword_scan:
	call	tistrchri
	jnz	tidoword_set
      @@:
	test	al,al
	jz	@F
	lodsb
	jmp	@B
      @@:
	lodsb
	test	al,al
	jz	tidoword_end
	dec	esi
	jmp	tidoword
    tidoword_find:
	dec	esi
	jmp	tidoword_scan
    tidoword_set:
	call	ticmpsbi
	jz	tidoword_find
	push	esi
	push	ebx
	push	eax
	call	isquote
	jnz	tidoword_pop	; = inside quote
	call	tiistart
	jz	tidoword_pop
	mov	al,[ebx][edi-1]
	call	islabel
	jnz	tidoword_pop
      @@:
	call	tisetat
	inc	edi
	dec	ebx
	jnz	@B
	dec	edi
    tidoword_pop:
	pop	eax
	pop	ebx
	pop	esi
	jmp	tidoword_find
    tidoword_end:
	ret

tidocontrol:		; match on all control chars
	mov	edi,[ebp].S_STYLE.st_boff
    tidocontrol_loop:
	mov	al,[edi]
	inc	edi
	test	al,al
	jz	tidocontrol_end
	call	getctype
	test	ah,ah
	jz	@F
	and	ah,_CONTROL
	jz	tidocontrol_next
	cmp	al,9
	je	tidocontrol_next
	mov	ebx,tinfo
	test	[ebx].S_TINFO.ti_flag,_T_SHOWTABS
	jz	tidocontrol_next
      @@:
	call	tisetat
    tidocontrol_next:
	cmp	edi,[ebp].S_STYLE.st_bend
	jb	tidocontrol_loop
    tidocontrol_end:
	ret

tidostring:		; match on all equal strings if not inside quote
	mov	edi,edx
	mov	ecx,[ebp].S_STYLE.st_slen
	call	tisetlen
	jz	tidostring_end
	call	tistrchr
	jnz	tidostring_set
    tidostring_next:
	test	al,al
	jz	@F
	lodsb
	jmp	tidostring_next
      @@:
	lodsb
	test	al,al
	jz	tidostring_end
	dec	esi
	jmp	tidostring
    tidostring_scan:
	repne	scasb
	test	ecx,ecx
	jz	tidostring_next
    tidostring_set:
	call	ticmpsb
	jz	tidostring_scan
	push	esi
	push	ebx
	call	isquote
	jnz	tidostring_pop  ; = inside quote
      @@:
	call	tisetat
	inc	edi
	dec	ebx
	jnz	@B
	dec	edi
    tidostring_pop:
	pop	ebx
	pop	esi
	jmp	tidostring_scan
    tidostring_end:
	ret

tidoquote:		; match on '"' and "'", fail on "\"C\""
	mov	edi,[ebp].S_STYLE.st_bp
    tidoquote_loop:
	mov	al,[edi]
	inc	edi
	test	al,al
	jz	tidoquote_end
	call	isquote
	jz	@F
	call	tisetat
     @@:
	cmp	edi,[ebp].S_STYLE.st_bend
	jb	tidoquote_loop
    tidoquote_end:
	ret

tidonumber:		; match on 0x 0123456789ABCDEF and Xh
	mov	edi,[ebp].S_STYLE.st_boff
    tidonumber_loop:
	mov	al,[edi]
	inc	edi
	call	getctype
	jz	tidonumber_end
	test	ah,_DIGIT
	jz	tidonumber_next
	call	isquote
	jnz	tidonumber_next
	call	tiistart
	jz	tidonumber_next
	mov	esi,edi
	cmp	al,'0'
	jne	@F
	mov	al,[esi]
	inc	esi
	or	al,20h
	cmp	al,'x'
	je	@F
	dec	esi
     @@:
	mov	al,[esi]
	inc	esi
	call	getctype
	jz	tidonumber_set
	test	ah,_HEX
	jnz	@B
	or	al,20h
	cmp	al,'h'
	jne	@F
	inc	esi
	jmp	tidonumber_set
     @@:
	and	ah,_UPPER or _LOWER
	jnz	tidonumber_next
    tidonumber_set:
	sub	esi,edi
      @@:
	call	tisetat
	inc	edi
	dec	esi
	jnz	@B
    tidonumber_next:
	cmp	edi,[ebp].S_STYLE.st_bend
	jb	tidonumber_loop
    tidonumber_end:
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

tisetquote:	; "s\"C\"e"
	push	esi
	mov	esi,[ebp].S_STYLE.st_bp
	mov	[ebp].S_STYLE.st_quote_start,esi
	mov	[ebp].S_STYLE.st_quote_end,esi
	invoke  strlen,esi	; ESI to line
	add	ecx,esi		; CX to eol
    tisetquote_00:
	sub	eax,eax
	call	tigetquote
	jz	tisetquote_end
	mov	ah,al
	mov	ebx,esi
	dec	ebx
	mov	[ebp].S_STYLE.st_quote_end,ecx
      @@:
	call	tigetquote
	jz	tisetquote_eof
	cmp	ah,al
	jne	@B
	cmp	esi,ecx
	jbe	tisetquote_00
	mov	eax,ebx
	cmp	eax,ecx
	jnb	@F
	mov	eax,[ebp].S_STYLE.st_bp
      @@:
	mov	[ebp].S_STYLE.st_quote_start,eax
	mov	ebx,esi
      @@:
	call	tigetquote
	jz	@F
	mov	ebx,esi
	jmp	@B
      @@:
	mov	eax,ebx
	dec	eax
	mov	[ebp].S_STYLE.st_quote_end,eax
    tisetquote_end:
	pop	esi
	ret
    tisetquote_eof:
	mov	eax,[ebp].S_STYLE.st_bp
	mov	[ebp].S_STYLE.st_quote_start,eax
	jmp	tisetquote_end

tistyle proc uses esi edi ebx ebp
local	style:S_STYLE
	mov	esi,tinfo
	lea	ebp,style
	mov	[ebp].S_STYLE.st_line,ebx		; line id
	mov	[ebp].S_STYLE.st_bp,eax		; pointer to line
	mov	[ebp].S_STYLE.st_wbuf,edx		; output buffer (*int) (SS)
	mov	[ebp].S_STYLE.st_slen,ecx		; length of line
	add	eax,[esi].S_TINFO.ti_boff		; start of line
	mov	[ebp].S_STYLE.st_boff,eax
	mov	edx,eax
	add	eax,ecx
	add	edx,TIMAXSCRLINE
	cmp	eax,edx
	jb	@F
	mov	eax,edx
	dec	eax
      @@:
	mov	[ebp].S_STYLE.st_bend,eax		; end of line
	mov	esi,tinfo
	mov	esi,[esi].S_TINFO.ti_style		; DS:SI style
	test	esi,esi
	jz	tistyle_end
	call	tisetquote
    tistyle_loop:
	sub	eax,eax
	lodsw
	mov	[ebp].S_STYLE.st_attr,ah
	mov	[ebp].S_STYLE.st_type,al
	test	al,al
	je	tistyle_end
	mov	ah,0
	dec	eax
	cmp	al,ST_COUNT
	jnb	tistyle_end
	mov	[ebp].S_STYLE.st_string,esi
	mov	edx,[ebp].S_STYLE.st_bp
	push	esi
	call	format_label[eax*4]
	pop	esi
      @@:
	lodsb
	test	al,al
	jnz	@B
	lodsb
	test	al,al
	jnz	@B
	jmp	tistyle_loop
    tistyle_end:
	ret
tistyle endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; 1. Attrib	A -	Set background and forground color
; 2. Control	O -	Set color of CONTROL characters
; 3. Quote	Q -	Set color of quoted text
; 4. Digit	D -	Set color of numbers
; 5. Char	C -	Set color of chars
; 6. String	S -	Set color of string
; 7. Begin	B -	Set color from start of string
; 8. Word	W -	Set color of words
; 9. Nested	N -	Set color of nested strings
;
.data

externdef	configpath:byte
externdef	configfile:byte

ID_TYPE		equ 0
ID_ATTRIB	equ 1

ST_ATTRIB	equ 1	; attrib	<at> [<char>]
ST_CHAR		equ 2	; char		<at> <chars>
ST_WORD		equ 3	; word		<at> <words> ...
ST_START	equ 4	; start		<at> <string>
ST_NESTED	equ 5	; nested	<at> <string1> <string2>
ST_CONTROL	equ 6	; control	<at>
;ST_STRING	equ 7	; string	<at> <string>
ST_QUOTE	equ 8	; quote		<at>
ST_NUMBER	equ 9	; number	<at>
ST_COUNT	equ ST_NUMBER

S_RDST		STRUC
st_file		db 256 dup(?)
st_path		db 256 dup(?)
st_section	db 64 dup(?)
st_label	db 64 dup(?)
st_sp		dd ?
st_eof		dd ?	; style + SIZE style - 2
S_RDST		ENDS

cp_style	db 'Style',0	; %dz%\style\*
cp_default	db 'default',0  ; asm, c, ...
cp_typech	db 'aoqdcsbwn',0
entry		label word
		db '00',0

.code

getentry:
	mov	ah,al
	mov	al,0
	cmp	ah,10
	jb	@F
	inc	al
	sub	ah,10
      @@:
	or	ax,'00'
	mov	entry,ax
	invoke  inientryf,edx,addr entry,addr [ebp].S_RDST.st_file
	ret

tireadlabel:
	push	esi
	push	edi
	lea	esi,[ebp].S_RDST.st_label
	mov	eax,ID_TYPE
	mov	edx,esi
	call	getentry
	jz	tireadlabel_end
	mov	edi,[ebp].S_RDST.st_sp
	cmp	edi,[ebp].S_RDST.st_eof
	ja	tireadlabel_end
	mov	ebx,eax
	mov	ah,[ebx]
	or	ah,20h
	xor	ecx,ecx
	xchg	ecx,ebx
      @@:
	mov	al,cp_typech[ebx]
	cmp	al,ah
	je	@F
	inc	ebx
	test	al,al
	jnz	@B
	jmp	tireadlabel_end
      @@:
	mov	al,bl
	inc	al
	mov	ebx,ecx
	stosb
	movzx	esi,al
	xor	ecx,ecx
      @@:
	inc	ebx
	mov	al,[ebx]
	call	islabel
	jnz	@B
	push	esi
	mov	esi,ebx
    tireadlabel_loop:
	lodsb
	cmp	al,' '
	jne	@F
	mov	eax,esi
	pop	esi
	jmp	tireadlabel_attrib
      @@:
	test	al,al
	jnz	tireadlabel_loop
	pop	esi
	mov	eax,ID_ATTRIB
	mov	edx,ebx
	call	getentry
	mov	ecx,1
	jz	tireadlabel_break
    tireadlabel_attrib:
	mov	ebx,eax
	add	eax,2
	push	eax
	mov	eax,[ebx]
	or	eax,2020h
	cmp	al,'x'
	jne	tireadlabel_bg
	mov	al,ah
	call	getctype
	and	ah,_HEX or _DIGIT
	jz	tireadlabel_getat
	sub	al,'0'
	and	ah,_DIGIT
	jnz	@F
	sub	al,39
      @@:
	mov	ebx,tinfo
	mov	ah,byte ptr [ebx+1].S_TINFO.ti_stat
	and	ah,0F0h
	or	al,ah
	jmp	tireadlabel_stoat
    tireadlabel_getat:
	push	ecx
	invoke  xtol,ebx
	pop	ecx
	jmp	tireadlabel_stoat
    tireadlabel_bg:
	cmp	ah,'x'
	jne	tireadlabel_getat
	call	getctype
	and	ah,_HEX or _DIGIT
	jz	tireadlabel_getat
	sub	al,'0'
	and	ah,_DIGIT
	jnz	@F
	sub	al,39
      @@:
	shl	al,4
	mov	ebx,tinfo
	mov	ah,byte ptr [ebx].S_TINFO.ti_stat[1]
	and	ah,0Fh
	or	al,ah
    tireadlabel_stoat:
	stosb
	pop	ebx
      @@:
	mov	ah,[ebx]
	inc	ebx
	cmp	ah,' '
	je	@B
	dec	ebx
	cmp	esi,ST_ATTRIB
	je	tireadlabel_char
	mov	esi,ecx
	inc	esi
	mov	eax,ebx
	jmp	tireadlabel_start
    tireadlabel_label:
	cmp	esi,100
	je	tireadlabel_break
	mov	eax,esi
	lea	edx,[ebp].S_RDST.st_label
	inc	esi
	call	getentry
	jz	tireadlabel_break
    tireadlabel_start:
	mov	ebx,esi
	mov	ecx,[ebp].S_RDST.st_eof
	mov	esi,eax
	cmp	byte ptr [esi],0
	je	tireadlabel_endcopy
    tireadlabel_copy:
	lodsb
	cmp	edi,ecx
	jae	tireadlabel_endcopy
	cmp	al,' '
	jne	@F
	mov	al,0
	stosb
	jmp	tireadlabel_copy
     @@:
	stosb
	test	al,al
	jnz	tireadlabel_copy
    tireadlabel_endcopy:
	mov	esi,ebx
	jmp	tireadlabel_label
    tireadlabel_char:
	mov	esi,tinfo
	mov	byte ptr [esi+1].S_TINFO.ti_stat,al
	test	ah,ah
	jz	tireadlabel_break
	invoke  xtol,ebx
	mov	byte ptr [esi].S_TINFO.ti_stat,al
	stosb
    tireadlabel_break:
	sub	eax,eax
	cmp	[edi-1],al
	je	@F
	stosb
      @@:
	stosb
	mov	[ebp].S_RDST.st_sp,edi
	inc	eax
    tireadlabel_end:
	pop	edi
	pop	esi
	ret

tiloadsection:
	invoke  strfcat,addr [ebp].S_RDST.st_file,addr [ebp].S_RDST.st_path,edx
	mov	eax,'.'
	mov	dword ptr [ebp].S_RDST.st_section,eax
	ret

tidosection:
	push	esi
	push	edi
	sub	esp,64
	mov	edi,esp
	invoke  memcpy,edi,addr [ebp].S_RDST.st_section,64
	mov	edx,eax
	call	tiloadsection
	xor	esi,esi
    tidosection_do:
	mov	eax,esi
	inc	esi
	lea	edx,[ebp].S_RDST.st_section
	call	getentry
	jz	tidosection_end
	mov	edi,eax
	mov	al,[edi]
	cmp	al,'['
	jne	tidosection_label
	mov	ebx,esi
	mov	edx,edi
	mov	esi,edi
	inc	esi
	lea	edi,[ebp].S_RDST.st_section
      @@:
	lodsb
	stosb
	test	al,al
	jz	@F
	cmp	al,']'
	jne	@B
      @@:
	dec	edi
	sub	eax,eax
	stosb
	mov	esi,ebx
	mov	edi,edx
	call	tidosection
	mov	edx,esp
	call	tiloadsection
	jmp	tidosection_do
    tidosection_label:
	invoke  strcpy,addr [ebp].S_RDST.st_label,edi
	call	tireadlabel
	jmp	tidosection_do
    tidosection_end:
	add	esp,64
	pop	edi
	pop	esi
	ret

tireadstyle proc uses esi edi ebx ebp
local rdst:S_RDST
	lea	ebp,rdst
	invoke  malloc,STYLESIZE
	jz	toend
	mov	esi,tinfo
	mov	[esi].S_TINFO.ti_style,eax
	mov	[ebp].S_RDST.st_sp,eax
	mov	edi,eax
	add	eax,STYLESIZE-4
	mov	[ebp].S_RDST.st_eof,eax
	xor	eax,eax
	mov	ecx,STYLESIZE/4
	rep	stosd
	invoke  strfcat,addr [ebp].S_RDST.st_path,addr configpath,addr cp_style
	invoke  strcpy,addr [ebp].S_RDST.st_section,addr cp_default
	invoke  strfn,[esi].S_TINFO.ti_file	; name || name.ext
	mov	edi,eax
	invoke  strrchr,edi,'.'			; *.ext
	jz	@F
	inc	eax
	mov	edi,eax
     @@:
	invoke  inientry,addr cp_style,edi
	jz	@F
	lea	ecx,[ebp].S_RDST.st_section
	invoke  strcpy,ecx,eax
     @@:
	call	tidosection
	mov	edi,[ebp].S_RDST.st_sp
	xor	eax,eax
	stosw
	inc	eax
    toend:
	ret
tireadstyle endp

	END
