include io.inc
include dir.inc
include conio.inc
include stdio.inc
include stdlib.inc
include string.inc
include alloc.inc

_LIST_APPEND	equ 01h
_LIST_XDRIVE	equ 02h
_LIST_XPATH	equ 04h
_LIST_UNIX	equ 08h
_LIST_MACRO	equ 10h
_LIST_INCDIR	equ 20h
_LIST_RECURSIV  equ 40h
_LIST_TRUNC	equ 80h
_LIST_USEFILE	equ 0100h

S_LIST		STRUC
li_flag		dd ?
li_outb		dd ?
li_curd		dd ?
li_file		dd ?
li_format	dd ?
li_sublen	dd ?	; length of local directory
li_handle	dd ?
li_total	dd ?	; total file count in list
S_LIST		ENDS

.data

cpinfo  db "LIST Version 1.01, "
%	db "&@Date",10,10,0
cpusage db "Usage: LIST [-option] [<listfile>] <file(s)> [<format>] [-option] [@arg_file]",10
	db '       LIST -v *.* -hHead "\t%%n \n" -eExit',10
	db '       LIST cc.mif *.asm -hOBJS=\ "\t%%n.obj \\\n"',10
	db " -a    append text to <listfile>",10
	db " -i    include directories in <listfile>",10
	db " -r    process subfolders",10
	db " -u    convert to unix",10
	db " -xd   exclude <drive> in location",10
	db " -xp   exclude <path> in location",10
	db " -y    assume Yes on all queries",10
	db " -q    quiet",10
	db " -v    verbose (no <listfile>)",10
	db " -h#   head text (start)",10
	db " -e#   exit text (end)",10
	db " @#    continue from file #",10,10
	db "Output format string:",10,10
	db " \\     \",10
	db " \%%      %%",10
	db " \t     09",10
	db " \n     0D 0A",10
	db " %%id    Index",10,10
	db " %%ext   .asm",10
	db " %%n     cmmklist",10
	db " %%p     /doszip/src/dzmain",10
	db " %%f     /doszip/src/dzmain/cmmklist.asm",10
	db " %%cd    <Current Directory>",10
	db 10,0

crlf	db 13,10,0
ff_form db '%f\n',0
	db WMAXPATH-5 dup(?)
options db "airuyxqveh",0

option_y db 0
option_v db 0
option_q db 0

ff_head db 256 dup(0)
ff_exit db 256 dup(0)
ff_name db WMAXPATH dup(0)
ff_path db WMAXPATH dup(0)
ff_mask db WMAXPATH dup(0)
ff_fblk S_WFBLK <0>
ff_list S_LIST <0>

$TAB9 db '\t',0		; --> 09
$CRLF db '\n',0		; --> 0D 0A
$FILE db '%f',0		; --> File name
$PATH db '%p',0		; --> Path part of file
$CURD db '%cd',0	; --> Current directory
$NAME db '%n',0		; --> Name part of file
$TYPE db '%ext',0	; --> Extension of file
$TMP1 db 7,1,0		; <--> unlikely combination 1 '\\'
$TMP2 db 7,2,0		; <--> unlikely combination 2 '\%'
$BACK db '\'		; --> 5C
BACK$ db '\',0		; '\'
FORS$ db '/',0		; '/'
$SIGN db '\'		; --> 25
SIGN$ db '%',0		; '%'
TAB9$ db 9,0		; 9
CRLF$ db 0Dh,0Ah	; 13,10
NULL$ db 0		; 0

.code
	assume  ebx:ptr S_LIST

listopen proc uses ebx lp:dword, file:dword, format:dword
	mov ebx,lp
	mov eax,ebx
	add eax,4
	invoke memzero,eax,SIZE S_LIST-4
	mov eax,format
	mov [ebx].li_format,eax
	mov eax,file
	mov [ebx].li_file,eax
	.if malloc(1024+WMAXPATH)
	    mov [ebx].li_outb,eax
	    add eax,1024
	    mov [ebx].li_curd,eax
	    mov byte ptr [eax],0
	    invoke getcwd,eax,WMAXPATH
	    mov eax,[ebx].li_flag
	    .if eax & _LIST_USEFILE
		.if eax & _LIST_APPEND
		    mov eax,A_OPEN
		.else
		    .if eax & _LIST_TRUNC
			mov eax,A_CREATETRUNC
		    .else
			mov eax,A_CREATE
		    .endif
		.endif
		.if osopen(file,_A_NORMAL,M_WRONLY,eax) != -1
		    mov [ebx].li_handle,eax
		    .if [ebx].li_flag & _LIST_APPEND
			invoke lseek,eax,0,SEEK_END
		    .endif
		.else
		    invoke free,[ebx].li_outb
		    sub eax,eax
		.endif
	    .else
		mov eax,1
		mov [ebx].li_handle,eax
	    .endif
	.endif
	test eax,eax
	ret
listopen endp

listclose proc uses eax ebx lp:dword
	mov ebx,lp
	.if [ebx].li_flag & _LIST_USEFILE
	    invoke close,[ebx].li_handle
	.endif
	invoke free,[ebx].li_outb
	ret
listclose endp

expand_macro:
	push	ecx
	mov	edx,eax
	invoke  strlen,eax
	pop	ecx
	invoke  strxchg,edi,edx,ecx,eax
	ret

listadd proc uses esi edi ebx lp:dword, filename:dword
local	f[WMAXPATH]:byte
	mov ebx,lp
	lea esi,f
	invoke strcpy,esi,filename
	mov eax,[ebx].li_flag
	sub ecx,ecx
	inc [ebx].li_total
	.if al & _LIST_XDRIVE
	    .if byte ptr [esi+1] == ':'
		add ecx,2
	    .endif
	.endif
	.if al & _LIST_XPATH
	    add esi,[ebx].li_sublen
	    sub ecx,ecx
	.endif
	add esi,ecx
	.if al & _LIST_UNIX
	    invoke dostounix,esi
	.endif
	mov edi,[ebx].li_outb
	invoke strcpy,edi,[ebx].li_format
	.if !([ebx].li_flag & _LIST_MACRO)
	    invoke strcpy,edi,esi
	    jmp listadd_nomacro
	.endif
	mov eax,offset $BACK	; '\\'
	mov ecx,offset $TMP1	; --> 07 01
	call expand_macro
	mov eax,offset $CRLF	; '\n'
	mov ecx,offset CRLF$	; --> 0D 0A
	call expand_macro
	mov eax,offset $TAB9	; '\t'
	mov ecx,offset TAB9$	; --> 09
	call expand_macro
	mov eax,offset $SIGN	; '\%'
	mov ecx,offset $TMP2	; --> 07 02
	call expand_macro
	mov eax,offset $TMP1	; 07 01
	mov ecx,offset BACK$	; --> '\'
	call expand_macro
	mov eax,offset $FILE
	mov ecx,esi
	call expand_macro
	invoke strfn,esi
	mov esi,eax
	invoke strrchr,eax,'.'
	push eax
	.if ZERO?
	    mov eax,offset NULL$
	.endif
	mov ecx,eax
	mov eax,offset $TYPE
	call expand_macro
	pop eax
	.if eax
	    mov byte ptr [eax],0
	.endif
	mov ecx,esi
	mov eax,offset $NAME
	call expand_macro
	lea eax,f
	.if eax != esi
	    mov ecx,eax
	    mov byte ptr [esi-1],0
	.else
	    mov ecx,offset NULL$
	.endif
	mov eax,offset $PATH
	call expand_macro
	mov ecx,[ebx].li_curd
	mov eax,offset $CURD
	call expand_macro
	mov eax,offset $TMP2 ; 07 02 00
	mov ecx,offset SIGN$ ; --> '%'
	call expand_macro
    listadd_nomacro:
	invoke strlen,edi
	.if eax && !([ebx].li_flag & _LIST_MACRO)
	    invoke strcat,edi,addr CRLF$
	    invoke strlen,edi
	.endif
	.if eax ;&& [ebx].li_flag & _LIST_USEFILE
	    invoke oswrite,[ebx].li_handle,[ebx].li_outb,eax
	.endif
	ret
listadd endp

	assume ebx:nothing

do_file proc uses ebx directory:dword, ff:dword
local	fname[WMAXPATH]:byte
	mov ebx,ff
	mov ecx,directory
	.if ebx
	    lea ecx,[ebx].S_WFBLK.wf_name
	.endif
	.if cmpwarg(ecx,addr ff_mask)
	    .if ebx
		invoke strfcat,addr fname,directory,addr [ebx].S_WFBLK.wf_name
	    .else
		invoke strcpy,addr fname,directory
	    .endif
	    .if listadd(addr ff_list,addr fname)
		sub eax,eax
	    .endif
	.endif
	ret
do_file endp

do_directory proc directory:dword
	.if !scan_files(directory)
	    .if ff_list.li_flag & _LIST_INCDIR
		invoke do_file,directory,0
	    .endif
	.else
	    mov eax,-1
	.endif
	ret
do_directory endp

set_directory proc directory:dword
local	path[WMAXPATH]:byte
	invoke strfcat, addr path, addr ff_path, directory
	sub eax,eax
	.if ff_list.li_flag & _LIST_RECURSIV
	    invoke scan_directory,0,addr path
	.elseif ff_list.li_flag & _LIST_INCDIR
	    invoke do_file,addr path,0
	.endif
	ret
set_directory endp

readfiles proc uses esi ebx
local ffmask[256]:byte
	invoke strlen,addr ff_path
	.if eax
	    inc eax
	.endif
	mov ff_list.li_sublen,eax
	mov ebx,offset ff_fblk
	invoke strfcat,addr ffmask,addr ff_path,"*.*"
	invoke wfindfirst,addr ffmask,ebx,_A_ALLFILES
	mov esi,eax
	.if eax == -1
	    sub eax,eax
	    jmp readwf_end
	.endif
	.if [ebx].S_WFBLK.wf_name == '.' && [ebx].S_WFBLK.wf_name[1] == 0
	    .if wfindnext(ebx,esi)
		jmp @F
	    .endif
	    .if [ebx].S_WFBLK.wf_name == '.' && [ebx].S_WFBLK.wf_name[2] == 0
		.if wfindnext(ebx,esi)
		    jmp @F
		.endif
	    .endif
	.endif
	.repeat
	    .if [ebx].S_WFBLK.wf_attrib & _A_SUBDIR
		.if set_directory(addr [ebx].S_WFBLK.wf_name)
		    .break
		.endif
	    .else
		invoke do_file,addr ff_path,ebx
	    .endif
	    invoke wfindnext,ebx,esi
	.until eax
      @@:
	invoke wcloseff,esi
	sub eax,eax
    readwf_end:
	ret
readfiles endp

putstring proc uses esi edi ebx string:dword
local buf[256]:byte
	lea edi,buf
	mov esi,string
	movzx eax,byte ptr [edi]
	.if al == '"'
	    mov ah,al
	    lodsb
	.endif
	.repeat
	    lodsb
	    .break .if al == ah
	    .if al == '\'
		lodsb
		.break .if !al
		.if al == 't'
		    mov al,9
		.elseif al == 'n'
		    mov al,0Dh
		    stosb
		    mov al,0Ah
		.endif
	    .endif
	    stosb
	.until 0
	mov ax,0A0Dh
	stosw
	lea eax,buf
	sub edi,eax
	invoke oswrite,ff_list.li_handle,eax,edi
	ret
putstring endp

arg_option_a:
	or ff_list.li_flag,_LIST_APPEND
	ret
arg_option_i:
	or ff_list.li_flag,_LIST_INCDIR
	ret
arg_option_r:
	or ff_list.li_flag,_LIST_RECURSIV
	ret
arg_option_u:
	or ff_list.li_flag,_LIST_UNIX
	ret
arg_option_y:
	or ff_list.li_flag,_LIST_TRUNC
	ret
arg_option_x:
	.if ah == 'd'
	    or ff_list.li_flag,_LIST_XDRIVE
	.elseif ah == 'p'
	    or ff_list.li_flag,_LIST_XPATH
	.endif
	ret
arg_option_q:
	inc option_q
	ret
arg_option_v:
	inc option_v
	ret

arg_option_h:
	add ebx,2
	.if byte ptr [ebx] == '"'
	    inc ebx
	    invoke strcpy,addr ff_head,ebx
	    .if strchr(eax,'"')
		mov byte ptr [eax],0
	    .endif
	.else
	    invoke strcpy,addr ff_head,ebx
	.endif
	inc cl
	ret
arg_option_e:
	add ebx,2
	invoke strcpy,addr ff_exit,ebx
	inc cl
	ret

read_args proc uses esi edi ebx
local	buf[512]:byte
	sub edi,edi
	mov eax,ebx
	inc eax
	.if fopen(eax,"rt")
	    mov esi,eax
	    .repeat
		lea ebx,buf
		invoke fgets,ebx,512,esi
		.break .if !eax
		invoke strtrim,ebx
		call arg_option
		mov edi,eax
	    .until ZERO?
	    invoke fclose,esi
	.endif
	mov eax,edi
	ret
read_args endp

arg_option_?:
	invoke _print, addr cpinfo
	invoke _print, addr cpusage
	sub eax,eax
	ret

arg_option:
	mov eax,[ebx]
	.if al == '?'
	    jmp arg_option_?
	.endif
	.if al == '/' || al == '-'
	    shr eax,8
	    or  eax,202020h
	    mov edx,offset options
	    mov ecx,edx
	  @@:
	    cmp al,[ecx]
	    je @F
	    inc ecx
	    cmp byte ptr [ecx],0
	    jne @B
	    jmp arg_option_?
	  @@:
	    sub ecx,edx
	    shl ecx,2
	    call option_label[ecx]
	.else
	    .if al == '@'
		.if !read_args
		    ret
		.endif
	    .elseif !ff_name
		invoke strcpy,addr ff_name,ebx
	    .elseif !ff_path
		invoke strcpy,addr ff_path,ebx
	    .else
		invoke strcpy,addr ff_form,ebx
	    .endif
	.endif
	sub eax,eax
	inc eax
	ret

.data

option_label label dword
	dd arg_option_a
	dd arg_option_i
	dd arg_option_r
	dd arg_option_u
	dd arg_option_y
	dd arg_option_x
	dd arg_option_q
	dd arg_option_v
	dd arg_option_e
	dd arg_option_h
	dd arg_option_?

.code

main	proc c
	mov edi,_argc
	mov esi,_argv
	.if _argc == 1
	    call arg_option_?
	    jmp main_end
	.endif
	dec edi
	lodsd
	.repeat
	    lodsd
	    mov ebx,eax
	    call arg_option
	    jz main_end
	    dec edi
	.until !edi
	.if !option_q
	    invoke _print, addr cpinfo
	.endif
	.if option_v
	    .if ff_name
		.if ff_path
		    invoke strcpy, addr ff_form, addr ff_path
		.endif
		invoke strcpy, addr ff_path, addr ff_name
	    .endif
	.endif
	invoke strfn, addr ff_path
	push eax
	invoke strcpy, addr ff_mask, eax
	pop eax
	.if eax > offset ff_path && byte ptr [eax-1] == '\'
	    mov byte ptr [eax-1],0
	.else
	    mov byte ptr [eax],0
	.endif
	.if !ff_name || !ff_mask
	    invoke perror,"Nothing to do.."
	    sub eax,eax
	    jmp main_end
	.endif
	.if !ff_path
	    .if !getcwd(addr ff_path, WMAXPATH)
		invoke perror,"Error init current path"
		mov eax,1
		jmp main_end
	    .endif
	.endif
	.if !option_v
	    or ff_list.li_flag,_LIST_USEFILE
	    mov eax,ff_list.li_flag
	    .if !(al & (_LIST_TRUNC or _LIST_APPEND))
		.if filexist(addr ff_name)
		    invoke _print,"File %s exist. Delete ? (Y,N): ",addr ff_name
		    call getch
		    or  al,20h
		    .if al == 'y'
			or  ff_list.li_flag,_LIST_TRUNC
			mov eax,ff_list.li_flag
		    .else
			jmp @F
		    .endif
		.endif
	    .endif
	.endif
	.if !option_q
	    invoke _print,"\nFile(s):   %s\n", addr ff_mask
	    invoke _print,"Directory: %s\n\n", addr ff_path
	.endif
	mov eax,offset ff_mask
	mov fp_maskp,eax
	mov eax,do_file
	mov fp_fileblock,eax
	mov eax,do_directory
	mov fp_directory,eax
	.if listopen(addr ff_list,addr ff_name,addr ff_form)
	    or ff_list.li_flag,_LIST_MACRO
	    .if ff_head
		invoke putstring, addr ff_head
	    .endif
	    invoke readfiles
	    .if ff_exit
		invoke putstring, addr ff_exit
	    .endif
	    invoke listclose, addr ff_list
	.endif
      @@:
	.if option_v
	    .if !option_q
		invoke _print,"\nTotal %d file(s)\n",ff_list.li_total
	    .endif
	.endif
	xor eax,eax
    main_end:
	ret
main	endp

	end
