ifndef __LIBC_INC
 include libc.inc
endif

.xlist

TIMAXSCRLINE	equ 256		; max screen size

B_Desktop	equ 0		; at_background
B_Panel		equ 1
B_Dialog	equ 2
B_Menus		equ 3
B_Error		equ 4
B_Title		equ 5
B_Inverse	equ 6
B_Gray		equ 7
B_PushButt	equ 8
B_InvPanel	equ 9
;--------------------
F_Title		equ 0		; at_foreground
F_Frame		equ 1
F_Files		equ 2
F_System	equ 3
F_Hidden	equ 4
F_PBShade	equ 5
F_KeyBar	equ 6
F_Desktop	equ 7
F_Inactive	equ 8
F_Dialog	equ 9
F_Panel		equ 10
F_Subdir	equ 11
F_Menus		equ 12
F_TitleKey	equ 13
F_DialogKey	equ 14
F_MenusKey	equ 15

CON_UBEEP	equ 0001h	; Use Beep
CON_MOUSE	equ 0002h	; Use Mouse
CON_IOLFN	equ 0004h	; Use Long File Names
CON_CLIPB	equ 0008h	; Use System Clipboard
CON_NTCMD	equ 0010h	; Use NT Prompt
CON_IMODE	equ 0020h	; Init screen mode on startup
CON_UTIME	equ 0040h	; Use Time
CON_UDATE	equ 0080h	; Use Date
CON_LTIME	equ 0100h	; Use Long Time HH:MM:SS
CON_LDATE	equ 0200h	; Use Long Date YYYY-MM-DD
CON_SLEEP	equ 0400h	; Wait if set

CON_SLEEP_TIME  equ 10		; Time to wait

_D_DOPEN	equ 01h
_D_ONSCR	equ 02h
_D_DMOVE	equ 04h
_D_SHADE	equ 08h
_D_MYBUF	equ 10h		; do not delete on exit (static)
_D_RCNEW	equ 20h		; dlclose -- delete dialog if set
_D_RESAT	equ 40h		; attrib is index in color table (rcedit)
_D_DHELP	equ 80h		; execute thelp() if set
_D_CLEAR	equ 0100h	; args on open/create
_D_BACKG	equ 0200h
_D_FOREG	equ 0400h
_D_STERR	equ 1000h	; error color (red)
_D_MENUS	equ 2000h	; menus color (gray), no title
_D_MUSER	equ 4000h

_D_COLOR	equ _D_BACKG or _D_FOREG
_D_RESRC	equ _D_RCNEW or _D_MYBUF
_D_SETRC	equ _D_RCNEW or _D_MYBUF or _D_DOPEN
_D_STDDLG	equ _D_DMOVE or _D_SHADE or _D_CLEAR or _D_COLOR
_D_STDERR	equ _D_STDDLG or _D_STERR

_O_PBUTT	equ 0
_O_RBUTT	equ 1
_O_CHBOX	equ 2
_O_XCELL	equ 3
_O_TEDIT	equ 4
_O_MENUS	equ 5
_O_XHTML	equ 6
_O_MOUSE	equ 7
_O_LLMSU	equ 8
_O_LLMSD	equ 9
_O_TBUTT	equ 10

_O_RADIO	equ 0010h	; Used in (*) Radio  (one of)
_O_FLAGB	equ 0020h	; Used in [x] switch (ON/OFF)
_O_LLIST	equ 0040h	; Linked list item
_O_DTEXT	equ 0080h	; Select text on activation
_O_CONTR	equ 0100h	; Allow _CONTROL chars
_O_DEXIT	equ 0200h	; Close dialog and return 0: Cancel
_O_PBKEY	equ 0400h	; Return result if short key used
_O_GLCMD	equ 1000h	; Object contain global short-key table
_O_EVENT	equ 2000h	; Object have local event handler
_O_CHILD	equ 4000h	; Object have a child
_O_STATE	equ 8000h	; State (ON/OFF)
_O_DEACT	equ _O_STATE

_C_NORMAL	equ 1
_C_RETURN	equ 2
_C_ESCAPE	equ 3
_C_REOPEN	equ 4

S_RECT		STRUC
rc_x		db ?
rc_y		db ?
rc_col		db ?
rc_row		db ?
S_RECT		ENDS

S_COLOR		STRUC
background	db 16 dup(?)
foreground	db 16 dup(?)
S_COLOR		ENDS

S_ROBJ		STRUC
rs_memsize	dw ?		; Alloc size
rs_flag		dw ?		; 8 byte object size in Resource.idd
rs_count	db ?
rs_index	db ?
rs_rect		S_RECT <?>
S_ROBJ		ENDS

S_DOBJ		STRUC
dl_flag		dw ?
dl_count	db ?
dl_index	db ?
dl_rect		S_RECT <?>
dl_wp		dd ?
dl_object	dd ?
S_DOBJ		ENDS

S_TOBJ		STRUC
to_flag		dw ?
to_count	db ?
to_ascii	db ?
to_rect		S_RECT <?>
to_data		dd ?
to_proc		dd ?
S_TOBJ		ENDS

S_LOBJ		STRUC
ll_dlgoff	dd ?	; start index in dialog
ll_dcount	dd ?	; number of cells (max)
ll_celoff	dd ?	; cell offset
ll_numcel	dd ?	; number of visible cells
ll_count	dd ?	; total number of items in list
ll_index	dd ?	; index in list buffer
ll_list		dd ?	; pointer to list buffer
ll_proc		dd ?
S_LOBJ		ENDS

S_GLCMD		STRUC
gl_key		dd ?
gl_proc		dd ?
S_GLCMD		ENDS

S_WCHAR		STRUC
wc_ch		db ?
wc_at		db ?
S_WCHAR		ENDS

CURSOR_NORMAL	equ 16

S_CURSOR	STRUC	; CONSOLE_CURSOR_INFO
dwSize		dd ?	; .dwSize	1..100
bVisible	dd ?	; .bVisible	0..1
x		dw ?	; word x,y	COORD
y		dw ?
S_CURSOR	ENDS

GCMD	MACRO	key, name	; GlobalCommand: <ShortKey>, <cmdProc>
	dd	key
	dd	name
	ENDM

externdef	console:dword		; BEEP/MOUSE/LFN/CLIPB/TIME/DATE
externdef	console_dl:S_DOBJ	; Init screen (user screen)
externdef	console_cu:S_CURSOR	; Init cursor (set on exit)
externdef	_scrrow:dword		; Screen rows - 1
externdef	_scrcol:dword		; Screen columns
externdef	tdcolor:dword		; = &at_background
externdef	tdialog:dword
externdef	tdllist:dword
externdef	thelp:size_p
externdef	tupdate:size_p
externdef	tgetevent:size_p
externdef	tdidle:size_p

externdef	at_background:byte
externdef	at_foreground:byte
externdef	tclrascii:byte

rcpush		proto :dword
rcalloc		proto :dword, :size_t
rcclose		proto :dword, :size_t, :dword
rchide		proto :dword, :size_t, :dword
rcshow		proto :dword, :size_t, :dword
rcopen		proto :dword, :size_t, :size_t, :dword, :dword
rcread		proto :dword, :dword
rcreadc		proto :dword, :dword, :dword
rcwrite		proto :dword, :dword
rcxchg		proto :dword, :dword
rcsetshade	proto :dword, :dword
rcclrshade	proto :dword, :dword
rcmoveup	proto :dword, :dword, :size_t
rcmovedn	proto :dword, :dword, :size_t
rcmoveleft	proto :dword, :dword, :size_t
rcmoveright	proto :dword, :dword, :size_t
rcmove		proto :dword, :dword, :size_t, :size_t, :size_t
rcmsmove	proto :dword, :dword, :size_t
rcaddrc		proto :dword, :dword, :dword
rcbprc		proto :dword, :dword, :size_t
rcbprcrc	proto :dword, :dword, :dword, :size_t
rcframe		proto :dword, :dword, :size_t, :size_t
rcmemsize	proto :dword, :size_t
rcxyrow		proto :dword, :size_t, :size_t
rcinside	proto :dword, :dword

dlopen		proto :dword, :size_t, :dword
dlclose		proto :dword
dlshow		proto :dword
dlhide		proto :dword
dlmove		proto :dword
dlmodal		proto :dword
dlevent		proto :dword
dllevent	proto :dword, :dword
dlinit		proto :dword
dlinitobj	proto :dword, :dword
dledit		proto :dword, :dword, :size_t, :size_t
dlscreen	proto :dword, :size_t
dlshowall	proto
dlhideall	proto
dlpbuttevent	proto
dlradioevent	proto
dlcheckevent	proto
dlxcellevent	proto
dlteditevent	proto
dlmenusevent	proto
tosetbitflag	proto :ptr S_TOBJ, :size_t, :size_t, :dword
togetbitflag	proto :ptr S_TOBJ, :size_t, :size_t

rsopen		proto :dword
rsevent		proto :dword, :dword
rsmodal		proto :dword
rsreload	proto :dword, :dword

editattrib	proto

consinit	proto
considle	proto
consrect	proto
conssetl	proto :size_t
consuser	proto

cursorget	proto :dword
cursorset	proto :dword
cursoron	proto
cursoroff	proto
cursorx		proto
cursory		proto
gotoxy		proto :size_t, :size_t

wcputf		proto c :dword, :size_t, :size_t, :dword, :VARARG
wcputs		proto :dword, :size_t, :size_t, :dword
__wcpath	proto :dword, :size_t, :dword
wcpath		proto :dword, :size_t, :dword
wcputa		proto :dword, :size_t, :size_t
wcputw		proto :dword, :size_t, :size_t
wcputfg		proto :dword, :size_t, :size_t
wcputbg		proto :dword, :size_t, :size_t
wcenter		proto :dword, :size_t, :dword
wctitle		proto :dword, :size_t, :dword
wcpbutt		proto :dword, :size_t, :size_t, :dword
wcpushst	proto :dword, :dword
wcpopst		proto :dword
wcunzip		proto :dword, :dword, :size_t
wcstrcpy	proto :ptr byte, :ptr word, :size_t

getch		proto
kbhit		proto

getevent	proto
ermsg		proto c :dword, :dword, :VARARG
stdmsg		proto c :dword, :dword, :VARARG
msgbox		proto :dword, :size_t, :dword

__wputs		proto

getxya		proto :size_t, :size_t
getxyc		proto :size_t, :size_t
getxyw		proto :size_t, :size_t
scgetws		proto :size_t, :size_t, :size_t
scputws		proto :size_t, :size_t, :size_t, :ptr word
scgetword	proto :ptr byte
scputa		proto :size_t, :size_t, :size_t, :size_t
scputfg		proto :size_t, :size_t, :size_t, :size_t
scputbg		proto :size_t, :size_t, :size_t, :size_t
scputc		proto :size_t, :size_t, :size_t, :size_t
scputw		proto :size_t, :size_t, :size_t, :size_t
scputs		proto :size_t, :size_t, :size_t, :size_t, :dword
scpath		proto :size_t, :size_t, :size_t, :dword
scenter		proto :size_t, :size_t, :size_t, :dword
scputf		proto c :size_t, :size_t, :size_t, :size_t, :dword, :VARARG
getxys		proto :size_t, :size_t, :dword, :size_t, :size_t
tgetline	proto :dword, :dword, :size_t, :size_t
notsup		proto
scroll_delay	proto

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

incidd  MACRO rc
	local @@
	.data
	@@ label word
	incbin <dos\res\&rc&.IDD>
	IDD_&rc& dd offset @@
	public IDD_&rc&
	ENDM

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

ENABLE_WINDOW_INPUT	equ 8
ENABLE_MOUSE_INPUT	equ 16

FOREGROUND_BLUE		equ 01h
FOREGROUND_GREEN	equ 02h
FOREGROUND_RED		equ 04h
FOREGROUND_INTENSITY	equ 08h
BACKGROUND_BLUE		equ 10h
BACKGROUND_GREEN	equ 20h
BACKGROUND_RED		equ 40h
BACKGROUND_INTENSITY	equ 80h

SWP_NOSIZE		equ 01h
SWP_NOACTIVATE		equ 10h
SWP_NOZORDER		equ 04h

CHAR_INFO	STRUCT
 Char		dw ?
 Attributes	dw ?
CHAR_INFO	ENDS

COORD		STRUCT
co_x		dw ?
co_y		dw ?
COORD		ENDS

SMALL_RECT	STRUCT
 Left		dw ?
 Top		dw ?
 Right		dw ?
 Bottom		dw ?
SMALL_RECT	ENDS

CONSOLE_SCREEN_BUFFER_INFO STRUCT
 dwSize			COORD <>
 dwCursorPosition	COORD <>
 wAttributes		dw ?
 srWindow		SMALL_RECT <>
 dwMaximumWindowSize	COORD <>
CONSOLE_SCREEN_BUFFER_INFO ENDS

CONSOLE_CURSOR_INFO STRUCT	; S_CURSOR
 dwSize		dd ?
 bVisible	dd ?
CONSOLE_CURSOR_INFO ENDS

externdef	_osfhnd:dword
externdef	hStdInput:dword
externdef	hStdOutput:dword
externdef	hStdError:dword
externdef	hCurrentWindow:dword

GetForegroundWindow		proto stdcall
FillConsoleOutputAttribute	proto stdcall :dword, :dword, :dword, :dword, :dword
FlushConsoleInputBuffer		proto stdcall :dword
GetConsoleCursorInfo		proto stdcall :dword, :dword
GetConsoleMode			proto stdcall :dword, :dword
GetConsoleScreenBufferInfo	proto stdcall :dword, :dword
GetLargestConsoleWindowSize	proto stdcall :dword
GetConsoleWindow		proto stdcall
ReadConsoleOutputAttribute	proto stdcall :dword, :dword, :dword, :dword, :dword
SetConsoleActiveScreenBuffer	proto stdcall :dword
SetConsoleCP			proto stdcall :dword
SetConsoleCtrlHandler		proto stdcall :dword, :dword
SetConsoleCursor		proto stdcall :dword, :dword
SetConsoleCursorInfo		proto stdcall :dword, :dword
SetConsoleCursorPosition	proto stdcall :dword, :dword
SetConsoleMode			proto stdcall :dword, :dword
SetConsoleOutputCP		proto stdcall :dword
SetConsoleScreenBufferSize	proto stdcall :dword, :dword
SetConsoleTextAttribute		proto stdcall :dword, :dword
SetConsoleWindowInfo		proto stdcall :dword, :dword, :dword
SetWindowPos			proto stdcall :dword, :dword, :dword, :dword, :dword, :dword, :dword
WriteConsoleOutputAttribute	proto stdcall :dword, :dword, :dword, :dword, :dword

GetModuleHandleA		proto stdcall :dword
FillConsoleOutputCharacterA	proto stdcall :dword, :dword, :dword, :dword, :dword
ReadConsoleOutputA		proto stdcall :dword, :dword, :dword, :dword, :dword
ReadConsoleOutputCharacterA	proto stdcall :dword, :dword, :dword, :dword, :dword
SetConsoleTitleA		proto stdcall :dword
WriteConsoleOutputA		proto stdcall :dword, :dword, :dword, :dword, :dword

GetModuleHandleW		proto stdcall :dword
FillConsoleOutputCharacterW	proto stdcall :dword, :dword, :dword, :dword, :dword
ReadConsoleOutputW		proto stdcall :dword, :dword, :dword, :dword, :dword
ReadConsoleOutputCharacterW	proto stdcall :dword, :dword, :dword, :dword, :dword
SetConsoleTitleW		proto stdcall :dword
WriteConsoleOutputW		proto stdcall :dword, :dword, :dword, :dword, :dword

ifdef __UNICODE__
 GetModuleHandle		equ <GetModuleHandleW>
 FillConsoleOutputCharacter	equ <FillConsoleOutputCharacterW>
 ReadConsoleOutput		equ <ReadConsoleOutputW>
 ReadConsoleOutputCharacter	equ <ReadConsoleOutputCharacterW>
 SetConsoleTitle		equ <SetConsoleTitleW>
 WriteConsoleOutput		equ <WriteConsoleOutputW>
else
 GetModuleHandle		equ <GetModuleHandleA>
 FillConsoleOutputCharacter	equ <FillConsoleOutputCharacterA>
 ReadConsoleOutput		equ <ReadConsoleOutputA>
 ReadConsoleOutputCharacter	equ <ReadConsoleOutputCharacterA>
 SetConsoleTitle		equ <SetConsoleTitleA>
 WriteConsoleOutput		equ <WriteConsoleOutputA>
endif

.list
