ifndef __LIBC_INC
 include libc.inc
endif

.xlist

WMAXPATH	equ 260
WMAXDRIVE	equ 3
MAXDRIVES	equ 26
WMAXDIR		equ 256
WMAXFILE	equ 256
WMAXEXT		equ 256
MAXPATH		equ 80
MAXDRIVE	equ 3
MAXDIR		equ 66
MAXFILE		equ 9
MAXEXT		equ 5
SIZEWFBLK	equ 318

DRIVE_REMOVABLE equ 2
DRIVE_FIXED	equ 3
DRIVE_REMOTE	equ 4
DRIVE_CDROM	equ 5
DRIVE_RAMDISK	equ 6

_DISK_LOCAL	equ 0001h		; _dos_remotedevice()
_DISK_FLOPPY	equ 0100h
_DISK_NETWORK	equ 0200h
_DISK_SUBST	equ 0400h
_DISK_CDROOM	equ 0800h

_DISK_NOSUCHDRIVE	equ 0	; _bios_disktype()
_DISK_FLOPPYNOCHAIN	equ 1
_DISK_FLOPPYWIDTHCHAIN  equ 2
_DISK_HARDDRIVE		equ 3

S_DISK		STRUC
di_flag		dd ?
di_time		dd ?
di_size		dq ?
di_name		db 32 dup(?)
S_DISK		ENDS

externdef	drvinfo:S_DISK
externdef	cp_stdpath:	byte
externdef	cp_stdmask:	byte
externdef	fp_maskp:	dword
externdef	fp_directory:	size_p  ; int (*fp_directory)(char *);
externdef	fp_fileblock:	size_p  ; int (*fp_fileblock)(char *, wfblk *);

getdrive	proto		; A=1 (0 == error)
chdrive		proto :size_t	; A=1 returns 0 if successful, else -1
validdrive	proto :size_t
chdir		proto :size_t
mkdir		proto :size_t
rmdir		proto :size_t
getcwd		proto :ptr byte, :size_t
getdcwd		proto :ptr byte, :size_t, :size_t
fullpath	proto :ptr byte, :ptr byte, :size_t
scansub		proto :ptr byte, :ptr byte, :size_t
scan_files	proto :ptr byte
scan_directory  proto :size_t, :ptr byte
recursive	proto :ptr byte, :ptr byte, :ptr byte

_disk_read	proto
_disk_exist	proto :size_t
_disk_init	proto :size_t
_disk_type	proto :size_t
_disk_test	proto :size_t
_disk_ready	proto :size_t
_disk_retry	proto :size_t
_disk_select	proto :ptr byte

GetVolumeID	proto lpRootPathName:ptr byte, lpVolumeNameBuffer:ptr byte
GetFileSystemName proto lpRootPathName:ptr byte, lpFileSystemNameBuffer:ptr byte

;;;;;;;;;;;;;;;;;;;;;;; kernel32.dll

SEM_FAILCRITICALERRORS  equ 1
externdef		OldErrorMode:dword
SetErrorMode		proto :dword
GetShortPathName	proto :dword, :dword, :dword
GetLogicalDrives	proto

GetFullPathNameA	proto :dword, :dword, :dword, :dword
RemoveDirectoryA	proto :dword
CreateDirectoryA	proto :dword, :dword
SetCurrentDirectoryA	proto :dword
GetCurrentDirectoryA	proto :dword, :dword
GetDriveTypeA		proto :dword
GetDiskFreeSpaceExA	proto :dword, :dword, :dword, :dword
GetVolumeInformationA	proto :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword

GetFullPathNameW	proto :dword, :dword, :dword, :dword
RemoveDirectoryW	proto :dword
CreateDirectoryW	proto :dword, :dword
SetCurrentDirectoryW	proto :dword
GetCurrentDirectoryW	proto :dword, :dword
GetDriveTypeW		proto :dword
GetDiskFreeSpaceExW	proto :dword, :dword, :dword, :dword
GetVolumeInformationW	proto :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword

ifdef __UNICODE__
 GetCurrentDirectory	equ <GetCurrentDirectoryW>
 SetCurrentDirectory	equ <SetCurrentDirectoryW>
 GetFullPathName	equ <GetFullPathNameW>
 CreateDirectory	equ <CreateDirectoryW>
 RemoveDirectory	equ <RemoveDirectoryW>
 GetDriveType		equ <GetDriveTypeW>
 GetDiskFreeSpaceEx	equ <GetDiskFreeSpaceExW>
 GetVolumeInformation	equ <GetVolumeInformationW>
else
 GetCurrentDirectory	equ <GetCurrentDirectoryA>
 SetCurrentDirectory	equ <SetCurrentDirectoryA>
 GetFullPathName	equ <GetFullPathNameA>
 CreateDirectory	equ <CreateDirectoryA>
 RemoveDirectory	equ <RemoveDirectoryA>
 GetDriveType		equ <GetDriveTypeA>
 GetDiskFreeSpaceEx	equ <GetDiskFreeSpaceExA>
 GetVolumeInformation	equ <GetVolumeInformationA>
endif

.list
