ifndef __LIBC_INC
 include libc.inc
endif

.xlist

TIMAXSCRLINE	equ 128		; max screen size

B_Desktop	equ 0
B_Panel		equ 1
B_Dialog	equ 2
B_Menus		equ 3
B_Error		equ 4
B_Title		equ 5
B_Inverse	equ 6
B_Gray		equ 7
B_PushButt	equ 8
B_InvPanel	equ 9

F_Title		equ 0
F_Frame		equ 1
F_Files		equ 2
F_System	equ 3
F_Hidden	equ 4
F_PBShade	equ 5
F_Desktop	equ 7
F_Inactive	equ 8
F_Dialog	equ 9
F_Panel		equ 10
F_Subdir	equ 11
F_Menus		equ 12
F_TitleKey	equ 13
F_DialogKey	equ 14
F_MenusKey	equ 15

CON_UBEEP	equ 0001h	; Use Beep
CON_MOUSE	equ 0002h	; Use Mouse
CON_IOLFN	equ 0004h	; Use Long File Names
CON_CLIPB	equ 0008h	; Use System Clipboard
CON_INT2F	equ 0010h	; Use Idle Int 2Fh
CON_NTCMD	equ 0020h	; Use NT Prompt
CON_DOSIO	equ 0040h	; Use DOS2 Open/Create
CON_COLOR	equ 0080h	; Use Color
CON_UTIME	equ 0100h	; Use Time
CON_UDATE	equ 0200h	; Use Date
CON_LTIME	equ 0400h	; Use Long Time HH:MM:SS
CON_LDATE	equ 0800h	; Use Long Date YYYY-MM-DD
CON_IMODE	equ 1000h	; Init screen mode on startup
CON_REVGA	equ 2000h	; Restore VGA palette on exit

_D_DOPEN	equ 01h
_D_ONSCR	equ 02h
_D_DMOVE	equ 04h
_D_SHADE	equ 08h
_D_MYBUF	equ 10h		; do not delete on exit (static)
_D_RCNEW	equ 20h		; twclose -- delete dialog if set
_D_RESAT	equ 40h		; attrib is index in color table (rcedit)
_D_DHELP	equ 80h		; execute thelp() if set
_D_CLEAR	equ 0100h	; args on open/create
_D_BACKG	equ 0200h
_D_FOREG	equ 0400h
_D_STERR	equ 1000h	; error color (red)
_D_MENUS	equ 2000h	; menus color (gray), no title
_D_MUSER	equ 4000h

_D_COLOR	equ _D_BACKG or _D_FOREG
_D_RESRC	equ 0030h
_D_SETRC	equ 0031h
_D_STDDLG	equ (_D_DMOVE or _D_SHADE or _D_CLEAR or _D_COLOR)
_D_STDERR	equ (_D_STDDLG or _D_STERR)

_O_PBUTT	equ 0
_O_RBUTT	equ 1
_O_CHBOX	equ 2
_O_XCELL	equ 3
_O_TEDIT	equ 4
_O_MENUS	equ 5
_O_XHTML	equ 6
_O_MOUSE	equ 7
_O_LLMSU	equ 8
_O_LLMSD	equ 9
_O_TBUTT	equ 10

_O_RADIO	equ 0010h	; Used in (*) Radio  (one of)
_O_FLAGB	equ 0020h	; Used in [x] switch (ON/OFF)
_O_LLIST	equ 0040h	; Linked list item
_O_DTEXT	equ 0080h	; Select text on activation
_O_CONTR	equ 0100h	; Allow _CONTROL chars
_O_DEXIT	equ 0200h	; Close dialog and return 0: Cancel
_O_PBKEY	equ 0400h	; Return result if short key used
_O_GLCMD	equ 1000h	; Object contain global short-key table
_O_EVENT	equ 2000h	; Object have local event handler
_O_CHILD	equ 4000h	; Object have a child
_O_STATE	equ 8000h	; State (ON/OFF)
_O_DEACT	equ _O_STATE

_C_NORMAL	equ 1
_C_RETURN	equ 2
_C_ESCAPE	equ 3
_C_REOPEN	equ 4

CURSOR_NORMAL	equ 0607h
CURSOR_HIDDEN	equ 0F00h

S_RECT		STRUC
rc_x		db ?
rc_y		db ?
rc_col		db ?
rc_row		db ?
S_RECT		ENDS

S_COLOR		STRUC
cl_backgr	db 16 dup(?)
cl_foregr	db 16 dup(?)
cl_palett	db 16 dup(?)
S_COLOR		ENDS

S_ROBJ		STRUC
rs_memsize	dw ?		; Alloc size
rs_flag		dw ?		; 8 byte object size in Resource.idd
rs_count	db ?
rs_index	db ?
rs_rect		S_RECT <?>
S_ROBJ		ENDS

S_DOBJ		STRUC
dl_flag		dw ?
dl_count	db ?
dl_index	db ?
dl_rect		S_RECT <?>
dl_wp		dd ?
dl_object	dd ?
S_DOBJ		ENDS

S_TOBJ		STRUC
to_flag		dw ?
to_count	db ?
to_ascii	db ?
to_rect		S_RECT <?>
to_data		dd ?
to_proc		p? ?
ifdef __c__
to_proc_seg	dw ?
endif
S_TOBJ		ENDS

S_LOBJ		STRUC
ll_dlgoff	dw ?	; start index in dialog
ll_dcount	dw ?	; number of cells (max)
ll_celoff	dw ?	; cell offset
ll_numcel	dw ?	; number of visible cells
ll_count	dw ?	; total number of items in list
ll_index	dw ?	; index in list buffer
ll_list		dd ?	; pointer to list buffer
ll_proc		p? ?
S_LOBJ		ENDS

S_GLCMD		STRUC
gl_key		dw ?
gl_proc		p? ?
S_GLCMD		ENDS

S_WCHAR		STRUC
wc_ch		db ?
wc_at		db ?
S_WCHAR		ENDS

S_CURSOR	STRUC	; CONSOLE_CURSOR_INFO
cr_xy		dw ?	; byte x,y
cr_type		dw ?	;
S_CURSOR	ENDS

GCMD	MACRO	key, name	; GlobalCommand: <ShortKey>, <cmdProc>
	dw	key
	p?	name
	ENDM

externdef	_scrseg:word	; Screen segment (B800 or B000)
externdef	console:word	; BEEP/MOUSE/LFN/CLIPB/2F/COLOR/TIME/DATE
externdef	console_dl:S_DOBJ	; Init screen (user screen)
;externdef	console_cu:S_CURSOR	; Init cursor (set on exit)
externdef	_scrrow:byte	; Screen rows - 1
externdef	_scrcol:byte	; Screen columns
externdef	tdialog:dword
externdef	tdllist:dword
externdef	thelp:size_p
externdef	tupdate:size_p
externdef	tgetevent:size_p
externdef	at_palett:byte
externdef	at_background:byte
externdef	at_foreground:byte

rcpush		proto _CType :word
rcalloc		proto _CType :dword, :word
rcclose		proto _CType :dword, :word, :dword
rchide		proto _CType :dword, :word, :dword
rcshow		proto _CType :dword, :word, :dword
rcopen		proto _CType :dword, :word, :word, :dword, :dword
rcread		proto _CType :dword, :dword
rcwrite		proto _CType :dword, :dword
rcxchg		proto _CType :dword, :dword
rcsetshade	proto _CType :dword, :dword
rcclrshade	proto _CType :dword, :dword
rcmoveup	proto _CType :dword, :dword, :word
rcmovedn	proto _CType :dword, :dword, :word
rcmoveleft	proto _CType :dword, :dword, :word
rcmoveright	proto _CType :dword, :dword, :word
rcmove		proto _CType :dword, :dword, :word, :word, :word
rcmsmove	proto _CType :dword, :dword, :word
rcaddrc		proto _CType :dword, :dword, :dword
rcsprc		proto _CType :dword
rcbprc		proto _CType :dword, :dword, :word
rcbprcrc	proto _CType :dword, :dword, :dword, :word
rcframe		proto _CType :dword, :dword, :word, :word
rcmemsize	proto _CType :dword, :word
rcxyrow		proto _CType :dword, :word, :word
rcinside	proto _CType :dword, :dword

dlopen		proto _CType :dword, :word, :dword
dlclose		proto _CType :dword
dlshow		proto _CType :dword
dlhide		proto _CType :dword
dlmove		proto _CType :dword
dlmodal		proto _CType :dword
dlevent		proto _CType :dword
dllevent	proto _CType :dword, :dword
dlinit		proto _CType :dword
dlinitobj	proto _CType :dword, :dword
dledit		proto _CType :dword, :dword, :word, :word
dlscreen	proto _CType :dword, :word

dlpbuttevent	proto _CType
dlradioevent	proto _CType
dlcheckevent	proto _CType
dlxcellevent	proto _CType
dlteditevent	proto _CType
dlmenusevent	proto _CType
tosetbitflag	proto _CType :dword, :word, :word, :dword
togetbitflag	proto _CType :dword, :word, :word

thelpinit	proto _CType :size_p
thelp_set	proto _CType :size_p
thelp_pop	proto _CType

rsopen		proto _CType :dword
rsevent		proto _CType :dword, :dword
rsmodal		proto _CType :dword
rsreload	proto _CType :dword, :dword

setpal		proto _CType :word, :word
resetpal	proto _CType
loadpal		proto _CType :ptr byte
editpal		proto _CType
editattrib	proto _CType

consinit	proto _CType
consrect	proto _CType
conssetl	proto _CType :word
consuser	proto _CType

cursorget	proto _CType :dword
cursorset	proto _CType :dword
cursoron	proto _CType
cursoroff	proto _CType
cursorx		proto _CType
cursory		proto _CType
gotoxy		proto _CType :word, :word

wcputf		proto _CDecl :dword, :word, :word, :dword, :VARARG
wcputs		proto _CType :dword, :word, :word, :dword
wcpath		proto _CType :dword, :word, :dword
wcputa		proto _CType :dword, :word, :word
wcputw		proto _CType :dword, :word, :word
wcputfg		proto _CType :dword, :word, :word
wcputbg		proto _CType :dword, :word, :word
wcenter		proto _CType :dword, :word, :dword
wctitle		proto _CType :dword, :word, :dword
wcpbutt		proto _CType :dword, :word, :word, :dword
wcpushst	proto _CType :dword, :dword
wcpopst		proto _CType :dword
wcunzip		proto _CType :dword, :dword, :word
wcstrcpy	proto _CType :dword, :dword, :word

getch		proto _CType
kbhit		proto _CType

getevent	proto _CType
ermsg		proto _CDecl :dword, :dword, :VARARG
stdmsg		proto _CDecl :dword, :dword, :VARARG
;msgbox		proto _CType :dword, :word, :dword

externdef	_scrcol:byte
externdef	_scrrow:byte
externdef	tupdate:size_p
externdef	tgetevent:size_p
externdef	tclrascii:byte
externdef	_scrseg:word
__getxyp	proto
__getxypm	proto
__wputs		proto

getxyp		proto _CType :word, :word
getxya		proto _CType :word, :word
getxyc		proto _CType :word, :word
getxyw		proto _CType :word, :word
scputa		proto _CType :word, :word, :word, :word
scputfg		proto _CType :word, :word, :word, :word
scputbg		proto _CType :word, :word, :word, :word
scputc		proto _CType :word, :word, :word, :word
scputw		proto _CType :word, :word, :word, :word
scputs		proto _CType :word, :word, :word, :word, :dword
scpath		proto _CType :word, :word, :word, :dword
scenter		proto _CType :word, :word, :word, :dword
scputf		proto _CDecl :word, :word, :word, :word, :dword, :VARARG
getxys		proto _CType :word, :word, :dword, :word, :word
tgetline	proto _CType :dword, :dword, :word, :word

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

incidd  MACRO rc
	local @rc
	.data
	@rc label word
	incbin <res\&rc&.IDD>
	IDD_&rc& dd _DATA:@rc
	public IDD_&rc&
	ENDM

.list
