ifndef __LIBC_INC
 include libc.inc
endif

.xlist

_NFILE_		equ 20

_A_RDONLY	equ 01h
_A_HIDDEN	equ 02h
_A_SYSTEM	equ 04h
_A_VOLID	equ 08h
_A_SUBDIR	equ 10h
_A_ARCH		equ 20h
_A_NORMAL	equ 80h

_A_TEMPORARY	equ 0100h
_A_SPARSE_FILE  equ 0200h
_A_REPARSEPOINT equ 0400h
_A_COMPRESSED	equ 0800h
_A_OFFLINE	equ 1000h
_A_NOT_INDEXED  equ 2000h
_A_ENCRYPTED	equ 4000h

_A_STDFILES	equ _A_ARCH or _A_RDONLY or _A_SYSTEM or _A_SUBDIR or _A_NORMAL
_A_ALLFILES	equ _A_STDFILES or _A_HIDDEN ;or 7F00h

FH_OPEN		equ 01h
FH_EOF		equ 02h
FH_CRLF		equ 04h
FH_PIPE		equ 08h
FH_APPEND	equ 20h
FH_DEVICE	equ 40h
FH_TEXT		equ 80h

SEEK_SET	equ 0
SEEK_CUR	equ 1
SEEK_END	equ 2

S_FTIME		STRUC	; FILETIME (QWORD)
ft_low		dd ?
ft_high		dd ?
S_FTIME		ENDS

S_WFBLK		STRUC
wf_attrib	dd ?	; DWORD File attributes
wf_timecreate	dq ?	; QWORD File creation time
wf_timeaccess	dq ?	; QWORD Last access time
wf_time		dq ?	; QWORD Last modification time
wf_size		dq ?	; QWORD File size
wf_reserved	db 8 dup(?)
wf_name		db 260 dup(?)
wf_shortname	db 14 dup(?)
S_WFBLK		ENDS	;  318 byte

externdef	_nfile:dword
externdef	_osfile:byte
externdef	_osfhnd:dword
externdef	_diskflag:dword
externdef	hStdInput:dword
externdef	hStdOutput:dword
externdef	hStdError:dword
externdef	OldErrorMode:dword

INVALID_SET_FILE_POINTER	equ -1

A_CREATE	equ 1 ; fails if exists
A_CREATETRUNC	equ 2 ; trunc if exists
A_OPEN		equ 3 ; fails if not exists
A_OPENCREATE	equ 4 ; open if exists or create
A_TRUNC		equ 5 ; fails if not exists

CREATE_NEW	equ 1
CREATE_ALWAYS	equ 2
OPEN_EXISTING	equ 3
OPEN_ALWAYS	equ 4
TRUNCATE_EXISTING equ 5


M_DELETE	equ 00010000h
M_RDONLY	equ 80000000h
M_WRONLY	equ 40000000h
M_RDWR		equ M_RDONLY or M_WRONLY

GENERIC_WRITE	equ M_WRONLY
GENERIC_READ	equ M_RDONLY
SHARE_READ	equ 1
SHARE_WRITE	equ 2

getosfhnd	proto :dword
close		proto :size_t
lseek		proto :size_t, :dword, :size_t
lseek64		proto :size_t, :qword, :size_t
write		proto :size_t, :dword, :size_t
access		proto :dword, :size_t
readword	proto :dword
osopen		proto :dword, :size_t, :size_t, :size_t
osread		proto :size_t, :dword, :size_t
oswrite		proto :size_t, :dword, :size_t
removefile	proto :dword
isatty		proto :size_t
osmaperr	proto
remove		proto :ptr byte
rename		proto :ptr byte, :ptr byte
dosmaperr	proto :size_t

open		proto c :dword, :size_t, :VARARG
sopen		proto c :dword, :size_t, :size_t, :VARARG
read		proto :size_t, :dword, :size_t
creat		proto :dword, :size_t
osfiletype	proto :size_t
eof		proto :size_t
chsize		proto :size_t, :dword
filelength	proto :size_t
tell		proto :size_t

getftime	proto :size_t
getftime_access proto :size_t
getftime_create proto :size_t
setftime	proto :size_t, :dword
setftime_access proto :size_t, :dword
setftime_create proto :size_t, :dword
getfattr	proto :ptr byte
setfattr	proto :ptr byte, :dword
filexist	proto :ptr byte

wfindfirst	proto :dword, :dword, attrib:size_t
wfindnext	proto :dword, :size_t
wcloseff	proto :size_t

wlongname	proto :dword, :dword
wlongpath	proto :dword, :dword
wshortname	proto :dword
wshortpath	proto :dword, :dword
removefile	proto :dword
removetemp	proto :dword

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

FILE_TYPE_UNKNOWN	equ 0
FILE_TYPE_DISK		equ 1
FILE_TYPE_CHAR		equ 2
FILE_TYPE_PIPE		equ 3
FILE_TYPE_REMOTE	equ 8000h

STD_INPUT_HANDLE	equ -10
STD_OUTPUT_HANDLE	equ -11
STD_ERROR_HANDLE	equ -12

SEM_FAILCRITICALERRORS  equ 1

FILE_ATTRIBUTE_READONLY		equ 1h
FILE_ATTRIBUTE_HIDDEN		equ 2h
FILE_ATTRIBUTE_SYSTEM		equ 4h
FILE_ATTRIBUTE_DIRECTORY	equ 10h
FILE_ATTRIBUTE_ARCHIVE		equ 20h
FILE_ATTRIBUTE_NORMAL		equ 80h
FILE_ATTRIBUTE_TEMPORARY	equ 100h
FILE_ATTRIBUTE_COMPRESSED	equ 800h

FILE_FLAG_WRITE_THROUGH		equ 80000000h	; CreateFile()
FILE_FLAG_OVERLAPPED		equ 40000000h
FILE_FLAG_NO_BUFFERING		equ 20000000h
FILE_FLAG_RANDOM_ACCESS		equ 10000000h
FILE_FLAG_SEQUENTIAL_SCAN	equ 8000000h
FILE_FLAG_DELETE_ON_CLOSE	equ 4000000h
FILE_FLAG_BACKUP_SEMANTICS	equ 2000000h
FILE_FLAG_POSIX_SEMANTICS	equ 1000000h

SECURITY_ATTRIBUTES	STRUC
nLength			dd ?
lpSecurityDescriptor	dd ?
bInheritHandle		dd ?
SECURITY_ATTRIBUTES	ENDS

SetErrorMode		proto stdcall :dword
GetStdHandle		proto stdcall :dword
CloseHandle		proto stdcall :dword
SetFilePointer		proto stdcall :dword, :dword, :dword, :dword
SetFilePointerEx	proto stdcall :dword, :qword, :dword, :dword

ReadFile		proto stdcall :dword, :dword, :dword, :dword, :dword
WriteFile		proto stdcall :dword, :dword, :dword, :dword, :dword
GetFileSize		proto stdcall :dword, :dword
SetEndOfFile		proto stdcall :dword ; BOOL(HANDLE hFile)
GetFileType		proto stdcall :dword ; _isatty()
FindClose		proto stdcall :dword
GetFileTime		proto stdcall :dword, :dword, :dword, :dword
SetFileTime		proto stdcall :dword, :dword, :dword, :dword

CreateFileA		proto stdcall :dword, :dword, :dword, :dword, :dword, :dword, :dword
FindFirstFileA		proto stdcall :dword, :dword
FindNextFileA		proto stdcall :dword, :dword
GetFileAttributesA	proto stdcall :dword
SetFileAttributesA	proto stdcall :dword, :dword
DeleteFileA		proto stdcall :dword
MoveFileA		proto stdcall :dword, :dword

CreateFileW		proto stdcall :dword, :dword, :dword, :dword, :dword, :dword, :dword
FindFirstFileW		proto stdcall :dword, :dword
FindNextFileW		proto stdcall :dword, :dword
GetFileAttributesW	proto stdcall :dword
SetFileAttributesW	proto stdcall :dword, :dword
DeleteFileW		proto stdcall :dword
MoveFileW		proto stdcall :dword, :dword

ifdef __UNICODE__
 FindFirstFile		equ <FindFirstFileW>
 FindNextFile		equ <FindNextFileW>
 SetFileAttributes	equ <SetFileAttributesW>
 GetFileAttributes	equ <GetFileAttributesW>
 DeleteFile		equ <DeleteFileW>
 MoveFile		equ <MoveFileW>
 CreateFile		equ <CreateFileW>
else
 FindFirstFile		equ <FindFirstFileA>
 FindNextFile		equ <FindNextFileA>
 SetFileAttributes	equ <SetFileAttributesA>
 GetFileAttributes	equ <GetFileAttributesA>
 DeleteFile		equ <DeleteFileA>
 MoveFile		equ <MoveFileA>
 CreateFile		equ <CreateFileA>
endif

.list
