#ifndef __INC_IOST
#define __INC_IOST
#if !defined(__INC_DEFS)
 #include <defs.h>
#endif

#define SEEK_CUR	1
#define SEEK_END	2
#define SEEK_SET	0

#define ISIZE		0x800000
#define OSIZE		0x800000

#define IO_SEARCHCASE	0x0001  /* Case sensitive search	*/
#define IO_SEARCHHEX	0x0002  /* Search hex string/ascii	*/
#define IO_SEARCHSET	0x0004  /* Search entire scope		*/
#define IO_SEARCHCUR	0x0008  /* Search from cursor/set	*/
#define IO_SEARCHMASK	0x000F
#define IO_SEARCHSUB	0x0020
#define IO_STRINGB	0x0080  /* String buffer		*/
#define IO_CRYPT	0x0100  /* Crypted file			*/
#define IO_USEUPD	0x0200  /* Progress			*/
#define IO_UPDTOTAL	0x0400  /* Add Read/Write size to total */
#define IO_USECRC	0x0800  /* Update CRC on read/write	*/
#define IO_USEBITS	0x1000  /* Align bits on read/write	*/
#define IO_CLIPBOARD	0x2000  /* Flush to clipboard		*/
#define IO_MEMREAD	0x4000  /* Read from memory		*/
#define IO_ERROR	0x8000  /* Write fault			*/

#ifdef __cplusplus
 extern "C" {
#endif

typedef struct IOBS {
	char *  bp;	/* buffer */
	DWORD	i;	/* index in buffer */
	DWORD	c;	/* byte count */
	DWORD	bsize;  /* alloc size */
	DWORD	flag;
	int	file;
	int	l;	/* number of bits in bit buffer */
	DWORD	bb;	/* bit buffer | CRC value */
	QWORD	total;  /* total bytes in/out | filesize */
	DWORD	offs;	/* file offset | loop count */
	QWORD	fsize;  /* file size */
      } IOST;
extern  IOST STDI;
extern  IOST STDO;

BOOL	_CType oinitst(IOST *, int __size);
int	_CType oopenst(IOST *, char *__file, int __mode, int __bsize);
DWORD	_CType oseekst(IOST *, DWORD __offset, int __from);
BOOL	_CType ocopyst(IOST *__des, IOST *__src, QWORD __len);
BOOL	_CType oflushst(IOST *);
BOOL	_CType ofreadst(IOST *);
void	_CType oclose(IOST *);
void	_CType ofreest(IOST *);
void *  _CType owritest(IOST *, void *__buf, int __len);
DWORD	_CType otellst(IOST *);
__int64 _CType otell64(IOST *);
int	_fastcall ogetcst(IOST *);
BOOL	_fastcall oputcst(int __c, IOST *);

DWORD	_CType otell(void);
void *  _fastcall oread(int __size);
BOOL	_fastcall oputc(int __c);
int	_CType ogetc(void);
BOOL	_CType continuesearch(void);
BOOL	_CType osearch(void);
BOOL	_CType oflush(void);
BOOL	_CType ofread(void);
int	_CType oreadb(void *__buf, int __len);
int	_CType oungetc(void);
int	_CDecl oprintf(char *__format, ...);

BOOL	_CType ogetl(char *__file, void *__buf, int __bsize);
char *  _CType ogets(void);
BOOL	_CType oputs(char *);
int	_CType oopen(char *__file, int __mode, int __bsize);
int	_CType ogetouth(char *__file, int __mode);
int	_CType openfile(char *__file, int __mode, int __action);
int	_CType oseek(DWORD __offset, int __from);
int	_CType oseekl(DWORD __offset, int __from);

#ifdef __cplusplus
 }
#endif
#endif
