ifndef __LIBC_INC
 include libc.inc
endif

.xlist

lodq	macro m,s,o
	ifnb <o>
	    mov o,dword ptr m
	    mov s,dword ptr m+4
	else
	    mov eax,dword ptr m
	    mov edx,dword ptr m+4
	endif
	endm

stoq	macro m,s,o
	ifnb <o>
	    mov dword ptr m,o
	    mov dword ptr m+4,s
	else
	    mov dword ptr m,eax
	    mov dword ptr m+4,edx
	endif
	endm

incq	macro v:VARARG
	add dword ptr v,1
	adc dword ptr v+4,0
	endm

decq	macro v:VARARG
	sub dword ptr v,1
	sbb dword ptr v+4,0
	endm

cmpq	macro a1,a2,r1
	local l1
	ifnb <r1>
	    cmp dword ptr a1+4,a2
	    jne l1
	    cmp dword ptr a1,r1
	else
	    mov eax,dword ptr a2+4
	    cmp dword ptr a1+4,eax
	    jne l1
	    mov eax,dword ptr a2
	    cmp dword ptr a1,eax
	endif
	l1:
	endm

movqm	macro m1,m2
	mov edx,dword ptr m2+4
	mov dword ptr m1+4,edx
	mov eax,dword ptr m2
	mov dword ptr m1,eax
	endm

movqx	macro m1,m2
	mov eax,dword ptr m2+4
	mov dword ptr m1+4,eax
	mov eax,dword ptr m2
	mov dword ptr m1,eax
	endm

_mul10 proto ; edx:eax * 10	 --> edx:eax
_div64 proto ; edx:eax / ecx	 --> edx:eax.ecx
_mul64 proto ; edx:eax * ecx:ebx --> ecx:ebx:edx:eax

.list
