ifndef __LIBC_INC
 include libc.inc
endif

.xlist
;
; ISO 8601:	YYYY-MM-DD hh:mm:ss
; Short form:	YY-MM-DD hh:mm
;
; input accept: MM/DD/YY[YY] | DD.MM.YY[YY] | [YY]YY-MM-DD
;
DT_BASEYEAR	equ 1980

S_FTIME		STRUC	; FILETIME
ft_low		dd ?
ft_high		dd ?
S_FTIME		ENDS

S_STIME		STRUC	; SYSTEMTIME
wYear		dw ?
wMonth		dw ?
wDayOfWeek	dw ?
wDay		dw ?
wHour		dw ?
wMinute		dw ?
wSecond		dw ?
wMilliseconds	dw ?
S_STIME		ENDS

dosdate		proto
dostime		proto
getyear		proto
getmnd		proto
getday		proto
gethour		proto
getmin		proto
getsec		proto
tupdtime	proto

atotime		proto :ptr byte
atodate		proto :ptr byte
strtime		proto :ptr byte, :dword
strdate		proto :ptr byte, :dword
strsdate	proto :ptr byte, :ptr S_STIME
strstime	proto :ptr byte, :ptr S_STIME
strfdate	proto :ptr byte, :ptr S_FTIME
strftime	proto :ptr byte, :ptr S_FTIME

FileTimeToTime  proto :ptr S_FTIME
TimeToFileTime  proto :dword, :ptr S_FTIME
SystemTimeToTime proto :ptr S_STIME
TimeToSystemTime proto :dword, :ptr S_STIME

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

Sleep			proto :dword	; sleep time in milliseconds
GetTickCount		proto
GetLocalTime		proto :ptr S_STIME
FileTimeToSystemTime	proto :ptr S_FTIME, :ptr S_STIME
SystemTimeToFileTime	proto :ptr S_STIME, :ptr S_FTIME
FileTimeToLocalFileTime proto :ptr S_FTIME, :ptr S_FTIME
LocalFileTimeToFileTime proto :ptr S_FTIME, :ptr S_FTIME
GetTimeFormatA		proto :dword,:dword,:dword,:dword,:dword,:dword
GetDateFormatA		proto :dword,:dword,:dword,:dword,:dword,:dword
GetUserDefaultLCID	proto stdcall

GetTimeFormat	equ	<GetTimeFormatA>
GetDateFormat	equ	<GetDateFormatA>
delay		equ	<Sleep>

; BOOL - 16-bit date and time
DosDateTimeToFileTime	proto wFatDate:dword, wFatTime:dword, :ptr S_FTIME
FileTimeToDosDateTime	proto :ptr S_FTIME, lpFatDate:dword, lpFatTime:dword

.list
