/****************************************************************************
*
*  This code is Public Domain.
*
*  ========================================================================
*
* Description:  JWasm top level module
*
****************************************************************************/

#include <signal.h>

#include "globals.h"
#include "msgtext.h"
#include "cmdline.h"

#if defined(__UNIX__) || defined(__CYGWIN__) || defined(__DJGPP__)

#define WILDCARDS 0
#define CATCHBREAK 0

#else

#define WILDCARDS 1
#ifdef __POCC__
#define CATCHBREAK 0
#else
#define CATCHBREAK 1
#endif

#endif

#if WILDCARDS
#ifdef __UNIX__
 #include <unistd.h>
#else
 #include <io.h>
#endif
#endif

static void genfailure( int signo )
/*********************************/
{
#if CATCHBREAK
    if (signo != SIGBREAK)
#else
    if (signo != SIGTERM)
#endif
	EmitError( GENERAL_FAILURE );
    close_files();
    exit( EXIT_FAILURE );
}

#ifdef __PROCESSSUBDIR

static char slash[] = "\\";

static char *strfn(char *fp)
{
    char *p = fp + strlen(fp);
    slash[0] = '\\';
    while (--p > fp) {
	if (*p == '\\')
	    return &p[1];
	if (*p == '/') {
	    slash[0] = '/';
	    return &p[1];
	}
    }
    return fp;
}

static char *strfcat(char *b, char *p, char *fp)
{
    if (*p) {
	strcpy(b, p);
	strcat(b, slash);
	strcat(b, fp);
    } else {
	strcpy(b, fp);
    }
    return b;
}

static int AssembleSubdir(char *directory, char *wild)
{
    long   h;
    char   path[_MAX_PATH];
    struct _finddata_t ff;
    int	   rc = 0;

    if ((h = _findfirst(strfcat(path, directory, wild), &ff)) != -1 ) {
	do {
	    rc = AssembleModule(strfcat(path, directory, ff.name));
	} while ((_findnext(h, &ff) != -1));
	_findclose(h);
    }
    if (Options.process_subdir) {
	if ((h = _findfirst(strfcat(path, directory, "*.*"), &ff)) != -1 ) {
	    do {
		if (ff.attrib & _A_SUBDIR &&
		  !(ff.name[0] == '.' && !ff.name[1]) &&
		  !(ff.name[0] == '.' && ff.name[1] == '.' && !ff.name[2])) {
		   strfcat(path, directory, ff.name);
		   if (AssembleSubdir(path, wild))
		       rc = 1;
		}
	    } while ((_findnext(h, &ff) != -1));
	    _findclose(h);
	}
    }
    return rc;
}

#endif

int main( int argc, char **argv )
/*******************************/
{
    char    *pEnv;
    int	    numArgs = 0;
    int	    numFiles = 0;
    int	    rc = 0;
#if WILDCARDS
    char    *p;
    long    fh; /* _findfirst/next/close() handle, must be long! */
    struct  _finddata_t finfo;
    char    drv[_MAX_DRIVE];
    char    dir[_MAX_DIR];
    char    fname[_MAX_PATH];
#endif

#if 0 //def DEBUG_OUT	 /* DebugMsg() cannot be used that early */
    int i;
    for ( i = 1; i < argc; i++ ) {
	printf("argv[%u]=>%s<\n", i, argv[i] );
    }
#endif

    pEnv = getenv( "ASM" );
    if ( pEnv == NULL )
	pEnv = "";
    argv[0] = pEnv;

#ifndef DEBUG_OUT
    signal(SIGSEGV, genfailure);
#endif

#if CATCHBREAK
    signal(SIGBREAK, genfailure);
#else
    signal(SIGTERM, genfailure);
#endif

    MsgInit();

    while ( 1 ) {
	if ( ParseCmdline( (const char **)argv, &numArgs ) == NULL )
	    break;  /* exit if no source file name supplied */
	numFiles++;
	write_logo();
#if WILDCARDS
 #ifdef __PROCESSSUBDIR
	if (Options.process_subdir == FALSE)
 #endif
	if ((fh = _findfirst( Options.names[ASM], &finfo )) == -1 ) {
	    DebugMsg(("main: _findfirst(%s) failed\n", Options.names[ASM] ));
	    EmitErr( CANNOT_OPEN_FILE, Options.names[ASM], ErrnoStr() );
	    break;
	}
 #ifndef __PROCESSSUBDIR
	_splitpath( Options.names[ASM], drv, dir, NULL, NULL );
	DebugMsg(("main: _splitpath(%s): drv=\"%s\" dir=\"%s\"\n", Options.names[ASM], drv, dir ));
 #endif
 #ifdef __FULLSRCPATH /* Skip if no WILDCARDS */
	strcpy(fname, Options.names[ASM]);
	if ( strchr(fname, '*') || strchr(fname, '?')) {
 #endif
 #ifdef __PROCESSSUBDIR
	if ((p = strfn(strcpy(fname, Options.names[ASM]))) > fname) p--;
	*p = 0;
	rc = AssembleSubdir(fname, strfn(Options.names[ASM]));
 #else
	do {
	    _makepath( fname, drv, dir, finfo.name, NULL );
	    DebugMsg(("main: _makepath(\"%s\", \"%s\", \"%s\")=\"%s\"\n", drv, dir, finfo.name, fname ));
	    rc = AssembleModule( fname );  /* assemble 1 module */
	} while ( ( _findnext( fh, &finfo ) != -1 ) );
	_findclose( fh );
 #endif
 #ifdef __FULLSRCPATH
	} else { /* Use command line name -- it may be short */
	    rc = AssembleModule( fname );  /* assemble 1 module */
	}
 #endif
#else
	rc = AssembleModule( Options.names[ASM] );
#endif
    };
    CmdlineFini();
    if ( numArgs == 0 ) {
	write_logo();
	printf( MsgGetEx( MSG_USAGE ) );
    } else if ( numFiles == 0 )
	EmitError( NO_FILENAME_SPECIFIED );

    MsgFini();
    return( 1 - rc ); /* zero if no errors */
}
