; DZ7ZA.ASM--
; Copyright (c) 2011 Hjort Nidudsson
;
; Change history:
; 2014-01-03 - dll_createlist() failed - inlined CreateConsole -- CREATE_NEW_CONSOLE
; 2013-11-03 - converted to 32-bit
; 07/26/2012 - added support for single files (.bz2)
; 23.01.2012 - added "quotes" to <archive> name
; 12/28/2011 - added 'modified' to the read function
;
include dir.inc
include ini.inc
include conio.inc
include errno.inc
include alloc.inc
include io.inc
include iost.inc
include string.inc
include stdio.inc
include stdlib.inc
include wsub.inc
include fblk.inc
include process.inc
include filter.inc
include keyb.inc
include time.inc
include confirm.inc
include version.inc
include dll.inc
include dzdata.inc

NAME?		equ <'7za'>

IDTYPE_7Z	equ 0
IDTYPE_GZ	equ 1
IDTYPE_BZ2	equ 2
IDTYPE_CAB	equ 3
IDTYPE_XZ	equ 4
IDTYPE_TAR	equ 5
IDTYPE_LZMA	equ 6

TYPE_7Z		equ 00007A37h
TYPE_GZ		equ 00008B1Fh
TYPE_BZ2	equ 00005A42h
TYPE_CAB	equ 4643534Dh
TYPE_XZ		equ 587A37FDh

.data

M1		macro v,n
		exitm<0F0h or ((n and 0FF00h) shr 8),n and 00FFh,v>
		endm

IDDABOUT	label word
		dw 4000,005Ch
		db 1,0,15,4,50,21,  0,0,0,'O',4,19,8,1
		db M1(50h,50),M1(29h,50*18+4),M1(80h,3),8Dh,M1(80h,4),M1(25h,50*2+38)
		db M1(" About",22)
		db M1(" DZ7ZA Version 1.05",78)
		db M1(" Doszip plugin for 7ZA.EXE",32)
		db M1(' ',25),M1('',39)
		db M1(" Files:",61)
		db M1(" Read Copy Add Del View",52)
		db M1(" *.7z    x    x    x   x   x",21)
		db M1(" *.gz    x    x            x  -tgzip",23)
		db M1(" *.bz2   x    x            x  -tbzip2",15)
		db M1(" *.cab   x    x            x  -tcab",14)
		db M1(" *.xz    x    x            x  -txz",16)
		db M1(" *.tar   x    x    x   x   x  -ttar",17)
		db M1(" *.lzma  x    x            x  -tlzma",16)
%		db M1(" Build:   &@Date &@Time, DZ ",64),VERSSTR
		db M1(" License: GNU General Public License",15)
		db M1(" OK   ",67),'',M1(' ',42),M1('',8),M1(' ',37)

externdef	IDD_addmsg:dword

c_entry db	NAME?,0
$PROG	db	NAME?,".exe",0
$LIST	db	WMAXPATH dup(?)
CPTEMP  db	" @"
$TEMP	db	WMAXPATH dup(?)

; default value

ARG_01  db	'7za l -y',0	; 01 - Read
ARG_02  db	'7za x -y',0	; 02 - Copy - e if not include subdir
ARG_03  db	'7za a -y',0	; 03 - Add
ARG_06  db	'7za d -y',0	; 06 - Delete
ARG_08  db	'7za m -e -y',0 ; 08 - Edit
ARG_09  db	'7za e -y',0	; 09 - View or copy single file (02)

; format strings

CPF_02  db	' %s -o%s',0	; <archive> -o<outpath> @list
CPF_03  db	' %s',0		; <archive> @list

; from [7ZA] config value, or default value

CMD_00  db	64 dup(?)	; ARG_09 - if files only (02)
CMD_01  db	64 dup(?)
CMD_02  db	64 dup(?)
CMD_03  db	64 dup(?)
CMD_06  db	64 dup(?)
CMD_08  db	64 dup(?)
CMD_09  db	64 dup(?)

config_label label dword
	dd	offset ARG_09, offset CMD_00
	dd	offset ARG_01, offset CMD_01
	dd	offset ARG_02, offset CMD_02
	dd	offset ARG_03, offset CMD_03
	dd	0,0
	dd	0,0
	dd	offset ARG_06, offset CMD_06
	dd	0,0
	dd	offset ARG_08, offset CMD_08
	dd	offset ARG_09, offset CMD_09

; file types

NUMTYPE equ	7

typ0	db	0
typ1	db	' -tgzip',0
typ2	db	' -tbzip2',0
typ3	db	' -tcab',0
typ4	db	' -txz',0
typ5	db	' -ttar',0
typ6	db	' -tlzma',0

label_types label dword
	dd	offset typ0
	dd	offset typ1
	dd	offset typ2
	dd	offset typ3
	dd	offset typ4
	dd	offset typ5
	dd	offset typ6

label_flag label dword	       ;  test,enter,attrib,view,edit,ren,del,mkdir,move,add,copy,read
	dd	100100100111B  ;   x		     x		   x		  x   x	   x
	dd	100100000011B  ;   x		     x				      x	   x
	dd	100100000011B  ;   x		     x				      x	   x
	dd	100100000011B  ;   x		     x				      x	   x
	dd	100100000011B  ;   x		     x				      x	   x
	dd	100100100111B  ;   x		     x		   x		  x   x	   x
	dd	100100000011B  ;   x		     x				      x	   x

$TYPE	dd	offset typ0	; current type string
$FLAG	dd	100100100111B	; current type flag

public  heaplen
public  configpath
public  configfile
public  programpath
public  envtemp
public  envpath

heaplen		dd 0
programpath	db WMAXPATH dup (?)
configpath	db WMAXPATH dup (?)
configfile	db WMAXPATH dup (?)
temppath	db WMAXPATH dup (?)
pathbuf		db 1024 dup (?)
envtemp		dd temppath
envpath		dd pathbuf

modified	db 1
startstring	db '------------------- '
quote		db '"',0

dll_count	dd 0
dz_memseg	dd 0
dz_conio	dd 0
dz_data		dd 0
dz_ti_keytable  dd 0
dz_global_key	dd 0
dz_topen	dd 0
dz_tmodal	dd 0
dz_tclose	dd 0
dz_tview	dd 0
dz_mousep	dd 0

.code

mousep proc
	call dz_mousep
	ret
mousep endp

mousex  proc
	mov eax,dz_conio
	mov eax,[eax].S_CONIO.co_keybmouse_x
	ret
mousex  endp

mousey  proc
	mov eax,dz_conio
	mov eax,[eax].S_CONIO.co_keybmouse_y
	ret
mousey  endp

CreateConsole proc string:dword, flag:dword
local cmd[WMAXPATH*3]:byte
	.if searchp("cmd.exe")
	    mov edx,eax
	    invoke strcpy,addr cmd,edx
	    invoke strcat,eax," /C "
	    invoke strcat,eax,addr quote
	    invoke strcat,eax,string
	    invoke strcat,eax,addr quote
	    mov edx,flag
	    or  edx,CREATE_NEW_CONSOLE;DETACHED_PROCESS
	    invoke process,0,eax,edx
	    invoke SetKeyState
	.endif
	ret
CreateConsole endp

;-------------------------------------------------------------------------
; Function 0 - get version
;-------------------------------------------------------------------------

dll_version:
	mov	eax,VERSION
	ret

;-------------------------------------------------------------------------
; Function 1 - init
;-------------------------------------------------------------------------

dll_init proc uses esi edi ; dllargs
	mov	esi,eax
	lea	edi,dll_count
	mov	ecx,sizeof(S_DLLARGS)/4
	rep	movsd
	mov	esi,dz_memseg
	lea	edi,memseg
	mov	ecx,3
	rep	movsd
	mov	esi,dz_conio
	lea	edi,keyshift
	mov	ecx,S_CONIO.co_tdialog/4
	rep	movsd
	mov	eax,_diskflag
	mov	byte ptr [eax],0
	invoke  memcpy,addr at_background,tdcolor,sizeof(S_COLOR)
	invoke  memcpy,addr programpath,dz_data,WMAXPATH*3
	.if !GetEnvironmentVariable("PATH",addr pathbuf,1024)
	    invoke strcpy,addr pathbuf,addr programpath
	.endif
	.if !GetEnvironmentVariable("TEMP",addr temppath,WMAXPATH)
	    invoke strcpy,addr temppath,addr configpath
	.endif
	invoke  strfcat,addr $LIST,envtemp,"ziplst.tmp"
	invoke  strfcat,addr $TEMP,envtemp,"ziplst"

	; All functions use 7ZA.EXE so init fail if not found

	invoke  searchp,addr $PROG
	test	eax,eax
	jnz	@F
	invoke  ermsg,addr $PROG,"File not found: 7ZA.EXE"
	sub	eax,eax
	jmp	toend
     @@:
	mov	eax,label_flag
  toend:
	ret
dll_init endp

;-------------------------------------------------------------------------
; Function 2 - Read
;-------------------------------------------------------------------------

lline_getdate:  ; 2008-04-28
	invoke  atol, addr entryname
	push	eax
	invoke  atol, addr entryname + 5
	push	eax
	invoke  atol, addr entryname + 8
	mov	dl,al
	pop	eax
	mov	dh,al
	pop	eax
	sub	ax,DT_BASEYEAR
	shl	ax,9
	xchg	ax,dx
	mov	cl,al
	mov	al,ah
	xor	ah,ah
	shl	ax,5
	xchg	ax,dx
	or	ax,dx
	or	al,cl
	ret

lline_gettime:  ; 02:19:00
	push	ebx
	invoke  atol,addr entryname + 11
	push	eax
	invoke  atol,addr entryname + 14
	push	eax
	invoke  atol,addr entryname + 17
	pop	ecx
	pop	ebx
	mov	ch,bl
	mov	dh,al
	xor	eax,eax ; DH = second
	mov	al,dh	; CH = hour
	shr	ax,1	; CL = minute
	mov	edx,eax
	mov	al,ch
	mov	ch,ah
	shl	cx,5
	shl	eax,11
	or	eax,ecx
	or	eax,edx ; hhhhhmmmmmmsssss
	pop	ebx
	ret

lline_getattrib:
	xor	eax,eax
	cmp	entryname[20],'D'
	jne	@F
	mov	al,_A_SUBDIR
      @@:
	cmp	entryname[21],'R'
	jne	@F
	or	al,_A_RDONLY
      @@:
	cmp	entryname[22],'H'
	jne	@F
	or	al,_A_HIDDEN
      @@:
	cmp	entryname[23],'S'
	jne	@F
	or	al,_A_SYSTEM
      @@:
	cmp	entryname[24],'A'
	jne	@F
	or	al,_A_ARCH
      @@:
	ret

lline_findfirst:
	call	ogets
	jz	@B
	cmp	entryname,'-'
	jne	lline_findfirst
	invoke  strncmp,edi,addr startstring, offset quote - offset startstring
	test	eax,eax
	jnz	lline_findfirst
;
;   Date      Time    Attr	   Size	  Compressed  Name
;------------------- ----- ------------ ------------  ------------------------
;		     .....		      790027  7z922.tar
;------------------- ----- ------------ ------------  ------------------------
;					      790027  1 files, 0 folders
;
lline_findnext:
	call	ogets
	jz	lline_findnext_fail
	mov	al,entryname	; 2008-04-28
	cmp	al,' '
	jne	@F
	invoke  strlen,addr entryname
	cmp	eax,52
	jb	lline_findnext_fail
	jmp	lline_findnext_set
      @@:
	cmp	al,'0'
	jb	lline_findnext_fail
	cmp	al,'9'
	ja	lline_findnext_fail
	cmp	entryname[4],'-'
	jne	lline_findnext_fail
    lline_findnext_set:
	xor	eax,eax
	mov	entryname[4],al
	mov	entryname[7],al
	mov	entryname[10],al
	mov	entryname[13],al
	mov	entryname[16],al
	mov	entryname[19],al
	mov	entryname[38],al
	mov	entryname[51],al
	mov	al,entryname[52]
	or	al,al
	ret
    lline_findnext_fail:
	xor	eax,eax
	ret

	assume  ebx:ptr S_WSUB

;
; Returns 0 if entry not part of basepath,
; else _A_ARCH or _A_SUBDIR.
;
testentryname proc uses esi edi ebx wsub:dword, ename:dword
	mov	ebx,wsub
	invoke  strlen,[ebx].ws_arch
	mov	edi,eax
	mov	esi,ename
	invoke  strlen,esi
	cmp	edi,eax
	jae	testentryname_fail
	cmp	edi,0
	jle	testentryname_flag
	invoke  strnicmp,ename,[ebx].ws_arch,edi
	test	eax,eax
	jnz	testentryname_fail
	mov	eax,edi
	mov	al,[esi+eax]
	cmp	al,'\'
	jne	testentryname_fail
    testentryname_copy:
	mov	eax,esi
	add	eax,edi
	inc	eax
	invoke  strcpy,esi,eax
    testentryname_comma:
	cmp	byte ptr [esi],','
	jne	testentryname_flag
	mov	eax,esi
	inc	eax
	invoke  strcpy,esi,eax
	jmp	testentryname_comma
    testentryname_flag:
	mov	edi,_A_ARCH
    testentryname_loop:
	lodsb
	test	al,al
	jz	testentryname_find
	cmp	al,'\'
	jne	testentryname_loop
	xor	eax,eax
	mov	[esi-1],al
	mov	edi,_A_SUBDIR
    testentryname_find:
	mov	esi,1
	cmp	[ebx].ws_count,esi
	jbe	testentryname_ok
    testentryname_cmp:
	cmp	[ebx].ws_count,esi
	jbe	testentryname_ok
	mov	eax,[ebx].ws_fcb
	mov	eax,[eax+esi*4]
	add	eax,S_FBLK.fb_name
	invoke  stricmp,ename,eax
	test	eax,eax
	jz	testentryname_fail
	inc	esi
	jmp	testentryname_cmp
    testentryname_ok:
	mov	eax,edi
	test	eax,eax
    testentryname_end:
	ret
    testentryname_fail:
	xor	eax,eax
	jmp	testentryname_end
testentryname endp

	assume  ebx:nothing
	assume  esi:ptr S_WSUB

dll_createlist proc uses esi edi wsub:dword
local batf[256]:byte
local arch[256]:byte
local cmd[512]:byte
	mov	esi,wsub
	mov	arch,'"'
	invoke  strfcat,addr arch+1,[esi].ws_path,[esi].ws_file
	invoke  strcat,eax,addr quote
	invoke  strfcat,addr batf,envtemp,"dzcmd.bat"
	mov	esi,eax
	invoke  osopen,eax,0,M_WRONLY,A_CREATETRUNC
	mov	edi,eax
	inc	eax
	jz	toend
	invoke  sprintf,addr cmd,"%s%s > %s\r\n",addr CMD_01,addr arch,addr $LIST
	invoke  strlen,addr cmd
	invoke  oswrite,edi,addr cmd,eax
	invoke  close,edi
	invoke  CreateConsole,addr batf,_P_WAIT
	invoke  remove,addr batf
	mov	eax,_diskflag
	mov	byte ptr [eax],0
	mov	eax,1
  toend:
	ret
dll_createlist endp

dll_read proc		; wsub
local fblk:dword
local fattrib:dword
local ename:dword
	mov esi,eax
	invoke wsfree,eax
	.if fbupdir(_W_ARCHEXT)
	    mov [esi].ws_count,1
	    mov ebx,[esi].ws_fcb
	    mov [ebx],eax
	    .if modified
		invoke dll_createlist,esi
	    .endif
	    .if ogetl(addr $LIST,addr entryname,512)
		lea edi,entryname
		lea eax,[edi+53]
		mov ename,eax
		call lline_findfirst
		.while eax
		    .if testentryname(esi,ename)
			mov fattrib,eax
			.if al & _A_SUBDIR || cmpwarg(ename,[esi].ws_mask)
			    invoke strlen,ename
			    add eax,SIZE S_FBLK
			    .break .if !malloc(eax)
			    mov ecx,fattrib
			    mov fblk,eax
			    or  ecx,_FB_ARCHEXT
			    mov [eax].S_FBLK.fb_flag,ecx
			    add eax,S_FBLK.fb_name
			    invoke strcpy,eax,ename
			    invoke atol,addr entryname + 26
			    mov ebx,fblk
			    mov dword ptr [ebx].S_FBLK.fb_size,eax
			    mov dword ptr [ebx].S_FBLK.fb_size+4,edx
			    call lline_getdate
			    push eax
			    call lline_gettime
			    pop ecx
			    shl ecx,16
			    or  eax,ecx
			    mov ebx,fblk
			    mov [ebx].S_FBLK.fb_time,eax
			    call lline_getattrib
			    mov ebx,fblk
			    or  [ebx],al
			    mov eax,[esi].ws_count
			    shl eax,2
			    add eax,[esi].ws_fcb
			    mov [eax],ebx
			    inc [esi].ws_count
			    mov eax,[esi].ws_count
			    .break .if eax >= [esi].ws_maxfb
			.endif
		    .endif
		    call lline_findnext
		.endw
		invoke oclose,addr STDI
		mov modified,0
		mov eax,[esi].ws_count
	    .endif
	.endif
	ret
dll_read endp

	assume  esi:nothing

;-------------------------------------------------------------------------
; Function 3 - Copy
;-------------------------------------------------------------------------

.data

S_MKLST		STRUC
mkl_macro	db ?	; use output macro
mkl_append	db ?	; add to list or create new
mkl_unix	db ?	; convert to unix
mkl_excl_cd	db ?	; use local directory
mkl_excl_drv	db ?	; use drive in directory
mkl_mask	db ?	; add mask to directory\[*.*]
mkl_offspath	dd ?	; length of local directory
mkl_offset	dd ?	; search offset from findfile
mkl_handle	dd ?
mkl_count	dd ?	; total file count in list
S_MKLST		ENDS

format_lst	db "%f\n",0
listwsub	dd ?
listfblk	dd ?
mklist		S_MKLST <>
CRLF$		db 0Dh,0Ah
BACK$		db '\',0		; '\'
mklsubcnt	dd ?

.code

panel_findnext proc
	invoke  wsffirst,listwsub
	jz	@F
	mov	edx,eax
	add	eax,S_FBLK.fb_name
     @@:
	ret
panel_findnext endp

panel_curobj proc
	mov eax,listfblk
	mov edx,eax
	mov ecx,[eax].S_FBLK.fb_flag
	add eax,S_FBLK.fb_name
	ret
panel_curobj endp

cpanel_findfirst proc
	.if !panel_findnext()
	    call panel_curobj
	.endif
	.if !ZERO? && !(ecx & _FB_UPDIR)
	    test eax,eax
	    ret
	.endif
	xor eax,eax
	ret
cpanel_findfirst endp


mklistadd proc uses esi edi ebx ; AX=file name
local tmp[1024]:byte
	mov  edx,eax
	xor  eax,eax
	mov  ecx,eax
	inc mklist.mkl_count
	.if mklist.mkl_excl_drv != al && byte ptr [edx+1] == ':'
	    add ecx,2
	.endif
	add edx,ecx
	.if mklist.mkl_excl_cd != al
	    add edx,mklist.mkl_offspath
	    sub edx,ecx
	.endif
	.if mklist.mkl_unix != al
	    invoke dostounix,edx
	    mov edx,eax
	.endif
	lea ebx,tmp
	lea edi,[ebx+WMAXPATH*2]
	invoke strcpy,edi,edx
	invoke strcpy,ebx,addr format_lst
	invoke strcpy,eax,edi
	invoke strlen,ebx
	.if oswrite(mklist.mkl_handle,ebx,eax)
	    mov eax,0
	    .if mklist.mkl_macro != 1
		invoke oswrite,mklist.mkl_handle,addr CRLF$, 2
		sub eax,2
		.if eax
		    inc eax
		.endif
	    .endif
	.else
	   inc eax
	.endif
	test eax,eax
	ret
mklistadd endp

fp_mklist proc path:dword, wblk:dword
	.if filter_wblk(wblk)
	    mov eax,wblk
	    add eax,S_WFBLK.wf_name
	    invoke strfcat,addr __srcfile,path,eax
	    mov eax,offset __srcfile
	    call mklistadd
	.endif
	ret
fp_mklist endp

mksublist proc uses esi edi zip_list:dword, path:dword
	mov eax,1
	mov mklist.mkl_macro,0
	mov mklist.mkl_excl_cd,al
	mov fp_fileblock,offset fp_mklist
	mov fp_directory,offset scan_files
	invoke strlen,path
	mov edx,path
	add edx,eax
	.if byte ptr [edx-1] != '\'
	    inc eax
	.endif
	mov mklist.mkl_offspath,eax
	.if cpanel_findfirst()
     @@:
	    .if ecx & _FB_ARCHEXT
		mov mklist.mkl_offspath,0
	    .endif
	    mov edi,ecx
	    mov esi,edx
	    invoke strfcat,addr __outpath,path,eax

		.if edi & _A_SUBDIR
		    .if edi & _FB_ARCHIVE
			invoke strcat,addr __outpath,addr BACK$
			.if mklist.mkl_mask
			    mov edx,listwsub
			    invoke strcat,eax,[edx].S_WSUB.ws_mask
			.endif
			call mklistadd
			inc mklsubcnt
		    .else
			.if scansub(addr __outpath,addr cp_stdmask,0)
			    jmp @F
			.endif
		    .endif
		.else
		    .if filter_fblk(esi)
			mov eax,offset __outpath
			call mklistadd
		    .endif
		.endif
		and [esi].S_FBLK.fb_flag,not _FB_SELECTED
		call panel_findnext
		jnz @B

	 @@:
	    push eax
	    invoke close,mklist.mkl_handle
	    pop eax
	.else
	    jmp @B
	.endif
    mksublist_end:
	ret
mksublist endp

mkwslist proc uses esi
	mov esi,eax
	.if cpanel_findfirst()
	    mov edx,listwsub
	    mov edx,[edx].S_WSUB.ws_flag
	    mov eax,[edx]
	    .if eax & _W_ARCHIVE
		add edx,S_PATH.wp_arch
	    .else
		add edx,S_PATH.wp_path
	    .endif
	    invoke mksublist,esi,edx
	.endif
	ret
mkwslist endp

mkziplst_open proc
	invoke ogetouth,addr $TEMP,M_WRONLY
	mov mklist.mkl_handle,eax
	.if eax
	    inc eax
	    .if eax
		mov eax,1
	    .endif
	.endif
	ret
mkziplst_open endp

mkziplst proc
	sub	eax,eax
	mov	mklsubcnt,eax
	inc	eax
	call	mkwslist
	mov	edx,mklsubcnt
	ret
mkziplst endp

doszip_mklist:
	mov	mklist.mkl_unix,al
	mov	mklist.mkl_mask,dl
	call	mkziplst_open
	test	eax,eax
	mov	eax,ENOENT
	jz	@F
	call	mkziplst
	mov	ecx,mklist.mkl_count
     @@:
	ret

dzmklist proc o_name:dword
	call	doszip_mklist
	test	eax,eax
	jz	dzmklist_count
	mov	eax,errno
	mov	eax,sys_errlist[eax*4]
	invoke  ermsg,o_name,"Error create listfile\n\n%s",eax
	dec	eax
	jmp	dzmklist_end
    dzmklist_count:
	test	ecx,ecx
	jnz	dzmklist_end
	invoke  ermsg,o_name,"Nothing to do.."
	dec	eax
    dzmklist_end:
	test	eax,eax
	ret
dzmklist endp

dll_mklist:	; create list
	mov	al,1	; unix path
	mov	dl,0	; no mask in directory\[*.*]
	invoke  dzmklist,"7ZA: Create list file"
	;
	; return AX result, BX directory count, DX:CX total
	;
	ret
;
; Clear selection set from panel
;
wsclrsel proc uses esi edi ebx wsub:dword
	mov	esi,1
	mov	edi,wsub
	cmp	[edi].S_WSUB.ws_count,esi
	jbe	wsclrsel_end
    wsclrsel_loop:
	cmp	[edi].S_WSUB.ws_count,esi
	jbe	wsclrsel_end
	mov	ebx,[edi].S_WSUB.ws_fcb
	mov	eax,esi
	shl	eax,2
	add	ebx,eax
	mov	ebx,[ebx]
	and	[ebx].S_FBLK.fb_flag,not _FB_SELECTED
	inc	esi
	jmp	wsclrsel_loop
    wsclrsel_end:
	ret
wsclrsel endp

dll_copy proc ; wsub, fblk, outp, filt
local cmd[WMAXPATH]:byte
local path[WMAXPATH]:byte
	mov	listwsub,eax
	mov	listfblk,edx
	mov	filter,ebx
	lea	esi,cmd
	lea	edi,CMD_02
	mov	ebx,ecx
	invoke  strcpy,addr path,ecx
	invoke  strlen,eax	; remove '\' from end of outpath (C:\)
	add	ebx,eax
	dec	ebx
	mov	eax,'\'
	cmp	[ebx],al
	jne	@F
	mov	[ebx],ah
     @@:
	call	dll_mklist	; make a list file
	jnz	toend
	mov	eax,mklsubcnt
	test	eax,eax
	jnz	@F
	lea	edi,CMD_00
     @@:
	mov	ebx,listwsub
	invoke  wsclrsel,ebx	; clear selection set from panel
	invoke  sprintf,esi,edi,[ebx].S_WSUB.ws_file,addr path
	invoke  CreateConsole,addr cmd,_P_WAIT
	invoke  remove,addr $TEMP
	sub	eax,eax
  toend:
	ret
dll_copy endp

;-------------------------------------------------------------------------
; Function 4 - Add
;
; - add files to <archive>\ root directory only
;-------------------------------------------------------------------------

display_addmsg:
	xor	eax,eax
	mov	ebx,[edi].S_WSUB.ws_arch
	cmp	[ebx],al
	je	@F
	invoke  rsmodal,IDD_addmsg ; OK == 1, else 0
	dec	eax
	jz	@F
	mov	eax,ER_USERABORT
     @@:
	ret

make_ziplst_add:
	call	display_addmsg
	jnz	@B
make_ziplst:
	call	dll_mklist
	jnz	@F
	invoke  wsclrsel,esi
	xor	eax,eax
     @@:
	ret

dll_add proc ; dest, wsub, fblk, filt
local cmd[256]:byte
local path[WMAXPATH]:byte
	mov	edi,eax
	mov	eax,$FLAG
	and	eax,_DLLF_ADD
	jz	@F
	mov	esi,edx
	mov	listwsub,edx
	mov	listfblk,ecx
	mov	filter,ebx
	call	make_ziplst_add
	jnz	@F
	invoke  strfcat,addr path,[edi].S_WSUB.ws_path,[edi].S_WSUB.ws_file
	lea	edx,cmd
	invoke  sprintf,edx,addr CMD_03,eax
	invoke  CreateConsole,addr cmd,_P_WAIT
	invoke  remove,addr $TEMP
	inc	modified
	xor	eax,eax
     @@:
	ret
dll_add endp

;-------------------------------------------------------------------------
; Function 7 - Delete
;-------------------------------------------------------------------------

dll_delete proc ; wsub, fblk
local cmd[256]:byte
	test	$FLAG,_DLLF_DELETE
	jz	cancel
	mov	listwsub,eax
	mov	listfblk,edx
	mov	esi,eax
	mov	edi,edx
	call	make_ziplst
	jnz	toend
	mov	ecx,[edi].S_FBLK.fb_flag
	lea	eax,[edi].S_FBLK.fb_name
	invoke  confirm_delete_file,eax,ecx
	test	eax,eax
	jz	cancel		; 0: Skip file
	inc	eax
	jz	cancel		; -1: Cancel
	invoke  wsclrsel,esi	; clear selection set from panel
	invoke  sprintf,addr cmd,addr CMD_06,[esi].S_WSUB.ws_file
	invoke  CreateConsole,addr cmd,_P_WAIT
	invoke  remove,addr $TEMP
	inc	modified
 cancel:
	sub	eax,eax
  toend:
	ret
dll_delete endp

;-------------------------------------------------------------------------
; Function 10 - View
;-------------------------------------------------------------------------

inv2 typedef proto stdcall :dword,:dword

dll_view proc	; wsub, fblk
local fbname[WMAXPATH]:byte
local cmd[WMAXPATH]:byte
	mov	esi,eax
	lea	edi,cmd
	mov	ebx,edx
	add	ebx,S_FBLK.fb_name
	invoke  strfcat,addr fbname,[esi].S_WSUB.ws_arch,ebx
	invoke  sprintf,edi,addr CMD_09,[esi].S_WSUB.ws_file,envtemp,eax
	invoke  CreateConsole,edi,_P_WAIT
	invoke  strfcat,edi,envtemp,ebx
	invoke  filexist,edi
	dec	eax
	jnz	@F
	mov	eax,dz_tview
	invoke  inv2 ptr eax,edi,0
	invoke  remove,edi
	mov	edi,_diskflag
	mov	byte ptr [edi],0
     @@:
	ret
dll_view endp

;-------------------------------------------------------------------------
; Function 11 - Test
;-------------------------------------------------------------------------

dll_gettype proc fblk, sign
	mov eax,sign
	.if eax == TYPE_CAB
	    mov eax,IDTYPE_CAB
	    jmp toend
	.endif
	.if eax == TYPE_XZ
	    mov eax,IDTYPE_XZ
	    jmp toend
	.endif
	and eax,0000FFFFh
	.if eax == TYPE_7Z
	    mov eax,IDTYPE_7Z
	    jmp toend
	.endif
	.if eax == TYPE_GZ
	    mov eax,IDTYPE_GZ
	    jmp toend
	.endif
	.if eax == TYPE_BZ2
	    mov eax,IDTYPE_BZ2
	    jmp toend
	.endif
	mov eax,fblk
	lea edx,[eax].S_FBLK.fb_name
	.if strext(edx)
	    mov edx,eax
	    .if !stricmp(eax,".tar")
		mov eax,IDTYPE_TAR
		jmp toend
	    .endif
	    .if !stricmp(edx,".lzma")
		mov eax,IDTYPE_LZMA
		jmp toend
	    .endif
	.endif
	mov eax,-1
  toend:
	ret
dll_gettype endp

dll_test proc	; fblk, sign
	.if dll_gettype(eax,edx) != -1
	    mov edx,eax
	    mov eax,label_types[edx*4]
	    mov $TYPE,eax
	    mov eax,label_flag[edx*4]
	    mov $FLAG,eax
	    mov ecx,1		; _DLL_READ
	    call find
	    invoke strcat,eax," "
	    mov ecx,0
	    call find
	    invoke strcat,eax,addr CPF_02
	    invoke strcat,eax,addr CPTEMP
	    mov ecx,2		; _DLL_COPY
	    call find
	    invoke strcat,eax,addr CPF_02
	    invoke strcat,eax,addr CPTEMP
	    mov ecx,3		; _DLL_ADD
	    call find
	    invoke strcat,eax,addr CPF_03
	    invoke strcat,eax,addr CPTEMP
	    mov ecx,6		; _DLL_DELETE
	    call find
	    invoke strcat,eax,addr CPF_03
	    invoke strcat,eax,addr CPTEMP
	    mov ecx,8		; _DLL_EDIT
	    call find
	    invoke strcat,eax," %s %s"
	    mov ecx,9		; _DLL_VIEW
	    call find
	    invoke strcat,eax," %s -o%s %s"
	    mov eax,1
	    mov modified,al
	.else
	    sub eax,eax
	.endif
	ret
   find:
	mov esi,ecx
	shl esi,3
	mov edi,config_label[esi]
	mov esi,config_label[esi+4]
	.if !inientryid(addr c_entry,ecx)
	    mov eax,edi
	.endif
	invoke strcpy,esi,eax
	invoke strcat,eax,$TYPE
	retn
dll_test endp

;-------------------------------------------------------------------------
; Function 14 - Exit
;-------------------------------------------------------------------------

dll_exit:
	invoke remove,addr $LIST
	sub eax,eax
	ret

;-------------------------------------------------------------------------
; Function 15 - about
;-------------------------------------------------------------------------

dll_about:
	invoke rsmodal,addr IDDABOUT
	ret

;-------------------------------------------------------------------------
; Functions not implemented
;-------------------------------------------------------------------------

dll_move:	; dest, wsub, fblk
dll_mkdir:	; wsub, directory
dll_rename:	; wsub, fblk, copy
dll_edit:	; wsub, fblk
dll_attrib:	; wsub, fblk
dll_enter:	; wsub, fblk
	invoke notsup
dll_link:
	sub eax,eax
	ret

.data

proc_label label dword
	dd dll_version
	dd dll_init
	dd dll_read
	dd dll_copy
	dd dll_add
	dd dll_move
	dd dll_mkdir
	dd dll_delete
	dd dll_rename
	dd dll_edit
	dd dll_view
	dd dll_attrib
	dd dll_enter
	dd dll_test
	dd dll_exit
	dd dll_link
	dd dll_about

.code

dll_call proc pascal export uses esi edi ebx a0, a1, a2, a3, a4
	mov	eax,a0
	cmp	eax,_DLL_ABOUT
	ja	error
	mov	esi,proc_label[eax*4]
	mov	eax,a1
	mov	edx,a2
	mov	ecx,a3
	mov	ebx,a4
	call	esi
  toend:
	ret
  error:
	sub	eax,eax
	jmp	toend
dll_call endp

	end
