; DZARJ.ASM--
; Copyright (c) 2011 Hjort Nidudsson
;
; Change history:
; 2013-11-03 - converted to 32-bit

include dir.inc
include ini.inc
include conio.inc
include errno.inc
include alloc.inc
include io.inc
include iost.inc
include string.inc
include stdio.inc
include stdlib.inc
include wsub.inc
include fblk.inc
include process.inc
include filter.inc
include keyb.inc
include time.inc
include confirm.inc
include version.inc
include dll.inc
include dzdata.inc

externdef	IDD_addmsg:dword
externdef	IDD_dodelete:dword

	; test|enter|attrib|view|edit|ren|del|mkdir|move|add|copy|read
	;  x		     x	  x    x   x	     x	  x   x	   x

FLAG?	equ	100111101110B	; functions that need ARJ.EXE
NAME?	equ	<'arj'>

.data

M1		macro v,n
		exitm<0F0h or ((n and 0FF00h) shr 8),n and 00FFh,v>
		endm

IDDABOUT	label word
		dw 3000,005Ch
		db 1,0,15,6,45,15,  0,0,0,'O',4,13,8,1
		db M1(50h,45),M1(29h,45*12+4),M1(80h,3),8Dh,M1(80h,4),M1(25h,45*2+38)
		db M1(" About",20)
		db M1(" DZARJ Version 1.04",70)
		db M1(" Doszip plugin for ARJ.EXE",27)
		db M1(' ',20),M1('',35)
		db M1(" Files:",55)
		db M1(" Read Copy Add Del View",47)
		db M1(" *.arj   x    x    x   x   x",16)
%		db M1(" Build:   &@Date &@Time, DZ ",62),VERSSTR
		db M1(" License: GNU General Public License",10)
		db M1(" OK   ",57),'',M1(' ',37),M1('',8),M1(' ',32)

$FLAG	dd	100111101111B	; functions included

c_entry db	NAME?,0		; the [<entry>] in dz.ini to read from

ARG_02  db	'arj x -y',0	; 02 - Copy - e if not include subdir
ARG_03  db	'arj a -y',0	; 03 - Add
ARG_04  db	'arj m -y',0	; 04 - Move
ARG_06  db	'arj d -p -y',0 ; 06 - Delete
ARG_07  db	'arj n',0	; 07 - Rename
ARG_08  db	'arj m -e -y',0 ; 08 - Edit
ARG_09  db	'arj e -y',0	; 09 - View - or copy single file (02)

CPF_02  db	' %s %s\',0	; <archive> -o<outpath>
CPF_03  db	' %s',0		; <archive>
CPTEMP  db	" !"
$TEMP	db	WMAXPATH dup(?)
$LIST	db	WMAXPATH dup(?)

CMD_00  db	64 dup(?)
CMD_02  db	64 dup(?)	; buffer for command format string
CMD_03  db	64 dup(?)
CMD_04  db	64 dup(?)
CMD_06  db	64 dup(?)
CMD_07  db	64 dup(?)
CMD_08  db	64 dup(?)
CMD_09  db	64 dup(?)

config_label label dword	; table: <default value>, <buffer>
	dd	offset ARG_09, offset CMD_00
	dd	0,0
	dd	offset ARG_02, offset CMD_02
	dd	offset ARG_03, offset CMD_03
	dd	offset ARG_04, offset CMD_04
	dd	0,0
	dd	offset ARG_06, offset CMD_06
	dd	offset ARG_07, offset CMD_07
	dd	offset ARG_08, offset CMD_08
	dd	offset ARG_09, offset CMD_09

;---------------------------------------------------------

public  heaplen
public  configpath
public  configfile
public  programpath
public  envtemp
public  envpath

heaplen		dd 0
programpath	db WMAXPATH dup (?)
configpath	db WMAXPATH dup (?)
configfile	db WMAXPATH dup (?)
temppath	db WMAXPATH dup (?)
pathbuf		db 1024 dup (?)
envtemp		dd temppath
envpath		dd pathbuf

dll_count	dd 0
dz_memseg	dd 0
dz_conio	dd 0
dz_data		dd 0
dz_ti_keytable  dd 0
dz_global_key	dd 0
dz_topen	dd 0
dz_tmodal	dd 0
dz_tclose	dd 0
dz_tview	dd 0
dz_mousep	dd 0

.code

mousep proc
	call dz_mousep
	ret
mousep endp

mousex  proc
	mov eax,dz_conio
	mov eax,[eax].S_CONIO.co_keybmouse_x
	ret
mousex  endp

mousey  proc
	mov eax,dz_conio
	mov eax,[eax].S_CONIO.co_keybmouse_y
	ret
mousey  endp

;
; Clear selection set from panel
;
wsclrsel proc uses esi edi ebx wsub:dword
	mov	esi,1
	mov	edi,wsub
	cmp	[edi].S_WSUB.ws_count,esi
	jbe	wsclrsel_end
    wsclrsel_loop:
	cmp	[edi].S_WSUB.ws_count,esi
	jbe	wsclrsel_end
	mov	ebx,[edi].S_WSUB.ws_fcb
	mov	eax,esi
	shl	eax,2
	add	ebx,eax
	mov	ebx,[ebx]
	and	[ebx].S_FBLK.fb_flag,not _FB_SELECTED
	inc	esi
	jmp	wsclrsel_loop
    wsclrsel_end:
	ret
wsclrsel endp

;-------------------------------------------------------------------------
; Function 0 - get version
;-------------------------------------------------------------------------

dll_version:
	mov	eax,VERSION
	ret

;-------------------------------------------------------------------------
; Function 1 - init
;-------------------------------------------------------------------------

dll_init proc uses esi edi ; dllargs
	mov	esi,eax
	lea	edi,dll_count
	mov	ecx,sizeof(S_DLLARGS)/4
	rep	movsd
	mov	esi,dz_memseg
	lea	edi,memseg
	mov	ecx,3
	rep	movsd
	mov	esi,dz_conio
	lea	edi,keyshift
	mov	ecx,S_CONIO.co_tdialog/4
	rep	movsd
	mov	eax,_diskflag
	mov	byte ptr [eax],0
	invoke  memcpy,addr at_background,tdcolor,sizeof(S_COLOR)
	invoke  memcpy,addr programpath,dz_data,WMAXPATH*3
	.if !GetEnvironmentVariable("PATH",addr pathbuf,1024)
	    invoke strcpy,addr pathbuf,addr programpath
	.endif
	.if !GetEnvironmentVariable("TEMP",addr temppath,WMAXPATH)
	    invoke strcpy,addr temppath,addr configpath
	.endif
	invoke  strfcat,addr $LIST,envtemp,"ziplst.tmp"
	invoke  strfcat,addr $TEMP,envtemp,"ziplst"
	invoke  searchp,"ARJ.EXE"
	test	eax,eax
	jz	@F	; clear functions needing ARJ.EXE
	call	init_args
	mov	eax,$FLAG
	jmp	toend
     @@:
	xor	$FLAG,FLAG?
	mov	eax,$FLAG
  toend:
	ret
dll_init endp

init_args:			; Compile arguments to CMD
	mov	ecx,2	; _DLL_COPY
	call	init_args_find  ; try DZ.INI or use default
	invoke  strcat,eax,addr CPF_02
	invoke  strcat,eax,addr CPTEMP
	mov	ecx,0
	call	init_args_find
	invoke  strcat,eax,addr CPF_02
	invoke  strcat,eax,addr CPTEMP
	mov	ecx,3	; _DLL_ADD
	call	init_args_find
	invoke  strcat,eax,addr CPF_03
	invoke  strcat,eax,addr CPTEMP
	mov	ecx,4	; _DLL_MOVE
	call	init_args_find
	invoke  strcat,eax,addr CPF_03
	invoke  strcat,eax,addr CPTEMP
	mov	ecx,6	; _DLL_DELETE
	call	init_args_find
	invoke  strcat,eax, addr CPF_03
	invoke  strcat,eax, addr CPTEMP
	mov	ecx,7	; _DLL_RENAME
	call	init_args_find
	invoke  strcat,eax," %s %s"
	mov	ecx,8	; _DLL_EDIT
	call	init_args_find
	invoke  strcat,eax," %s %s"
	mov	ecx,9	; _DLL_VIEW
	call	init_args_find
	invoke  strcat,eax," %s %s\ %s"
	ret
    init_args_find:
	mov esi,ecx
	shl esi,3
	mov edi,config_label[esi]
	mov esi,config_label[esi+4]
	.if !inientryid(addr c_entry,ecx)
	    mov eax,edi
	.endif
	invoke strcpy,esi,eax
	ret

;-------------------------------------------------------------------------
; Function 2 - Read
;-------------------------------------------------------------------------

ARJHEADERID	equ 0EA60h
ARJEXTFILE	equ 08h
MAXENTRYNAME	equ 512

S_ARJ			STRUC
arj_id			dw ?
arj_size_head		dw ?
arj_size_filehead	db ?
arj_version		db ?
arj_min_version		db ?
arj_os			db ?
arj_flag		db ?
arj_method		db ?
arj_type		db ?
arj_password		db ?
arj_time		dw ?
arj_date		dw ?
arj_compressed_size	dd ?
arj_original_size	dd ?
arj_crc			dd ?
arj_name_pos		dw ?
arj_file_access_mode	dw ?
arj_host_data		dw ?
S_ARJ			ENDS

	assume  ebx:ptr S_ARJ

warjreadentry proc uses ebx arj:dword, handle:dword
local	result:word
	mov	eax,arj
	invoke  osread,handle,eax,SIZE S_ARJ
	cmp	eax,SIZE S_ARJ
	jne	readentry_fail
	mov	ebx,arj
	cmp	[ebx].arj_id,ARJHEADERID
	jne	readentry_fail
	movzx	eax,[ebx].arj_size_head
	sub	eax,30
	cmp	eax,MAXENTRYNAME+4
	jbe	@F
	mov	eax,MAXENTRYNAME
      @@:
	invoke  osread,handle,addr entryname,eax
	mov	edx,eax
	movzx	eax,[ebx].arj_size_head
	add	eax,4
	sub	eax,edx
	sub	eax,30
	invoke  lseek,handle,eax,SEEK_CUR
	inc	eax
	jz	readentry_fail
	invoke  osread,handle,addr result,2
	cmp	eax,2
	jne	readentry_fail
	mov	eax,[ebx].arj_compressed_size
	movzx	ecx,result
	test	ecx,ecx
	jz	@F
	add	ecx,4
	add	eax,ecx
      @@:
	invoke  lseek,handle,eax,SEEK_CUR
	inc	eax
	jz	readentry_fail
	invoke  unixtodos,addr entryname
	test	eax,eax
      @@:
	ret
    readentry_fail:
	xor	eax,eax
	jmp	@B
warjreadentry ENDP

	assume  ebx:nothing
	assume  ebx:ptr S_WSUB
;
; Returns 0 if entry not part of basepath,
; else _A_ARCH or _A_SUBDIR.
;
testentryname proc uses esi edi ebx wsub:dword, ename:dword
	mov	ebx,wsub
	invoke  strlen,[ebx].ws_arch
	mov	edi,eax
	mov	esi,ename
	invoke  strlen,esi
	cmp	edi,eax
	jae	testentryname_fail
	cmp	edi,0
	jle	testentryname_flag
	invoke  strnicmp,ename,[ebx].ws_arch,edi
	test	eax,eax
	jnz	testentryname_fail
	mov	eax,edi
	mov	al,[esi+eax]
	cmp	al,'\'
	jne	testentryname_fail
    testentryname_copy:
	mov	eax,esi
	add	eax,edi
	inc	eax
	invoke  strcpy,esi,eax
    testentryname_comma:
	cmp	byte ptr [esi],','
	jne	testentryname_flag
	mov	eax,esi
	inc	eax
	invoke  strcpy,esi,eax
	jmp	testentryname_comma
    testentryname_flag:
	mov	edi,_A_ARCH
    testentryname_loop:
	lodsb
	test	al,al
	jz	testentryname_find
	cmp	al,'\'
	jne	testentryname_loop
	xor	eax,eax
	mov	[esi-1],al
	mov	edi,_A_SUBDIR
    testentryname_find:
	mov	esi,1
	cmp	[ebx].ws_count,esi
	jbe	testentryname_ok
    testentryname_cmp:
	cmp	[ebx].ws_count,esi
	jbe	testentryname_ok
	mov	eax,[ebx].ws_fcb
	mov	eax,[eax+esi*4]
	add	eax,S_FBLK.fb_name
	invoke  stricmp,ename,eax
	test	eax,eax
	jz	testentryname_fail
	inc	esi
	jmp	testentryname_cmp
    testentryname_ok:
	mov	eax,edi
	test	eax,eax
    testentryname_end:
	ret
    testentryname_fail:
	xor	eax,eax
	jmp	testentryname_end
testentryname endp

	assume  ebx:nothing

	assume  esi:ptr S_WSUB
	assume  ebx:ptr S_ARJ

dll_read proc ; wsub
local	handle:dword
local	entry:S_ARJ
local	extsize:word
local	fattrib:word
	mov	esi,eax
	invoke  wsfree,esi	; free allocated file block's
	invoke  wsopenarch,esi
	mov	handle,eax
	inc	eax
	jz	dll_read_ioerr
	lea	ebx,entry
	lea	edi,entryname	; read main entry
	invoke  osread,handle,addr entry,SIZE S_ARJ
	cmp	eax,SIZE S_ARJ
	jne	dll_read_ioerr
	cmp	[ebx].arj_id,ARJHEADERID
	jne	dll_read_ioerr
	mov	eax,8
	add	ax,[ebx].arj_size_head
	invoke  lseek,handle,eax,SEEK_SET
	inc	eax
	jz	dll_read_ioerr
	invoke  osread,handle,addr extsize,2
	cmp	eax,2
	jne	dll_read_ioerr
	movzx	eax,extsize
	test	eax,eax
	jz	dll_readmain_ok
	add	eax,4
	invoke  lseek,handle,eax,SEEK_CUR
	inc	eax
	jz	dll_read_ioerr
    dll_readmain_ok:
	invoke  warjreadentry,ebx,handle
	jnz	dll_read_init
    dll_read_ioerr:
	invoke  close,handle
	jmp	dll_read_fail
    dll_read_init:
	mov	[esi].ws_count,1
	invoke  fbupdir,_W_ARCHEXT
	mov	edx,[esi].ws_fcb
	mov	[edx],eax
    dll_read_do:
	test	[ebx].arj_flag,ARJEXTFILE
	jnz	dll_read_while
	invoke  testentryname,esi,addr entryname
	jz	dll_read_while
	mov	fattrib,ax
	test	al,_A_SUBDIR
	jnz	dll_read_sub
	invoke  cmpwarg,addr entryname,[esi].ws_mask
	jz	dll_read_while
    dll_read_sub:
	invoke  strlen,edi
	add	eax,size S_FBLK
	invoke  malloc,eax
	jz	dll_read_break
	mov	edx,eax
	movzx	eax,fattrib
	or	eax,_FB_ARCHEXT
	mov	[edx].S_FBLK.fb_flag,eax
	mov	ax,[ebx].arj_date
	shl	eax,16
	mov	ax,[ebx].arj_time
	mov	[edx].S_FBLK.fb_time,eax
	mov	eax,[ebx].arj_original_size
	mov	dword ptr [edx].S_FBLK.fb_size,eax
	mov	dword ptr [edx].S_FBLK.fb_size+4,0
	push	edx
	add	edx,S_FBLK.fb_name
	invoke  strcpy,edx,edi
	pop	eax
	mov	ecx,[esi].ws_count	; add block to panel
	shl	ecx,2
	add	ecx,[esi].ws_fcb
	mov	[ecx],eax
	inc	[esi].ws_count
	mov	eax,[esi].ws_count
	cmp	eax,[esi].ws_maxfb
	jae	dll_read_break
    dll_read_while:			; read next file record
	invoke  warjreadentry,ebx,handle
	jnz	dll_read_do
    dll_read_break:
	invoke  close,handle
	mov	eax,[esi].ws_count	; return file count
    dll_read_end:
	ret
    dll_read_fail:
	mov	eax,ER_READARCH
	jmp	dll_read_end
dll_read ENDP

	assume  esi:nothing
	assume  ebx:nothing

;-------------------------------------------------------------------------
; Function 02 - Copy
;-------------------------------------------------------------------------

.data

S_MKLST		STRUC
mkl_macro	db ?	; use output macro
mkl_append	db ?	; add to list or create new
mkl_unix	db ?	; convert to unix
mkl_excl_cd	db ?	; use local directory
mkl_excl_drv	db ?	; use drive in directory
mkl_mask	db ?	; add mask to directory\[*.*]
mkl_offspath	dd ?	; length of local directory
mkl_offset	dd ?	; search offset from findfile
mkl_handle	dd ?
mkl_count	dd ?	; total file count in list
S_MKLST		ENDS

format_lst	db "%f\n",0
listwsub	dd 0
listfblk	dd 0
mklist		S_MKLST <>
CRLF$		db 0Dh,0Ah
BACK$		db '\',0
mklsubcnt	dd 0

.code

panel_findnext proc
	invoke  wsffirst,listwsub
	jz	@F
	mov	edx,eax
	add	eax,S_FBLK.fb_name
     @@:
	ret
panel_findnext endp

panel_curobj proc
	mov eax,listfblk
	mov edx,eax
	mov ecx,[eax].S_FBLK.fb_flag
	add eax,S_FBLK.fb_name
	ret
panel_curobj endp

cpanel_findfirst proc
	.if !panel_findnext()
	    call panel_curobj
	.endif
	.if !ZERO? && !(ecx & _FB_UPDIR)
	    test eax,eax
	    ret
	.endif
	xor eax,eax
	ret
cpanel_findfirst endp


mklistadd proc uses esi edi ebx ; AX=file name
local tmp[1024]:byte
	mov  edx,eax
	xor  eax,eax
	mov  ecx,eax
	inc mklist.mkl_count
	.if mklist.mkl_excl_drv != al && byte ptr [edx+1] == ':'
	    add ecx,2
	.endif
	add edx,ecx
	.if mklist.mkl_excl_cd != al
	    add edx,mklist.mkl_offspath
	    sub edx,ecx
	.endif
	.if mklist.mkl_unix != al
	    invoke dostounix,edx
	    mov edx,eax
	.endif
	lea ebx,tmp
	lea edi,[ebx+WMAXPATH*2]
	invoke strcpy,edi,edx
	invoke strcpy,ebx,addr format_lst
	invoke strcpy,eax,edi
	invoke strlen,ebx
	.if oswrite(mklist.mkl_handle,ebx,eax)
	    mov eax,0
	    .if mklist.mkl_macro != 1
		invoke oswrite,mklist.mkl_handle,addr CRLF$, 2
		sub eax,2
		.if eax
		    inc eax
		.endif
	    .endif
	.else
	   inc eax
	.endif
	test eax,eax
	ret
mklistadd endp

fp_mklist proc path:dword, wblk:dword
	.if filter_wblk(wblk)
	    mov eax,wblk
	    add eax,S_WFBLK.wf_name
	    invoke strfcat,addr __srcfile,path,eax
	    mov eax,offset __srcfile
	    call mklistadd
	.endif
	ret
fp_mklist endp

mksublist proc uses esi edi zip_list:dword, path:dword
	mov eax,1
	mov mklist.mkl_macro,0
	mov mklist.mkl_excl_cd,al
	mov fp_fileblock,offset fp_mklist
	mov fp_directory,offset scan_files
	invoke strlen,path
	mov edx,path
	add edx,eax
	.if byte ptr [edx-1] != '\'
	    inc eax
	.endif
	mov mklist.mkl_offspath,eax
	.if cpanel_findfirst()
     @@:
	    .if ecx & _FB_ARCHEXT
		mov mklist.mkl_offspath,0
	    .endif
	    mov edi,ecx
	    mov esi,edx
	    invoke strfcat,addr __outpath,path,eax

		.if edi & _A_SUBDIR
		    .if edi & _FB_ARCHIVE
			invoke strcat,addr __outpath,addr BACK$
			.if mklist.mkl_mask
			    mov edx,listwsub
			    invoke strcat,eax,[edx].S_WSUB.ws_mask
			.endif
			call mklistadd
			inc mklsubcnt
		    .else
			.if scansub(addr __outpath,addr cp_stdmask,0)
			    jmp @F
			.endif
		    .endif
		.else
		    .if filter_fblk(esi)
			mov eax,offset __outpath
			call mklistadd
		    .endif
		.endif
		and [esi].S_FBLK.fb_flag,not _FB_SELECTED
		call panel_findnext
		jnz @B

	 @@:
	    push eax
	    invoke close,mklist.mkl_handle
	    pop eax
	.else
	    jmp @B
	.endif
    mksublist_end:
	ret
mksublist endp

mkwslist proc uses esi
	mov esi,eax
	.if cpanel_findfirst()
	    mov edx,listwsub
	    mov edx,[edx].S_WSUB.ws_flag
	    mov eax,[edx]
	    .if eax & _W_ARCHIVE
		add edx,S_PATH.wp_arch
	    .else
		add edx,S_PATH.wp_path
	    .endif
	    invoke mksublist,esi,edx
	.endif
	ret
mkwslist endp

mkziplst_open proc
	invoke ogetouth,addr $TEMP,M_WRONLY
	mov mklist.mkl_handle,eax
	.if eax
	    inc eax
	    .if eax
		mov eax,1
	    .endif
	.endif
	ret
mkziplst_open endp

mkziplst proc
	sub	eax,eax
	mov	mklsubcnt,eax
	inc	eax
	call	mkwslist
	mov	edx,mklsubcnt
	ret
mkziplst endp

doszip_mklist:
	mov	mklist.mkl_unix,al
	mov	mklist.mkl_mask,dl
	call	mkziplst_open
	test	eax,eax
	mov	eax,ENOENT
	jz	@F
	call	mkziplst
	mov	ecx,mklist.mkl_count
     @@:
	ret

dzmklist proc o_name:dword
	call	doszip_mklist
	test	eax,eax
	jz	dzmklist_count
	mov	eax,errno
	mov	eax,sys_errlist[eax*4]
	invoke  ermsg,o_name,"Error create listfile\n\n%s",eax
	dec	eax
	jmp	dzmklist_end
    dzmklist_count:
	test	ecx,ecx
	jnz	dzmklist_end
	invoke  ermsg,o_name,"Nothing to do.."
	dec	eax
    dzmklist_end:
	test	eax,eax
	ret
dzmklist endp

arj_mklist:	; create list
	mov	al,0	; no unix path
	mov	dl,1	; use mask in directory\*.*
	invoke  dzmklist, "ARJ.DLL: Create list file"
	ret

dll_copy proc	; wsub, fblk, outp, filter
local cmd[256]:byte
local path[WMAXPATH]:byte
	mov	listwsub,eax
	mov	listfblk,edx
	mov	filter,ebx
	mov	esi,eax
	lea	edi,CMD_02
	mov	ebx,ecx
	invoke  strcpy,addr path,ecx
	invoke  strlen,eax
	dec	eax
	add	ebx,eax
	mov	eax,'\'
	cmp	[ebx],al
	jne	@F
	mov	[ebx],ah
      @@:
	call	arj_mklist
	jnz	dll_copy_end
	or	ebx,ebx
	jnz	@F
	lea	edi,CMD_00
      @@:
	invoke  wsclrsel,esi
	invoke  sprintf,addr cmd,edi,[esi].S_WSUB.ws_file,addr path
	invoke  CreateConsole,addr cmd,_P_WAIT
	invoke  remove,addr $TEMP
	xor	eax,eax
    dll_copy_end:
	ret
dll_copy ENDP

;-------------------------------------------------------------------------
; Function 03 - Add
;
; add files to <archive>\ root directory only
;-------------------------------------------------------------------------

dll_add proc ; dest, wsub, fblk, filt
local cmd[256]:byte
local path[WMAXPATH]:byte
	mov	edi,eax
	mov	eax,$FLAG
	and	eax,_DLLF_ADD
	jz	toend
	mov	esi,edx
	mov	listwsub,edx
	mov	listfblk,ecx
	mov	filter,ebx
	mov	ebx,[edi].S_WSUB.ws_arch
	mov	eax,[ebx]
	test	al,al
	jz	@F
	invoke  rsmodal,IDD_addmsg
	jz	fail
      @@:
	call	arj_mklist
	jnz	toend
	invoke  strfcat,addr path,[edi].S_WSUB.ws_path,[edi].S_WSUB.ws_file
	lea	edx,cmd
	invoke  sprintf,edx,addr CMD_03,eax
	invoke  CreateConsole,addr cmd,_P_WAIT
	invoke  remove,addr $TEMP
	xor	eax,eax
  toend:
	ret
   fail:
	mov	eax,ER_USERABORT
	jmp	toend
dll_add endp

;-------------------------------------------------------------------------
; Function 04 - Move
;
; move files to <archive>\ root directory only
;-------------------------------------------------------------------------

dll_move proc ; dest, wsub, fblk, filt
local cmd[256]:byte
local path[WMAXPATH]:byte
	mov	edi,eax
	mov	eax,$FLAG
	and	eax,_DLLF_MOVE
	jz	toend
	mov	esi,edx
	mov	listwsub,edx
	mov	listfblk,ecx
	mov	filter,ebx
	mov	ebx,[edi].S_WSUB.ws_arch
	mov	eax,[ebx]
	test	al,al
	jz	@F
	invoke  rsmodal,IDD_addmsg
	jz	fail
     @@:
	call	arj_mklist
	jnz	toend
	invoke  wsclrsel,edi
	invoke  strfcat,addr path,[edi].S_WSUB.ws_path,[edi].S_WSUB.ws_file
	lea	edx,cmd
	invoke  sprintf,edx,addr CMD_04,eax
	invoke  CreateConsole,addr cmd,_P_WAIT
	invoke  remove,addr $TEMP
	xor	eax,eax
  toend:
	ret
   fail:
	mov	eax,ER_USERABORT
	jmp	toend
dll_move endp

;-------------------------------------------------------------------------
; Function 06 - Delete
;-------------------------------------------------------------------------

dll_delete proc ; wsub, fblk
local cmd[256]:byte
	test	$FLAG,_DLLF_DELETE
	jz	cancel
	mov	listwsub,eax
	mov	listfblk,edx
	mov	esi,eax
	mov	edi,edx
	invoke  rsmodal,IDD_dodelete
	dec	eax
	jnz	cancel
	call	arj_mklist
	jnz	toend
	invoke  wsclrsel,esi	; clear selection set from panel
	invoke  sprintf,addr cmd,addr CMD_06,[esi].S_WSUB.ws_file
	invoke  CreateConsole,addr cmd,_P_WAIT
	invoke  remove,addr $TEMP
 cancel:
	sub	eax,eax
  toend:
	ret
dll_delete endp

;-------------------------------------------------------------------------
; Function 07 - Rename
;-------------------------------------------------------------------------
if 0
dll_rename proc ; wsub, fblk
local cmd[256]:byte
local tmp[WMAXPATH]:byte
	mov	esi,eax
	mov	edi,edx
	call	arj_mklist
	jnz	@F
	invoke  wsclrsel,esi
	add	edi,fb_name
	invoke  strfcat,addr tmp,[esi].ws_arch,edi
	invoke  sprintf,edi,addr CMD_07,[esi].S_WSUB.ws_file,envtemp,eax
	invoke  CreateConsole,edi,_P_WAIT
	xor	eax,eax
      @@:
	ret
dll_rename ENDP

;-------------------------------------------------------------------------
; Function 08 - Edit
;-------------------------------------------------------------------------

dll_edit proc ; wsub, fblk
local tmp[WMAXPATH]:byte
local cmd[WMAXPATH]:byte
	mov	esi,eax
	lea	edi,cmd
	lea	ebx,[edx].S_FBLK.fb_name
	invoke  strfcat,addr tmp,[esi].S_WSUB.ws_arch,ebx
	invoke  sprintf,edi,addr CMD_09,[esi].S_WSUB.ws_file,envtemp,eax
	invoke  CreateConsole,edi,_P_WAIT
	invoke  strfcat,edi,envtemp,ebx
	invoke  filexist,edi
	dec	eax
	jnz	@F
	invoke  dzedit,edi,0
	test	edx,edx
	jz	@F
	invoke  sprintf,edi,addr CMD_08,[esi].S_WSUB.ws_file,envtemp,addr tmp
	invoke  CreateConsole,edi,_P_NOWAIT
     @@:
	invoke  remove,addr tmp
	ret
dll_edit ENDP
endif

;-------------------------------------------------------------------------
; Function 10 - View
;-------------------------------------------------------------------------

inv2 typedef proto stdcall :dword,:dword

dll_view proc	; wsub, fblk
local fbname[WMAXPATH]:byte
local cmd[WMAXPATH]:byte
	mov	esi,eax
	lea	edi,cmd
	mov	ebx,edx
	add	ebx,S_FBLK.fb_name
	invoke  strfcat,addr fbname,[esi].S_WSUB.ws_arch,ebx
	invoke  sprintf,edi,addr CMD_09,[esi].S_WSUB.ws_file,envtemp,eax
	invoke  CreateConsole,edi,_P_WAIT
	invoke  strfcat,edi,envtemp,ebx
	invoke  filexist,edi
	dec	eax
	jnz	@F
	mov	eax,dz_tview
	invoke  inv2 ptr eax,edi,0
	invoke  remove,edi
	mov	edi,_diskflag
	mov	byte ptr [edi],0
     @@:
	ret
dll_view endp

;-------------------------------------------------------------------------
; Function 11 - Test
;-------------------------------------------------------------------------

dll_test proc	; fblk, sign
	and edx,0000FFFFh
	cmp edx,ARJHEADERID
	je found
	lea edx,[eax].S_FBLK.fb_name
	.if strext(edx)
	    mov edx,eax
	    .if !stricmp(eax,".arj")
		jmp found
	    .endif
	.endif
	sub eax,eax
  toend:
	ret
   found:
	mov eax,1
	jmp toend
dll_test endp

;-------------------------------------------------------------------------
; Function 14 - Exit
;-------------------------------------------------------------------------

dll_exit:
	invoke remove,addr $LIST
	sub eax,eax
	ret

;-------------------------------------------------------------------------
; Function 15 - about
;-------------------------------------------------------------------------

dll_about:
	invoke rsmodal,addr IDDABOUT
	ret

;-------------------------------------------------------------------------
; Functions not implemented
;-------------------------------------------------------------------------

;dll_move:	; dest, wsub, fblk
dll_mkdir:	; wsub, directory
dll_rename:	; wsub, fblk, copy
dll_edit:	; wsub, fblk
dll_attrib:	; wsub, fblk
dll_enter:	; wsub, fblk
	invoke notsup
dll_link:
	sub eax,eax
	ret

.data

proc_label label dword
	dd dll_version
	dd dll_init
	dd dll_read
	dd dll_copy
	dd dll_add
	dd dll_move
	dd dll_mkdir
	dd dll_delete
	dd dll_rename
	dd dll_edit
	dd dll_view
	dd dll_attrib
	dd dll_enter
	dd dll_test
	dd dll_exit
	dd dll_link
	dd dll_about

.code

dll_call proc pascal export uses esi edi ebx a0, a1, a2, a3, a4
	mov	eax,a0
	cmp	eax,_DLL_ABOUT
	ja	error
	mov	esi,proc_label[eax*4]
	mov	eax,a1
	mov	edx,a2
	mov	ecx,a3
	mov	ebx,a4
	call	esi
  toend:
	ret
  error:
	sub	eax,eax
	jmp	toend
dll_call endp

	end
