; DZBMP.ASM--
; Copyright (c) 2013 Hjort Nidudsson
;
; Change history:
; 2013-11-04 - created
;

include io.inc
include dll.inc
include ini.inc
include conio.inc
include string.inc
include dzdata.inc
include version.inc

include keyb.inc
include iost.inc
include alloc.inc
include errno.inc

DLLPROC		equ dzbmp
POPUPKEY	equ SHIFT_CTRLLEFT or SHIFT_LEFT

.data

M1		macro v,n
		exitm<0F0h or ((n and 0FF00h) shr 8),n and 00FFh,v>
		endm

IDDABOUT	label word
		dw 2000,005Ch
		db 1,0,15,7,45,12,  0,0,0,'O',4,10,8,1
		db M1(50h,45),M1(29h,45*9+4),M1(80h,3),8Dh,M1(80h,4),M1(25h,45*2+35)
		db M1(" About",20)
		db M1(" DZBMP Version 1.04",70)
		db M1(" A screen Capture utility for Doszip",27)
		db M1(' ',10),M1('',35)
		db M1(" Capture: Ctrl-Left + Shift-Left",55)
%		db M1(" Build:   &@Date &@Time, DZ ",14),VERSSTR
		db M1(" License: GNU General Public License",10)
		db M1(" OK   ",57),'',M1(' ',37),M1('',8),M1(' ',35)

.code

;-------------------------------------------------------------------------
; Function 1 - init
;-------------------------------------------------------------------------

dll_init:
	jmp	dll_install

include ..\idle.asm

;-------------------------------------------------------------------------
; DZBMP
;-------------------------------------------------------------------------

.data

rect		S_RECT <?>

S_RGB		STRUC
rgb_R		db ?
rgb_G		db ?
rgb_B		db ?
rgb_Q		db ?
S_RGB		ENDS

S_BMP		STRUC
bmp_type	dw ?
bmp_filesize	dd ?
bmp_res1	dd ?
bmp_offset_bit  dd ?
bmp_res2	dd ?
bmp_width	dd ?
bmp_height	dd ?
bmp_planes	dw ?
bmp_bitcount	dw ?
bmp_compression dd ?
bmp_sizeimage	dd ?
bmp_xpelsperm	dd ?
bmp_ypelsperm	dd ?
bmp_colorused	dd ?
bmp_climportant dd ?
bmp_palett	db 64 dup(?)
S_BMP		ENDS

Bitmap  label	byte
	db	'BM'
bfz	dd	1F400h + SIZE S_BMP	; file size
	dd	0			;
	dd	SIZE S_BMP		; offset bit
	dd	40			;
bcol	dd	80*8
brow	dd	25*16
	dw	1		; planes
	dw	4		; bit count
	dd	0		; compression
bmz	dd	1F400h		; size image
	dd	2835		; x pels per meter
	dd	2835		; y pels per meter
	dd	16		; color used
	dd	0		; color important
	db	  0,  0,  0,0	; Black
	db	128,  0,  0,0	; Blue
	db	  0,128,  0,0	; Green
	db	128,128,  0,0	;
	db	  0,  0,128,0	; Red
	db	255,255,255,0	; - Title
	db	  0,128,128,0	;
	db	192,192,192,0	; Gray
	db	128,128,128,0	; Dark Gray
	db	255,  0,  0,0	; Blue
	db	  0,255,  0,0	; Green
	db	255,255,  0,0	;
	db	  0,  0,255,0	; Red
	db	255,  0,255,0	; Pink
	db	  0,255,255,0	; Yellow
	db	255,255,255,0	; White

bmpfile db "default.bmp",0
	db 256 dup(?)
screen  dd ?

font8x16 label byte
incbin  <font816.bin>

.code

read_screen:
	mov	eax,_scrcol
	mov	ah,byte ptr _scrrow
	inc	ah
	shl	eax,16
	mov	rect,eax
	mov	eax,_scrrow
	inc	eax
	mul	_scrcol
	shl	eax,1
	invoke  malloc,eax
	jz	@F
	mov	screen,eax
	invoke  rcread,rect,eax
	mov	eax,1
     @@:
	ret

font_putc:
	push	esi	; AX = Screen word
	push	edi	; SI = Font line [15..0]
	push	ecx
	movzx	ebx,al  ; mask = *(font + (AL * 16) + SI);
	shl	ebx,4
	movzx	esi,font8x16[ebx+esi]
	mov	edi,4	; output 4 byte
	movzx	eax,ah
    fontputc_00:
	mov	ecx,eax
	test	esi,128
	jnz	fontputc_01
	shr	cl,4
	jmp	fontputc_02
    fontputc_01:
	and	cl,15
    fontputc_02:
	shl	ecx,4
	shl	esi,1
	push	eax
	test	esi,128
	jnz	fontputc_03
	shr	al,4
	jmp	fontputc_04
    fontputc_03:
	and	al,15
    fontputc_04:
	or	al,cl
	shl	esi,1
	call	oputc
	pop	eax
	jz	fontputc_05
	dec	edi
	jnz	fontputc_00
	xor	eax,eax
	inc	eax
	jmp	fontputc_06
    fontputc_05:
	xor	eax,eax
    fontputc_06:
	pop	ecx
	pop	edi
	pop	esi
	ret

font_putline:
	push	esi	; AX = line [24..0]
	push	edi
	movzx	ebx,al
	mov	eax,_scrcol
	add	eax,eax
	mul	ebx
	add	eax,screen
	mov	edi,eax
	mov	esi,15
    fontputl_00:
	mov	ecx,_scrcol
	push	edi
    fontputl_01:
	movzx	eax,word ptr [edi]
	add	edi,2
	call	font_putc
	jz	fontputl_05
	dec	ecx
	jnz	fontputl_01
	pop	edi
	dec	esi
	cmp	esi,-1
	jne	fontputl_00
    fontputl_04:
	xor	eax,eax
	pop	edi
	pop	esi
	ret
    fontputl_05:
	pop	edi
	jmp	fontputl_04

cmsavebmp:
	push	ebx
	push	esi
	push	edi
	mov	eax,_scrrow
	inc	eax
	shl	ax,4
	mov	brow,eax
	mov	ebx,eax
	mov	eax,_scrcol
	shl	ax,3
	mov	bcol,eax
	shr	ebx,1
	mul	ebx
	mov	bmz,eax
	add	eax,size S_BMP
	mov	bfz,eax
	invoke  oopen,addr bmpfile,M_WRONLY,10000h
	cmp	eax,1
	jl	cmsavebmp_eropen
	invoke  owritest,addr STDO,addr Bitmap,size S_BMP
	jz	cmsavebmp_erwrite
	mov	esi,_scrrow	; line [24..0]
    cmsavebmp_00:
	mov	eax,esi
	call	font_putline
	dec	esi
	cmp	esi,-1
	jne	cmsavebmp_00
    cmsavebmp_flush:
	invoke  oflush		; flush STDO
	invoke  oclose,addr STDO
    cmsavebmp_end:
	pop	ebx
	pop	edi
	pop	esi
	ret
    cmsavebmp_erwrite:
	invoke  oclose,addr STDO
    cmsavebmp_eropen:
	invoke  eropen,addr bmpfile
	jmp	cmsavebmp_end

dzbmp	proc
	invoke  tgetline,"Save Screen",addr bmpfile,0028h,0104h
	test	eax,eax
	jz	@F
	xor	eax,eax
	cmp	bmpfile,al
	je	@F
	call	read_screen
	test	eax,eax
	jz	@F
	call	cmsavebmp
	invoke  stdmsg,"Screen Saved","Screen saved to:\n%s",addr bmpfile
     @@:
	ret
dzbmp	endp

	end
