; DZCI.ASM--
; Copyright (c) 1997-2014 Hjort Nidudsson
;
; Code Info is a RAM-resident (TSR) utility that accesses
; Code Information (help) using an editor or similar
;
; The program activates by Shift-Left + Shift-Right
;
; Change history:
; 2013-11-23 - made edit dialog movable -- Mouse/Alt-Up...
; 2013-11-20 - fixed bug in CIDelSection
; 2013-11-04 - converted to 32-bit
;

include io.inc
include dir.inc
include iost.inc
include string.inc
include conio.inc
include alloc.inc
include keyb.inc
include errno.inc
include stdlib.inc
include dzdata.inc
include version.inc
include _tinfo.inc
include ini.inc
include dll.inc

DLLPROC		equ CodeInfo
POPUPKEY	equ SHIFT_RIGHT or SHIFT_LEFT

.data

M1		macro v,n
		exitm<0F0h or ((n and 0FF00h) shr 8),n and 00FFh,v>
		endm

IDDABOUT	label word
		dw 2000,005Ch
		db 1,0,15,7,50,12,  0,0,0,'O',4,10,8,1
		db M1(50h,50),M1(29h,50*9+4),M1(80h,3),8Dh,M1(80h,4),M1(25h,50*2+38)
		db M1(" About",22)
		db M1(" CI Version 2.04",78)
		db M1(" A Word Capture utility for the editor",35)
		db M1(' ',13),M1('',37)
		db M1(" Capture: Shift-Left + Shift-Right",63)
%		db M1(" Build:   &@Date &@Time, DZ ",17),VERSSTR
		db M1(" License: GNU General Public License",15)
		db M1(" OK   ",67),'',M1(' ',42),M1('',8),M1(' ',39)

.code

;-------------------------------------------------------------------------
; Function 1 - init
;-------------------------------------------------------------------------

dll_init:
	call dll_install
	invoke memcpy,addr programpath,dz_data,WMAXPATH*3
	invoke strfcat,addr cifile,addr configpath,"dz.ci"
	.if !GetEnvironmentVariable("PATH",addr pathbuf,1024)
	    invoke strcpy,addr pathbuf,addr programpath
	.endif
	.if !GetEnvironmentVariable("TEMP",addr temppath,WMAXPATH)
	    invoke strcpy,addr temppath,addr configpath
	.endif
	mov eax,_DLLF_GLOBAL
	ret

include ..\idle.asm

;-------------------------------------------------------------------------
; DZCI
;-------------------------------------------------------------------------

.data

programpath	db WMAXPATH dup (?)
configpath	db WMAXPATH dup (?)
configfile	db WMAXPATH dup (?)
temppath	db WMAXPATH dup (?)
pathbuf		db 1024 dup (?)
envtemp		dd temppath
envpath		dd pathbuf

public		configpath		; set by dll_init
public		configfile
public		programpath
public		envtemp
public		envpath

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

MAXLABEL	equ 32		; label size in memory
MAXLABELS	equ 8000	; labels in memory
MAXLSTACK	equ 9

S_LABEL		STRUC
section		db MAXLABEL dup(?)
c_decl		db MAXLABEL*3 dup(?)
arg0		db MAXLABEL dup(?)
arg1		db MAXLABEL dup(?)
arg2		db MAXLABEL dup(?)
arg3		db MAXLABEL dup(?)
arg4		db MAXLABEL dup(?)
arg5		db MAXLABEL dup(?)
arg6		db MAXLABEL dup(?)
ret0		db MAXLABEL dup(?)
ret1		db MAXLABEL dup(?)
ret2		db MAXLABEL dup(?)
incfile		db MAXLABEL*2 dup(?)
info		db MAXLABEL*2 dup(?)
ref0		db MAXLABEL dup(?)
ref1		db MAXLABEL dup(?)
ref2		db MAXLABEL dup(?)
ref3		db MAXLABEL dup(?)
ref4		db MAXLABEL dup(?)
ref5		db MAXLABEL dup(?)
ref6		db MAXLABEL dup(?)
ref7		db MAXLABEL dup(?)
ref8		db MAXLABEL dup(?)
ref9		db MAXLABEL dup(?)
srcfile		db MAXLABEL*2 dup(?)
time		db MAXLABEL*2 dup(?)
S_LABEL		ENDS ; 1024

externdef	IDD_CIEdit:dword
externdef	IDD_CIDict:dword
externdef	IDD_CISetup:dword
externdef	IDD_CIHelp:dword

callstack	dd 0

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

MAXENTRIES	equ 25
ID_INCLUDE	equ 12
ID_INFO		equ 13

cisection	S_LABEL <>
cilstack	S_LABEL MAXLSTACK dup(<>)
cilcount	dd 0
cisrcpath	db WMAXPATH dup(0)
ciincpath	db WMAXPATH dup(0)
cifile		db WMAXPATH dup(0)
cifileid	dd 0
cp_CodeInfo	db "CodeInfo",0 ; [CodeInfo] in dz.ini
cilabels	dd 0		; sizeof(S_LABEL) * MAXLABELS
DLG_CIEdit	dd 0
txtval		dd 0
txtvaled	dd 0

GCMD_CI		label dword
GCMD KEY_F2,	event_save
GCMD KEY_F3,	event_view
GCMD KEY_F4,	event_edit
GCMD KEY_F5,	event_dict
GCMD KEY_F8,	event_delete
GCMD KEY_F9,	event_conf
GCMD KEY_CTRLUP,event_CTRLUP
GCMD KEY_CTRLDN,event_CTRLDN
GCMD KEY_ALTX,  event_exit
		dd 0

cp_conf		db ".file",0

CI_LABELS label byte
	db 1		; [section]
	db 0		; 00 c_decl
	db 0,0,0,0,0,0,0; 01 arg0
	db 0,0,0	; 08 ret0
	db 3		; 11 include
	db 2		; 12 info
	db 1,1,1,1,1,1,1; 13 ref0
	db 1,1,1
	db 4		; 23 srcfile
	db 5		; 24 time

;
; .CI Index to offset
;
CI_OFFSETS label dword  ; [section] == offset 0
	dd MAXLABEL*1	; 00 c_decl
	dd MAXLABEL*4	; 01 arg0
	dd MAXLABEL*5
	dd MAXLABEL*6
	dd MAXLABEL*7
	dd MAXLABEL*8
	dd MAXLABEL*9
	dd MAXLABEL*10
	dd MAXLABEL*11  ; 08 ret0
	dd MAXLABEL*12
	dd MAXLABEL*13
	dd MAXLABEL*14  ; 11 include
	dd MAXLABEL*16  ; 12 info
	dd MAXLABEL*18  ; 13 ref0
	dd MAXLABEL*19
	dd MAXLABEL*20
	dd MAXLABEL*21
	dd MAXLABEL*22
	dd MAXLABEL*23
	dd MAXLABEL*24
	dd MAXLABEL*25
	dd MAXLABEL*26
	dd MAXLABEL*27
	dd MAXLABEL*28  ; 23 srcfile
	dd MAXLABEL*30  ; 24 time

.code

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

inv2 typedef proto stdcall :dword, :dword

ciedit proc uses esi edi ebx file
	mov	eax,dz_conio
	mov	esi,[eax].S_CONIO.co_tinfo
	mov	[eax].S_CONIO.co_tinfo,0
	push	file
	call	dz_topen
	test	eax,eax
	jz	@F
	call	dz_tmodal
	call	dz_tclose
	call	CIPutSection
     @@:
	mov	eax,dz_conio
	mov	[eax].S_CONIO.co_tinfo,esi
	ret
ciedit endp

citview proc file
	mov	eax,dz_tview
	invoke  inv2 ptr eax,file,0
	ret
citview endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; Get value of edited text to put '*' (not saved)

gettxtval:
	push	ebx
	lea	edx,cisection
	sub	eax,eax
	mov	ebx,eax
	mov	ecx,sizeof(S_LABEL)
     @@:
	mov	al,[edx]
	inc	edx
	add	ebx,eax
	shl	ebx,1
	adc	ebx,0
	dec	ecx
	jnz	@B
	mov	eax,ebx
	pop	ebx
	ret

puttxtval:
	call	gettxtval
	mov	edx,DLG_CIEdit
	movzx	ecx,[edx].S_DOBJ.dl_rect.rc_x
	add	ecx,1
	movzx	edx,[edx].S_DOBJ.dl_rect.rc_y
	add	edx,2
	cmp	eax,txtval
	mov	eax,' ';0C4h
	je	@F
	mov	eax,'*'
     @@:
	invoke  scputc,ecx,edx,1,eax
	ret

cigetp  proc lp, id
	mov eax,id
	.if eax < MAXENTRIES
	    mov eax,CI_OFFSETS[eax*4]
	    add eax,lp
	.else
	    sub eax,eax
	.endif
	ret
cigetp  endp

CIFindSection proc uses esi edi ebx ecx edx section
	mov edi,cilabels
	mov ebx,cilcount
	invoke strlen,section
	mov edx,eax
	sub eax,eax
	.if edx && ebx
	    .repeat
		.if !stricmp(edi,section)
		    mov eax,edi
		    jmp @F
		.endif
		add edi,SIZE S_LABEL
		dec ebx
	    .until !ebx
	    sub eax,eax
	.endif
     @@:
	ret
CIFindSection endp

CIRead proc uses esi edi ebx
local lbuf[256]:byte
	mov cilcount,0
	invoke memzero,cilabels,sizeof(S_LABEL) * MAXLABELS
	.if ogetl(addr cifile,addr lbuf,256)
	    mov edi,cilabels
	    .while ogets()
		lea esi,lbuf
		mov al,[esi]
		.if al == '['
		    inc cilcount
		    mov eax,cilcount
		    .if eax >= MAXLABELS
			dec cilcount
			.break
		    .endif
		    dec eax
		    shl eax,10
		    mov edi,cilabels
		    add edi,eax
		    mov edx,edi
		    inc esi
		    mov ecx,MAXLABEL
		    .repeat
			lodsb
			.break .if al == ']'
			stosb
			.break .if !al
		    .untilcxz
		    mov edi,edx
		.elseif al >= '0' && al <= '9'
		    mov ax,[esi+1]
		    .if ah == '=' || al == '='
			invoke atol,esi
			.if cigetp(edi,eax)
			    lea edx,[esi+1]
			    .if byte ptr [edx] != '='
				inc edx
			    .endif
			    inc edx
			    invoke strcpy,eax,edx
			.endif
		    .endif
		.endif
	    .endw
	    invoke oclose,addr STDI
	    .if CIFindSection(addr cp_conf)
		mov edx,eax
		invoke strcpy,addr ciincpath,addr [edx].S_LABEL.incfile
		invoke strcpy,addr cisrcpath,addr [edx].S_LABEL.srcfile
	    .endif
	    mov eax,1
	.endif
	ret
CIRead endp

CIWrite proc uses esi edi ebx
local bak[WMAXPATH]:byte
	invoke strcpy,addr bak,addr cifile
	invoke setfext,eax,".bak"
	invoke remove,eax
	invoke rename,addr cifile,addr bak
	.if sdword ptr oopen(addr cifile,M_WRONLY,10000h) > 1
	    mov edi,cilabels
	    mov ebx,cilcount
	    .while ebx
		.if byte ptr [edi]
		    invoke oprintf,"[%s]\n",edi
		    sub esi,esi
		    .while cigetp(edi,esi)
			.if byte ptr [eax]
			    invoke oprintf,"%d=%s\n",esi,eax
			.endif
			inc esi
		    .endw
		.endif
		add edi,SIZE S_LABEL
		dec ebx
	    .endw
	    invoke oflush
	    invoke oclose,addr STDO
	    mov eax,1
	.endif
	ret
CIWrite endp

CIClearSection proc uses esi edi
	mov   eax,DLG_CIEdit
	movzx esi,[eax].S_DOBJ.dl_rect.rc_x
	add   esi,35
	movzx edx,[eax].S_DOBJ.dl_rect.rc_y
	add   edx,6
	mov   ecx,11
	mov   edi,31
	push  edx
	.repeat
	    invoke scputc,esi,edx,edi,' '
	    inc edx
	.untilcxz
	pop edx
	mov eax,esi
	ret
CIClearSection endp

CIPutSection proc uses esi edi ebx
	invoke CIClearSection
	mov esi,eax
	lea edi,cisection.ref0
	mov ecx,7
	.repeat
	    .if CIFindSection(edi)
		add eax,S_LABEL.info
		invoke scputs,esi,edx,0,31,eax
	    .endif
	    inc edx
	    add edi,MAXLABEL
	.untilcxz
	inc edx
	mov ecx,3
	.repeat
	    .if CIFindSection(edi)
		lea eax,[eax].S_LABEL.info
		invoke scputs,esi,edx,0,31,eax
	    .endif
	    inc edx
	    add edi,MAXLABEL
	.untilcxz
	add edx,2
	sub esi,33
	invoke scputc,esi,edx,40,' '
	invoke strfn,addr cifile
	invoke scputs,esi,edx,0,40,eax
	invoke dlinit,DLG_CIEdit
	ret
CIPutSection endp

CINextFile proc uses esi edi ebx
	mov ebx,cifileid
	inc ebx
	.if !inientryid(addr cp_CodeInfo,ebx)
	    sub ebx,ebx
	    invoke inientryid,addr cp_CodeInfo,ebx
	.endif
	.if eax
	    mov edi,eax
	    call CIWrite
	    mov dx,[edi]
	    .if dl == '\' || dl == '/' || dh == ':'
		invoke strcpy,addr cifile,edi
	    .else
		invoke strfcat,addr cifile,addr configpath,edi
	    .endif
	    mov cifileid,ebx
	    call CIRead
	    call CIPutSection
	    mov eax,DLG_CIEdit
	    mov [eax].S_DOBJ.dl_index,0
	    mov eax,1
	.endif
	ret
CINextFile endp

CIReadSection proc uses esi ebx section
local tmp[MAXLABEL]:byte
	lea ebx,cisection
	.if strcmp(ebx,section)
	    lea eax,cilstack
	    invoke memmove,eax,ebx,sizeof(S_LABEL) * MAXLSTACK
	.endif
	invoke strncpy,addr tmp,section,MAXLABEL
	invoke memzero,ebx,sizeof(S_LABEL)
	invoke strcpy,ebx,addr tmp
	.if CIFindSection(eax)
	    invoke memcpy,ebx,eax,sizeof(S_LABEL)
	.endif
	call gettxtval
	mov  txtval,eax
	call CIPutSection
	ret
CIReadSection endp

CISaveSection proc section
	.if CIFindSection(section)
	    invoke memcpy,eax,addr cisection,sizeof(S_LABEL)
	.else
	    mov eax,cilcount
	    .if eax < MAXLABELS
		shl eax,10
		add eax,cilabels
		inc cilcount
		invoke memcpy,eax,addr cisection,sizeof(S_LABEL)
	    .else
		sub eax,eax
	    .endif
	.endif
	mov txtval,eax
	.if eax
	    call gettxtval
	    mov txtval,eax
	.endif
	ret
CISaveSection endp

CIDelSection proc uses esi edi
	.if CIFindSection(addr cisection)
	    mov edi,eax
	    mov esi,eax
	    add esi,sizeof(S_LABEL)
	    dec cilcount
	    mov eax,cilcount
	    shl eax,10
	    add eax,cilabels
	    mov ecx,eax
	    sub ecx,esi
	    js  @F
	    shr ecx,2
	    rep movsd
	    sub eax,sizeof(S_LABEL)
	 @@:
	    mov edi,eax
	    sub eax,eax
	    mov ecx,sizeof(S_LABEL) / 4
	    rep stosd
	    mov txtval,eax
	.endif
	invoke memzero,addr cisection,sizeof(S_LABEL)
	ret
CIDelSection endp

CIViewSrc proc
local path[WMAXPATH]:byte
	.if cisection.srcfile
	    invoke strfcat,addr path,addr cisrcpath,addr cisection.srcfile
	    invoke citview,eax
	.endif
	mov eax,_C_NORMAL
	ret
CIViewSrc endp

CIViewInc proc
local path[WMAXPATH]:byte
	.if cisection.incfile
	    invoke strfcat,addr path,addr ciincpath,addr cisection.incfile
	    invoke citview,eax
	.endif
	mov eax,_C_NORMAL
	ret
CIViewInc endp

CIEditSrc proc
local path[WMAXPATH]:byte
	.if cisection.srcfile
	    invoke strfcat,addr path,addr cisrcpath,addr cisection.srcfile
	    invoke ciedit,eax
	.endif
	mov eax,_C_NORMAL
	ret
CIEditSrc endp

CIEditInc proc
local path[WMAXPATH]:byte
	.if cisection.incfile
	    invoke strfcat,addr path,addr ciincpath,addr cisection.incfile
	    invoke ciedit,eax
	.endif
	mov eax,_C_NORMAL
	ret
CIEditInc endp

CIMoveUp proc
local ll:S_LABEL
	lea	edx,cisection
	invoke  memcpy,addr ll,edx,sizeof(S_LABEL)
	invoke  memcpy,edx,addr cilstack,sizeof(S_LABEL) * MAXLSTACK
	invoke  memcpy,addr [edx + sizeof(S_LABEL) * MAXLSTACK],addr ll,sizeof(S_LABEL)
	ret
CIMoveUp endp

CIMoveDn proc
local ll:S_LABEL
	lea	edx,cisection
	invoke  memcpy,addr ll,addr [edx + sizeof(S_LABEL) * MAXLSTACK],sizeof(S_LABEL)
	invoke  memmove,addr cilstack,edx,sizeof(S_LABEL) * MAXLSTACK
	invoke  memcpy,edx,addr ll,sizeof(S_LABEL)
	ret
CIMoveDn endp

editevent proc uses esi edi
local ti:S_TINFO
local cursor:S_CURSOR
local rc:S_RECT
	invoke  cursorget,addr cursor
	invoke  memzero,addr ti,SIZE S_TINFO
	mov	edi,tinfo
	lea	eax,ti
	mov	tinfo,eax
	mov	edx,DLG_CIEdit
	movzx	eax,[edx].S_DOBJ.dl_index
	shl	eax,4
	add	eax,[edx].S_DOBJ.dl_object
	mov	edx,[edx].S_DOBJ.dl_rect
	mov	esi,eax
	mov	eax,[esi].S_TOBJ.to_rect
	add	ax,dx
	mov	rc,eax
	mov	eax,[esi].S_TOBJ.to_data
	mov	ti.ti_bp,eax
	movzx	eax,[esi].S_TOBJ.to_count
	shl	eax,4
	mov	ti.ti_bcol,eax
	inc	ti.ti_brow
	movzx	eax,rc.S_RECT.rc_x
	mov	ti.ti_xpos,eax
	mov	al,rc.S_RECT.rc_y
	mov	ti.ti_ypos,eax
	mov	al,rc.S_RECT.rc_col
	mov	ti.ti_cols,eax
	mov	al,rc.S_RECT.rc_row
	mov	ti.ti_rows,eax
	mov	eax,_T_OVERWRITE or _T_DLEDIT ; _T_USECONTROL
	mov	ti.ti_flag,eax
	mov	ti.ti_clat,07FAh
	invoke  tisetcursor
	test	[esi].S_TOBJ.to_flag,_O_DTEXT
	jz	@F
	invoke  titoend
	mov	eax,ti.ti_xoff
	add	eax,ti.ti_boff
	mov	ti.ti_cleo,eax
     @@:
	invoke  timodal
	push	eax
	mov	ti.ti_clat,0720h
	invoke  tiputs
	invoke  cursorset,addr cursor
	pop	eax
	mov	tinfo,edi
	ret
editevent endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

event_help:
	invoke  rsmodal,IDD_CIHelp
	jmp	event_normal
event_CTRLUP:
	call	CIMoveUp
	jmp	event_normalput
event_CTRLDN:
	call	CIMoveDn
	jmp	event_normalput
event_view:
	mov	eax,DLG_CIEdit
	cmp	[eax].S_DOBJ.dl_index,ID_INCLUDE
	je	CIViewInc
	cmp	cisection.srcfile,0
	je	CIViewInc
	jmp	CIViewSrc
event_edit:
	mov	eax,DLG_CIEdit
	cmp	[eax].S_DOBJ.dl_index,ID_INCLUDE
	je	CIEditInc
	jmp	CIEditSrc
event_save:
	invoke  CISaveSection,addr cisection
	call	puttxtval
	jmp	event_normal
event_dict:
	call	CIDict
	jmp	event_normalput
	ret
event_conf:
	push esi
	push edi
	.if rsopen(IDD_CISetup)
	    mov edi,eax
	    .if CIFindSection(addr cp_conf)
		mov esi,eax
		invoke strcpy,[edi].S_TOBJ.to_data[16],addr [esi].S_LABEL.srcfile
		invoke strcpy,[edi].S_TOBJ.to_data[32],addr [esi].S_LABEL.incfile
		invoke dlinit,edi
		.if dlevent(edi)
		    invoke strcpy,addr [esi].S_LABEL.srcfile,[edi].S_TOBJ.to_data[16]
		    invoke strcpy,addr [esi].S_LABEL.incfile,[edi].S_TOBJ.to_data[32]
		    invoke strcpy,addr cisrcpath,[edi].S_TOBJ.to_data[16]
		    invoke strcpy,addr ciincpath,[edi].S_TOBJ.to_data[32]
		.endif
	    .endif
	    invoke dlclose,edi
	.endif
	pop edi
	pop esi
	jmp event_normal
event_exit:
	mov	eax,_C_ESCAPE
	ret
event_delete:
	call	CIDelSection
event_normalput:
	call	CIPutSection
	call	puttxtval
event_normal:
	mov	eax,_C_NORMAL
	ret
event_tedit proc uses esi edi
	invoke editevent
	mov esi,eax
	.if eax == KEY_ENTER
	    mov eax,DLG_CIEdit
	    movzx eax,[eax].S_DOBJ.dl_index
	    mov ecx,eax
	    mov al,CI_LABELS[eax]
	    .if al == 1
		lea eax,cisection
		.if ecx
		    dec ecx
		    invoke cigetp,eax,ecx
		.endif
		.if eax && byte ptr [eax]
		    invoke CIReadSection,eax
		.endif
	    .elseif al == 3
		invoke CIViewInc
	    .elseif al == 4
		invoke CIViewSrc
	    .endif
	    sub esi,esi
	.elseif eax == KEY_TAB
	    call CINextFile
	    sub esi,esi
	.endif
	call gettxtval
	.if  txtvaled != eax
	     mov txtvaled,eax
	     call CIPutSection
	.endif
	call puttxtval
	mov eax,esi
	ret
event_tedit endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

.data

MAXLINES	equ 12  ; visible lines on screen

d_index		dd ?	; index in buffer
d_section	db MAXLABEL dup(0)
dictdlg		dd ?
dictdlgx	dd ?
dictdlgy	dd ?
dictdlgc	dd ?

; this may be a bit "code-page" spesific..

sort_convertable label byte
	db	'','A'
	db	'','O'
	db	'','A'
	db	'','A'
	db	'','T'
	db	'','a'
	db	'','o'
	db	'','a'
	db	'','a'
	db	'','t'
	db	'','d'
	db	'','o'
	db	'','i'
	db	'','I'
	db	'','e'
	db	'','o'
	db	'','u'
	db	'','y'

sort_tablesize = (($ - offset sort_convertable) / 2)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

.code

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

dictput proc uses esi edi ebx
	mov	ebx,dictdlgx
	mov	edx,dictdlgy
	mov	edi,dictdlgc
	sub	edi,4
	mov	eax,dictdlg
	movzx	ecx,[eax].S_DOBJ.dl_rect.rc_row
	sub	ecx,3
	invoke  scputc,ebx,edx,edi,' '
	invoke  scputc,ebx,edx,32,0FAh
	inc	edx
	.repeat
	    invoke scputc,ebx,edx,edi,' '
	    inc edx
	.untilcxz
	mov	edx,dictdlgy
	invoke  scputs,ebx,edx,0,31,addr d_section
	mov	esi,d_index
	mov	edi,cilcount
	test	edi,edi
	jz	toend
	sub	edi,esi
	cmp	edi,MAXLINES
	jb	@F
	mov	edi,MAXLINES
     @@:
	add	edx,2
	shl	esi,10
	add	esi,cilabels
	lea	ecx,[ebx+30]
     @@:
	invoke  scputs,ebx,edx,0,28,esi
	invoke  scputs,ecx,edx,0,35,addr [esi].S_LABEL.info
	inc	edx
	add	esi,sizeof(S_LABEL)
	dec	edi
	jnz	@B
	add	ebx,45
	mov	edx,dictdlgy
	invoke  scputf,ebx,edx,0,5,"%d",d_index
	add	ebx,8
	invoke  scputf,ebx,edx,0,5,"%d",cilcount
	add	ebx,8
	invoke  scputf,ebx,edx,0,5,"%d",MAXLABELS
  toend:
	ret
dictput endp

sortconvch proc
	push	ebx
	push	ecx
	mov	ebx,offset sort_convertable
	mov	ecx,sort_tablesize
    sortconvch_find:
	cmp	al,[ebx]
	je	sortconvch_found
	add	ebx,2
	dec	ecx
	jnz	sortconvch_find
    sortconvch_end:
	pop	ecx
	pop	ebx
	ret
    sortconvch_found:
	inc	ebx
	mov	al,[ebx]
	jmp	sortconvch_end
sortconvch endp

compare proc uses esi edi ebx edx ecx
	mov	eax,cilabels
	shl	edi,10
	add	edi,eax
	mov	edx,edi
	shl	esi,10
	add	esi,eax
	mov	ebx,esi
	sub	eax,eax
	mov	al,[edi]
	call	sortconvch
	jz	compare_si
	mov	ah,al
	inc	edi
    compare_si:
	mov	al,[esi]
	call	sortconvch
	jz	compare_start
	inc	esi
	or	ah,ah
	jnz	compare_ahal
	mov	ah,[edi]
	inc	edi
	jmp	compare_ahal
    compare_start:
	or	ah,ah
	jnz	compare_skipdi
    compare_continue:
	or	al,al
	jz	compare_endcmp
	mov	al,[edi]
	call	sortconvch
	mov	ah,al
	inc	edi
    compare_skipdi:
	mov	al,[esi]
	call	sortconvch
	inc	esi
    compare_ahal:
	cmp	ah,al
	je	compare_continue
	sub	al,'A'
	cmp	al,'Z' - 'A' + 1
	sbb	cl,cl
	and	cl,'a' - 'A'
	add	al,cl
	add	al,'A'
	xchg	ah,al
	sub	al,'A'
	cmp	al,'Z' - 'A' + 1
	sbb	cl,cl
	and	cl,'a' - 'A'
	add	al,cl
	add	al,'A'
	cmp	al,ah
	je	compare_continue
	sbb	al,al
	sbb	al,-1
    compare_endcmp:
	cmp	al,0
	jle	compare_end
	invoke  memxchg,edx,ebx,sizeof(S_LABEL)
    compare_end:
	ret
compare endp

dictsort proc uses esi edi ebx
	mov	edx,cilcount
    dictsort_loopg:
	shr	edx,1
	jz	dictsort_end
	mov	ebx,edx
    dictsort_loopc:
	cmp	ebx,cilcount
	jae	dictsort_loopg
	mov	ecx,ebx
	sub	ecx,edx
    dictsort_loopn:
	cmp	ecx,0
	jl	dictsort_endn
	mov	edi,ecx
	mov	esi,ecx
	add	esi,edx
	call	compare
	jle	dictsort_endn
	sub	ecx,edx
	jmp	dictsort_loopn
    dictsort_endn:
	inc	ebx
	jmp	dictsort_loopc
    dictsort_end:
	ret
dictsort endp

dictfind proc uses esi edi ebx eax
	mov	eax,edi
	sub	eax,dictdlgx
	mov	ecx,eax
	mov	esi,d_index
	mov	edi,cilcount
	test	edx,edx			; if (DX == 0) search from start
	jnz	dictfind_loop		; (case BKSP)
	xor	esi,esi
	inc	ch
    dictfind_loop:
	cmp	esi,edi			; search from current to end
	jnb	dictfind_start
	mov	ebx,esi
	shl	ebx,10
	add	ebx,cilabels
	push	edi
	mov	edi,offset d_section
	mov	dl,cl
    dictfind_cmp:
	mov	al,[ebx]
	call	sortconvch
	mov	ah,al
	mov	al,[edi]
	call	sortconvch
	inc	edi
	inc	ebx
	or	ax,2020h
	cmp	al,ah
	jne	dictfind_next
	dec	dl
	jnz	dictfind_cmp
	pop	edi
    dictfind_match:
	mov	d_index,esi
	mov	eax,1
	jmp	dictfind_end
    dictfind_next:
	pop	edi
	inc	esi
	jmp	dictfind_loop
    dictfind_start:
	xor	eax,eax
	mov	esi,eax
	test	ch,ch
	jnz	dictfind_end
	inc	ch
	mov	edi,d_index
	cmp	esi,edi
	jb	dictfind_loop
    dictfind_end:
	test	eax,eax
	ret
dictfind endp

dictinitdlg proc
	invoke  rsopen,IDD_CIDict
	jz	@F
	mov	dictdlg,eax
	movzx	edx,[eax].S_DOBJ.dl_rect.rc_x
	add	edx,2
	mov	dictdlgx,edx
	movzx	edx,[eax].S_DOBJ.dl_rect.rc_col
	mov	dictdlgc,edx
	movzx	edx,[eax].S_DOBJ.dl_rect.rc_y
	inc	edx
	mov	dictdlgy,edx
	invoke  dlshow,eax
	inc	eax
     @@:
	ret
dictinitdlg endp

dictopen proc
	mov	d_index,0
	call	dictsort
	sub	edx,edx
	call	dictfind
	call	dictput
	ret
dictopen endp

.data

cidict_keys label dword
	dd 0,		cidict_loop
	dd KEY_ESC,	cidict_toend
	dd KEY_ENTER,	cidict_enter
	dd KEY_KPENTER, cidict_enter
	dd KEY_BKSP,	cidict_bksp
	dd KEY_UP,	cidict_up
	dd KEY_DOWN,	cidict_down
	dd KEY_F5,	cidict_toend
	dd KEY_PGUP,	cidict_PGUP
	dd KEY_PGDN,	cidict_PGDN
cidict_count = ($ - cidict_keys) / 8

.code

cidict_loop:
	invoke  gotoxy,edi,dictdlgy
	call	tgetevent		; get key
	mov	ecx,cidict_count	; test key
	xor	ebx,ebx
cidict_next:
	cmp	eax,cidict_keys[ebx]
	je	cidict_found
	add	ebx,8
	dec	ecx
	jnz	cidict_next
	jmp	cidict_find	; add char to search string
cidict_found:
	jmp	cidict_keys[ebx+4]
cidict_toend:
	invoke  dlclose,dictdlg
cidict_pop:
	ret
cidict_enter:
	mov	eax,d_index
	shl	eax,10
	add	eax,cilabels
	invoke  memcpy,addr cisection,eax,sizeof(S_LABEL)
	jmp	cidict_toend
cidict_bksp:			; delete char and search from start
	mov	eax,edi
	sub	eax,dictdlgx
	jz	cidict_bksp_null
	dec	edi
	xor	edx,edx
	call	dictfind
	jz	cidict_bksp
	mov	ah,0
	mov	ebx,offset d_section
	dec	eax
	add	ebx,eax
	mov	[ebx],ah
	call	dictput
	jmp	cidict_loop
cidict_bksp_null:
	mov	d_section,0
	mov	edi,dictdlgx
cidict_HOME:
	xor	eax,eax
	mov	d_index,eax
	call	dictput
	jmp	cidict_loop
cidict_find:
	test	al,al
	jz	cidict_loop
	mov	edx,eax
	mov	eax,edi
	sub	eax,dictdlgx
	cmp	eax,MAXLABEL
	jge	cidict_loop
	mov	ebx,eax
	mov	al,dl
	mov	ah,0
	mov	word ptr d_section[ebx],ax
	mov	edx,1
	push	ebx
	push	edi
	inc	edi
	call	dictfind
	pop	edi
	pop	ebx
	jz	cidict_notfound
	inc	edi
   cidict_update:
	call	dictput
	jmp	cidict_loop
   cidict_notfound:
	xor	eax,eax
	mov	d_section[ebx],al
	jmp	cidict_loop
cidict_up:
	mov	eax,d_index
	or	eax,eax
	jz	cidict_loop
	dec	eax
	mov	d_index,eax
	jmp	cidict_update
cidict_down:
	mov	eax,cilcount
	dec	eax
	cmp	d_index,eax
	jae	cidict_loop
	inc	d_index
	jmp	cidict_update
cidict_PGUP:
	mov	eax,d_index
	cmp	eax,MAXLINES
	jb	cidict_HOME
	sub	eax,MAXLINES
	mov	d_index,eax
	jmp	cidict_update
cidict_PGDN:
	mov	edx,cilcount
	dec	edx
	mov	eax,d_index
	cmp	edx,eax
	je	cidict_loop
	add	eax,MAXLINES
	cmp	eax,edx
	ja	cidict_END
	mov	d_index,eax
	jmp	cidict_update
cidict_END:
	mov	d_index,edx
	jmp	cidict_update

CIDict  proc uses esi edi ebx
local	cursor:S_CURSOR
	invoke  cursorget,addr cursor
	call	cursoron
	call	dictinitdlg
	jz	@F
	invoke  strcpy,addr d_section,addr cisection
	mov	edi,dictdlgx
	invoke  strlen,eax
	add	edi,eax
	call	dictopen
	jz	quit
	call	cidict_loop
	invoke  cursorset,addr cursor
     @@:
	ret
   quit:
	invoke  dlclose,dictdlg
	jmp	@B
CIDict  endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

CodeInfo proc uses esi edi ebx
local scword[128]:byte
local ascii:byte
	mov al,tclrascii
	mov ascii,al
	.if !callstack
	    .if GlobalAlloc(GMEM_FIXED,sizeof(S_LABEL) * MAXLABELS)
		mov cilabels,eax
	    .else
		jmp toend
	    .endif
	.endif
	inc callstack
	lea ebx,cisection
	.if scgetword(addr scword)
	    .if callstack == 1
		invoke CIRead
	    .endif
	    .if rsopen(IDD_CIEdit)
		push DLG_CIEdit
		push thelp
		mov tclrascii,' '
		mov DLG_CIEdit,eax
		mov edx,[eax].S_DOBJ.dl_object
		mov thelp,event_help
		mov [edx].S_TOBJ.to_data,ebx
		mov [edx].S_TOBJ.to_proc,event_tedit
		sub ecx,ecx
		.repeat
		    add edx,sizeof(S_TOBJ)
		    invoke cigetp,ebx,ecx
		    mov [edx].S_TOBJ.to_data,eax
		    mov [edx].S_TOBJ.to_proc,event_tedit
		    inc ecx
		.until ecx == MAXENTRIES-1
		mov [edx+16].S_TOBJ.to_data,offset GCMD_CI
		invoke dlshow,DLG_CIEdit
		invoke CIReadSection,addr scword
		invoke rsevent,IDD_CIEdit,DLG_CIEdit
		invoke dlclose,DLG_CIEdit
		mov al,ascii
		mov tclrascii,al
		pop eax
		mov thelp,eax
		pop eax
		mov DLG_CIEdit,eax
		mov txtvaled,0
	    .endif
	    .if callstack == 1
		invoke CIWrite
	    .endif
	.endif
	dec callstack
	.if ZERO?
	    invoke GlobalFree,cilabels
	.endif
  toend:
	sub eax,eax
	ret
CodeInfo endp

	end
