include libc.inc
ifdef __CLIP__
include clip.inc
include keyb.inc
include string.inc
include iost.inc
include mouse.inc
include conio.inc
include tinfo.inc
include alloc.inc

;public clipbsize
;public clipboard

tigetline	proto
tiremline	proto
tidelete	proto
tiseto		proto
ticontinue	proto
tiflushl	proto
tiputc		proto
tievent		proto

.data
winoldap  dw ?
clipbsize dw ?
clipboard dd ?

.code

OpenClipboard proc private
	sub ax,ax
	.if winoldap != ax
	    mov ax,1701h	; OPEN CLIPBOARD
	    int 2Fh		; nonzero success, else already open
	    inc ax
	.endif
	ret
OpenClipboard endp

CloseClipboard proc private
	push	dx
	push	ax
	mov	ax,1708h	; INT 2F - MS Windows - CloseClipboard
	int	2Fh
	pop	ax
	pop	dx
	ret
CloseClipboard endp

ClearClipboard proc private
	invoke  free,clipboard
	sub	ax,ax
	mov	clipbsize,ax
	mov	dx,ax
	stom	clipboard
	ret
ClearClipboard endp

ClipboardFree proc _CType public
	invoke  ClearClipboard
	ret
ClipboardFree endp

ClipboardCopy proc _CType public uses si di bx string:dword, len:size_t
	mov di,len
	call ClearClipboard
	.if console & CON_CLIPB
	    call OpenClipboard
	    .if !ZERO?
		mov ax,1702h	; EMPTY CLIPBOARD
		int 2Fh		; AX nonzero clipboard has been emptied
		mov dx,1	; set type to text
		mov cx,di	; SI:CX = size of data
		xor si,si	; HSIZE = 0
		les bx,string	; ES:BX = data
		mov ax,1703h	; SET CLIPBOARD DATA
		int 2Fh
		call CloseClipboard
		test ax,ax	; nonzero data copied into the Clipboard
		mov  ax,di
		jnz  @F
	    .endif
	    mov ax,di
	    inc ax
	    .if malloc(ax)
		stom clipboard
		mov clipbsize,di
		mov es,dx
		mov bx,ax
		add bx,di
		mov byte ptr es:[bx],0
		invoke memcpy,dx::ax,string,di
		mov ax,di
	    .endif
	.endif
      @@:
	ret
ClipboardCopy endp

ClipboardPaste proc _CType private uses bx
	.if (console & CON_CLIPB)
	    mov ax,1701h	; OPEN CLIPBOARD
	    int 2Fh		; nonzero success, else already open
	    mov ax,1704h	; GET CLIPBOARD DATA SIZE
	    mov dx,1		; DX = clipboard format supported
	    int 2Fh		; DX:AX = size of data in bytes
	    .if dx
		sub ax,ax	; to big..
	    .endif
	    call CloseClipboard
	    .if !ax || ax >= MAXCLIPSIZE
		sub ax,ax
		.if clipbsize != ax
		    lodm clipboard
		.endif
	    .else
		push ax
		push ax
		call ClearClipboard
		call malloc
		pop cx
		.if ax
		    mov clipbsize,cx
		    stom clipboard
		    invoke memzero,dx::ax,cx
		    mov ax,1701h
		    int 2Fh
		    mov dx,1
		    les bx,clipboard
		    mov ax,1705h
		    int 2Fh
		    call CloseClipboard
		    lodm clipboard
		.endif
	    .endif
	.else
	    .if clipbsize
		lodm clipboard
	    .else
		sub ax,ax
		cwd
	    .endif
	.endif
	test ax,ax
	ret
ClipboardPaste endp

Install:
	.if console & CON_CLIPB
	    mov ax,1700h
	    int 2Fh
	    mov dx,ax
	    xor ax,ax		; AX <> 1700h
	    .if dx != 1700h	; - AL = WINOLDAP major version
		inc ax		; - AH = WINOLDAP minor version
	    .endif
	    mov winoldap,ax
	.endif
	ret

_TEXT	ENDS

pragma_init Install,12

externdef IDD_ClipboardWarning:dword
;
; Cut		Shift-Del	Ctrl-X
; Copy		Ctrl-Ins	Ctrl-C
; Paste		Shift-Ins	Ctrl-V
; Clear		Del		Ctrl-Del
;

.code

tiselected proc public uses bx
	mov	bx,tinfo
    ifdef __TE__
	mov	ax,[bx].S_TINFO.ti_clel ; CX line count
	sub	ax,[bx].S_TINFO.ti_clsl
	mov	cx,ax
	jnz	@F
    endif
	mov	ax,[bx].S_TINFO.ti_cleo ; AX byte count
	sub	ax,[bx].S_TINFO.ti_clso
      @@:
	ret
tiselected endp

ticlipset proc public uses bx	; set clipboard to current position
	mov	bx,tinfo
	mov	ax,[bx].S_TINFO.ti_boff
	add	ax,[bx].S_TINFO.ti_xoff
	mov	[bx].S_TINFO.ti_clso,ax
	mov	[bx].S_TINFO.ti_cleo,ax
    ifdef __TE__
	test	[bx].S_TINFO.ti_flag,_T_LINEBUF
	jz	@F
	mov	ax,[bx].S_TINFO.ti_loff
	add	ax,[bx].S_TINFO.ti_yoff
	mov	[bx].S_TINFO.ti_clsl,ax
	mov	[bx].S_TINFO.ti_clel,ax
      @@:
    endif
	ret
ticlipset endp

alignxy:
	test	cx,cx		; subtract ax then dx while cx--
	je	alignxy_end
	cmp	ax,cx
	jb	alignxy_00
	sub	ax,cx
    alignxy_end:
	ret
    alignxy_00:
	sub	cx,ax
	xor	ax,ax
	sub	dx,cx
	ret

tialigncl:
	push	bx		; goto start of selection
	mov	bx,tinfo
    ifdef __TE__
	test	[bx].S_TINFO.ti_flag,_T_LINEBUF
	jz	@F
	mov	dx,[bx].S_TINFO.ti_loff
	mov	ax,[bx].S_TINFO.ti_yoff
	mov	cx,dx
	add	cx,ax
	sub	cx,[bx].S_TINFO.ti_clsl
	call	alignxy
	mov	[bx].S_TINFO.ti_loff,dx
	mov	[bx].S_TINFO.ti_yoff,ax
      @@:
    endif
	mov	dx,[bx].S_TINFO.ti_boff
	mov	ax,[bx].S_TINFO.ti_xoff
	mov	cx,dx
	add	cx,ax
	sub	cx,[bx].S_TINFO.ti_clso
	call	alignxy
	mov	[bx].S_TINFO.ti_boff,dx
	mov	[bx].S_TINFO.ti_xoff,ax
	pop	bx
	ret

ifdef __TE__

tiremline proc public uses si di bx bp
	mov	bx,ax		; AX index of line to remove
	mov	bp,tinfo	; DX number of lines to remove
	mov	cx,[bp].S_TEDIT.ti_lcnt
	mov	ax,[bp].S_TINFO.ti_bcol
	sub	sp,ax
	mov	bp,sp
	push	ax		; [bp-2] line size
	mov	ax,dx
	sub	cx,bx
	push	cx		; [bp-4] max lines
	add	dx,bx
	push	dx		; [bp-6] last line
	push	ax		; [bp-8] count
      @@:
	mov	ax,[bp-6]
	call	tigetline
	jc	@F
	mov	ds,dx
	mov	si,ax
	mov	cx,[bp-2]
	shr	cx,1
	push	ss
	pop	es
	mov	di,bp
	rep	movsw
	push	ss
	pop	ds
	mov	ax,bx
	call	tigetline
	jc	tiremlines_err
	mov	es,dx
	mov	di,ax
	mov	cx,[bp-2]
	shr	cx,1
	mov	si,bp
	rep	movsw
	inc	bx
	inc	word ptr [bp-6]
	dec	word ptr [bp-4]
	jnz	@B
      @@:
	mov	bx,[bp-8]
	mov	si,tinfo
      @@:
	mov	ax,[si].S_TEDIT.ti_lcnt
	dec	ax
	call	tigetline
	jz	tiremlines_end
	mov	es,dx
	mov	di,ax
	xor	ax,ax
	mov	cx,[bp-2]
	shr	cx,1
	rep	stosw
	dec	[si].S_TEDIT.ti_lcnt
	dec	bx
	jnz	@B
	inc	ax
    tiremlines_end:
	add	sp,[bp-2]
	add	sp,8
	or	ax,ax
	ret
    tiremlines_err:
	xor	ax,ax
	jmp	tiremlines_end
tiremline endp

endif

ticlipdel proc public uses si di bx
	invoke  tiselected
  ifdef __TE__
	mov	di,cx		; DI line count selected
	jz	ticlipdel_end
	call	tialigncl	; goto start
	mov	bx,tinfo
	mov	ax,[bx].S_TINFO.ti_clsl
	call	tigetline	; get line
	jz	ticlipdel_end
	test	di,di
	jnz	@F
	or	[bx].S_TINFO.ti_flag,_T_MODIFIED
	mov	cx,ax
	add	ax,[bx].S_TINFO.ti_clso
	add	cx,[bx].S_TINFO.ti_cleo
	invoke  strcpy,dx::ax,dx::cx
	jmp	ticlipdel_set
      @@:
	mov	es,dx		; multi line
	mov	si,ax
	sub	ax,ax
	add	si,[bx].S_TINFO.ti_clso
	mov	es:[si],al	; start=0
	mov	ax,[bx].S_TINFO.ti_clel
	call	tigetline	; get last selected line
	jz	ticlipdel_end
	or	[bx].S_TINFO.ti_flag,_T_MODIFIED
	mov	cx,ax
	add	cx,[bx].S_TINFO.ti_cleo
	invoke  strcpy,dx::ax,dx::cx
	dec	di
	jz	ticlipdel_del
	mov	si,[bx].S_TINFO.ti_clsl
	inc	si
    ticlipdel_lines:
	mov	ax,si
	mov	dx,di
	call	tiremline
    ticlipdel_del:
	call	tidelete
  else  ; __TE__
	jz	ticlipdel_end
	mov	bx,tinfo
	lodm	[bx].S_TINFO.ti_bp
	mov	si,ax
	mov	di,[bx].S_TINFO.ti_cleo
	add	ax,[bx].S_TINFO.ti_clso
	mov	cx,si
	add	cx,di
	invoke  strcpy,dx::ax,dx::cx
	mov	dx,si
	add	dx,di
	sub	dx,ax
	mov	cx,si
	add	cx,[bx].S_TINFO.ti_boff
	add	cx,[bx].S_TINFO.ti_xoff
	cmp	ax,cx
	je	ticlipdel_set
	sub	[bx].S_TINFO.ti_xoff,dx
  endif
    ticlipdel_set:
	call	tiseto
	call	ticlipset
	sub	ax,ax
	inc	ax
    ticlipdel_end:
	ret
ticlipdel endp

ifdef __TE__

tiselectall proc public
	push	bx
	mov	bx,tinfo
	xor	ax,ax
	mov	[bx].S_TINFO.ti_clsl,ax
	mov	[bx].S_TINFO.ti_clso,ax
	mov	[bx].S_TINFO.ti_clel,ax
	mov	ax,[bx].S_TINFO.ti_bcol
	mov	[bx].S_TINFO.ti_cleo,ax
	cmp	[bx].S_TEDIT.ti_lcnt,ax
	je	@F
	mov	ax,[bx].S_TEDIT.ti_lcnt
	dec	ax
	mov	[bx].S_TINFO.ti_clel,ax
      @@:
	pop	bx
	jmp	ticontinue
tiselectall endp

endif

ifdef	__TE__
ticopyselection:
	push	di
	push	bx
	xor	di,di
	invoke  oinitst,addr STDO,MAXCLIPSIZE
	jnz	@F
	invoke  oinitst,addr STDO,1000h
	jz	ticopyselection_eof
      @@:
	inc	di
	mov	STDO.ios_flag,IO_CLIPBOARD
	mov	ax,[si].S_TINFO.ti_clsl
	mov	dx,[si].S_TINFO.ti_clso
	mov	cx,[si].S_TINFO.ti_clel
	mov	bx,[si].S_TINFO.ti_cleo
	call	tiflushl
	jnz	@F
	mov	ax,bx
	mov	[si].S_TINFO.ti_clsl,dx
	mov	[si].S_TINFO.ti_clso,ax
	inc	di
	invoke  rsmodal,IDD_ClipboardWarning
      @@:
	call	oflush
	invoke  ofreest,addr STDO
    ticopyselection_eof:
	mov	ax,di
	test	ax,ax
	pop	bx
	pop	di
	ret
endif

ticlipcut proc private uses si di
	mov	si,tinfo
	mov	di,ax			; AX: Copy == 0, Cut == 1
	call	tiselected		; get size of selection
	jz	ticlipcut_set
    ifdef __TE__
	call	ticopyselection
	jz	ticlipcut_eof
	dec	ax
	jnz	ticlipcut_eof
    else
	mov	cx,ax
	lodm	[si].S_TINFO.ti_bp
	add	ax,[si].S_TINFO.ti_clso
	invoke  ClipboardCopy,dx::ax,cx
    endif
	test	di,di
	jz	ticlipcut_set
	call	ticlipdel
    ticlipcut_set:
	call	ticlipset
    ticlipcut_eof:
	sub	ax,ax
	ret
ticlipcut endp

ticlipget proc private uses si di bx
	mov	si,tinfo
	mov	ax,[si].S_TINFO.ti_flag
	and	ax,_T_OVERWRITE
	jnz	@F
	call	ticlipset
	jmp	ticlipget_get
      @@:
	call	ticlipdel
    ticlipget_get:
	call	ClipboardPaste
	jz	ticlipget_end
  ifdef __TE__
	push	[si].S_TINFO.ti_yoff
	push	[si].S_TINFO.ti_loff
  endif
	push	[si].S_TINFO.ti_xoff
	push	[si].S_TINFO.ti_boff
	mov	si,clipbsize
	mov	di,ax
	mov	es,dx
  ifdef __TE__
	mov	dx,ax		; Problem of inserting text by pushing
	mov	cx,si		; a long line in front - EOL == abort
	cld?
	mov	ax,0Ah		; Insert '\n' if clipboard contain a '\n'
	repne	scasb		; then move back to prev pos
	mov	di,dx
	jne	ticlipget_00
	mov	bx,si
	cmp	es:[di+bx-2],al ; remove '\n' from end if exist
	jne	@F		; This align line-based clip-set
	mov	es:[di+bx-2],ah
      @@:
	push	es
	call	tiputc
	pop	es
	test	ax,ax
	jnz	ticlipget_01
	pop	dx
	pop	ax
	pop	cx
	pop	bx
	push	bx
	push	cx
	push	ax
	push	dx
	mov	si,tinfo
	mov	[si].S_TINFO.ti_xoff,ax
	mov	[si].S_TINFO.ti_boff,dx
	mov	[si].S_TINFO.ti_yoff,cx
	mov	[si].S_TINFO.ti_loff,bx
	mov	si,clipbsize
  endif
    ticlipget_00:
	mov	al,es:[di]
	test	al,al
	jz	ticlipget_01
	inc	di
	push	es
	call	tiputc
	pop	es
	test	ax,ax
	jnz	ticlipget_01
	dec	si
	jnz	ticlipget_00
    ticlipget_01:
	pop	dx
	pop	ax
	mov	si,tinfo
	mov	[si].S_TINFO.ti_xoff,ax
	mov	[si].S_TINFO.ti_boff,dx
  ifdef __TE__
	pop	dx
	pop	ax
	mov	[si].S_TINFO.ti_yoff,ax
	mov	[si].S_TINFO.ti_loff,dx
  endif
    ticlipget_end:
	xor	ax,ax
	ret
ticlipget endp

	.data
	cl_proctable label word
		dw ticlip_Copy
		dw ticlip_Copy
		dw ticlipget
		dw ticlip_Cut
		dw ticlip_Cut
	cl_keytable label word
		dw KEY_CTRLINS
		dw KEY_CTRLC
		dw KEY_CTRLV
		dw KEY_CTRLX
		dw KEY_CTRLDEL
	cl_keycount = (($ - offset cl_keytable) / 2)
	cl_shiftkeytable label word
		dw KEY_HOME
		dw KEY_LEFT
		dw KEY_RIGHT
		dw KEY_END
	    ifdef __TE__
		dw KEY_UP
		dw KEY_DOWN
		dw KEY_PGUP
		dw KEY_PGDN
	    endif
	cl_shiftkeycount = (($ - offset cl_shiftkeytable) / 2)
	cl_nodeletekeys label size_t
		dw KEY_ESC
	    ifdef __MOUSE__
		dw MOUSECMD
	    endif
		dw KEY_BKSP
		dw KEY_ENTER
		dw KEY_KPENTER
	cl_nodeletecount = (($ - offset cl_nodeletekeys) / 2)

	.code

ticlip_Copy:
	sub	ax,ax
	jmp	ticlipcut

ticlip_Cut:
	mov	ax,1
	jmp	ticlipcut

ticlipevent proc public uses si di bx
	mov	si,ax
	call	tiselected
	jnz	@F
	call	ticlipset
      @@:
	xor	di,di
	mov	cx,cl_keycount
	jmp	ticlipevent_loop
    ticlipevent_found:
	call	cl_proctable[di]
	jmp	ticlipevent_end
    ticlipevent_loop:
	cmp	si,cl_keytable[di]
	je	ticlipevent_found
	add	di,size_l
	dec	cx
	jnz	ticlipevent_loop
	les	bx,keyshift
	mov	al,es:[bx]
	and	al,KEY_SHIFT
	jnz	@F
	cmp	si,KEY_DEL
	jne	ticlipevent_ESC
	call	ticlipdel
	jz	ticlipevent_set
	xor	ax,ax
	jmp	ticlipevent_end
      @@:
	cmp	si,KEY_INS
	jne	@F
	call	ticlipget
	jmp	ticlipevent_end
      @@:
	cmp	si,KEY_DEL
	jne	@F
	mov	ax,1
	call	ticlipcut
	jmp	ticlipevent_end
      @@:
	mov	di,offset cl_shiftkeytable
	mov	cx,cl_shiftkeycount
  ifdef __TE__
	mov	bx,tinfo
	test	[bx].S_TINFO.ti_flag,_T_LINEBUF
	jnz	@F
	sub	cx,4
  endif
      @@:
	cmp	si,[di]
	je	ticlipevent_MOVE
	add	di,size_l
	dec	cx
	jnz	@B
    ticlipevent_ESC:
	mov	cx,cl_nodeletecount
	xor	di,di
      @@:
	cmp	si,cl_nodeletekeys[di]
	je	ticlipevent_set
	add	di,size_l
	dec	cx
	jnz	@B
	mov	ax,si
	test	al,al
	jz	ticlipevent_set
    ifdef __TE__
	mov	bx,tinfo
	test	[bx].S_TINFO.ti_flag,_T_LINEBUF
	jnz	@F
	cmp	si,KEY_TAB
	je	ticlipevent_set
      @@:
    endif
	call	ticlipdel
    ticlipevent_set:
	call	ticlipset
	mov	ax,si
    ticlipevent_end:
	ret
    ticlipevent_MOVE:
	mov	ax,si
	call	tievent
	test	ax,ax
	jnz	ticlipevent_nul
	mov	bx,tinfo
    ifdef __TE__
	mov	cx,[bx].S_TINFO.ti_loff
	add	cx,[bx].S_TINFO.ti_yoff
	cmp	cx,[bx].S_TINFO.ti_clsl
	jb	ticlipevent_MOVEBACK
    endif
	mov	ax,[bx].S_TINFO.ti_boff
	add	ax,[bx].S_TINFO.ti_xoff
	cmp	ax,[bx].S_TINFO.ti_clso
	jb	ticlipevent_MOVEBACK
	cmp	si,KEY_RIGHT
	jne	@F
	mov	dx,ax
	dec	dx
	cmp	dx,[bx].S_TINFO.ti_clso
	jne	@F
	cmp	dx,[bx].S_TINFO.ti_cleo
	jne	ticlipevent_MOVEBACK
      @@:
	mov	[bx].S_TINFO.ti_cleo,ax
    ifdef __TE__
	mov	[bx].S_TINFO.ti_clel,cx
    endif
	jmp	ticlipevent_nul
    ticlipevent_MOVEBACK:
	mov	[bx].S_TINFO.ti_clso,ax
    ifdef __TE__
	mov	[bx].S_TINFO.ti_clsl,cx
    endif
    ticlipevent_nul:
	xor	ax,ax
	jmp	ticlipevent_end
ticlipevent endp

endif ; __CLIP__

	END
