include clip.inc
include conio.inc
include tinfo.inc
include keyb.inc
include mouse.inc
include string.inc
include dos.inc
include ctype.inc

ifdef __TE__
tienter		proto
tienterni	proto
tigetline	proto		; AX line
tiexpand	proto
tistrip		proto
tistripl	proto
tistripline	proto
tiremline	proto
tistyle		proto pascal
endif
	.data

ti_keytable label size_t
	dw _TI_CONTINUE
	dw KEY_ESC
	dw KEY_LEFT
	dw KEY_RIGHT
	dw KEY_HOME
	dw KEY_END
	dw KEY_BKSP
	dw KEY_TAB
	dw KEY_DEL
	dw MOUSECMD
	dw KEY_CTRLRIGHT
	dw KEY_CTRLLEFT
	dw KEY_ENTER
	dw KEY_KPENTER
	dw KEY_UP
	dw KEY_DOWN
ifdef __TE__
	dw KEY_PGUP
	dw KEY_PGDN
	dw KEY_CTRLPGUP
	dw KEY_CTRLPGDN
	dw KEY_CTRLHOME
	dw KEY_CTRLEND
	dw KEY_CTRLUP	; Scroll up one line
	dw KEY_CTRLDN	; Scroll down one line
endif

ti_proctab label size_t
	dw ticontinue
	dw tiesc
	dw tileft
	dw tiright
	dw tihome
	dw titoend
	dw tibacksp
	dw titab
	dw tidelete
	dw timouse
	dw tinextword
	dw tiprevword
  ifdef __TE__
	dw tienter
	dw tienter
	dw tiup
	dw tidown
	dw tipgup
	dw tipgdn
	dw tictrlhome
	dw tictrlend
	dw tictrlpgup
	dw tictrlpgdn
	dw tiscrollup
	dw tiscrolldn
  else
	dw tiesc
	dw tiesc
	dw tiesc
	dw tiesc
  endif

ti_key_count = (($ - offset ti_proctab) / size_l)

	cp_linetolong db 'Line too long, was truncated',0
public  cp_linetolong

	.code

tinocando proc public
	invoke  beep,9,1
	mov	ax,_TI_CMFAILED ; end of line/buffer
	ret
tinocando endp

ticurlp proc public uses bx
	mov	bx,tinfo
    ifdef __TE__
	mov	ax,[bx].S_TINFO.ti_loff ; this return ZF set if NULL
	add	ax,[bx].S_TINFO.ti_yoff
	call	tigetline
	jz	@F
	call	tistrlen
	test	dx,dx
      @@:
    else
	lodm	[bx].S_TINFO.ti_bp
    endif
	ret
ticurlp endp

ticurcp proc public uses bx
	mov	bx,tinfo
	call	ticurlp
	add	ax,[bx].S_TINFO.ti_boff ; no ZF flag if __TE__
	add	ax,[bx].S_TINFO.ti_xoff
	ret
ticurcp endp

ticontinue proc public
	sub ax,ax
	ret
ticontinue endp

tiretevent proc public
	mov ax,_TI_RETEVENT
	ret
tiretevent endp

tiesc proc private
	jmp tiretevent
tiesc endp

tileft proc private uses bx
	mov bx,tinfo
	sub ax,ax
	.if ax == [bx].S_TINFO.ti_xoff
	    .if ax == [bx].S_TINFO.ti_boff
		mov ax,_TI_CMFAILED
	    .else
		dec [bx].S_TINFO.ti_boff
	    .endif
	.else
	    dec [bx].S_TINFO.ti_xoff
	.endif
	ret
tileft  endp

tiincvalue proc pascal private uses si di dx boff:dword, soff:dword,
	bmax:size_t, smax:size_t
	mov si,word ptr boff
	mov di,word ptr soff
	mov ax,[si]
	add ax,[di]
	inc ax
	.if ax >= bmax
	    sub ax,ax
	.else
	    mov dx,[si]
	    mov ax,[di]
	    inc ax
	    .if ax >= smax
		mov ax,smax
		dec ax
		inc dx
	    .endif
	    mov [di],ax
	    mov [si],dx
	.endif
	ret
tiincvalue endp

tiincx proc private uses bx ax
	mov bx,tinfo
	invoke tiincvalue,addr [bx].S_TINFO.ti_boff,addr [bx].S_TINFO.ti_xoff,
		[bx].S_TINFO.ti_bcol,[bx].S_TINFO.ti_cols
	ret
tiincx endp

tiright proc private uses di bx
	mov	bx,tinfo
    ifdef __TE__
	test	[bx].S_TINFO.ti_flag,_T_LINEBUF
	jz	@F
	call	tiincx
	jmp	tiright_ok
      @@:
    endif
	call	ticurcp
	mov	es,dx
	mov	di,ax
	mov	al,es:[di]
	sub	di,[bx].S_TINFO.ti_xoff
	test	al,al
	jz	tiright_00
	mov	ax,[bx].S_TINFO.ti_cols
	dec	ax
	cmp	ax,[bx].S_TINFO.ti_xoff
	jbe	tiright_00
	inc	[bx].S_TINFO.ti_xoff
    tiright_ok:
	call	ticontinue
    tiright_end:
	ret
    tiright_00:
	invoke  strlen,es::di
	cmp	ax,[bx].S_TINFO.ti_cols
	jb	tiright_eof
	inc	[bx].S_TINFO.ti_boff
	jmp	tiright_ok
    tiright_eof:
	call	tinocando
	jmp	tiright_end
tiright endp

tihome proc private uses bx
    ifdef __TE__
	call	tistripline
    endif
	mov	bx,tinfo
	sub	ax,ax
	mov	[bx].S_TINFO.ti_xoff,ax
	mov	[bx].S_TINFO.ti_boff,ax
	ret
tihome endp

titoend proc public uses bx
    ifdef __TE__
	call	tistripline
    endif
	mov	bx,tinfo
	mov	dx,[bx].S_TINFO.ti_cols
	dec	dx
	mov	ax,[bx].S_TINFO.ti_bcnt
	cmp	ax,dx
	jle	@F
	mov	ax,dx
      @@:
	mov	[bx].S_TINFO.ti_xoff,ax
	mov	dx,[bx].S_TINFO.ti_bcnt
	sub	dx,[bx].S_TINFO.ti_cols
	inc	dx
	xor	ax,ax
	cmp	ax,dx
	jg	@F
	mov	ax,dx
      @@:
	mov	[bx].S_TINFO.ti_boff,ax
	add	ax,[bx].S_TINFO.ti_xoff
	cmp	ax,[bx].S_TINFO.ti_bcnt
	jbe	@F
	dec	[bx].S_TINFO.ti_boff
      @@:
	call	ticontinue
	ret
titoend endp

; set byte count in line to .ti_bcnt
; set line[size-1]=0
; return CX strlen(DX:AX)

tistrlen proc private uses si di bx
	mov	bx,tinfo
	push	es
	mov	es,dx
	mov	si,ax
	mov	di,ax
	xor	ax,ax
	add	di,[bx].S_TINFO.ti_bcol
	dec	di
	mov	es:[di],al
	mov	di,si
	mov	cx,ax
	dec	cx
	cld?
	repnz	scasb
	not	cx
	dec	cx
	mov	[bx].S_TINFO.ti_bcnt,cx
	mov	ax,si
	pop	es
	ret
tistrlen endp

tidecvalue proc pascal private uses si di dx boff:dword, soff:dword,
	bmax:size_t, smax:size_t
	mov si,word ptr boff
	mov di,word ptr soff
	mov ax,[si]
	add ax,[di]
	.if ax
	    mov dx,[si]
	    mov ax,[di]
	    .if ax
		dec ax
		and si,si
		stc
	    .else
		dec dx
		and si,si
		clc
	    .endif
	    mov [di],ax
	    mov [si],dx
	.endif
	ret
tidecvalue endp

tidecx proc private uses ax bx
	mov	bx,tinfo
	invoke  tidecvalue,addr [bx].S_TINFO.ti_boff,addr [bx].S_TINFO.ti_xoff,
		[bx].S_TINFO.ti_bcol,[bx].S_TINFO.ti_cols
	ret
tidecx endp

tialignx proc public uses bx cx
	mov	bx,tinfo
	mov	cx,[bx].S_TINFO.ti_xoff
	add	cx,[bx].S_TINFO.ti_boff
	cmp	cx,ax
	jb	tialignx_inc
	je	tialignx_end
    tialignx_dec:
	call	tidecx
	jz	tialignx_end
	dec	cx
	cmp	ax,cx
	jne	tialignx_dec
	jmp	tialignx_ok
    tialignx_inc:
	call	tiincx
	jz	tialignx_end
	inc	cx
	cmp	ax,cx
	jne	tialignx_inc
    tialignx_ok:
	inc	cx
    tialignx_end:
	ret
tialignx endp

ifdef __TE__

tidoiflines proc public
	mov	ax,tinfo
	xchg	ax,bx
	test	[bx].S_TINFO.ti_flag,_T_LINEBUF
	xchg	ax,bx
	jnz	@F
	pop	ax
	jmp	tiretevent
      @@:
    ifdef __TE__
	push	ax
	call	tistripline
	pop	ax
    endif
	ret
tidoiflines endp

tiup proc private
	call tidoiflines
	push bx
	mov bx,ax
	sub ax,ax
	.if ax != [bx].S_TINFO.ti_yoff
	    dec [bx].S_TINFO.ti_yoff
	.elseif ax != [bx].S_TINFO.ti_loff
	    dec [bx].S_TINFO.ti_loff
	.endif
	pop bx
	ret
tiup endp

tidown proc public
	call	tidoiflines
	push	bx
	mov	bx,ax
	mov	dx,[bx].S_TINFO.ti_loff
	mov	cx,[bx].S_TINFO.ti_yoff
	mov	ax,dx
	add	ax,cx
	inc	ax
	cmp	ax,[bx].S_TINFO.ti_brow
	jae	tidown_retevent
	cmp	ax,[bx].S_TEDIT.ti_lcnt
	jae	tidown_continue
	mov	ax,[bx].S_TINFO.ti_rows
	dec	ax
	cmp	cx,ax
	jae	@F
	inc	[bx].S_TINFO.ti_yoff
	jmp	tidown_continue
      @@:
	mov	ax,[bx].S_TINFO.ti_brow
	sub	ax,dx
	sub	ax,cx
	jz	tidown_retevent
	dec	ax
	jz	tidown_retevent
	inc	[bx].S_TINFO.ti_loff
    tidown_continue:
	pop	bx
	jmp	ticontinue
    tidown_retevent:
	pop	bx
	jmp	tiretevent
tidown  endp

tipgup proc private
	call	tidoiflines
	push	bx
	mov	bx,ax
	mov	ax,[bx].S_TINFO.ti_loff
	test	ax,ax
	jz	tipgup_tictrlhome
	cmp	ax,[bx].S_TINFO.ti_rows
	jb	tipgup_tictrlhome
	sub	ax,[bx].S_TINFO.ti_rows
	mov	[bx].S_TINFO.ti_loff,ax
    tipgup_continue:
	pop	bx
	jmp	ticontinue
    tipgup_tictrlhome:
	pop	bx
	jmp	tictrlhome
tipgup endp

tipgdn proc private
	call	tidoiflines
	push	bx
	mov	bx,ax
	mov	ax,[bx].S_TINFO.ti_rows
	add	ax,ax
	add	ax,[bx].S_TINFO.ti_loff
	cmp	ax,[bx].S_TEDIT.ti_lcnt
	jnb	tipgdn_ctrlend
	mov	ax,[bx].S_TINFO.ti_loff
	add	ax,[bx].S_TINFO.ti_rows
	mov	[bx].S_TINFO.ti_loff,ax
    tipgdn_continue:
	pop	bx
	jmp	ticontinue
    tipgdn_ctrlend:
	pop	bx
	jmp	tictrlend
tipgdn endp

tictrlpgup proc private
	call	tidoiflines
	push	bx
	mov	bx,ax
	sub	ax,ax
	mov	[bx].S_TINFO.ti_yoff,ax
	pop	bx
	ret
tictrlpgup endp

tictrlpgdn proc private
	call	tidoiflines
	push	bx
	mov	bx,ax
	mov	ax,[bx].S_TINFO.ti_rows
	dec	ax
	mov	[bx].S_TINFO.ti_yoff,ax
	add	ax,[bx].S_TINFO.ti_loff
	cmp	ax,[bx].S_TEDIT.ti_lcnt
	pop	bx
	jb	@F
	ret
      @@:
	jmp	tictrlend
tictrlpgdn endp

tictrlend proc private
	call	tidoiflines
	xchg	bx,ax
	mov	bx,[bx].S_TEDIT.ti_lcnt
	xchg	bx,ax
	dec	ax
	call	tialigny
	jmp	ticontinue
tictrlend endp

tictrlhome proc private
	call	tictrlpgup
	push	bx
	mov	bx,tinfo
	mov	[bx].S_TINFO.ti_loff,ax
	pop	bx
	ret
tictrlhome endp

tiscrollup proc private
	call	tidoiflines
	push	bx
	mov	bx,ax
	sub	ax,ax
	cmp	ax,[bx].S_TINFO.ti_loff
	je	@F
	dec	[bx].S_TINFO.ti_loff
      @@:
	pop	bx
	ret
tiscrollup endp

tiscrolldn proc private
	call	tidoiflines
	push	bx
	mov	bx,ax
	mov	ax,[bx].S_TINFO.ti_loff
	add	ax,[bx].S_TINFO.ti_yoff
	inc	ax
	cmp	ax,[bx].S_TEDIT.ti_lcnt
	jae	@F
	inc	[bx].S_TINFO.ti_loff
      @@:
	pop	bx
	jmp	ticontinue
tiscrolldn endp

tidecy proc private uses bx ax
	mov	bx,tinfo
	invoke  tidecvalue,addr [bx].S_TINFO.ti_loff,addr [bx].S_TINFO.ti_yoff,
		[bx].S_TINFO.ti_brow,[bx].S_TINFO.ti_rows
	ret
tidecy endp

tiincy proc private uses si bx ax
	mov	bx,tinfo
	mov	si,[bx].S_TINFO.ti_rows
	test	[bx].S_TINFO.ti_flag,_T_USEMENUS
	jz	@F
	dec	si
      @@:
	invoke  tiincvalue,addr [bx].S_TINFO.ti_loff,addr [bx].S_TINFO.ti_yoff,
		[bx].S_TINFO.ti_brow,si
	ret
tiincy endp

tialigny proc public uses bx cx
	mov	bx,tinfo	; Align yoff and loff to AX
	mov	cx,[bx].S_TINFO.ti_yoff
	add	cx,[bx].S_TINFO.ti_loff
	cmp	cx,ax
	jb	tialigny_inc
	je	tialigny_end
      @@:
	call	tidecy
	jz	tialigny_end
	dec	cx
	cmp	ax,cx
	jne	@B
	jmp	tialigny_ok
    tialigny_inc:
	call	tiincy
	jz	tialigny_end
	inc	cx
	cmp	ax,cx
	jne	tialigny_inc
    tialigny_ok:
	inc	cx
    tialigny_end:
	ret
tialigny endp

endif

tiseto proc public uses si di bx
	call	ticurlp
	mov	di,ax
  ifdef __TE__
	jz	tiseto_00
	mov	bx,2020h
	call	tistripl
	mov	bx,tinfo
	mov	ax,[bx].S_TINFO.ti_boff ; test if char is visible
	add	ax,[bx].S_TINFO.ti_xoff
	cmp	ax,cx
	jbe	tiseto_00
	test	[bx].S_TINFO.ti_flag,_T_LINEBUF
	jz	tiseto_01
	add	di,cx			; length of line
	mov	es,dx			; ES to segment
	mov	cx,ax
	sub	cx,[bx].S_TINFO.ti_bcnt ; CX to pad count
   ifdef _PADD_WITH_TABS
	test	[bx].S_TINFO.ti_flag,_T_OPTIMALFILL
	jz	tiseto_space
    tiseto_tab:
	mov	dx,di			; insert '\t' if possible
	add	dx,cx
	mov	ax,di
	and	ax,not 7
	add	ax,8
	cmp	ax,dx
	ja	tiseto_space
	sub	ax,di
	mov	ah,al
	mov	al,9
      @@:
	stosb
	mov	al,TITABCHAR
	dec	cx
	dec	ah
	jnz	@B
	jmp	tiseto_tab
    tiseto_space:			; padd the rest with ' '
   endif
	mov	ax,' '
	cld?
	rep	stosb
	mov	al,ah
	stosb
	jmp	tiseto_01
  else
	mov	bx,tinfo
	mov	cx,ax
	add	cx,[bx].S_TINFO.ti_bcol
	dec	cx
	mov	es,dx
	mov	bx,cx
	mov	byte ptr es:[bx],0
	invoke  strlen,dx::ax
	mov	dx,ax
	mov	bx,tinfo
	mov	[bx].S_TINFO.ti_bcnt,ax
	mov	ax,[bx].S_TINFO.ti_boff ; test if char is visible
	add	ax,[bx].S_TINFO.ti_xoff
	cmp	ax,dx
	jb	tiseto_00
  endif
    tiseto_toend:
	call	titoend			; if not --> to end of line
    tiseto_01:
	mov	ax,1
    tiseto_end:
	ret
    tiseto_00:
	xor	ax,ax
	jmp	tiseto_end
	ret
tiseto endp

ifdef __TE__
tigetindent proto
tibacksp proc private uses si di bx
else
tibacksp proc private uses bx
endif
	mov bx,tinfo
	xor cx,cx
	mov ax,[bx].S_TINFO.ti_boff
	add ax,[bx].S_TINFO.ti_xoff
	.if ax
  ifdef __TE__
	    .if [bx].S_TINFO.ti_flag & _T_USEINDENT
		mov di,ax
		mov ax,[bx].S_TINFO.ti_loff
		add ax,[bx].S_TINFO.ti_yoff
		mov si,ax
		call tigetindent
		.if ax == di
		    .while si
			dec si
			mov ax,si
			call tigetindent
			.break .if ax < di
			mov ax,di
		    .endw
		    .if ax < di
			sub di,ax
			.repeat
			    call tileft
			    call tidelete
			    dec di
			.until !di
			jmp tibacksp_end
		    .endif
		.endif
	    .endif
	    call tileft
  else
	    call tileft
  endif
	    jmp tibacksp_delete
	.else
  ifdef __TE__
	    .if [bx].S_TINFO.ti_flag & _T_LINEBUF
		mov ax,[bx].S_TINFO.ti_loff
		add ax,[bx].S_TINFO.ti_yoff
		.if ax
		    .if [bx].S_TINFO.ti_yoff
			dec [bx].S_TINFO.ti_yoff
		    .else
			dec [bx].S_TINFO.ti_loff
		    .endif
		    jmp @F
		.endif
	    .endif
  endif
	    call tinocando
	    jmp tibacksp_end
	.endif
      @@:
	call tiseto
	call titoend
    tibacksp_delete:
	call tidelete
    tibacksp_end:
	ret
tibacksp endp

ifdef	__TE__

tistr0B proc private uses di ax
	mov	di,ax
	mov	ax,2000h+TITABCHAR
	cmp	es:[di],al
	jne	tistr0B_end
	mov	es:[di],ah
	cmp	es:[di+1],al
	jne	@F
	mov	byte ptr es:[di],9
      @@:
	test	di,di
	jz	tistr0B_end
      @@:
	dec	di
	cmp	es:[di],al
	jne	@F
	mov	es:[di],ah
	or	di,di
	jnz	@B
      @@:
	cmp	byte ptr es:[di],9
	jne	tistr0B_end
	mov	es:[di],ah
    tistr0B_end:
	ret
tistr0B endp

endif

tiputc_add:
	mov	ax,[bx].S_TINFO.ti_bcnt
	inc	ax
	cmp	ax,[bx].S_TINFO.ti_bcol
	jae	tiputc_eof
  ifdef __TE__
	call	tiincx
	jz	tiputc_eof
	inc	[bx].S_TINFO.ti_bcnt
	push	cx
	call	ticurlp
	pop	cx
	jz	tiputc_eof
	or	[bx].S_TINFO.ti_flag,_T_MODIFIED
	mov	es,dx
	add	ax,[bx].S_TINFO.ti_xoff
	add	ax,[bx].S_TINFO.ti_boff
	test	[bx].S_TINFO.ti_flag,_T_LINEBUF
	jnz	tiputc_lbuf
    tiputc_insert:
	dec	ax
	mov	bx,ax
	mov	ah,cl
    tiputc_addcl:
	mov	al,es:[bx]
	mov	es:[bx],ah
	mov	ah,al
	inc	bx
	test	al,al
	jnz	tiputc_addcl
	mov	es:[bx],al
	jmp	tiputc_CONTINUE
    tiputc_lbuf:
	dec	ax
	push	ax
	test	[bx].S_TINFO.ti_flag,_T_USETABS
	jz	@F
	call	tistr0B
	call	tistrip
      @@:
	inc	ax
	call	tiputc_insert
	pop	ax
	push	cx
	call	tiexpand
	push	ax
	call	ticurlp
	pop	cx
	mov	bx,ax
	mov	ah,' '
      @@:
	cmp	bx,cx
	je	@F
	mov	al,es:[bx]
	inc	bx
	or	al,al
	jnz	@B
	mov	es:[bx]-1,ah
	jmp	@B
      @@:
	pop	cx
	mov	bx,tinfo
	cmp	cl,9
	jne	tiputc_CONTINUE
	mov	ax,[bx].S_TINFO.ti_xoff ; Align xoff and boff to next TAB
	add	ax,[bx].S_TINFO.ti_boff
	mov	cx,ax
	mov	dl,tetabsize
	dec	dl
	and	dl,TIMAXTABSIZE-1
	test	al,dl
	jz	tiputc_CONTINUE
	not	dl
	and	al,dl
	add	al,tetabsize
	cmp	cx,ax			; Align xoff and boff to AX
	jb	tiputc_inc
	je	tiputc_CONTINUE
    tiputc_dec:
	call	tidecx
	jz	tiputc_CONTINUE
	dec	cx
	cmp	ax,cx
	jne	tiputc_dec
	jmp	tiputc_CONTINUE
    tiputc_inc:
	call	tiincx
	jz	tiputc_CONTINUE
	inc	cx
	cmp	ax,cx
	jne	tiputc_inc
  else
	push	cx
	call	ticurcp
	push	si
	push	di
	mov	cx,[bx].S_TINFO.ti_bcol
	sub	cx,[bx].S_TINFO.ti_xoff
	sub	cx,[bx].S_TINFO.ti_boff
	dec	cx
	mov	ds,dx
	mov	es,dx
	mov	di,ax
	mov	si,ax
	inc	di
	dec	cx
	mov	ax,si
	add	si,cx
	add	di,cx
	inc	cx
	std
	rep	movsb
	cld
	mov	bx,ax
	pop	di
	pop	si
	pop	ax
	mov	[bx],al
	mov	ax,ss
	mov	ds,ax
	mov	bx,tinfo
	inc	[bx].S_TINFO.ti_bcnt
	inc	[bx].S_TINFO.ti_xoff
	mov	ax,[bx].S_TINFO.ti_cols
	cmp	[bx].S_TINFO.ti_xoff,ax
	jl	tiputc_CONTINUE
	dec	ax
	mov	[bx].S_TINFO.ti_xoff,ax
	add	ax,[bx].S_TINFO.ti_boff
	cmp	[bx].S_TINFO.ti_bcnt,ax
	jbe	tiputc_CONTINUE
	inc	[bx].S_TINFO.ti_boff
  endif
    tiputc_CONTINUE:
	mov	ax,_TI_CONTINUE
	ret
  ifdef __TE__
    tiputc_strbuf:
  else
    tiputc_CONTROL:
  endif
	test	al,al
	jz	tiputc_ret
	test	[bx].S_TINFO.ti_flag,_T_USECONTROL
	jnz	tiputc_add
    tiputc_ret:
	mov	ax,_TI_RETEVENT
	ret
    tiputc_eof:
  ifdef __TE__
	mov	ax,[bx].S_TINFO.ti_bcol
	dec	ax
	mov	[bx].S_TINFO.ti_bcnt,ax
	invoke  ermsg,0,addr cp_linetolong
    tiputc_nocando:
  endif
	jmp	tinocando
  ifdef __TE__
    tiputc_ENTER:
	jmp	tienterni
    tiputc_CONTROL:
	test	[bx].S_TINFO.ti_flag,_T_LINEBUF
	jz	tiputc_strbuf
	cmp	al,9
	je	tiputc_TAB
	cmp	al,0Ah
	je	tiputc_ENTER
	cmp	al,0Dh
	je	tiputc_CONTINUE
	jmp	tiputc_ret
    tiputc_TAB:
	.if [bx].S_TINFO.ti_flag & _T_USETABS
	    call tiputc_add
	.else
	    call ticurcp
	    push di
	    mov di,ax
	    mov cx,ax
	    sub ax,ax
	    mov al,tetabsize
	    add di,ax
	    dec ax
	    not ax
	    and di,ax
	    sub di,cx
	    .while di
		mov cl,' '
		call tiputc_add
		.break .if ax != _TI_CONTINUE
		dec di
	    .endw
	    pop di
	.endif
	cmp ax,_TI_CONTINUE
	jne tiputc_nocando
	jmp tiputc_CONTINUE
  endif

tiputc proc public uses bx
	mov bx,tinfo
	mov cx,ax
	call getctype
	.if ah & _CONTROL
	    call tiputc_CONTROL
	.else
	    call tiputc_add
	.endif
	ret
tiputc endp

titab proc private uses bx
	mov bx,tinfo
	.if [bx].S_TINFO.ti_flag & _T_LINEBUF
	    call tiputc
	    call ticontinue
	.else
	    call tiretevent
	.endif
	ret
titab endp

tidelete proc public uses si di bp bx
	mov  bx,tinfo
	call ticurcp
	mov  es,dx
	mov  di,ax
	or   [bx].S_TINFO.ti_flag,_T_MODIFIED
	.if  byte ptr es:[di] == 0
    ifdef __TE__
	    .if [bx].S_TINFO.ti_flag & _T_LINEBUF
		mov ax,[bx].S_TINFO.ti_loff
		add ax,[bx].S_TINFO.ti_yoff
		inc ax
		.if ax < [bx].S_TINFO.ti_brow && ax < [bx].S_TEDIT.ti_lcnt
		    call tigetline
		    .if !CARRY?
			push ax
			invoke strlen,dx::ax
			add ax,[bx].S_TINFO.ti_bcnt
			mov cx,ax
			pop ax
			.if cx < [bx].S_TINFO.ti_bcol
			    sub sp,[bx].S_TINFO.ti_bcol ; add next line to this
			    mov bp,sp
			    invoke strcpy,ss::bp,dx::ax
			    mov ax,[bx].S_TINFO.ti_loff
			    add ax,[bx].S_TINFO.ti_yoff
			    mov si,ax
			    call tigetline
			    .if !CARRY?
				invoke strcat,dx::ax,ss::bp
				add sp,[bx].S_TINFO.ti_bcol
				inc si
				mov ax,si
				mov dx,1
				call tiremline
			    .endif
			.endif
		    .endif
		.endif
	    .endif
    endif
	.else
    ifdef __TE__
	    mov cx,[bx].S_TINFO.ti_flag
	    .if cx & _T_LINEBUF && cx & _T_USETABS
		call tistrip
		mov bx,ax
		mov ah,tetabsize
		dec ah
		and ah,TIMAXTABSIZE-1
		.if al & ah
		    mov ah,es:[bx]
		    mov al,es:[bx][-1]
		    .if al == 9
			mov byte ptr es:[bx][-1],' '
			jmp @F
		    .elseif al == TITABCHAR
			mov di,bx
			mov ah,' '
			.repeat
			    dec di
			    .break .if es:[di] != al
			    mov es:[di],ah
			.until !di
			mov es:[di],ah
			jmp @F
		    .endif
		.endif
		.repeat
		    mov ax,bx
		    inc ax
		    invoke strcpy,dx::bx,dx::ax
		.until byte ptr es:[bx] != TITABCHAR
	      @@:
		mov  ax,bx
		call tiexpand
		mov  bx,tinfo
		or   [bx].S_TINFO.ti_flag,_T_MODIFIED
		jmp  @F
	    .endif
    endif
	    dec [bx].S_TINFO.ti_bcnt
	    mov cx,ax
	    inc cx
	    invoke strcpy,dx::ax,dx::cx
	.endif
      @@:
	call ticontinue
	ret
tidelete endp

tiisword proc private
	call	getctype
	and	ah,_UPPER or _LOWER or _DIGIT
	jnz	@F
	cmp	al,'_'
	jne	tiisword_nul
	test	al,al
      @@:
	ret
    tiisword_nul:
	cmp	al,al
	ret
tiisword endp

tinextword proc private uses si bp
	push	ds
	call	ticurcp
	mov	bp,tinfo
	mov	ds,dx
	mov	si,ax
	mov	dx,ax
	cld?
      @@:
	lodsb
	call	tiisword
	jnz	@B
	test	al,al
	jz	tinextword_eof
      @@:
	lodsb
	test	al,al
	jz	tinextword_eof
	call	tiisword
	jz	@B
	dec	si
	sub	si,dx
	mov	ax,[bp].S_TINFO.ti_boff
	add	ax,[bp].S_TINFO.ti_xoff
	add	ax,si
	cmp	ax,[bp].S_TINFO.ti_bcnt
	ja	tinextword_eof
	mov	ax,si
	add	ax,[bp].S_TINFO.ti_xoff
	mov	dx,[bp].S_TINFO.ti_cols
	cmp	ax,dx
	jb	@F
	dec	dx
	sub	ax,dx
	add	[bp].S_TINFO.ti_boff,ax
	mov	ax,dx
     @@:
	mov	[bp].S_TINFO.ti_xoff,ax
	pop	ds
	call	ticontinue
    tinextword_end:
	ret
    tinextword_eof:
	; next line..
	pop	ds
	call	titoend
	jmp	tinextword_end
tinextword endp

tiprevword proc private uses si di bp bx
	mov	di,ds
	mov	bp,tinfo
	mov	ax,[bp].S_TINFO.ti_boff
	add	ax,[bp].S_TINFO.ti_xoff
	test	ax,ax
	jz	tiprevword_eof
	mov	si,ax
	mov	cx,ax
	call	ticurlp
	mov	ds,dx
	add	si,ax
	mov	bx,si
	mov	dx,ax
	std
	lodsb
	inc	si
	call	tiisword
	jnz	tiprevword_start
	test	al,al
	jnz	tiprevword_l1
	dec	si
    tiprevword_l1:
	lodsb
	cmp	si,dx
	jbe	tiprevword_eof
	test	al,al
	jz	tiprevword_eof
	call	tiisword
	jz	tiprevword_l1
    tiprevword_l2:
	lodsb
	cmp	si,dx
	jbe	tiprevword_eof
	test	al,al
	jz	tiprevword_eof
	call	tiisword
	jnz	tiprevword_l2
	cld
	add si,2
	mov ds,di
	mov ax,si
	sub ax,dx
	.if ax < [bp].S_TINFO.ti_cols
	    mov [bp].S_TINFO.ti_xoff,ax
	    mov [bp].S_TINFO.ti_boff,0
	.else
	    sub ax,[bp].S_TINFO.ti_xoff
	    mov [bp].S_TINFO.ti_boff,ax
	.endif
	jmp tiprevword_continue
    tiprevword_start:
	mov	al,[si-1]
	call	tiisword
	jnz	tiprevword_l2
	dec	si
	jmp	tiprevword_l1
    tiprevword_continue:
	call	ticontinue
    tiprevword_end:
	ret
    tiprevword_eof:
	cld
	mov	ds,di
	call	tihome
	jmp	tiprevword_end
tiprevword endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

tiinitcursor proc public
	push	bx
	mov	bx,tinfo
	mov	[bx].S_TINFO.ti_cursor.cr_type,CURSOR_NORMAL
	pop	bx
tiinitcursor endp

tisetcursor proc private uses bx
	mov	bx,tinfo
	mov	ax,[bx].S_TINFO.ti_xpos
	add	ax,[bx].S_TINFO.ti_xoff
	mov	ah,byte ptr [bx].S_TINFO.ti_ypos
    ifdef __TE__
	test	[bx].S_TINFO.ti_flag,_T_LINEBUF
	jz	@F
	add	ah,byte ptr [bx].S_TINFO.ti_yoff
      @@:
    endif
	mov	[bx].S_TINFO.ti_cursor.cr_xy,ax
	mov	[bx].S_TINFO.ti_cursor.cr_type,CURSOR_NORMAL
	invoke  cursorset,addr [bx].S_TINFO.ti_cursor
	ret
tisetcursor endp

timouse proc private uses bx
  ifdef __MOUSE__
	mov	bx,tinfo
	call	mousey
   ifdef __TE__
	mov	dx,ax
	call	mousex
	mov	cx,ax
	mov	ax,[bx].S_TINFO.ti_xpos
	cmp	cx,ax
	jb	timouse_esc
	add	ax,[bx].S_TINFO.ti_cols
	cmp	cx,ax
	jae	timouse_esc
	mov	ax,[bx].S_TINFO.ti_ypos
	cmp	dx,ax
	jb	timouse_esc
	add	ax,[bx].S_TINFO.ti_rows
	cmp	dx,ax
	jae	timouse_esc
	sub	dx,[bx].S_TINFO.ti_ypos
	mov	[bx].S_TINFO.ti_yoff,dx
	push	cx
	call	ticurlp
	jz	@F
	invoke  strlen,dx::ax
     @@:
	pop	cx
	sub	cx,[bx].S_TINFO.ti_xpos
	cmp	cx,ax
	jg	@F
	mov	ax,cx
     @@:
	mov	[bx].S_TINFO.ti_xoff,ax
	call	tisetcursor
	call	msloop
   else
	cmp	ax,[bx].S_TINFO.ti_ypos
	jne	timouse_esc
	call	mousex
	mov	dx,[bx].S_TINFO.ti_xpos
	cmp	al,dl
	jb	timouse_esc
	add	dx,[bx].S_TINFO.ti_cols
	cmp	ax,dx
	jnb	timouse_esc
	sub	ax,[bx].S_TINFO.ti_xpos
	mov	[bx].S_TINFO.ti_xoff,ax
	lodm	[bx].S_TINFO.ti_bp
	add	ax,[bx].S_TINFO.ti_boff
	invoke  strlen,dx::ax
	cmp	ax,[bx].S_TINFO.ti_xoff
	jnb	@F
	mov	[bx].S_TINFO.ti_xoff,ax
      @@:
	mov	ax,[bx].S_TINFO.ti_xpos
	add	ax,[bx].S_TINFO.ti_xoff
	invoke  gotoxy,ax,[bx].S_TINFO.ti_ypos
	call	msloop
   endif ; __TE__
	call	ticontinue
    timouse_end:
	ret
    timouse_esc:
	call	tiesc
	jmp	timouse_end
  else
	call	ticontinue
	ret
  endif ; __MOUSE__
timouse endp

tievent proc public
	mov	dx,bx
	mov	cx,ti_key_count
	xor	bx,bx
    tievent_loop:
	test	cx,cx
	jz	tievent_break
	cmp	ax,ti_keytable[bx]
	jne	tievent_next
	mov	bx,ti_proctab[bx]
	xchg	bx,dx
	jmp	dx
    tievent_next:
	add	bx,size_l
	dec	cx
	jnz	tievent_loop
    tievent_break:
	mov	bx,dx
	call	tiputc
	ret
tievent endp

tiputl proc private uses si di bx
local	lb[2+TIMAXSCRLINE]:byte
local	wc[2*TIMAXSCRLINE]:byte
local	line:size_t	; current line 0..max
local	loff:size_t	; adress of line
local	lseg:size_t
local	llen:size_t	; length of line
local	clst:size_t	; clip start
local	clen:size_t	; clip end
	mov si,tinfo
  ifdef __TE__
	mov	line,ax
	mov	ah,[si].S_TINFO.ti_clat
	mov	al,[si].S_TINFO.ti_clch
	test	[si].S_TINFO.ti_flag,_T_USESTYLE
	jz	@F
	mov	ah,[si].S_TEDIT.ti_stat
	mov	al,[si].S_TEDIT.ti_stch
      @@:
  else
	mov	ah,[si].S_TINFO.ti_clat
	mov	al,[si].S_TINFO.ti_clch
  endif
	push	ss
	pop	es
	lea	dx,wc
	mov	di,dx
	mov	cx,TIMAXSCRLINE
	cld?
	rep	stosw
	mov	di,dx
  ifdef __TE__
	mov	ax,line
	call	tigetline
	mov	loff,ax
	mov	lseg,dx
	jz	tiputl_screen
  else
	lodm	[si].S_TINFO.ti_bp
	mov	loff,ax
	mov	lseg,dx
  endif
	push	dx
	push	ax
	lea	bx,lb
	add	ax,[si].S_TINFO.ti_boff
	invoke  memcpy,ss::bx,dx::ax,TIMAXSCRLINE
	mov	[bx+TIMAXSCRLINE],cl
	call	strlen
	mov	es,dx
	mov	llen,ax
	cmp	ax,[si].S_TINFO.ti_boff
	jbe	tiputl_color
	xchg	si,bx
	mov	cx,TIMAXSCRLINE
    tiputl_cl:
	lodsb
	or	al,al
	jz	tiputl_break
	cmp	al,TITABCHAR
	jne	@F
	mov	al,' '
    @@:
	cmp	al,9
	jne	@F
	test	[bx].S_TINFO.ti_flag,_T_SHOWTABS
	jnz	@F
	mov	al,' '
    @@:
	stosb
	inc	di
	dec	cx
	jnz	tiputl_cl
    tiputl_break:
	mov	si,bx
  ifdef __TE__
	test	[si].S_TINFO.ti_flag,_T_USESTYLE
	jz	tiputl_color
	push	es
	mov	ax,loff
	mov	di,lseg
	lea	dx,wc
	mov	cx,llen
	mov	bx,line
	call	tistyle
	pop	es
  endif
    tiputl_color:
  ifdef __CLIP__
	xor	ax,ax
	mov	clen,ax ; clip end to	0000
	dec	ax		; clip start to FFFF
	mov	clst,ax
	call	tiselected
	jz	tiputl_screen
  ifdef __TE__
	xor	dx,dx
	cmp	word ptr [si].S_TINFO.ti_bp,dx
	jne	tiputl_local
	mov	ax,line
	cmp	ax,[si].S_TINFO.ti_clsl
	jb	tiputl_screen
	je	tiputl_clst
	cmp	ax,[si].S_TINFO.ti_clel
	ja	tiputl_screen
	mov	clst,dx
	je	tiputl_clen
	dec	dx
	mov	clen,dx
	jmp	tiputl_clput
    tiputl_clen:
	mov	ax,[si].S_TINFO.ti_cleo
	mov	clen,ax
	jmp	tiputl_clput
    tiputl_clst:
	dec	dx
	mov	clen,dx
	cmp	ax,[si].S_TINFO.ti_clel
	mov	ax,[si].S_TINFO.ti_clso
	mov	clst,ax
	je	tiputl_clen
	jmp	tiputl_clput
    tiputl_local:
  endif
	mov	ax,[si].S_TINFO.ti_clso
	add	ax,word ptr [si].S_TINFO.ti_bp
	mov	clst,ax
	mov	ax,[si].S_TINFO.ti_cleo
	add	ax,word ptr [si].S_TINFO.ti_bp
	mov	clen,ax
    tiputl_clput:
	mov	cx,TIMAXSCRLINE
	lea	di,wc+1
	mov	al,at_background[B_Inverse]
	mov	bx,loff
	add	bx,[si].S_TINFO.ti_boff
	mov	dx,clst
    tiputl_cloop:
	cmp	bx,dx
	jb	@F
	cmp	bx,clen
	jae	tiputl_screen
	stosb
	jmp	tiputl_inc
    @@:
	inc	di
    tiputl_inc:
	inc	bx
	inc	di
	dec	cx
	jnz	tiputl_cloop
  endif
    tiputl_screen:
	mov	ax,[si].S_TINFO.ti_xpos
	mov	dx,[si].S_TINFO.ti_ypos
    ifdef __TE__
	add	dx,line
	sub	dx,[si].S_TINFO.ti_loff
    endif
	HideMouseCursor
	invoke  getxyp,ax,dx
	mov	es,dx
	mov	di,ax
	mov	cx,[si].S_TINFO.ti_cols
	lea	si,wc
	assert  cx,TIMAXSCRLINE,jna,"tiputl"
	rep	movsw
	ShowMouseCursor
	xor	ax,ax
	ret
tiputl  endp

tiputs proc public
	call	tisetcursor
    ifdef __TE__
	push	si
	push	di
	mov	di,tinfo
	mov	si,[di].S_TINFO.ti_rows
	mov	di,[di].S_TINFO.ti_loff
	.if !si
	    inc si
	.endif
	.while si
	    mov  ax,di
	    call tiputl
	    inc  di
	    dec  si
	.endw
	pop	di
	pop	si
    else
	sub	ax,ax
	call	tiputl
    endif
	ret
tiputs endp


timodal proc public uses si di
	mov si,_TI_CONTINUE
	.while si != _TI_RETEVENT
	    call tiseto
	    call tiputs
	    call tgetevent
	  ifdef __CLIP__
	    call ticlipevent
	  endif
	    mov  di,ax
	    call tievent
	    mov  si,ax
	.endw
	call	ticurlp
	invoke  strlen,dx::ax
	mov	si,tinfo
	mov	[si].S_TINFO.ti_bcnt,ax
	mov	ax,di
	ret
timodal endp

	END
