include doszip.inc
include io.inc
include iost.inc
include errno.inc
include time.inc
include string.inc
include doserrls.inc
include progress.inc
ifdef __ZIP__
 include unzip.inc
endif
ifdef __DLL__
 include dll.inc
endif

public  copy_jump
public  copy_flag
public  copy_fast
;public  copy_filecount
;public  copy_subdcount

_COPY_SELECTED  equ 01h ; copy selected files
_COPY_IARCHIVE  equ 02h ; source is archive
_COPY_OARCHIVE  equ 04h ; target is archive
_COPY_IEXTFILE  equ 08h ; source is .DLL archive - %doszip%/dll/.dll
_COPY_IZIPFILE  equ 10h ; source is .ZIP archive
_COPY_OZIPFILE  equ 20h ; target is .ZIP archive
_COPY_OEXTFILE  equ 40h ; target is .DLL archive
_COPY_RECURSIV  equ 80h ; recursive error

.data

copy_jump	dd 0
copy_flag	db 0
copy_fast	db 0
copy_filecount  dd 0
copy_subdcount  dd 0

cp_ercopy	db 'There was an error while copying',0
cp_fnisequal	db "You can't copy a file to itself",0
cp_recursive	db "You tried to recursively copy or move a directory",0
cp_needpanel	db "You need two file panels to use this command",0

format_sLsLLs	db '%s',10,'%s',10,10
format_s	db '%s',0
format_sLs	db '%s',10,'%s',0
format_sL_s_	db '%s',10
format_iSi	db "'%s'",0
cp_unixslash	db '/',0
cp_copyto	db "' to",0

.code

error_copy:
	cmp	errno,ENOSPC
	je	error_diskfull
	invoke  ermsg,0,addr format_sLs,addr cp_ercopy,addr __outfile
	ret

error_diskfull:
	invoke  ermsg,0,addr format_sLsLLs,addr cp_ercopy,
		addr __outfile,sys_errlist[ENOSPC*4]
	ret

getcopycount proc private uses esi edi ebx
	mov ebx,cpanel
	mov ebx,[ebx].S_PANEL.pn_wsub
	mov ecx,[ebx].S_WSUB.ws_count
	mov edi,[ebx].S_WSUB.ws_fcb
	.while ecx
	    mov ebx,[edi]
	    add edi,4
	    mov eax,[ebx]
	    .if eax & _FB_SELECTED
		.if eax & _A_SUBDIR
		    inc copy_subdcount
		    push ecx
		    add ebx,S_FBLK.fb_name
		    invoke recursive,ebx,addr __srcpath,addr __outpath
		    pop ecx
		    .if !ZERO?
			mov copy_flag,_COPY_RECURSIV
			.break
		    .endif
		.endif
		inc copy_filecount
	    .endif
	    dec ecx
	.endw
	mov eax,copy_filecount
	add eax,copy_subdcount
	ret
getcopycount endp

cpyevent_filter proc
	invoke  cmfilter
	mov	ecx,tdialog
	mov	ecx,[ecx+4]
	add	ecx,0510h
	mov	dl,ch
	mov	eax,' '
	cmp	filter,0
	je	@F
	mov	al,7
      @@:
	invoke  scputw,ecx,edx,1,eax
	mov	eax,_C_NORMAL
	ret
cpyevent_filter endp

confirm_copy proc private uses esi edi ebx fblk:dword, move:dword
local dialog:dword
local result:dword
	xor ebx,ebx
	mov esi,move
	mov eax,config.c_cflag
	.if esi
	    and eax,_C_CONFCOPY
	.else
	    and eax,_C_CONFMOVE
	.endif
	.if eax
	    .if esi
		mov eax,IDD_DZCopy
	    .else
		mov eax,IDD_DZMove
	    .endif
	    .if rsopen(eax)
		mov dialog,eax
		mov ebx,eax
		.if esi
		    mov filter,0
		    mov [ebx+3*16].S_TOBJ.to_proc,cpyevent_filter
		.endif
		invoke dlshow,dialog
		mov edi,[ebx].S_DOBJ.dl_rect
		add edi,0209h
		mov esi,offset __outpath
		mov byte ptr [ebx+1*16+2],16
		mov ebx,fblk
		mov ebx,[ebx].S_FBLK.fb_flag
		.if ebx & _FB_SELECTED
		    mov ebx,edi
		    mov eax,copy_filecount
		    add eax,copy_subdcount
		    mov cl,bh
		    invoke scputf,ebx,ecx,0,0,addr cp_copyselected,eax
		.else
		    mov ebx,edi
		    mov cl,bh
		    invoke scputw,ebx,ecx,1,0027h
		    inc bl
		    mov eax,fblk
		    add eax,S_FBLK.fb_name
		    invoke scpath,ebx,ecx,38,eax
		    add bl,al
		    invoke scputs,ebx,ecx,0,0,addr cp_copyto
		    mov ebx,fblk
		    .if !(byte ptr [ebx] & _A_SUBDIR)
			mov esi,offset __outfile
		    .endif
		.endif
		.if copy_flag & _COPY_OARCHIVE
		    mov esi,offset __outfile
		.endif
		mov ebx,dialog
		mov ebx,[ebx].S_DOBJ.dl_object
		mov [ebx].S_TOBJ.to_data,esi
		.if copy_flag & (_COPY_IARCHIVE or _COPY_OARCHIVE)
		    invoke dlinit,dialog
		    or [ebx].S_TOBJ.to_flag,_O_STATE
		.endif
		mov eax,IDD_DZMove
		.if move
		    mov eax,IDD_DZCopy
		.endif
		invoke rsevent,eax,dialog
		invoke dlclose,dialog
		xor eax,eax
		.if edx
		    inc eax
		.endif
	    .endif
	.else
	    inc eax
	.endif
	ret
confirm_copy endp

init_copy proc uses esi edi fblk:dword, docopy:dword
	xor eax,eax
	mov copy_fast,al
	mov copy_jump,eax		; set if skip file (jump)
	mov copy_flag,al		; type of copy
	mov copy_filecount,eax		; selected files
	mov copy_subdcount,eax
	.if cpanel_gettarget()		; get __outpath
	    mov esi,eax			; SI = target path
	    invoke panel_getb
	    mov edi,[eax].S_PANEL.pn_wsub ; DI = target directory struct
	    mov ecx,[eax].S_PANEL.pn_path ; CX = target panel
ifdef __ROT__
	    xor eax,eax
	    mov edx,cpanel
	    mov edx,[edx].S_PANEL.pn_path
	    .if [edx].S_PATH.wp_flag & _W_ROOTDIR
		call notsup
		jmp @F
	    .endif
	    .if [edx].S_PATH.wp_flag & _W_ROOTDIR
		jmp @F
	    .endif
endif
ifdef __ARC__
	    mov eax,[ecx].S_PATH.wp_flag
	    and eax,_W_ARCHIVE
	    .if !ZERO?
		.if [edi].S_WSUB.ws_count == 1
		    inc copy_fast
		.endif
		and eax,_W_ARCHEXT
		mov al,_COPY_OARCHIVE or _COPY_OEXTFILE
		.if ZERO?
		    mov al,_COPY_OARCHIVE or _COPY_OZIPFILE
		    .if ! byte ptr docopy
			invoke notsup	; moving files to archive..
			jmp @F
		    .endif
		.endif
	    .endif
	    mov copy_flag,al
endif
	    invoke strcpy,addr __outpath,esi
	    mov eax,cpanel
	    mov eax,[eax].S_PANEL.pn_wsub
	    invoke strcpy,addr __srcpath,[eax].S_WSUB.ws_path
	    mov eax,fblk
	    add eax,S_FBLK.fb_name
	    invoke strfcat,addr __srcfile,addr __srcpath,eax
ifdef __ARC__
	    .if copy_flag & _COPY_OARCHIVE
		invoke strfcat,addr __outfile,addr __outpath,[edi].S_WSUB.ws_file
		invoke strcpy,addr __outpath,[edi].S_WSUB.ws_arch
		invoke dostounix,eax
	    .else
		invoke strfn,addr __srcfile
		invoke strfcat,addr __outfile,addr __outpath,eax
	    .endif
else
	    invoke strfn,addr __srcfile
	    invoke strfcat,addr __outfile,addr __outpath,eax
endif
	    mov eax,fblk
	    mov esi,[eax].S_FBLK.fb_flag
	    .if esi & _FB_SELECTED
		call getcopycount	; copy/move selected files
		.if !eax
		    mov al,copy_flag
		    jmp @F
		.endif
		or copy_flag,_COPY_SELECTED
	    .elseif esi & _A_SUBDIR
		add eax,S_FBLK.fb_name
		invoke recursive,eax,addr __srcpath,addr __outpath
		.if !ZERO?
		    or copy_flag,_COPY_RECURSIV
		.endif
		mov copy_subdcount,1	; copy/move one directory
	    .else
		mov copy_filecount,1	; copy/move one file
	    .endif
	    mov eax,copy_filecount
	    add eax,copy_subdcount
	    .if eax
		mov eax,fblk
		mov eax,[eax].S_FBLK.fb_flag
		and eax,_FB_ARCHIVE
		.if eax
		    mov al,_COPY_IARCHIVE
		    .if eax & _FB_ARCHEXT
			or al,_COPY_IEXTFILE
		    .else
			or al,_COPY_IZIPFILE
		    .endif
		.endif
		or copy_flag,al
		.if confirm_copy(fblk,docopy)
ifdef __ARC__
		    .if copy_flag & _COPY_IARCHIVE
			and copy_flag,not _COPY_RECURSIV
		    .else
endif
			invoke strcmp,addr __outfile,addr __srcfile
			.if ZERO?
			    invoke ermsg,0,addr cp_fnisequal
			    jmp @F
			.endif
ifdef __ARC__
		    .endif
endif
		    .if copy_flag & _COPY_RECURSIV
			invoke ermsg,0,addr cp_recursive
			jmp @F
		    .endif
ifdef __ARC__
		    .if !(copy_flag & _COPY_OARCHIVE)
endif
			invoke getfattr,addr __outpath
			inc eax
			.if ZERO?
			    invoke mkdir,addr __outpath
			    .if eax
				invoke ermkdir,addr __outpath
				inc eax
				jmp @F
			    .endif
			.endif
ifdef __ARC__
		    .endif
endif
		    invoke setconfirmflag
		    mov eax,1
		.endif
	    .endif
	.else
	    invoke ermsg,0,addr cp_needpanel	; need two panels..
	.endif
      @@:
	test eax,eax
	ret
init_copy endp

copyfile proc uses esi edi file_size:qword, time:dword, attrib:dword
	xor esi,esi
	mov eax,offset __srcfile
	mov edx,offset __outfile
	invoke wscopy_open
	.if eax && eax != -1
	    or STDI.ios_flag,IO_USECRC
	    mov STDO.ios_flag,IO_USECRC or IO_UPDTOTAL or IO_USEUPD
	    invoke ocopyst,addr STDO,addr STDI,file_size	; copy the file
	    mov esi,eax
	    .if eax
		invoke oflush		; flush the stream
	    .endif
	    invoke oclose,addr STDI	; test CRC value
	    mov eax,STDO.ios_bb
	    sub eax,STDI.ios_bb
	    .if ZERO?
		.if !esi
		    invoke oclose,addr STDO
		    call error_copy
		    mov eax,offset __outfile
		    invoke wscopy_remove
		    jmp @F
		.endif
		invoke progress_update,file_size ; test user break (ESC)
		mov esi,eax
		invoke setftime,STDO.ios_file,time
		invoke oclose,addr STDO
		mov eax,attrib
		.if al & _A_RDONLY && cflag & _C_CDCLRDONLY
		    mov edx,cpanel
		    mov edx,[edx]
		    mov edx,[edx]
		    .if edx & _W_CDROOM		; remove RDONLY if CD-ROOM
			xor al,_A_RDONLY	; @v2.18
		    .endif
		.endif
		and eax,_A_FATTRIB
		invoke setfattr,addr __outfile,eax
		mov eax,esi
	    .else
		invoke oclose,addr STDO
		mov eax,offset CP_EIO
		mov edx,errno
		.if edx
		    mov eax,sys_errlist[edx*4]
		.endif
		invoke ermsg,0,addr format_sL_s_,addr cp_ercopy,eax
	    .endif
	.endif
      @@:
	ret	; return 1: ok, -1: error, 0: jump (if exist)
copyfile endp

fblk_copyfile proc private fblk:dword, skip_outfile:dword
	.if filter_fblk(fblk)
	    mov eax,fblk
	    add eax,S_FBLK.fb_name
	    invoke strfcat,addr __srcfile,addr __srcpath,eax
	    .if byte ptr skip_outfile == 0
ifdef __ZIP__
		.if !(copy_flag & _COPY_OARCHIVE)
endif
		    mov eax,fblk
		    add eax,S_FBLK.fb_name
		    invoke strfcat,addr __outfile,addr __outpath,eax
ifdef __ZIP__
		.endif
endif
	    .endif
	    mov ebx,fblk
	    invoke progress_set,addr [ebx].S_FBLK.fb_name,addr __outpath,[ebx].S_FBLK.fb_size
	    .if ZERO?
		mov ebx,fblk
		mov edx,[ebx].S_FBLK.fb_flag
ifdef __ZIP__
		.if edx & _FB_ARCHIVE
		    mov ebx,cpanel
		    invoke wsdecomp,[ebx].S_PANEL.pn_wsub,fblk,addr __outpath
		.else
endif
ifdef __ZIP__
		    .if copy_flag & _COPY_OARCHIVE
			invoke wzipadd,[edi].S_FBLK.fb_size,[edi].S_FBLK.fb_time,edx
		    .else
endif
			invoke copyfile,[edi].S_FBLK.fb_size,[edi].S_FBLK.fb_time,edx
ifdef __ZIP__
		    .endif
		.endif
endif
	    .endif
	.endif
	ret
fblk_copyfile endp

fp_copyfile proc directory:dword, wblk:dword
	.if filter_wblk(wblk)
	    mov ebx,wblk
	    invoke strfcat,addr __srcfile,directory,addr [ebx].S_WFBLK.wf_name
ifdef __ZIP__
	    .if !(copy_flag & _COPY_OARCHIVE)
endif
	    invoke strfcat,addr __outfile,addr __outpath,addr [ebx].S_WFBLK.wf_name
ifdef __ZIP__
	    .endif
endif
	    .if !progress_set(addr [ebx].S_WFBLK.wf_name,addr __outpath,[ebx].S_WFBLK.wf_size)
		invoke FileTimeToTime,addr [ebx].S_WFBLK.wf_time
		mov edx,[ebx].S_WFBLK.wf_attrib
		and edx,_A_FATTRIB
ifdef __ZIP__
		.if copy_flag & _COPY_OARCHIVE
		    invoke wzipadd,[ebx].S_WFBLK.wf_size,eax,edx
		.else
endif
		    invoke copyfile,[ebx].S_WFBLK.wf_size,eax,edx
ifdef __ZIP__
		.endif
endif
	    .endif
	.endif
	ret
fp_copyfile endp

fp_copydirectory proc uses esi edi directory:dword
local path[WMAXPATH]:byte
	invoke strlen,addr __srcpath
	mov esi,directory
	add esi,eax
	.if byte ptr [esi] == '\'
	    inc esi
	.endif
	invoke strcpy,addr path,addr __outpath
ifdef __ZIP__
	.if copy_flag & _COPY_OARCHIVE
	    .if __outpath
		invoke strcat,addr __outpath,addr cp_unixslash
	    .endif
	    invoke strcat,addr __outpath,esi
	    invoke strcat,eax,addr cp_unixslash
	    invoke dostounix,eax
	    mov __srcfile,0
	    .if cflag & _C_ZINCSUBDIR
		invoke dostime
		push eax
		invoke getfattr,directory
		pop edx
		invoke wzipadd,0,edx,eax
	    .endif
	.else
endif
	    invoke strfcat,addr __outpath,0,esi
	    invoke mkdir,eax
	    .if eax != -1
		invoke setfattr,addr __outpath,0
		.if !eax
		    invoke getfattr,directory
		    and eax,not _A_SUBDIR
		    invoke setfattr,addr __outpath,eax
		.endif
	    .endif
ifdef __ZIP__
	.endif
endif
	invoke  scan_files, directory
	mov	esi,eax
	invoke  strcpy,addr __outpath,addr path
	mov	eax,esi
	ret
fp_copydirectory endp

copydirectory proc private uses esi fblk:dword
local path[WMAXPATH]:byte
	add fblk,S_FBLK.fb_name
	.if !progress_set(fblk,addr __outpath,0)
ifdef __ZIP__
	    .if !(copy_flag & _COPY_OARCHIVE)
		invoke mkdir,addr __outpath
	    .endif
else
	    invoke mkdir,addr __outpath
endif
	    invoke strfcat,addr path,addr __srcpath,fblk
	    mov esi,eax
ifdef __ZIP__
	    .if copy_flag & _COPY_OARCHIVE && copy_fast != 1
		mov eax,panela
		.if eax == cpanel
		    mov eax,panelb
		.endif
		;
		; if panel name is not found: use fast copy
		;
		invoke wsearch,[eax].S_PANEL.pn_wsub,fblk
		inc eax
		.if ZERO?
		    inc copy_fast
		    invoke wzipopen
		    .if !ZERO?
			invoke scansub,esi,addr cp_stdmask,1
			dec copy_fast
			invoke wzipclose
		    .else
			dec copy_fast
			dec eax
		    .endif
		    jmp @F
		.endif
	    .endif
endif
	    invoke scansub,esi,addr cp_stdmask,1
	.endif
      @@:
	ret
copydirectory endp

copyselected proc private
	invoke panel_getb
	push [eax].S_PANEL.pn_fcb_index
	push [eax].S_PANEL.pn_cel_index
	mov ecx,esi
	.while 1
	  ifdef __ZIP__
	    .if ecx & _FB_ARCHIVE
		mov eax,cpanel
		invoke wsdecomp,[eax].S_PANEL.pn_wsub,edi,addr __outpath
	    .elseif cl & _A_SUBDIR
	  else
	    .if cl & _A_SUBDIR
	  endif
		invoke copydirectory,edi
	    .else
		invoke fblk_copyfile,edi,0
	    .endif
	    .break .if eax
	    invoke cpanel_deselect,edi
	    mov eax,cpanel
	    invoke panel_findnext
	    mov edi,edx
	    .break .if !eax
	.endw
	mov	edx,eax
	invoke  panel_getb
	mov	ecx,eax
	pop	eax
	mov	[ecx].S_PANEL.pn_cel_index,eax
	pop	eax
	mov	[ecx].S_PANEL.pn_fcb_index,eax
	mov	eax,edx
	ret
copyselected endp

cmcopy  proc uses esi edi
	.if cpanel_findfirst()
	    mov edi,edx
	    mov esi,ecx
	    .if init_copy(edx,1)
ifdef __DLL__
		.if copy_flag & _COPY_IEXTFILE
		    mov ebx,cpanel
		    mov ebx,[ebx].S_PANEL.pn_wsub
		    invoke dll_call,_DLL_COPY,ebx,edi,addr __outpath,filter
		    jmp cmcopy_upd
		.elseif copy_flag & _COPY_OEXTFILE
		    call panel_getb
		    mov ebx,eax
		    mov edx,[ebx].S_PANEL.pn_wsub
		    mov ebx,cpanel
		    mov ebx,[ebx].S_PANEL.pn_wsub
		    invoke dll_call,_DLL_ADD,edx,ebx,edi,filter
		    jmp cmcopy_upd
		.endif
endif
		invoke progress_open,addr cp_copy,addr cp_copy
		mov fp_fileblock,fp_copyfile
		mov fp_directory,fp_copydirectory
ifdef __ZIP__
		.if copy_flag & _COPY_OARCHIVE
		    invoke dostounix,addr __outpath
		    .if copy_flag & _COPY_OZIPFILE && copy_fast
			invoke wzipopen
			jz cmcopy_ret
		    .endif
		.endif
endif
		.if esi & _FB_SELECTED
		    invoke copyselected
		.else
		    .if esi & _A_SUBDIR
ifdef __ZIP__
			.if esi & _FB_ARCHIVE
			    mov eax,cpanel
			    invoke wsdecomp,[eax].S_PANEL.pn_wsub,edi,addr __outpath
			.else
endif
			    invoke copydirectory,edi
ifdef __ZIP__
			.endif
endif
		    .else
			invoke fblk_copyfile,edi,1
		    .endif
		.endif
		cmcopy_upd:
ifdef __ZIP__
		.if copy_flag & _COPY_OZIPFILE && copy_fast
		    invoke wzipclose
		.endif
		cmcopy_ret:
endif
		invoke progress_close
	    .endif
	.endif
    cmcopy_end:
	mov copy_fast,0
	ret
cmcopy  endp

	END

