include doszip.inc
include helpid.inc
include string.inc
include tview.inc

.data

cp_doszip_txt db 'doszip.txt',0
Offset_README label dword
	dd 0		; DZ.TXT
	dd HELPID_02	; Compress
	dd HELPID_03	; View
	dd HELPID_06	; Extension
	dd HELPID_07	; Environ
	dd HELPID_08	; Install
	dd HELPID_09	; Tools
	dd HELPID_10	; FF
	dd HELPID_11	; List
	dd HELPID_12	; Filter
	dd HELPID_13	; Shortkey

M_WZIP  macro val, count
	db 0F0h or ((count and 0FF00h) shr 8)
	db count and 00FFh
	db val
	endm

S_OOBJ	  STRUC
ro_flag	  dw ?
ro_mem	  db ?
ro_key	  db ?
ro_rcx	  db ?
ro_rcy	  db ?
ro_rcc	  db ?
ro_rcr	  db ?
S_OOBJ	  ENDS

;******** Resource begin DZABOUT *
;	{ 0x005C,   2,	 0, {15, 7,50,10} },
;	{ 0x0000,   0, 'O', {20, 8, 8, 1} },
;	{ 0x400A,   0, 'L', {17, 5,28, 1} },
;******** Resource data  *******************
DZABOUT_RC label word
	dw	1000	    ; Alloc size
	S_OOBJ  <005Ch,1,0,15,7,50,9>
	S_OOBJ  <_O_PBUTT,0,'O',20,7,8,1>
	M_WZIP  5Ch,50
	M_WZIP  29h,50*6+20
	M_WZIP  80h,3
	db	8Dh
	M_WZIP  80h,4
	M_WZIP  25h,50*2+20
	M_WZIP  ' About',22
	M_WZIP  ' The Doszip Commander Version ',78
	db	VERSSTR,' Win32'
	M_WZIP  ' Copyright (c) 1997-2014 Hjort Nidudsson',11
	M_WZIP  ' ',11
	M_WZIP  '',39
	M_WZIP  ' Build Date - Time:',11
%	M_WZIP  ' &@Date - &@Time',2
	M_WZIP  ' OK   ',79
	db	''
	M_WZIP  ' ',42
	M_WZIP  '',8
	M_WZIP  ' ',21
;******** Resource end	 DZABOUT *

.code

view_doszip proc private f:dword, o:dword
local path[WMAXPATH]:byte
	invoke strfcat,addr path,addr configpath,f
	invoke tview,eax,o
	ret
view_doszip endp

view_readme proc
	invoke view_doszip,addr cp_doszip_txt,eax
	ret
view_readme endp

cmabout proc
	invoke rsmodal,addr DZABOUT_RC
	ret
cmabout endp

cmhelp proc uses esi edi
	.if rsopen(IDD_DZHelp)
	    mov edi,eax
	    mov [edi].S_TOBJ.to_proc[13*16],cmabout
	    mov esi,thelp
	    mov thelp,cmabout
	    .while rsevent(IDD_DZHelp,edi)
		dec eax
		mov eax,Offset_README[eax*4]
		call view_readme
	    .endw
	    invoke dlclose,edi
	    mov thelp,esi
	    mov eax,1
	.endif
	ret
cmhelp endp

	END
