
include doszip.inc
include helpid.inc
ifdef __FF__
include tview.inc
include alloc.inc
include io.inc
include iost.inc
include progress.inc
include string.inc
include syserrls.inc
include keyb.inc
include stdio.inc
include math.inc

ID_FILE		equ 13
ID_GOTO		equ 22

OF_MASK		equ 14*16
OF_PATH		equ 15*16
OF_SSTR		equ 16*16
OF_SUBD		equ 17*16
OF_CASE		equ 18*16
OF_HEXA		equ 19*16
OF_FIND		equ 20*16
OF_FILT		equ 21*16
OF_SAVE		equ 22*16
OF_GOTO		equ 23*16
OF_QUIT		equ 24*16
OF_MSUP		equ 25*16
OF_MSDN		equ 26*16
OF_GCMD		equ OF_MSUP

.data

OUTPUT_BINARY	equ 0	; Binary dump (default)
OUTPUT_TEXT	equ 1	; Convert tabs, CR/LF
OUTPUT_LINE	equ 2	; Convert tabs, break on LF

DLG_FindFile	dd 0
FCB_FindFile	dd 0

GCMD_search	label dword
GCMD KEY_F2,	event_mklist
GCMD KEY_F3,	event_view
GCMD KEY_F4,	event_edit
GCMD KEY_F5,	ffevent_filter
GCMD KEY_F6,	event_toggle_hex
GCMD KEY_F7,	event_find
GCMD KEY_F8,	event_delete
GCMD KEY_F9,	cmfilter_load
GCMD KEY_F10,	event_toggle_format
GCMD KEY_DEL,	event_delete
GCMD KEY_ALTX,  event_exit
		dd 0

ff_basedir	dd 0
cp_formatID	db '[%03d:%03d]',0
cp_format_l	db '(%u)',0

ff_directory	proto directory:dword
ff_fileblock	proto directory:dword, wfblk:dword

.code

getcurobj:
	sub eax,eax
	mov edx,FCB_FindFile
	.if [edx].S_LOBJ.ll_count
	    mov eax,[edx].S_LOBJ.ll_index
	    add eax,[edx].S_LOBJ.ll_celoff
	    mov edx,[edx].S_LOBJ.ll_list
	    lea edx,[edx+eax*4]
	    mov eax,[edx]
	.endif
	ret

getcurfile:
	.if getcurobj()
	    add eax,S_SBLK.sb_file
	.endif
	ret

putcelid:
	push	ebx
	mov	ebx,DLG_FindFile
	movzx	eax,[ebx].S_DOBJ.dl_index
	cmp	al,ID_FILE
	jb	@F
	sub	eax,eax
      @@:
	inc	eax
	mov	edx,FCB_FindFile
	add	eax,[edx].S_LOBJ.ll_index
	mov	ecx,[edx].S_LOBJ.ll_count
	mov	bx,[ebx+4]
	add	bx,0F04h
	mov	dl,bh
	invoke  scputf,ebx,edx,0,0,addr cp_formatID,eax,ecx
	pop	ebx
	ret

FFAlloc proc private uses esi edi ebx path, offs, line, ll:dword
local	fblk:dword
	invoke  strlen,path
	add	eax,BLOCKSIZE
	mov	edi,eax
	invoke  malloc,eax
	jz	toend
	mov	esi,eax
	invoke  memzero,eax,edi
	add	eax,S_SBLK.sb_file
	invoke  strcpy,eax,path
	mov	ebx,ll
	sub	edx,edx
	mov	eax,[ebx].S_LOBJ.ll_count
	invoke  progress_update,edx::eax
	mov	ecx,eax
	mov	eax,[ebx].S_LOBJ.ll_count
	inc	[ebx].S_LOBJ.ll_count
	mov	edx,[ebx].S_LOBJ.ll_count
	cmp	edx,ID_FILE
	jb	@F
	mov	edx,ID_FILE
     @@:
	mov	[ebx].S_LOBJ.ll_numcel,edx
	mov	ebx,[ebx].S_LOBJ.ll_list
	mov	[ebx+eax*4],esi
	mov	[esi].S_SBLK.sb_size,edi
	mov	eax,line
	mov	[esi].S_SBLK.sb_line,eax
	mov	eax,offs
	mov	[rsi].S_SBLK.sb_offs,eax
	mov	eax,esi
	test	ecx,ecx
	mov	ecx,edi
	jz	toend
	xor	eax,eax
  toend:
	test	eax,eax
	ret
FFAlloc endp

ffsearch proc private
	invoke  oseek,eax,SEEK_SET
	jz	error
	mov	STDI.ios_bb,eax
	or	STDI.ios_flag,IO_SEARCHCUR
	cmp	searchstring,0
	je	error
	invoke  osearch
	jnz	toend
  error:
	mov	eax,-1
  toend:
;	mov	ecx,STDI.ios_l
	ret
ffsearch endp

ff_fileblock proc private uses esi edi ebx directory:dword, wfblk:dword
local path[WMAXPATH*2]:byte
local fblk:dword
local offs:dword
local line:dword
local fbsize:dword
local ioflag:dword
local result:dword
	xor	eax,eax
	mov	offs,eax
	mov	edi,wfblk
	mov	STDI.ios_l,eax
	mov	line,eax
	mov	edx,MAXHIT
	mov	result,edx
	mov	ebx,FCB_FindFile
	cmp	[ebx].S_LOBJ.ll_count,edx
	jnb	toend
	mov	result,eax
	invoke  filter_wblk,edi
	test	eax,eax
	jz	toend
	add	edi,S_WFBLK.wf_name
	invoke  strfcat,addr path,directory,edi
	invoke  progress_set,0,edi,1
	mov	result,eax
	jnz	toend
	cmp	directory,eax
	jz	error
	invoke  cmpwarg,edi,fp_maskp
	jz	toend
	cmp	searchstring,0
	je	found
	mov	ebx,wfblk
	invoke  osopen,addr path,[ebx].S_WFBLK.wf_attrib,M_RDONLY,A_OPEN
	mov	STDI.ios_file,eax
	mov	esi,eax
	inc	eax
	;
	; @v2.33 -- continue seacrh if open fails..
	;
	jz	toend
	movqm	STDI.ios_fsize,[ebx].S_WFBLK.wf_size
	xor	eax,eax
	;
	; No search above 4G...
	;
	cmp	edx,eax
	jne	done

	mov	STDI.ios_bb,eax
	mov	STDI.ios_flag,IO_RETURNLF
	mov	STDI.ios_i,eax
	mov	STDI.ios_c,eax
	invoke  ofread
	mov	ebx,wfblk
	mov	eax,STDI.ios_c
	cmp	dword ptr STDI.ios_fsize,eax
	ja	@F
	or	STDI.ios_flag,IO_MEMBUF
     @@:
	sub	eax,eax
	mov	ebx,DLG_FindFile
	test	byte ptr [ebx+OF_CASE],_O_FLAGB
	jz	@F
	or	STDI.ios_flag,IO_SEARCHCASE
     @@:
	test	byte ptr [ebx+OF_HEXA],_O_FLAGB
	jz	search
	or	STDI.ios_flag,IO_SEARCHHEX
 search:
	invoke  ffsearch
	mov	offs,eax
	mov	line,ecx
	inc	eax
	jz	done
  found:
	invoke  FFAlloc,addr path,offs,line,FCB_FindFile
	jz	fail
	mov	fblk,eax
	mov	edi,ecx
	invoke  strlen,ff_basedir
	inc	eax
	mov	ebx,fblk
	mov	[ebx],ax
	cmp	searchstring,0
	je	toend
	invoke  oseek,offs,SEEK_SET
	mov	eax,fblk
	add	eax,edi
	sub	eax,INFOSIZE
	invoke  oreadb,eax,INFOSIZE-1
	mov	ebx,wfblk
	mov	eax,offs
	inc	eax
	cmp	eax,dword ptr STDI.ios_fsize
	jb	@F
	mov	eax,dword ptr STDI.ios_fsize
     @@:
	invoke  oseek,eax,SEEK_SET
	cmp	result,0
	jne	done
	mov	ebx,FCB_FindFile
	cmp	[ebx].S_LOBJ.ll_count,MAXHIT
	jb	search
   done:
	invoke  close,esi
  toend:
	mov	eax,result
	ret
   fail:
	invoke  close,esi
  error:
	mov	result,-1
	jmp	toend
ff_fileblock endp

ff_directory proc private directory:dword
	invoke  progress_set,0,directory,0
	jnz	@F
	invoke  scan_files,directory
     @@:
	ret
ff_directory endp

ffsearchinitpath proc private path:dword
	mov	esi,path
	mov	ah,0
	mov	dl,' '
	cmp	[esi],dl
	jne	@F
	inc	esi
     @@:
	cmp	byte ptr [esi],'"'
	jne	@F
	inc	esi
	mov	dl,'"'
     @@:
	push	esi
     @@:
	mov	al,[esi]
	test	al,al
	jz	@F
	inc	esi
	cmp	al,dl
	jne	@B
	mov	[esi-1],ah
     @@:
	pop	eax
	ret
ffsearchinitpath endp

ffsearchpath proc private uses esi edi ebx directory:dword
local path[WMAXPATH]:byte
	mov	fp_fileblock,ff_fileblock
	mov	fp_directory,ff_directory
	invoke  strcpy,addr path,directory
	mov	ff_basedir,eax
	cmp	path,0
	jne	@F
	mov	path,'"'
	inc	eax
	mov	edx,com_wsub
	invoke  strcpy,eax,[edx].S_WSUB.ws_path
     @@:
	;
	; Multi search using quotes:
	; Find Files: ["Long Name.type" *.c *.asm.......]
	; Location:   ["D:\My Documents" c: f:\doc......]
	;
	.repeat
	    invoke ffsearchinitpath,ff_basedir
	    mov ff_basedir,eax
	    push esi
	    .if strlen(ff_basedir)
		push eax
		mov ebx,ff_basedir
		dec eax
		add ebx,eax
		.if byte ptr [ebx] == '\'
		    mov byte ptr [ebx],0
		.endif
		mov ebx,DLG_FindFile
		mov edi,[ebx+OF_SUBD]
		mov eax,[ebx].S_TOBJ.to_data[OF_MASK]
		mov fp_maskp,eax
		.repeat
		    invoke ffsearchinitpath,fp_maskp
		    mov fp_maskp,eax
		    push edx
		    .if edi & _O_FLAGB
			invoke scan_directory,1,ff_basedir
		    .else
			invoke ff_directory,ff_basedir
		    .endif
		    pop edx
		    mov fp_maskp,esi
		    mov ebx,fp_maskp
		    .if dl == '"'
			mov [ebx-1],dl
		    .endif
		    .break .if !(byte ptr [ebx])
		    mov [ebx-1],dl
		.until eax
		pop eax
	    .endif
	    pop esi
	    mov ff_basedir,esi
	    .break .if !(byte ptr [esi])
	.until !eax
	ret
ffsearchpath endp

event_find proc private uses esi edi ebx
local cursor:S_CURSOR
	mov STDI.ios_size,4096		; default to _bufin
	mov STDI.ios_bp,offset _bufin
	.if malloc(20000h)		; try a big buffer..
	    mov ebx,eax
	    .if malloc(400000h)
		mov STDI.ios_bp,eax
		mov STDI.ios_size,400000h
	    .endif
	    invoke free,ebx
	.endif
	mov ebx,DLG_FindFile
	.if !([ebx].S_TOBJ.to_flag[OF_GOTO] & _O_STATE)
	    invoke cursorget,addr cursor
	    invoke cursoroff
	    mov edi,FCB_FindFile
	    mov esi,[edi].S_LOBJ.ll_count
	    mov edi,[edi].S_LOBJ.ll_list
	    .while esi
		invoke free,[edi]
		add edi,4
		dec esi
	    .endw
	    sub eax,eax
	    mov edi,FCB_FindFile
	    mov [edi].S_LOBJ.ll_celoff,eax
	    mov [edi].S_LOBJ.ll_index,eax
	    mov [edi].S_LOBJ.ll_numcel,eax
	    mov [edi].S_LOBJ.ll_count,eax
	    invoke dlinit,ebx
	    mov ax,[ebx+4]
	    add ax,0F04h
	    mov dl,ah
	    invoke scputw,eax,edx,9,00C4h
	    invoke progress_open,addr cp_search,0
	    mov eax,[ebx].S_TOBJ.to_data[OF_PATH]
	    push eax
	    invoke progress_set,eax,0,MAXHIT+2
	    call ffsearchpath
	    call progress_close
	    invoke cursorset,addr cursor
	    mov eax,[edi].S_LOBJ.ll_count
	    .if eax >= ID_FILE
		mov eax,ID_FILE
	    .endif
	    mov [edi].S_LOBJ.ll_numcel,eax
	    call update_cellid
	.endif
	.if STDI.ios_size != 4096
	    invoke free,STDI.ios_bp
	.endif
	invoke memzero,addr STDI,SIZE S_IOST
	ret
event_find endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

event_xcell:
	call	putcelid
	mov	edx,DLG_FindFile
	movzx	eax,[edx].S_DOBJ.dl_index
	mov	edx,FCB_FindFile
	mov	[edx].S_LOBJ.ll_celoff,eax
	call	dlxcellevent
	ret

event_hexa:
	call	dlcheckevent
	cmp	eax,KEY_SPACE
	je	toggle_hex
	ret

event_toggle_format:
	.if ffflag == OUTPUT_LINE
	    mov ffflag,OUTPUT_BINARY
	.elseif ffflag
	    mov ffflag,OUTPUT_LINE
	.else
	    mov ffflag,OUTPUT_TEXT
	.endif
	call	event_list
	jmp	event_normal

event_toggle_hex:
	mov	eax,DLG_FindFile
	cmp	[eax].S_DOBJ.dl_index,ID_FILE+2
	jne	event_normal
	xor	byte ptr [eax+OF_HEXA],_O_FLAGB

toggle_hex:
	mov eax,DLG_FindFile
	push [eax+OF_SSTR].S_TOBJ.to_data
	.if byte ptr [eax+OF_HEXA] & _O_FLAGB
	    call atohex
	.else
	    call hextoa
	.endif
	call event_list
	jmp event_normal

event_help:
	mov	eax,HELPID_10
	invoke  view_readme
	ret

event_edit:
	call	getcurfile
	jz	event_normal
  ifdef __TE__
	push	eax
	invoke  dlhide,DLG_FindFile
	pop	eax
	invoke  tedit,eax,[eax-8]
	invoke  dlshow,DLG_FindFile
	jmp	event_normal
  endif

event_exit:
	mov	eax,_C_ESCAPE
	ret

event_view:
	mov	eax,DLG_FindFile
	cmp	[eax].S_DOBJ.dl_index,ID_FILE
	jnb	event_normal
	call	getcurfile
	jz	event_normal
	invoke  tview,eax,[eax-4] ; .S_SBLK.sb_offs

event_normal:
	mov	eax,_C_NORMAL
	ret

ffevent_filter:
	call	cmfilter
	mov	edx,DLG_FindFile
	mov	dx,[edx+4]
	add	dx,1410h
	mov	cl,dh
	mov	eax,filter
	test	eax,eax
	mov	eax,7
	jnz	@F
	mov	al,' '
     @@:
	invoke  scputw,edx,ecx,1,eax
	jmp	event_normal

event_mklist proc private uses esi edi
	mov esi,FCB_FindFile
	sub eax,eax
	.if [esi].S_LOBJ.ll_count != eax
	    .if mklistidd()
		xor edi,edi
		.while edi < [esi].S_LOBJ.ll_count
		    mov edx,[esi].S_LOBJ.ll_list
		    mov edx,[edx+edi*4]
		    mov eax,[edx]
		    mov mklist.mkl_offspath,eax
		    mov eax,[edx].S_SBLK.sb_offs
		    mov mklist.mkl_offset,eax
		    mov eax,edx
		    add eax,S_SBLK.sb_file
		    call mklistadd
		    inc edi
		.endw
		invoke close,mklist.mkl_handle
if 0
		mov eax,cpanel
		.if panel_state()
		    invoke dlhide,DLG_FindFile
		    mov eax,cpanel
		    call panel_reread
		    invoke dlshow,DLG_FindFile
		.endif
endif
		mov eax,_C_NORMAL
	    .endif
	.endif
	ret
event_mklist endp

event_list proc private
	push	ebp
	push	esi
	push	edi
	push	ebx
	sub	esp,8
	mov	ebp,esp
	invoke  dlinit,DLG_FindFile
	mov	ebx,DLG_FindFile
	sub	eax,eax
	mov	al,[ebx].S_DOBJ.dl_rect.rc_x
	add	al,4
	mov	esi,eax
	mov	al,[ebx].S_DOBJ.dl_rect.rc_y
	mov	edi,eax
	add	edi,2
	mov	al,0
	mov	[ebp+4],eax
	.repeat
	    mov ebx,FCB_FindFile
	    .break .if eax >= [ebx].S_LOBJ.ll_numcel
	    add eax,[ebx].S_LOBJ.ll_index
	    shl eax,2
	    mov ebx,[ebx].S_LOBJ.ll_list
	    add ebx,eax
	    mov eax,[ebx]
	    mov [ebp],eax
	    mov ebx,[ebp]
	    add eax,[ebx]	; strip search directory from filename
	    mov ebx,esi
	    mov edx,[ebp+4]
	    add edx,edi
	    mov bh,dl
	    mov cl,bh
	    add eax,S_SBLK.sb_file
	    mov edx,[ebp+2]
	    invoke scpath,ebx,ecx,25,eax
	    add al,bl
	    mov ah,bh
	    mov ebx,[ebp]
	    mov ebx,[ebx].S_SBLK.sb_line
	    .if ebx
		inc ebx ; append (<line>) to filename
		mov dl,ah
		invoke scputf,eax,edx,0,7,addr cp_format_l,ebx
	    .endif
	    push esi
	    push edi
	    mov ebx,esi
	    add ebx,33
	    add di,[ebp+4]
	    mov edx,ffflag
	    mov ecx,36
	    mov esi,[ebp]
	    add esi,[esi].S_SBLK.sb_size
	    sub esi,INFOSIZE
	    .while ecx
		lodsb
		.if dl == OUTPUT_LINE && (al == 10 || al == 13)
		    .break
		.elseif dl && (al == 9 || al == 10 || al == 13)
		    mov ah,al
		    mov al,'\'
		    invoke scputc,ebx,edi,1,eax
		    inc ebx
		    .if ah == 13
			mov al,'n'
		    .elseif ah == 10
			mov al,'r'
		    .else
			mov al,'t'
		    .endif
		    dec ecx
		    .break .if !ecx
		.endif
		.if al
		    invoke scputc,ebx,edi,1,eax
		.endif
		inc ebx
		dec ecx
	    .endw
	    pop edi
	    pop esi
	    mov eax,[ebp+4]
	    inc eax
	    mov [ebp+4],eax
	.until 0
	mov eax,1
	add esp,8
	pop ebx
	pop edi
	pop esi
	pop ebp
	ret
event_list endp

update_cellid proc private uses edi ebx
	call putcelid
	call event_list
	mov ebx,DLG_FindFile
	mov edi,FCB_FindFile
	mov ecx,ID_FILE
	mov eax,_O_STATE
	.repeat
	    add ebx,16
	    or [ebx],ax
	.untilcxz
	mov ebx,DLG_FindFile
	mov eax,not _O_STATE
	mov ecx,[edi].S_LOBJ.ll_numcel
	.while ecx
	    add ebx,16
	    and [ebx],ax
	    dec ecx
	.endw
	mov eax,_C_NORMAL
	ret
update_cellid endp

event_delete proc private uses ebx
	.if getcurobj()
	    push eax
	    .repeat
		mov eax,[edx+4]
		mov [edx],eax
		add edx,4
	    .until !eax
	    call free
	    mov ebx,FCB_FindFile
	    dec [ebx].S_LOBJ.ll_count
	    mov eax,[ebx].S_LOBJ.ll_count
	    mov edx,[ebx].S_LOBJ.ll_index
	    mov ecx,[ebx].S_LOBJ.ll_celoff
	    .if ZERO?
		mov edx,eax
		mov ecx,eax
	    .else
		.if edx
		    mov ebx,eax
		    sub ebx,edx
		    .if ebx < ID_FILE
			dec edx
			inc ecx
		    .endif
		.endif
		sub eax,edx
		.if eax >= ID_FILE
		    mov eax,ID_FILE
		.endif
		.if ecx >= eax
		    dec ecx
		.endif
	    .endif
	    mov ebx,FCB_FindFile
	    mov [ebx].S_LOBJ.ll_index,edx
	    mov [ebx].S_LOBJ.ll_celoff,ecx
	    mov [ebx].S_LOBJ.ll_numcel,eax
	    mov ebx,DLG_FindFile
	    test eax,eax
	    mov al,cl
	    .if ZERO?
		mov al,ID_FILE
	    .endif
	    mov [ebx].S_DOBJ.dl_index,al
	    call update_cellid
	.endif
	mov eax,_C_NORMAL
	ret
event_delete endp

FFOpen proc private ll:dword
	invoke memzero,ll,SIZE S_LOBJ
	mov [eax].S_LOBJ.ll_dcount,ID_FILE
	mov [eax].S_LOBJ.ll_proc,event_list
	invoke malloc,(MAXHIT*4)+4
	mov edx,ll
	mov [edx].S_LOBJ.ll_list,eax
	.if eax
	    invoke memzero,eax,(MAXHIT*4)+4
	    mov eax,ecx
	    inc eax
	.endif
	ret
FFOpen  endp

FFClose proc private uses esi edi ll:dword
	mov esi,ll
	mov eax,[esi].S_LOBJ.ll_list
	.if eax
	    xor edi,edi
	    .while edi < [esi].S_LOBJ.ll_count
		mov eax,[esi].S_LOBJ.ll_list
		invoke free,[eax+edi*4]
		inc edi
	    .endw
	    invoke free,[esi].S_LOBJ.ll_list
	    xor eax,eax
	    mov [esi].S_LOBJ.ll_list,eax
	.endif
	ret
FFClose endp

FindFile proc uses esi edi ebx wspath:dword, ll_off:dword
local sbfile:dword
local cursor:S_CURSOR
local oldll:dword
local ll:S_LOBJ
	push thelp
	mov thelp,event_help
	sub esi,esi		; returned value
	mov eax,FCB_FindFile
	mov oldll,eax
	mov eax,ll_off
	mov FCB_FindFile,eax
	.if !eax
	    lea eax,ll
	    mov FCB_FindFile,eax
	    invoke FFOpen,eax
	    jz findfile_nomem
	.endif
	invoke clrcmdl
	invoke cursorget,addr cursor
	invoke rsopen,IDD_DZFindFile
	jz findfile_somem
	mov DLG_FindFile,eax
	mov ebx,eax
	mov [ebx].S_TOBJ.to_data[OF_GCMD],offset GCMD_search
	lea eax,findfilemask
	mov [ebx].S_TOBJ.to_data[OF_MASK],eax
	.if byte ptr [eax] == 0
	    invoke strcpy,eax,addr cp_stdmask
	.endif
	mov esi,offset searchstring
	mov [ebx].S_TOBJ.to_data[OF_SSTR],esi
	.if ll_off
	    invoke strcpy,[ebx].S_TOBJ.to_data[OF_PATH],wspath
	.else
	    mov eax,wspath
	    mov [ebx].S_TOBJ.to_data[OF_PATH],eax
	.endif
	mov [ebx].S_TOBJ.to_proc[OF_HEXA],event_hexa
	mov [ebx].S_TOBJ.to_proc[OF_FIND],event_find
	mov [ebx].S_TOBJ.to_proc[OF_FILT],ffevent_filter
	mov [ebx].S_TOBJ.to_proc[OF_SAVE],event_mklist
	mov ah,byte ptr fsflag
	mov al,_O_FLAGB
	.if ah & IO_SEARCHCASE
	    or [ebx+OF_CASE],al
	.endif
	.if ah & IO_SEARCHHEX
	    or [ebx+OF_HEXA],al
	.endif
	.if ah & IO_SEARCHSUB
	    or [ebx+OF_SUBD],al
	.endif
	lea edx,[ebx].S_TOBJ.to_proc[SIZE S_TOBJ]
	mov ecx,ID_FILE
	mov eax,event_xcell
	.repeat
	    mov [edx],eax
	    add edx,SIZE S_TOBJ
	.untilcxz
	invoke dlshow,ebx
	invoke dlinit,ebx
	mov filter,0
	mov eax,FCB_FindFile
	mov tdllist,eax
	.if ll_off
	    mov eax,_O_STATE
	    or [ebx+OF_FIND],ax
	    or [ebx+OF_GOTO],ax
	    invoke update_cellid
	.endif
	.while rsevent(IDD_DZFindFile,ebx)
	    mov esi,eax
	    mov edi,ecx
	    mov al,[ebx].S_DOBJ.dl_index
	    .if al < ID_FILE
		call event_view
		.break .if eax != _C_NORMAL
	    .elseif al == ID_GOTO
		.break
	    .elseif !ll_off
		invoke event_find
	    .endif
	.endw
	mov ah,byte ptr fsflag
	and ah,not (IO_SEARCHCASE or IO_SEARCHSUB or IO_SEARCHHEX)
	mov al,_O_FLAGB
	.if [ebx+OF_CASE] & al
	    or ah,IO_SEARCHCASE
	.endif
	.if [ebx+OF_HEXA] & al
	    or ah,IO_SEARCHHEX
	.endif
	.if [ebx+OF_SUBD] & al
	    or ah,IO_SEARCHSUB
	.endif
	mov byte ptr fsflag,ah
	movzx eax,[ebx].S_DOBJ.dl_index
	invoke dlclose,ebx
	.if edx == ID_GOTO
	    mov ebx,FCB_FindFile
	    .if [ebx].S_LOBJ.ll_count
		mov eax,cpanel
		.if panel_state()
		    mov eax,[ebx].S_LOBJ.ll_index
		    add eax,[ebx].S_LOBJ.ll_celoff
		    mov ebx,[ebx].S_LOBJ.ll_list
		    mov eax,[ebx+eax*4]
		    add eax,S_SBLK.sb_file
		    mov sbfile,eax
		    .if strrchr(eax,'\')
			mov byte ptr [eax],0
			mov eax,sbfile
			invoke cpanel_setpath
		    .endif
		.endif
	    .endif
	.endif
	invoke  FFClose,FCB_FindFile
    findfile_end:
	pop	eax
	mov	thelp,eax
	mov	eax,oldll
	mov	FCB_FindFile,eax
	invoke  cursorset,addr cursor
	mov	eax,esi		; Exit code
	mov	ecx,edi		; Exit key
	ret
    findfile_somem:
	invoke  FFClose,FCB_FindFile
    findfile_nomem:
	mov	esi,-1
	invoke  ermsg,0,addr CP_ENOMEM
	jmp	findfile_end
FindFile endp

cmsearch proc
	invoke FindFile,addr findfilepath,0
	ret
cmsearch endp
endif
	end
