include doszip.inc
include io.inc
include progress.inc
include stdlib.inc
include conio.inc
include string.inc
include math.inc

.data
cp_subsize	db "Directory Information",0
qrax		label qword
qeax		dd 0
qedx		dd 0
di_subdcount	dd 0
di_filecount	dd 0
cp_bytesize	db "BKMGTPE",0

.code

di_fileblock proc private directory:dword, wblk:dword
	inc di_filecount
	mov eax,directory
	.if eax
	    mov edx,wblk
	    add edx,S_WFBLK.wf_name
	    .if !progress_set(edx,eax,eax::eax)
		mov ecx,wblk
		mov eax,dword ptr [ecx].S_WFBLK.wf_size
		mov edx,dword ptr [ecx].S_WFBLK.wf_size[4]
		add qeax,eax
		adc qedx,edx
		sub eax,eax
	    .endif
	.endif
	ret
di_fileblock endp

di_directory proc private directory:dword
	invoke strlen,directory
	mov edx,directory
	add edx,eax
	mov eax,'\'
	dec edx
	.if [edx] == al
	    mov [edx],ah
	.endif
	.if !progress_set(0,directory,0)
	    inc di_subdcount
	    invoke scan_files,directory
	.endif
	ret
di_directory endp

di_Init proc private
	sub	eax,eax
	mov	qeax,eax
	mov	qedx,eax
	mov	di_filecount,eax
	mov	di_subdcount,eax
	ret
di_Init endp

di_ReadDirectory proc private
	push	eax
	invoke  progress_open,addr cp_subsize,0
	mov	fp_maskp,offset cp_stdmask
	mov	fp_fileblock,di_fileblock
	mov	fp_directory,di_directory
	pop	eax
	invoke  scan_directory,1,eax
	invoke  progress_close
	test	eax,eax
	ret
di_ReadDirectory endp

di_SubInfo proc private uses esi edi ebx s1:dword, s2:dword
local x,y,col:dword
	.if rsopen(IDD_DZSubInfo)
	    mov	   edi,eax
	    movzx  eax,[edi].S_DOBJ.dl_rect.rc_x
	    add	   eax,5
	    mov	   x,eax
	    movzx  eax,[edi].S_DOBJ.dl_rect.rc_y
	    add	   eax,2
	    mov	   y,eax
	    movzx  eax,[edi].S_DOBJ.dl_rect.rc_col
	    mov	   col,eax
	    invoke wctitle,[edi].S_DOBJ.dl_wp,eax,s2
	    invoke dlshow,edi
	    mov	   edx,y
	    mov	   ecx,x
	    invoke scputs,ecx,edx,0,0,"Location:"
	    add	   cl,10
	    invoke scpath,ecx,edx,20,s1
	    sub	   cl,11
	    inc	   edx
	    mov	   eax,di_subdcount
	    dec	   eax
	    invoke scputf,ecx,edx,0,0,"%10u Files\n%10u Directories",di_filecount,eax
	    invoke mkbstring,s1,qrax
	    mov	   ebx,eax
	    mov	   esi,edx
	    mov	   edx,y
	    mov	   ecx,x
	    add	   ecx,1
	    add	   edx,4
	    invoke scputf,ecx,edx,0,0,"total %s byte",s1
	    .if ebx && esi
		mov al,cp_bytesize[esi]
		add ecx,6
		inc edx
		invoke scputf,ecx,edx,0,0,"%u%c",ebx,eax
	    .endif
	    invoke dlmodal,edi
	.endif
	ret
di_SubInfo endp

di_SelectedFiles proc private uses esi edi s1:dword
	inc di_subdcount
	sub esi,esi
	.repeat
	    mov eax,1
	    mov edx,cpanel
	    .break .if esi >= [edx].S_PANEL.pn_fcb_count
	    mov eax,[esi*4+4]
	    mov ecx,[eax]
	    inc esi
	    .continue .if !(ecx &_FB_SELECTED)
	    .if ecx & _A_SUBDIR
		mov edx,cpanel
		mov edx,[edx].S_PANEL.pn_wsub
		add eax,S_FBLK.fb_name
		invoke strfcat,s1,[edx].S_WSUB.ws_path,eax
		invoke di_ReadDirectory
		.break .if eax
	    .else
		mov edx,dword ptr [eax].S_FBLK.fb_size[4]
		mov eax,dword ptr [eax].S_FBLK.fb_size
		add qeax,eax
		adc qedx,edx
		inc di_filecount
	    .endif
	.until 0
	.if eax
	    mov eax,cpanel
	    mov eax,[eax].S_PANEL.pn_wsub
	    invoke strcpy,s1,[eax].S_WSUB.ws_path
	    invoke di_SubInfo,eax,"Selected Files"
	.endif
	ret
di_SelectedFiles endp

di_cmSubInfo proc private uses esi edi ebx panel:dword
local path[WMAXPATH]:byte
	mov esi,panel
	lea edi,path
	mov eax,esi
	.if panel_state()
	    mov ebx,[esi]
	    mov eax,[ebx]
	    .if !(eax & _W_ARCHIVE or _W_ROOTDIR)
		invoke di_Init
		mov eax,esi
		.if panel_findnext()
		    invoke di_SelectedFiles,edi
		.else
		    mov ebx,[esi].S_PANEL.pn_wsub
		    invoke strcpy,edi,[ebx].S_WSUB.ws_path
		    invoke di_ReadDirectory
		    .if !eax
			invoke di_SubInfo,edi,addr cp_subsize
		    .endif
		.endif
	    .else
		sub eax,eax
	    .endif
	.endif
	ret
di_cmSubInfo endp

cmsubinfo proc
	invoke di_cmSubInfo,cpanel
	ret
cmsubinfo endp

cmasubinfo proc
	invoke di_cmSubInfo,panela
	ret
cmasubinfo endp

cmbsubinfo proc
	invoke di_cmSubInfo,panelb
	ret
cmbsubinfo endp

cmsubsize proc
local path[WMAXPATH]:byte
	invoke di_Init
	mov eax,cpanel
	.if panel_curobj()
	    .if !(ecx & _FB_ARCHIVE or _FB_UPDIR)
		mov edx,cpanel
		mov edx,[edx].S_PANEL.pn_wsub
		mov ecx,eax
		invoke strfcat,addr path,[edx].S_WSUB.ws_path,ecx
		.if !di_ReadDirectory()
		    invoke di_SubInfo,addr path,addr cp_subsize
		.endif
	    .endif
	.endif
	sub eax,eax
	ret
cmsubsize endp

	END
