include doszip.inc
include string.inc
include keyb.inc

externdef	IDD_DZHistory:dword

.data
doskey_bindex	db 0
doskey_isnext	db 0

.code

doskeysave proc uses ebx
	.if strtrim(addr com_base)
	    mov eax,history
	    .if eax
		lea eax,[eax].S_HISTORY.h_doskey
		mov ebx,eax
		mov doskey_bindex,0
		mov doskey_isnext,0
		.if strcmp(addr com_base,eax)
		    lea eax,[ebx+MAXDOSKEY]
		    invoke memmove,eax,ebx,MAXDOSKEY*(MAXDOSKEYS-1)
		    invoke strcpy,ebx,addr com_base
		.endif
		mov eax,1
	    .endif
	.endif
	ret
doskeysave endp

doskeytocommand proc private
	mov	eax,history
	lea	eax,[eax].S_HISTORY.h_doskey
	sub	ecx,ecx
	mov	ch,doskey_bindex
	shr	ecx,1
	add	eax,ecx
	invoke  strcpy,addr com_base,eax
	ret
doskeytocommand endp

CommandlineVisible:
	mov eax,DLG_Commandline
	mov eax,[eax]
	and eax,_D_ONSCR
	ret

cmdoskeyup proc
	.if CommandlineVisible()
	    mov al,1
	    .if doskey_isnext == al
		mov com_base,ah
	    .else
		invoke doskeytocommand
		inc doskey_bindex
		.if doskey_bindex >= MAXDOSKEYS
		    mov doskey_bindex,0
		.endif
	    .endif
	    invoke comevent,KEY_END
	    mov eax,1
	    mov doskey_isnext,ah
	.endif
	ret
cmdoskeyup endp

cmdoskeydown proc
	.if CommandlineVisible()
	    sub eax,eax
	    .if doskey_isnext == al
		mov com_base,al
	    .else
		.if doskey_bindex == al
		    mov doskey_bindex,MAXDOSKEYS-1
		.else
		    dec doskey_bindex
		.endif
		invoke doskeytocommand
	    .endif
	    invoke comevent,KEY_END
	    mov eax,1
	    mov doskey_isnext,al
	.endif
	ret
cmdoskeydown endp

cmhistory proc uses esi edi ebx
	.if CommandlineVisible()
	    .if rsopen(IDD_DZHistory)
		mov ebx,eax
		mov edi,history
		add edi,S_HISTORY.h_doskey
		lea eax,[eax+16]
		mov edx,not _O_STATE
		sub ecx,ecx
		.repeat
		    mov [eax].S_TOBJ.to_data,edi
		    .break .if byte ptr [edi] == 0
		    and [eax],dx
		    add eax,SIZE S_TOBJ
		    add edi,MAXDOSKEY
		    inc ecx
		.until ecx == MAXDOSKEYS
		mov [ebx].S_DOBJ.dl_count,cl
		mov al,doskey_bindex
		mov [ebx].S_DOBJ.dl_index,al
		.if al >= cl
		    mov [ebx].S_DOBJ.dl_index,ch
		.endif
		invoke dlinit,ebx
		invoke rsevent,IDD_DZHistory,ebx
		invoke dlclose,ebx
		mov eax,edx
		.if eax
		    dec eax
		    mov doskey_bindex,al
		    inc eax
		    shl eax,4
		    invoke strcpy,addr com_base,[ebx+eax].S_TOBJ.to_data
		    invoke comevent,KEY_END
		    mov eax,1
		.endif
	    .endif
	.endif
	ret
cmhistory endp

	END
