include doszip.inc
ifdef __DLL__
include io.inc
include ini.inc
include string.inc
include keyb.inc
include alloc.inc
include dll.inc

public  dll_active

MAXDLL		equ 32

externdef	ti_keytable:dword
tview		proto :dword, :dword

.data

S_PLUGIN	STRUC
p_flag		dd ?
p_handle	dd ?
p_dllname	dd ?
p_title		dd ?
S_PLUGIN	ENDS

dll_count	dd 0
dll_table	S_PLUGIN MAXDLL dup(<0,0,0,0>)
dll_active	dd -1
cp_dllcall	db "DLL_CALL",0
cp_dllmask	db "*.dll",0
cp_plugins	db "plugins",0
dll_args	dd offset dll_count
		dd offset memseg
		dd offset keyshift
		dd offset programpath
		dd offset ti_keytable
		dd offset global_key
		dd topen
		dd tmodal
		dd tclose
		dd tview
		dd mousep

.code

calldll proc private h, i, a1, a2, a3, a4:dword
	.if GetProcAddress(h,addr cp_dllcall)
	    invoke dllcall ptr eax,i,a1,a2,a3,a4
	.else
	    dec eax
	.endif
	ret
calldll endp

dll_test proc uses esi edi ebx fblk, signature:dword
	lea esi,dll_table
	sub edi,edi
	sub ebx,ebx
	mov dll_active,ebx
	.while edi < dll_count
	    .if [esi].S_PLUGIN.p_flag & _DLLF_TEST
		.if calldll([esi].S_PLUGIN.p_handle,_DLL_TEST,fblk,signature,0,0) == 1
		    mov dll_active,esi
		.endif
		.if eax
		    mov ebx,eax
		    .break
		.endif
	    .endif
	    add esi,SIZE S_PLUGIN
	    inc edi
	.endw
	mov eax,ebx
	ret
dll_test endp

dll_call proc func, a1, a2, a3, a4:dword
	mov eax,dll_active
	.if eax
	    mov eax,[eax].S_PLUGIN.p_handle
	    invoke calldll,eax,func,a1,a2,a3,a4
	.endif
	ret
dll_call endp

LoadPlugin proc private uses esi edi ebx DLLFile:ptr sbyte
	mov edi,dll_count
	lea esi,dll_table
	.while edi
	    invoke strfn,[esi].S_PLUGIN.p_dllname
	    mov edx,eax
	    invoke strfn,DLLFile
	    .if !stricmp(eax,edx)
		jmp @F
	    .endif
	    add esi,SIZE S_PLUGIN
	    dec edi
	.endw
	.if LoadLibraryA(DLLFile)
	    mov edi,eax
	    sub ebx,ebx
	    .if sdword ptr calldll(edi,_DLL_VERSION,0,0,0,0) >= MINDLLV
		.if dll_count < MAXDLL
		    .if sdword ptr calldll(edi,_DLL_INIT,addr dll_args,0,0,0) > 0
			mov esi,dll_count
			inc dll_count
			shl esi,4
			add esi,offset dll_table
			mov [esi].S_PLUGIN.p_flag,eax
			mov [esi].S_PLUGIN.p_handle,edi
			invoke salloc,DLLFile
			mov [esi].S_PLUGIN.p_dllname,eax
			inc ebx
		    .endif
		.endif
	    .endif
	    .if !ebx
		invoke FreeLibrary,edi
	    .endif
	    mov eax,ebx
	.endif
     @@:
	ret
LoadPlugin endp

FreePlugin proc private uses esi edi ebx Plugin:ptr S_PLUGIN
	mov edi,Plugin
	mov eax,dll_active
	.if edi == eax
	    sub eax,eax
	.elseif eax > edi
	    sub eax,SIZE S_PLUGIN
	.endif
	mov dll_active,eax
	mov ebx,[edi].S_PLUGIN.p_handle
	invoke calldll,ebx,_DLL_EXIT,0,0,0,0
	push eax
	invoke FreeLibrary,ebx
	invoke free,[edi].S_PLUGIN.p_dllname
	mov eax,dll_count
	dec dll_count
	shl eax,4
	add eax,offset dll_table
	sub eax,edi
	shr eax,2
	lea esi,[edi+SIZE S_PLUGIN]
	mov ecx,eax
	rep movsd
	pop eax
	.if eax
	    mov ebx,dll_count
	    lea esi,dll_table
	    .while ebx
		invoke calldll,[esi].S_PLUGIN.p_handle,_DLL_LINK,eax,0,0,0
		add esi,SIZE S_PLUGIN
		dec ebx
	    .endw
	.endif
	ret
FreePlugin endp

readplugins proc uses esi
local path[WMAXPATH]:byte
local rmask[WMAXPATH]:byte
local fb:S_WFBLK
	invoke strfcat,addr path,addr configpath,addr cp_plugins
	invoke strfcat,addr rmask,eax,addr cp_dllmask
	invoke wfindfirst,addr rmask,addr fb,_A_STDFILES
	mov esi,eax
	inc eax
	.if eax
	    .repeat
		invoke strfcat,addr rmask,addr path,addr fb.wf_name
		invoke LoadPlugin,eax
		invoke wfindnext,addr fb,esi
	    .until eax
	    invoke wcloseff,esi
	.endif
	ret
readplugins endp

freeplugins proc uses esi
	mov esi,dll_count
	.while esi
	    dec esi
	    mov eax,esi
	    shl eax,4
	    add eax,offset dll_table
	    invoke FreePlugin,eax
	    .break .if esi != dll_count
	.endw
	ret
freeplugins endp

.data

MAXDLGOBJECT	equ 16  ; visible plugins on screen
MAXOBJECTLEN	equ 38  ; size of line on screen
ID_FREE		equ 17  ; Child: Unload current DLL and exit
ID_INFO		equ 18  ; Child: display About Box from DLL
ID_READ		equ 19  ; Child: load all plugins
ID_QUIT		equ 20  ; KEY_Plugins
DLG_Plugins	dd ?
FCB_Plugins	dd ?

.code

cmplugins proc uses esi edi ebx
local ll:S_LOBJ
local pl[MAXDLL]:dword
local KEY_Plugins[9]:dword
	lea eax,ll
	mov FCB_Plugins,eax
	invoke memzero,eax,SIZE S_LOBJ
	lea edi,pl
	mov ll.ll_list,edi
	mov ll.ll_dcount,MAXDLGOBJECT	; number of cells (max)
	mov ll.ll_proc,event_list
	lea esi,dll_table
	mov ecx,MAXDLL
	.repeat
	    mov [edi],esi
	    add edi,4
	    add esi,SIZE S_PLUGIN
	.untilcxz
	mov eax,dll_count
	mov ll.ll_count,eax
	.if eax >= MAXDLGOBJECT
	    mov eax,MAXDLGOBJECT
	.endif
	mov ll.ll_numcel,eax
	.if rsopen(IDD_DZPlugins)
	    mov DLG_Plugins,eax
	    mov esi,eax
	    mov edx,eax
	    mov ecx,MAXDLGOBJECT
	    mov eax,event_xcell
	    .repeat
		add edx,SIZE S_TOBJ
		mov [edx].S_TOBJ.to_proc,eax
	    .untilcxz
	    lea edi,KEY_Plugins
	    mov [edx].S_TOBJ.to_data[64],edi
	    mov eax,KEY_F2
	    stosd
	    mov eax,event_free
	    mov [edx].S_TOBJ.to_proc[16],eax
	    stosd
	    mov eax,KEY_F3
	    stosd
	    mov eax,event_info
	    mov [edx].S_TOBJ.to_proc[32],eax
	    stosd
	    mov eax,KEY_F4
	    stosd
	    mov eax,event_read
	    mov [edx].S_TOBJ.to_proc[48],eax
	    stosd
	    sub eax,eax
	    stosd
	    invoke dlshow,esi
	    call event_list
	    .while dllevent(esi,addr ll)
		call event_info
	    .endw
	    mov dx,[esi+4]
	    mov eax,IDD_DZPlugins
	    mov [eax+6],dx
	    invoke dlclose,esi
	    sub eax,eax
	.endif
	ret
event_xcell:
	mov	eax,DLG_Plugins
	movzx	eax,[eax].S_DOBJ.dl_index
	mov	edx,FCB_Plugins
	mov	[edx].S_LOBJ.ll_celoff,eax
	call	dlxcellevent
	retn
event_list:
	push esi
	push ebx
	mov esi,DLG_Plugins
	invoke dlinit,esi
	lea eax,[esi+SIZE S_TOBJ]
	mov ecx,MAXDLGOBJECT
	.repeat
	    or [eax].S_TOBJ.to_flag,_O_STATE
	    lea eax,[eax+SIZE S_TOBJ]
	.untilcxz
	mov bx,[esi+4]		;.S_DOBJ.dl_rect.rc_x
	add bx,0204h
	mov eax,FCB_Plugins
	mov ecx,[eax].S_LOBJ.ll_numcel
	mov eax,[eax].S_LOBJ.ll_index
	shl eax,4
	add eax,offset dll_table
	mov edx,eax
	.while ecx
	    mov al,bh
	    invoke scpath,ebx,eax,MAXOBJECTLEN,[edx].S_PLUGIN.p_dllname
	    lea edx,[edx+SIZE S_PLUGIN]
	    lea esi,[esi+SIZE S_TOBJ]
	    and [esi].S_TOBJ.to_flag,not _O_STATE
	    inc bh
	    dec ecx
	.endw
	mov eax,1
	pop ebx
	pop esi
	retn
event_get_plugin:
	sub eax,eax
	mov ecx,FCB_Plugins
	.if [ecx].S_LOBJ.ll_count
	    mov eax,[ecx].S_LOBJ.ll_index
	    add eax,[ecx].S_LOBJ.ll_celoff
	    mov ecx,[ecx].S_LOBJ.ll_list
	    mov ecx,[ecx+eax*4]
	    mov eax,[ecx].S_PLUGIN.p_handle
	.endif
	retn
event_free:
	.if event_get_plugin()
	    invoke FreePlugin,ecx
	    call event_updlist
	    .if dll_count
		jmp event_setindex
	    .endif
	    mov eax,DLG_Plugins
	    mov [eax].S_DOBJ.dl_index,ID_READ-1
	.endif
	jmp event_normal
event_info:
	.if event_get_plugin()
	    invoke calldll,eax,_DLL_ABOUT,0,0,0,0
	    jmp event_setindex
	.endif
	jmp event_normal
event_setindex:
	mov eax,FCB_Plugins
	mov eax,[eax].S_LOBJ.ll_celoff
	mov ecx,DLG_Plugins
	mov [ecx].S_DOBJ.dl_index,al
event_normal:
	mov eax,_C_NORMAL
	retn
event_read:
	call readplugins
event_updlist:
	push ebx
	mov ebx,FCB_Plugins
	mov eax,dll_count
	mov [ebx].S_LOBJ.ll_count,eax
	.if eax >= MAXDLGOBJECT
	    mov eax,MAXDLGOBJECT
	.endif
	mov [ebx].S_LOBJ.ll_numcel,eax
	mov edx,[ebx].S_LOBJ.ll_index
	mov ecx,[ebx].S_LOBJ.ll_celoff
	.if eax
	    inc edx
	    .repeat
		.if edx
		    dec edx
		.else
		    dec ecx
		.endif
		mov eax,edx
		add eax,ecx
	    .until eax < [ebx].S_LOBJ.ll_count
	.else
	    mov edx,eax
	    mov ecx,eax
	    mov eax,DLG_Plugins
	    mov [eax].S_DOBJ.dl_index,ID_READ-1
	.endif
	mov [ebx].S_LOBJ.ll_index,edx
	mov [ebx].S_LOBJ.ll_celoff,ecx
	pop ebx
	invoke dlinit,DLG_Plugins
	call event_list
	jmp event_normal
cmplugins endp

endif ; __DLL__
	end
