include doszip.inc
include string.inc
include keyb.inc
include syserrls.inc
include io.inc

ID_MPANELA	equ 0
ID_MFILE	equ 1
ID_MEDIT	equ 2
ID_MSETUP	equ 3
ID_MTOOLS	equ 4
ID_MHELP	equ 5
ID_MPANELB	equ 6

MENUSCMD	equ -1

.data

CPW_PANELA	db 'Panel-&A',0
CPW_FILE	db '&File',0
CPW_EDIT	db '&'
cp_edit		db 'Edit',0
CPW_SETUP	db '&Setup',0
CPW_TOOLS	db '&'
cp_tools	db 'Tools',0
CPW_HELP	db '&'
cp_help		db 'Help',0
CPW_PANELB	db 'Panel-&B',0

cp_long		db 'Long/short filename',0
cp_detail	db 'Show detail',0
cp_wideview	db 'Wide view',0
cp_hidden	db 'Show hidden files',0
cp_mini		db 'Ministatus',0
cp_volinfo	db 'Volume information',0
cp_sort		db 'Sort current panel by Name, '
		db 'Type, Time, Size, or Unsorted',0
cp_toggle	db 'Toggle panel - on/off',0
cp_pfilter	db 'Panel filter',0
cp_subinfo	db 'Directory information',0
cp_update	db 'Re-read',0
cp_chdrv	db 'Select drive',0
cp_rename	db 'Rename file or directory',0
cp_view		db 'View File or Directory information',0
cp_copy		db 'Copy',0
cp_move		db 'Move',0
cp_delete	db 'Delete',0
cp_blkprop	db 'Edit file property',0
cp_compress	db 'Compress',0
cp_decompress	db 'Decompress',0
cp_history	db 'List of the last 16 DOS commands',0
cp_memory	db 'Memory Information',0
cp_search	db 'Search',0
cp_exit		db 'Exit program',0
cp_select	db 'Select files',0
cp_deselect	db 'Deselect files',0
cp_invert	db 'Invert selection',0
cp_mklist	db 'Create List File from selection',0
cp_qsearch	db 'Quick Search',0
cp_compare	db 'Compare directories',0
cp_toggleml	db 'Toggle Menus line - on/off',0
cp_togglecl	db 'Toggle Command line - on/off',0
cp_togglesl	db 'Toggle Status line - on/off',0
cp_toggleon	db 'Toggle panels - on/off',0
cp_togglehz	db 'Toggle panels - horizontal/vertical',0
cp_togglesz	db 'Toggle Panels - size',0
cp_egaline	db 'Toggle 25-50 lines',0
cp_swappanels	db 'Swap panels',0
cp_confirm	db 'Confirmations options',0
cp_screen	db 'Screen options',0
cp_panel	db 'Panel options',0
cp_config	db 'Configuration',0
cp_about	db 'About Doszip',0
ifdef __DLL__
cp_plugins	db 'Installed Plugins',0
endif

menus_idd	dd 0
menus_obj	dd 0
menus_xtitle	dd 11,8,8,9,9,8,11
menus_xpos	dd 0,10,17,24,32,40,47
menus_iddtable  dd 7 dup(0)

MENUS_PANELA	label	dword
	GCMD	<offset cp_long>,	cmalong
	GCMD	<offset cp_detail>,	cmadetail
	GCMD	<offset cp_wideview>,	cmawideview
	GCMD	<offset cp_hidden>,	cmahidden
	GCMD	<offset cp_mini>,	cmamini
	GCMD	<offset cp_volinfo>,	cmavolinfo
	GCMD	<offset cp_sort>,	cmaname
	GCMD	<offset cp_sort>,	cmatype
	GCMD	<offset cp_sort>,	cmadate
	GCMD	<offset cp_sort>,	cmasize
	GCMD	<offset cp_sort>,	cmanosort
	GCMD	<offset cp_toggle>,	cmatoggle
	GCMD	<offset cp_pfilter>,	cmafilter
	GCMD	<offset cp_subinfo>,	cmasubinfo
	GCMD	<offset cp_update>,	cmaupdate
	GCMD	<offset cp_chdrv>,	cmachdrv

MENUS_FILE label dword
	GCMD	<offset cp_rename>,	cmrename
	GCMD	<offset cp_view>,	cmview
	GCMD	<offset cp_edit>,	cmedit
	GCMD	<offset cp_copy>,	cmcopy
	GCMD	<offset cp_move>,	cmmove
	GCMD	<offset cp_mkdir>,	cmmkdir
	GCMD	<offset cp_delete>,	cmdelete
	GCMD	<offset cp_blkprop>,	cmattrib
  ifdef __ARC__
	GCMD	<offset cp_compress>,	cmcompress
	GCMD	<offset cp_decompress>, cmdecompress
	GCMD	<offset cp_mkzip>,	cmmkzip
  else
	GCMD	<offset cp_compress>,	notsup
	GCMD	<offset cp_decompress>, notsup
	GCMD	<offset CP_EAGAIN>,	notsup
  endif
  ifdef __FF__
	GCMD	<offset cp_search>,	cmsearch
  else
	GCMD	<offset cp_search>,	notsup
  endif
	GCMD	<offset cp_history>,	cmhistory
	GCMD	<offset cp_memory>,	cmmemory
	GCMD	<offset cp_exit>,	cmexit

MENUS_EDIT label dword
	GCMD	<offset cp_select>,	cmselect
	GCMD	<offset cp_deselect>,	cmdeselect
	GCMD	<offset cp_invert>,	cminvert
	GCMD	<offset cp_mklist>,	cmmklist
	GCMD	<offset cp_qsearch>,	cmquicksearch
	GCMD	<offset cp_compare>,	cmcompare

MENUS_SETUP label dword
	GCMD	<offset cp_toggleml>,	cmxormenubar
	GCMD	<offset cp_toggleon>,	cmtoggleon
	GCMD	<offset cp_togglesz>,	cmtogglesz
	GCMD	<offset cp_togglehz>,	cmtogglehz
	GCMD	<offset cp_togglecl>,	cmxorcmdline
	GCMD	<offset cp_togglesl>,	cmxorkeybar
	GCMD	<offset cp_egaline>,	cmegaline
	GCMD	<offset cp_swappanels>, cmswap
  ifdef __DLL__
	GCMD	<offset cp_plugins>,	cmplugins
  else
	GCMD	<offset cp_config>,	notsup
  endif
	GCMD	<offset cp_confirm>,	cmconfirm
	GCMD	<offset cp_panel>,	cmpanel
	GCMD	<offset cp_config>,	cmcompression
  ifdef __TE__
	GCMD	<offset cp_config>,	teoption
  else
	GCMD	<offset cp_config>,	notsup
  endif
	GCMD	<offset cp_screen>,	cmscreen
	GCMD	<offset cp_config>,	cmsystem
	GCMD	<offset cp_config>,	cmoptions

MENUS_HELP label dword
	GCMD	<offset cp_help>,	cmhelp
	GCMD	<offset cp_about>,	cmabout

MENUS_PANELB label dword
	GCMD	<offset cp_long>,	cmblong
	GCMD	<offset cp_detail>,	cmbdetail
	GCMD	<offset cp_wideview>,	cmbwideview
	GCMD	<offset cp_hidden>,	cmbhidden
	GCMD	<offset cp_mini>,	cmbmini
	GCMD	<offset cp_volinfo>,	cmbvolinfo
	GCMD	<offset cp_sort>,	cmbname
	GCMD	<offset cp_sort>,	cmbtype
	GCMD	<offset cp_sort>,	cmbdate
	GCMD	<offset cp_sort>,	cmbsize
	GCMD	<offset cp_sort>,	cmbnosort
	GCMD	<offset cp_toggle>,	cmbtoggle
	GCMD	<offset cp_pfilter>,	cmbfilter
	GCMD	<offset cp_subinfo>,	cmbsubinfo
	GCMD	<offset cp_update>,	cmbupdate
	GCMD	<offset cp_chdrv>,	cmbchdrv

menus_oid label dword
	dd	offset MENUS_PANELA
	dd	offset MENUS_FILE
	dd	offset MENUS_EDIT
	dd	offset MENUS_SETUP
	dd	0
	dd	offset MENUS_HELP
	dd	offset MENUS_PANELB

menus_shortkeys label dword
	dd	1E00h	; A Panel-A
	dd	2100h	; F File
	dd	1200h	; E Edit
	dd	1F00h	; S Setup
	dd	1400h	; T Tools
	dd	2300h	; H Help
	dd	3000h	; B Panel-B

menus_TOBJ label S_TOBJ
	S_TOBJ  <0006h,0,1Eh,< 0,0,11,1>,CPW_PANELA,0>
	S_TOBJ  <0006h,0,21h,<10,0,10,1>,CPW_FILE,0>
	S_TOBJ  <0006h,0,12h,<17,0, 8,1>,CPW_EDIT,0>
	S_TOBJ  <0006h,0,1Fh,<24,0,10,1>,CPW_SETUP,0>
	S_TOBJ  <0006h,0,14h,<32,0, 9,1>,CPW_TOOLS,0>
	S_TOBJ  <0006h,0,23h,<40,0, 8,1>,CPW_HELP,0>
	S_TOBJ  <0006h,0,30h,<47,0,11,1>,CPW_PANELB,0>

.code

open_idd proc uses edi ebx id:size_t, lpMTitle:dword
	mov eax,id
	.if rsopen(menus_iddtable[eax*4])
	    mov edi,eax
	    .if cflag & _C_MENUSLINE
		mov eax,id
		mov ecx,menus_xtitle[eax*4]
		mov edx,menus_xpos[eax*4]
		invoke scgetws,edx,0,ecx
		mov ebx,lpMTitle
		mov [ebx],eax
		movzx eax,at_foreground[F_MenusKey]
		invoke scputa,edx,0,ecx,eax
	    .endif
	    mov eax,edi
	.endif
	ret
open_idd endp

close_idd proc uses eax edx id:size_t, wpMenusTitle:dword
	.if cflag & _C_MENUSLINE
	    mov eax,id
	    mov edx,menus_xtitle[eax*4]
	    mov eax,menus_xpos[eax*4]
	    invoke scputws,eax,0,edx,wpMenusTitle
	.endif
	ret
close_idd endp

modal_idd proc index:size_t, stInfo:ptr byte, dialog:dword, wpMenusTitle:dword
local stBuffer[256]:word
	invoke  wcpushst,addr stBuffer,stInfo
	invoke  dlinit,dialog
	invoke  dlshow,dialog
	invoke  msloop
	invoke  dlevent,dialog
	push	eax
	shl	eax,4
	add	eax,dialog
	mov	eax,[eax]
	and	eax,_O_STATE or _O_FLAGB
	push	eax
	invoke  wcpopst,addr stBuffer
	invoke  close_idd,index,wpMenusTitle
	pop	edx
	pop	eax
	ret
modal_idd endp

menus_modalidd proc uses esi edi ebx id:dword
local object:dword
local mtitle:dword
local dialog:dword
	sub esi,esi
	.if id == ID_MTOOLS
	    invoke tools_idd,128,0,addr cp_tools
	    mov esi,eax
	.else
	    mov eax,IDD_DZMenuPanel
	    mov byte ptr [eax+6],0
	    .if id == ID_MPANELB
		mov byte ptr [eax+6],42
	    .endif
	    .if open_idd(id,addr mtitle)
		mov dialog,eax
		mov ebx,eax
		add eax,16
		mov object,eax
		movzx ecx,[ebx].S_DOBJ.dl_count
		add ebx,S_TOBJ.to_data[16]
		mov edx,id
		mov edx,menus_oid[edx*4]
		.while cl > ch
		    mov eax,[edx]
		    mov [ebx],eax
		    add ebx,SIZE S_TOBJ
		    add edx,8
		    inc ch
		.endw
		mov eax,id
		xor edx,edx
		.if !eax
		    mov edx,config.c_apath.wp_flag
		.elseif eax == ID_MPANELB
		    mov edx,config.c_bpath.wp_flag
		.endif
		.if edx
		    mov ebx,object
		    ;or [ebx].S_TOBJ.to_flag,_O_STATE
		    mov eax,_O_FLAGB
		    mov ecx,_W_LONGNAME
		    call @1
		    mov ecx,_W_DETAIL
		    call @1
		    mov ecx,_W_WIDEVIEW
		    call @1
		    mov ecx,_W_HIDDEN
		    call @1
		    mov ecx,_W_MINISTATUS
		    call @1
		    mov ecx,_W_DRVINFO
		    call @1
		    mov eax,_O_RADIO
		    .if edx & _W_NOSORT
			or [ebx+64],ax
		    .else
			and edx,_W_SORTSIZE
			mov ecx,_W_SORTNAME
			call @2
			mov ecx,_W_SORTTYPE
			call @2
			mov ecx,_W_SORTDATE
			call @2
			mov ecx,_W_SORTSIZE
			call @2
		    .endif
		.endif
		mov eax,id
		shl eax,4
		.if modal_idd(id,menus_TOBJ[eax].S_TOBJ.to_data,dialog,mtitle)
		    mov esi,eax
		    mov edi,edx
		    mov eax,dialog
		    movzx eax,[eax].S_DOBJ.dl_count
		    invoke dlclose,dialog	; -- return AX in DX
		    .if edx >= esi
			mov edx,id
			mov menus_idd,edx
			mov eax,esi
			dec eax
			mov menus_obj,eax
			and edi,_O_STATE
			.if ZERO?
			    mov edx,menus_oid[edx*4]
			    call [edx+eax*8].S_GLCMD.gl_proc
			.endif
		    .endif
		.else
		    invoke dlclose,dialog
		.endif
ifdef __MOUSE__
		.if mousep()
		    mov esi,MOUSECMD
		.endif
endif
	    .endif
	.endif
	mov eax,esi
	ret
    @1:
	test	edx,ecx
	jz	@4
	jmp	@3
    @2:
	cmp	edx,ecx
	jne	@4
    @3:
	or	[ebx].S_TOBJ.to_flag,ax
    @4:
	add	ebx,SIZE S_TOBJ
	retn
menus_modalidd endp

menus_event proc uses esi edi ebx id:dword, key:dword
	mov edi,key
	mov esi,1
	.while 1
	    .if edi == MOUSECMD
		xor edi,edi
		mov esi,edi
	    .elseif edi == MENUSCMD
		invoke menus_modalidd,id
		mov esi,1
	    .elseif edi == KEY_RIGHT
		mov eax,edi
		.break .if !esi
		mov eax,id
		inc eax
		.if eax > ID_MPANELB
		    xor eax,eax
		.endif
	      @@:
		mov id,eax
		invoke menus_modalidd,eax
		mov edi,eax
	    .elseif edi == KEY_LEFT
		mov eax,edi
		.if esi
		    mov eax,id
		    dec eax
		    .if eax == -1
			mov eax,ID_MPANELB
		    .endif
		    jmp @B
		.endif
		.break
	    .elseif edi == KEY_ESC
		mov eax,edi
		.break .if !esi
		xor eax,eax
		.break
	    .elseif esi
		invoke msloop
		.break
	    .else
		.if edi
		    mov ecx,7
		    xor ebx,ebx
		    .repeat
			.if edi == menus_shortkeys[ebx]
			    shr ebx,2
			    mov id,ebx
			    invoke menus_modalidd,ebx
			    mov edi,eax
			    mov esi,1
			    jmp @F
			.else
			    add ebx,4
			.endif
		    .untilcxz
		    mov eax,edi
		    .break .if !esi
		.endif
	    .endif
	  @@:
	    .if !esi
		.if tgetevent() == MOUSECMD
		    sub eax,eax
		.endif
		mov edi,eax
	    .endif
	    .if cflag & _C_MENUSLINE
ifdef __MOUSE__
		invoke mousep
		jz  @F
		cmp keybmouse_y,0
		jne @F
endif
		test edi,edi
		jnz @F
ifdef __MOUSE__
		mov eax,keybmouse_x
		mov edx,eax
else
		xor edx,edx
endif
		mov ecx,ID_MPANELB
		.if eax >= 57
		    mov eax,MOUSECMD
		    .break
		.endif
		.repeat
		    mov ebx,ecx
		    dec ecx
		    shl ebx,4
		    add ebx,offset menus_TOBJ
		.until al >= [ebx+4]
		mov ah,[ebx].S_TOBJ.to_ascii
		mov al,0
		mov edi,eax
		inc ecx
		mov id,ecx
		.continue
	    .endif
	  @@:
	    .if edi
		.continue
	    .endif
	    mov eax,MOUSECMD
	    .break
	.endw
	ret
menus_event endp

menus_getevent proc
	invoke menus_event,0,MOUSECMD
	ret
menus_getevent endp

	END
