include alloc.inc
include errno.inc

public  memseg
extrn	heaplen:dword

.data
_avail  dd 0
memseg  dd 0
brklvl  dd 0
mavail  dd offset _avail

.code

mb	struc
mb_size dd ?
mb_used dd ?
mb	ends

create_heap:
	mov	eax,heaplen
	test	eax,eax
	jz	@F
	invoke  GlobalAlloc,GMEM_FIXED,eax
	mov	memseg,eax
	mov	ecx,mavail
	mov	[ecx],eax
	test	eax,eax
	jz	@F
	mov	ecx,heaplen
	sub	ecx,SIZE mb
	mov	[eax].mb.mb_size,ecx
	mov	[eax].mb.mb_used,0
	add	eax,ecx
	mov	[eax].mb.mb_size,0
	mov	[eax].mb.mb_used,1
	mov	brklvl,eax
      @@:
	ret

getfreeblock:
	push	esi
	push	edi
	push	ebx
	mov	eax,memseg
	mov	edx,eax		; largest free block
	sub	esi,esi		; size of largest free block
    getmaxblock:
	cmp	[eax].mb.mb_used,0
	jne	getnextblock
	mov	edi,eax		; merge free block's
      addfreeblocks:
	assert [eax].mb.mb_size,0,jne,"block size is 0!"
	add	eax,[eax].mb.mb_size
	mov	ebx,[eax].mb.mb_size
	cmp	[eax].mb.mb_used,0
	jne	updateblock
	add	[edi].mb.mb_size,ebx
	jmp	addfreeblocks
      updateblock:
	mov	eax,edi		; update result
	cmp	esi,[eax].mb.mb_size
	ja	getnextblock
	mov	esi,[eax].mb.mb_size
	mov	edx,eax
    getnextblock:
	cmp	esi,ecx
	jae	@F
	add	eax,[eax].mb.mb_size
	cmp	eax,brklvl
	jb	getmaxblock
     @@:
	mov	eax,esi		; size in eax
	test	eax,eax
	jz	@F
	mov	ebx,mavail
	mov	[ebx],edx
     @@:
	pop	ebx
	pop	edi
	pop	esi
	ret

malloc  proc msize:dword
	mov	eax,msize
	test	eax,eax
	jz	malloc_failed
	add	eax,SIZE mb
	test	eax,7
	jz	@F
	and	eax,not 7
	add	eax,8
      @@:
	mov	ecx,eax
	mov	eax,mavail
	mov	eax,[eax]
	test	eax,eax
	jz	malloc_failed
	mov	edx,eax
	cmp	[eax].mb.mb_used,0
	mov	eax,[eax].mb.mb_size
	jne	malloc_find
    malloc_found:
	cmp	eax,ecx
	jb	malloc_find
	mov	[edx].mb.mb_used,1
	je	malloc_set
	mov	[edx].mb.mb_size,ecx
	sub	eax,ecx
	add	ecx,edx
	mov	[ecx].mb.mb_size,eax
	mov	[ecx].mb.mb_used,0
    malloc_set:
	mov	eax,[edx].mb.mb_size
	add	eax,edx
	mov	ecx,mavail
	mov	[ecx],eax
	mov	eax,edx
	add	eax,SIZE mb
    malloc_end:
	test	eax,eax
	ret
    malloc_find:
	call	getfreeblock
	jz	malloc_failed
	cmp	eax,ecx
	jnb	malloc_found
    malloc_failed:
	mov	errno,ENOMEM
	xor	eax,eax
	jmp	malloc_end
malloc  endp

free proc uses eax maddr:dword
	mov eax,maddr
	sub eax,SIZE mb
	.if eax >= memseg && eax < brklvl
	    assert [eax].mb.mb_used,0,jne,"block is free!"
	    mov [eax].mb.mb_used,0
	    mov ecx,mavail
	    mov [ecx],eax
	.endif
	ret
free endp

freememseg proc private
	.if memseg && heaplen
	    invoke GlobalFree,memseg
	    sub eax,eax
	    mov memseg,eax
	.endif
	ret
freememseg endp

pragma_init create_heap,3
pragma_exit freememseg, 128

	END
