include io.inc
include share.inc
include stdio.inc
include fcntl.inc
include stat.inc
include errno.inc

extrn	_fmode:size_t
extrn	_umaskval:size_t

	.code

sopen	proc c uses esi edi ebx filename:dword, oflag:size_t, shflag:size_t, args:VARARG
local	sa:SECURITY_ATTRIBUTES
	sub eax,eax
	assert filename,eax,jne,"sopen:1"
	mov sa.nLength,SIZE SECURITY_ATTRIBUTES
	mov sa.lpSecurityDescriptor,eax
	mov sa.bInheritHandle,eax
	.if !(oflag & O_NOINHERIT)
	    inc sa.bInheritHandle
	.endif
	mov eax,oflag
	and eax,O_RDONLY or O_WRONLY or O_RDWR
	.if eax == O_RDONLY
	    mov edi,M_RDONLY
	.elseif eax == O_WRONLY
	    mov edi,M_WRONLY
	.elseif eax == O_RDWR
	    mov edi,M_RDWR
	.else
	    jmp sopen_einval
	.endif
	mov eax,shflag
	.if eax == SH_DENYRW		; exclusive access
	    mov ebx,0
	.elseif eax == SH_DENYWR	; share read access
	    mov ebx,SHARE_READ
	.elseif eax == SH_DENYRD	; share write access
	    mov ebx,SHARE_WRITE
	.elseif eax == SH_DENYNO	; share read and write access
	    mov ebx,SHARE_READ or SHARE_WRITE
	.else
	    jmp sopen_einval
	.endif
	mov eax,oflag
	and eax,O_CREAT or O_EXCL or O_TRUNC
	.if !eax || eax == O_EXCL
	    mov eax,OPEN_EXISTING
	.elseif eax == O_CREAT
	    mov eax,OPEN_ALWAYS
	.elseif eax == O_CREAT or O_EXCL || eax == O_CREAT or O_EXCL or O_TRUNC
	    mov eax,CREATE_NEW
	.elseif eax == O_CREAT or O_TRUNC
	    mov eax,CREATE_ALWAYS
	.elseif eax == O_TRUNC || eax == O_TRUNC or O_EXCL
	    mov eax,TRUNCATE_EXISTING
	.else
	    jmp sopen_einval
	.endif
	mov ecx,FILE_ATTRIBUTE_NORMAL
	mov edx,oflag
	.if edx & O_CREAT
	    push eax
	    lea eax,args
	    mov eax,[eax]
	    mov edx,_umaskval
	    not edx
	    and eax,edx
	    mov edx,oflag
	    and eax,S_IWRITE
	    pop eax
	    .if ZERO?
		mov ecx,FILE_ATTRIBUTE_READONLY
	    .endif
	.endif
	.if edx & O_TEMPORARY
	    or ecx,FILE_FLAG_DELETE_ON_CLOSE
	    or edi,M_DELETE
	.endif
	.if edx & O_SHORT_LIVED
	    or ecx,FILE_ATTRIBUTE_TEMPORARY
	.endif
	.if edx & O_SEQUENTIAL
	    or ecx,FILE_FLAG_SEQUENTIAL_SCAN
	.elseif edx & O_RANDOM
	    or ecx,FILE_FLAG_RANDOM_ACCESS
	.endif
	mov edx,eax
	sub eax,eax
	.repeat
	    .break .if !(_osfile[eax] & FH_OPEN)
	    inc eax
	.until eax == _nfile
	.if eax == _nfile
	    sub eax,eax
	    mov doserrno,eax	; no OS error
	    mov errno,EBADF
	    dec eax
	    jmp sopen_end
	.endif
	mov esi,eax
	.if CreateFile(filename,edi,ebx,addr sa,edx,ecx,0) == -1
	    call osmaperr
	    jmp sopen_end
	.endif
	mov edi,eax
	mov eax,oflag
	mov ebx,FH_TEXT
	.if _fmode != O_BINARY && eax & O_BINARY
	    sub ebx,ebx
	.endif
	.if GetFileType(edi) == FILE_TYPE_UNKNOWN
	    invoke CloseHandle,edi
	    invoke osmaperr
	    jmp sopen_end
	.endif
     	.if eax == FILE_TYPE_CHAR
	    or ebx,FH_DEVICE
	.elseif eax == FILE_TYPE_PIPE
	    or ebx,FH_PIPE
	.endif
	mov eax,ebx
	or  eax,FH_OPEN
	mov _osfile[esi],al
	mov _osfhnd[esi*4],edi
	.if !(al & FH_DEVICE or FH_PIPE) && al & FH_TEXT && oflag & O_RDWR
	    .if lseek(esi,-1,SEEK_END) == -1
		cmp doserrno,ERROR_NEGATIVE_SEEK
		jne sopen_error
	    .else
		mov ebx,eax
		sub eax,eax
		push eax
		mov eax,esp
		invoke osread,esi,eax,1
		pop edx
		.if !eax && dl == 26
		    invoke chsize,esi,ebx
		    inc eax
		    jz sopen_error
		.endif
		invoke lseek,esi,0,SEEK_SET
		inc eax
		jz sopen_error
	    .endif
	.endif
	mov al,_osfile[esi]
	.if !(al & FH_DEVICE or FH_PIPE) && oflag & O_APPEND
	    or _osfile[esi],FH_APPEND
	.endif
	mov eax,esi
    sopen_end:
	ret
    sopen_error:
	invoke	close,esi
	mov	eax,-1
	jmp	sopen_end
    sopen_einval:
	mov	errno,EINVAL
	sub	eax,eax
	mov	doserrno,eax
	dec	eax
	jmp	sopen_end
sopen	endp

	END
