include iost.inc
include io.inc
include errno.inc
include confirm.inc

	.code

ogetouth proc filename:dword, mode:dword
	invoke  osopen,filename,_A_NORMAL,mode,A_CREATE
	cmp	eax,-1
	jne	ogetouth_end
	cmp	errno,EEXIST
	jne	ogetouth_err
	test	confirmflag,CFDELETEALL
	jnz	ogetouth_confirm
    ogetouth_trunc:
	invoke  setfattr,filename,0
	invoke  openfile,filename,mode,A_TRUNC
	jmp	ogetouth_end
    ogetouth_confirm:
	invoke  confirm_delete,filename,0
	cmp	eax,1
	je	ogetouth_trunc  ; delete --> trunc
	cmp	eax,2
	je	ogetouth_del	; delete all --> clear flag, trunc
	cmp	eax,3
	je	ogetouth_nul	; jump --> return 0
	mov	eax,-1		; Cancel --> return -1
	jmp	ogetouth_end
    ogetouth_del:
	and	confirmflag,not CFDELETEALL
	jmp	ogetouth_trunc
    ogetouth_nul:
	xor	eax,eax
    ogetouth_end:
	ret
    ogetouth_err:
	invoke  eropen,filename ; -1
	jmp	ogetouth_end
ogetouth endp

	END
