include stdio.inc
include math.inc

public  output_flush
;public  output_proctab
;public  output_getd

BUFFERSIZE	equ 512		; ANSI-specified minimum is 509

FLAG_SIGN	equ 0001h	; put plus or minus in front
FLAG_SIGNSP	equ 0002h	; put space or minus in front
FLAG_LEFT	equ 0004h	; left justify
FLAG_LEADZERO	equ 0008h	; pad with leading zeros
FLAG_LONG	equ 0010h	; long value given
FLAG_SHORT	equ 0020h	; short value given
FLAG_SIGNED	equ 0040h	; signed data given
FLAG_ALTERNATE  equ 0080h	; alternate form requested
FLAG_NEGATIVE	equ 0100h	; value is negative
FLAG_FORCEOCTAL equ 0200h	; force leading '0' for octals

	.data

cl_table label byte
	db	 06h, 00h, 00h, 06h, 00h, 01h, 00h, 00h
	db	 10h, 00h, 03h, 06h, 00h, 06h, 02h, 10h
	db	 04h, 45h, 45h, 45h, 05h, 05h, 05h, 05h
	db	 05h, 35h, 30h, 00h, 50h, 00h, 00h, 00h
	db	 00h, 20h, 28h, 38h, 50h, 58h, 07h, 08h
	db	 00h, 37h, 30h, 30h, 57h, 50h, 07h, 00h
	db	 00h, 20h, 20h, 08h, 00h, 00h, 00h, 00h
	db	 08h, 60h, 60h, 60h, 60h, 60h, 60h, 00h
	db	 00h, 70h, 78h, 78h, 78h, 78h, 78h, 08h
	db	 07h, 08h, 00h, 00h, 07h, 00h, 08h, 08h
	db	 08h, 00h, 00h, 08h, 00h, 08h, 00h, 00h
	db	 08h

formchar	db 'bcdefginopsuxEGX'
nullstring	db '(null)',0
output_flush	dd 0

OPST_table	label size_t
	dd	OPST_normal
	dd	OPST_percent
	dd	OPST_flag
	dd	OPST_width
	dd	OPST_dot
	dd	OPST_precision
	dd	OPST_size
	dd	OPST_type

output_proctab  label size_t
	dd	OUTPUT_b
	dd	OUTPUT_c
	dd	OUTPUT_d
	dd	OUTPUT_dummy
	dd	OUTPUT_dummy
	dd	OUTPUT_dummy
	dd	OUTPUT_d
	dd	OUTPUT_n
	dd	OUTPUT_o
	dd	OUTPUT_p
	dd	OUTPUT_s
	dd	OUTPUT_u
	dd	OUTPUT_x
	dd	OUTPUT_dummy
	dd	OUTPUT_dummy
	dd	OUTPUT_xu

S_OUTPUT	STRUC
OP_filep	dd ?
OP_format	dd ?
OP_charsout	dd ?
OP_hexoff	dd ?
OP_state	dd ?
OP_curadix	dd ?
OP_prefix	db 2 dup(?)
OP_count	dd ?
OP_prefixlen	dd ?
OP_no_output	dd ?
OP_fldwidth	dd ?
OP_padding	dd ?
OP_text		dd ?
OP_capitalize	dd ?
OP_numeax	dd ?
OP_numedx	dd ?
OP_buffer	db BUFFERSIZE dup(?)
OP_STACK	dd ? ; [(E)BP]
OP_CSIP		dd ?
ifdef __CDECL__
OP_ARGfile	dd ?
OP_ARGformat	dd ?
OP_argp		dd ?
else
OP_argp		dd ?
OP_ARGformat	dd ?
OP_ARGfile	dd ?
endif
S_OUTPUT	ENDS

	.code

	ASSUME  ebp:ptr S_OUTPUT

output_getd:	; Get DWORD from stack
	mov	eax,[ebp].OP_argp
	add	[ebp].OP_argp,4
	mov	eax,[eax]
	sub	edx,edx
	ret

output_getq:	; Get QWORD from stack
	mov	eax,[ebp].OP_argp
	add	[ebp].OP_argp,8
	mov	edx,[eax+4]
	mov	eax,[eax]
	ret

OPST_percent:
	sub	eax,eax
	mov	[ebp].OP_no_output,eax
	mov	[ebp].OP_fldwidth,eax
	mov	[ebp].OP_prefixlen,eax
	mov	[ebp].OP_capitalize,eax
	mov	esi,eax ; bufferiswide (default)
	mov	edi,eax ; precision
	dec	edi
	ret

OPST_flag:
	mov al,dl
	.if al == '+'
	    or esi,FLAG_SIGN		; '+' force sign indicator
	.elseif al == ' '
	    or esi,FLAG_SIGNSP		; ' ' force sign or space
	.elseif al == '#'
	    or esi,FLAG_ALTERNATE	; '#' alternate form
	.elseif al == '-'
	    or esi,FLAG_LEFT		; '-' left justify
	.elseif al == '0'
	    or esi,FLAG_LEADZERO	; '0' pad with leading zeros
	.endif
	ret

OPST_width:
	.if dl == '*'
	    call output_getd
	    mov [ebp].OP_fldwidth,eax
	    .if sdword ptr eax < 0
		or  esi,4
		neg eax
		mov [ebp].OP_fldwidth,eax
	    .endif
	.else
	    movsx eax,dl
	    push  eax
	    mov	  eax,[ebp].OP_fldwidth
	    mov	  edx,10
	    imul  edx
	    pop	  edx
	    add	  edx,eax
	    add	  edx,-48
	    mov	  [ebp].OP_fldwidth,edx
	.endif
	ret

OPST_dot:
	sub edi,edi
	ret

OPST_precision:
	.if dl == '*'
	    call output_getd
	    mov edi,eax
	    .if sdword ptr eax < 0
		mov edi,-1
	    .endif
	.else
	    movsx eax,dl
	    push eax
	    mov  eax,edi
	    mov  edx,10
	    imul edx
	    pop  edx
	    add  edx,eax
	    add  edx,-48
	    mov  edi,edx
	.endif
	ret

OPST_size:
	.if dl == 'l'
	    or esi,FLAG_LONG
	.endif
	ret

OPST_type:
	sub eax,eax
	mov ecx,16
	.repeat
	    .if dl == formchar[eax]
		call output_proctab[eax*4]
		.break
	    .endif
	    inc eax
	.untilcxz
	jmp OUTPUT

OUTPUT_b:
	call output_getd
	mov ecx,32
	mov edx,eax
	.repeat
	    mov eax,edx
	    shr eax,cl
	    .break .if CARRY?
	.untilcxz
	.if !ecx
	    inc ecx
	.endif
	mov [ebp].OP_count,ecx
	.repeat
	    sub eax,eax
	    shr edx,1
	    adc al,'0'
	    mov [ebp].OP_buffer[ecx-1],al
	.untilcxz
	jmp OUTPUT_LDTEXT

OUTPUT_c:
	call output_getd
	mov  [ebp].OP_buffer,al
	mov  [ebp].OP_count,1

OUTPUT_LDTEXT:
	lea eax,[ebp].OP_buffer
	mov [ebp].OP_text,eax
	ret

OUTPUT_s:
	.if !output_getd()
	    mov eax,offset nullstring
	.endif
	mov [ebp].OP_text,eax
	.if edi == -1
	    mov ecx,7FFFh
	.else
	    mov ecx,edi
	.endif
	.repeat
	    .break .if byte ptr [eax] == 0
	    inc eax
	.untilcxz
	sub eax,[ebp].OP_text
	mov [ebp].OP_count,eax
	ret

OUTPUT_n:
	mov eax,[ebp].OP_argp
	add [ebp].OP_argp,4
	mov edx,[eax-4]
	mov eax,[ebp].OP_charsout
	mov [edx],eax
	.if esi & FLAG_LONG
	    mov [ebp].OP_no_output,1
	.endif
	ret

OUTPUT_p:
	mov	edi,8

OUTPUT_xu:
	mov	[ebp].OP_hexoff,'A'-'9'-1
	jmp	OPCOMMONHEX

OUTPUT_x:
	mov	[ebp].OP_hexoff,'a'-'9'-1

OPCOMMONHEX:
	mov [ebp].OP_curadix,16
	.if esi & FLAG_ALTERNATE
	    mov [ebp].OP_prefix,'0'
	    mov [ebp].OP_prefix+1,'x'
	    mov [ebp].OP_prefixlen,2
	.endif
	test	esi,FLAG_LONG
	jnz	OUTPUT_LONGINT
	cmp	[ebp].OP_fldwidth,2
	jne	OUTPUT_SHORTINT
	call	output_getd
	and	eax,00FFh
	jmp	OUTPUT_UNSIGNED

OUTPUT_o:
	mov	[ebp].OP_curadix,8
	test	esi,FLAG_ALTERNATE
	jz	OUTPUT_GENINT
	or	esi,FLAG_FORCEOCTAL
	jmp	OUTPUT_GENINT

OUTPUT_d:
	or	esi,FLAG_SIGNED

OUTPUT_u:
	mov	[ebp].OP_curadix,10

OUTPUT_GENINT:
	test	esi,FLAG_LONG
	jz	OUTPUT_SHORTINT

OUTPUT_LONGINT:
	call	output_getq
	jmp	OUTPUT_NUMBER

OUTPUT_SHORTINT:
	call	output_getd
	test	esi,FLAG_SIGNED
	jz	OUTPUT_UNSIGNED
	cmp	eax,0
	jnl	OUTPUT_NUMBER
	dec	edx
	jmp	OUTPUT_NUMBER

OUTPUT_UNSIGNED:

OUTPUT_NUMBER:
	test	esi,FLAG_SIGNED
	jz	@F
	test	edx,edx
	jns	@F
	neg	eax
	neg	edx
	sbb	edx,0
	or	esi,FLAG_NEGATIVE
      @@:
	mov	[ebp].OP_numeax,eax
	mov	[ebp].OP_numedx,edx
	test	edi,edi
	jnl	OPNUM_01
	mov	edi,1
	jmp	OPNUM_02
    OPNUM_01:
	and	esi,-9
    OPNUM_02:
	test	eax,eax
	jnz	OPNUM_03
	test	edx,edx
	jnz	OPNUM_03
	mov	[ebp].OP_prefixlen,eax
    OPNUM_03:
	lea	eax,[ebp].OP_buffer+512-1
	mov	[ebp].OP_text,eax
	jmp	OPNUM_06
    OPNUM_04:
	mov	ecx,[ebp].OP_curadix
	mov	eax,[ebp].OP_numeax
	mov	edx,[ebp].OP_numedx
	call	_div64
	mov	[ebp].OP_numeax,eax
	mov	[ebp].OP_numedx,edx
	add	ecx,'0'
	cmp	ecx,'9'
	jng	OPNUM_05
	add	ecx,[ebp].OP_hexoff
    OPNUM_05:
	mov	edx,[ebp].OP_text
	mov	[edx],cl
	dec	[ebp].OP_text
    OPNUM_06:
	mov	ecx,edi
	dec	edi
	test	ecx,ecx
	jg	OPNUM_04
	or	eax,[ebp].OP_numedx
	jnz	OPNUM_04
	lea	eax,[ebp].OP_buffer+512-1
	sub	eax,[ebp].OP_text
	mov	[ebp].OP_count,eax
	inc	[ebp].OP_text
	test	esi,FLAG_FORCEOCTAL
	jz	OUTPUT_dummy
	mov	edx,[ebp].OP_text
	cmp	byte ptr [edx],'0'
	jne	OPNUM_07
	cmp	[ebp].OP_count,0
	jne	OUTPUT_dummy
    OPNUM_07:
	dec	edx
	mov	[ebp].OP_text,edx
	mov	byte ptr [edx],'0'
	inc	[ebp].OP_count
OUTPUT_dummy:
	ret

OPST_normal:
	mov	al,dl

OUTPUT_PUTC:
	mov	edx,[ebp].OP_filep
	dec	[edx].S_FILE.iob_cnt
	jl	OPPUTC_00
	inc	[edx].S_FILE.iob_bp
	mov	edx,[edx].S_FILE.iob_bp
	mov	[edx-1],al
    OPPUTC_01:
	inc	[ebp].OP_charsout
	ret
    OPPUTC_00:
      ifdef __CDECL__
	push	[ebp].OP_filep
	push	eax
      else
	push	eax
	push	[ebp].OP_filep
      endif
	call	output_flush
	cmp	eax,-1
	jne	OPPUTC_01
	mov	[ebp].OP_charsout,eax
	ret

OUTPUT_MULTI:
	push  esi
	push  edi
	movzx eax,al
	mov   esi,eax
	mov   edi,edx
	.while sdword ptr edi > 0
	    mov eax,esi
	    call OUTPUT_PUTC
	    .break .if [ebp].OP_charsout == -1
	    dec edi
	.endw
	pop edi
	pop esi
	ret

OUTPUT_STRING:
	push esi
	push edi
	mov esi,ecx
	mov edi,edx
	.while sdword ptr esi > 0
	    mov al,[edi]
	    call OUTPUT_PUTC
	    .break .if [ebp].OP_charsout == -1
	    inc edi
	    dec esi
	.endw
	pop edi
	pop esi
	ret

OUTPUT:
	sub eax,eax
	.if eax == [ebp].OP_no_output
	    .if esi & FLAG_SIGNED
		.if esi & FLAG_NEGATIVE
		    mov [ebp].OP_prefix,'-'
		    mov [ebp].OP_prefixlen,1
		.else
		    .if esi & FLAG_SIGN
			mov [ebp].OP_prefix,43
			mov [ebp].OP_prefixlen,1
		    .elseif esi & FLAG_SIGNSP
			mov [ebp].OP_prefix,' '
			mov [ebp].OP_prefixlen,1
		    .endif
		.endif
	    .endif
	    mov eax,[ebp].OP_fldwidth
	    sub eax,[ebp].OP_count
	    sub eax,[ebp].OP_prefixlen
	    mov [ebp].OP_padding,eax
	    .if !(esi & FLAG_LEFT or FLAG_LEADZERO)
		mov edx,eax
		mov eax,' '
		call OUTPUT_MULTI
	    .endif
	    lea edx,[ebp].OP_prefix
	    mov ecx,[ebp].OP_prefixlen
	    call OUTPUT_STRING
	    .if esi & FLAG_LEADZERO
		.if !(esi & FLAG_LEFT)
		    mov eax,'0'
		    mov edx,[ebp].OP_padding
		    call OUTPUT_MULTI
		.endif
	    .endif
	    mov ecx,[ebp].OP_count
	    .if sdword ptr ecx > 0
		mov edx,[ebp].OP_text
		.while sdword ptr ecx > 0
		    movzx eax,byte ptr [edx]
		    push  edx
		    push  ecx
		    call  OUTPUT_PUTC
		    pop	  ecx
		    pop	  edx
		    inc	  edx
		    dec	  ecx
		.endw
	    .else
		mov edx,[ebp].OP_text
		call OUTPUT_STRING
	    .endif
	    .if esi & FLAG_LEFT
		mov eax,' '
		mov edx,[ebp].OP_padding
		call OUTPUT_MULTI
	    .endif
	.endif
	ret

_output proc uses edx ecx esi edi ebp filep:dword, format:dword, argp:dword
local	OP[S_OUTPUT.OP_STACK]:byte
	lea ebp,OP
	mov eax,[ebp].OP_ARGformat
	mov [ebp].OP_format,eax
	mov eax,[ebp].OP_ARGfile
	mov [ebp].OP_filep,eax
	sub eax,eax
	mov [ebp].OP_count,eax
	mov [ebp].OP_charsout,eax
	mov [ebp].OP_state,eax
	.repeat
	    mov eax,[ebp].OP_format
	    inc [ebp].OP_format
	    movzx eax,byte ptr [eax]
	    mov edx,eax
	    .break .if !al
	    .break .if [ebp].OP_charsout > 7FFFFFFFh
	    .if al < ' ' || al > 'x'
		sub eax,eax
	    .else
		mov al,cl_table[eax-32]
		and eax,15
	    .endif
	    shl eax,3
	    add eax,[ebp].OP_state
	    mov al,cl_table[eax]
	    shr eax,4
	    and eax,15
	    mov [ebp].OP_state,eax
	    .if eax <= 7
		shl eax,2
		call OPST_table[eax]
	    .endif
	.until 0
	mov eax,[ebp].OP_charsout
	ret
_output endp

	END
