;
; unsigned SystemTimeToTime(S_STIME *lpSystemTime);
;
; Return:
;
;    edx - <date> yyyyyyymmmmddddd
;    ecx - <time> hhhhhmmmmmmsssss
;    eax - <date>:<time>
;
include	time.inc

.code

SystemTimeToTime proc uses edi lpSystemTime:ptr S_STIME
	mov	ecx,lpSystemTime
	movzx	eax,[ecx].S_STIME.wYear
	sub	eax,DT_BASEYEAR
	shl	eax,9
	movzx	edx,[ecx].S_STIME.wMonth
	shl	edx,5
	or	eax,edx
	or	ax,[ecx].S_STIME.wDay
	shl	eax,16
	mov	edi,eax
	movzx	eax,[ecx].S_STIME.wSecond
	shr	eax,1
	mov	edx,eax	; second/2
	mov	al,byte ptr [ecx].S_STIME.wHour
	movzx	ecx,byte ptr [ecx].S_STIME.wMinute
	shl	ecx,5
	shl	eax,11
	or	eax,ecx
	or	eax,edx
	mov	edx,edi	; <date> yyyyyyymmmmddddd
	mov	ecx,eax	; <time> hhhhhmmmmmmsssss
	or	eax,edx	; <date>:<time>
	shr	edx,16
	ret
SystemTimeToTime endp

	END
