include _tinfo.inc
include string.inc
include iost.inc
include clip.inc
include ctype.inc

externdef	IDD_Replace:dword
externdef	IDD_ReplacePrompt:dword
notfoundmsg	proto
cmsearchidd	proto :dword

.data
tisearch_off	dd 0
tisearch_line	dd 0
timask		dw 07Fh,0FFh,1FFh,3FFh,7FFh,0FFFh
sflag		dd 0

.code

tisearchsetoff:
	test	sflag,IO_SEARCHSET
	jz	@F
	sub	eax,eax
	mov	tisearch_off,eax
	mov	tisearch_line,eax
	ret
     @@:
	mov	edx,tinfo
	mov	eax,[edx].S_TINFO.ti_boff
	add	eax,[edx].S_TINFO.ti_xoff
	mov	tisearch_off,eax
	mov	eax,[edx].S_TINFO.ti_loff
	add	eax,[edx].S_TINFO.ti_yoff
	mov	tisearch_line,eax
	ret

tisearchcontinue proc private uses esi edi ebx clear_selection:dword
local offs:dword
	invoke  strlen,addr searchstring
	jz	fail
	mov	esi,eax
	call	tisearchsetoff
	and	sflag,not IO_SEARCHSET
	mov	edx,tinfo
	mov	eax,[edx].S_TINFO.ti_bcol
	mov	ecx,[edx].S_TINFO.ti_lcnt
	sub	ecx,tisearch_line
	mul	ecx
	sub	eax,tisearch_off
	jz	fail
	dec	eax
	jz	fail
	mov	ebx,eax		; byte count left in buffer
	mov	eax,tisearch_line
	invoke  tigetline
	jbe	fail
	add	eax,tisearch_off
	inc	eax
	mov	edi,eax
	test	fsflag,IO_SEARCHCASE
	jz	nocase
   scan:
	mov	ecx,ebx
	mov	al,searchstring
	repnz	scasb
	jne	notfound
	cmp	ecx,esi
	jl	notfound
	mov	ebx,ecx
	invoke  strncmp,addr searchstring,addr [edi-1],esi
	jnz	scan
  found:
	dec	edi
	sub	edi,[edx].S_TINFO.ti_bp
	mov	eax,edi
	mov	ecx,[edx].S_TINFO.ti_bcol
	shr	ecx,8
	add	ecx,7
	shr	edi,cl
	mov	tisearch_line,edi
	sub	ecx,7
	movzx	ecx,timask[ecx*2]
	and	eax,ecx
	mov	tisearch_off,eax
	mov	eax,edi
	invoke  tialigny
	mov	eax,tisearch_off
	inc	tisearch_off
	invoke  tialignx
	invoke  ticlipset
	invoke  strlen,addr searchstring
	mov	edx,tinfo
	add	[edx].S_TINFO.ti_cleo,eax
	invoke  tiputs
	sub	eax,eax
	cmp	eax,clear_selection
	je	toend
	invoke  ticlipset
	sub	eax,eax
  toend:
	ret
notfound:
	invoke  notfoundmsg
   fail:
	sub	eax,eax
	dec	eax
	jmp	toend
 nocase:
	mov	ecx,ebx
	mov	edx,-1
	mov	al,searchstring
	invoke  tolower,eax
	push	edi
	repnz	scasb
	jne	@F
	mov	edx,edi
	mov	offs,ecx
     @@:
	pop	edi
	mov	al,searchstring
	invoke  toupper,eax
	mov	ecx,ebx
	repnz	scasb
	jne	@F
	cmp	edx,edi
	ja	nctest
	mov	edi,edx
	mov	ecx,offs
	jmp	nctest
     @@:
	cmp	edx,-1
	je	notfound
	mov	edi,edx
	mov	ecx,offs
 nctest:
	cmp	ecx,esi
	jl	notfound
	mov	ebx,ecx
	invoke  strnicmp,addr searchstring,addr [edi-1],esi
	jnz	nocase
	mov	edx,tinfo
	jmp	found
tisearchcontinue endp

ticontinuesearch proc uses esi
	mov	esi,fsflag
	invoke  tisearchcontinue,1
	mov	fsflag,esi
	ret
ticontinuesearch endp

tisearch proc
	.if cmsearchidd(fsflag)
	    mov eax,fsflag
	    and eax,not IO_SEARCHMASK
	    and edx,IO_SEARCHMASK
	    or  eax,edx
	    mov fsflag,eax
	    mov sflag,eax
	    invoke ticontinuesearch
	.endif
	sub eax,eax
	ret
tisearch endp

tisearchxy proc
local linebuf[128]:byte
	invoke  scgetword,addr linebuf
	jz	@F
	invoke  strcpy,addr searchstring,eax
	invoke  tisearch
      @@:
	ret
tisearchxy endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

ID_YES  equ	1
ID_ALL  equ	2
ID_NO	equ	3

iddreplaceprompt proc private uses ebx
	mov eax,1
	mov ebx,tinfo
	.if [ebx].S_TINFO.ti_flag & _T_PROMPTONREP
	    .if rsmodal(IDD_ReplacePrompt)
		mov edx,eax
		.if eax
		    dec edx
		.endif
		mov ebx,IDD_ReplacePrompt
		mov [ebx].S_ROBJ.rs_index,dl
		mov ebx,tinfo
		.if eax == ID_ALL
		    xor [ebx].S_TINFO.ti_flag,_T_PROMPTONREP
		.endif
	    .endif
	.endif
	test eax,eax
	ret
iddreplaceprompt endp

ID_OLDSTRING	equ 1*16
ID_NEWSTRING	equ 2*16
ID_USECASE	equ 3*16
ID_PROMPT	equ 4*16
ID_CURSOR	equ 5*16
ID_GLOBAL	equ 6*16
ID_OK		equ 7
ID_CHANGEALL	equ 8

iddreplace proc private uses ebx
	.if rsopen(IDD_Replace)
	    mov ebx,eax
	    mov [ebx].S_TOBJ.to_count[ID_OLDSTRING],128 shr 4
	    mov [ebx].S_TOBJ.to_count[ID_NEWSTRING],128 shr 4
	    mov eax,offset searchstring
	    mov [ebx].S_TOBJ.to_data[ID_OLDSTRING],eax
	    mov eax,offset replacestring
	    mov [ebx].S_TOBJ.to_data[ID_NEWSTRING],eax
	    mov eax,fsflag
	    mov dl,_O_FLAGB
	    .if eax & IO_SEARCHCASE
		or [ebx][ID_USECASE],dl
	    .endif
	    .if eax & _T_PROMPTONREP
		or [ebx][ID_PROMPT],dl
	    .endif
	    mov dl,_O_RADIO
	    .if eax & IO_SEARCHCUR
		or [ebx][ID_CURSOR],dl
	    .else
		or [ebx][ID_GLOBAL],dl
	    .endif
	    invoke dlinit,ebx
	    .if rsevent(IDD_Replace,ebx)
		mov eax,fsflag
		and eax,not (IO_SEARCHMASK or _T_PROMPTONREP)
		mov dl,_O_FLAGB
		.if [ebx][ID_USECASE] & dl
		    or eax,IO_SEARCHCASE
		.endif
		.if [ebx][ID_PROMPT] & dl
		    or eax,_T_PROMPTONREP
		.endif
		.if byte ptr [ebx][ID_CURSOR] & _O_RADIO
		    or eax,IO_SEARCHCUR
		.else
		    or eax,IO_SEARCHSET
		.endif
		mov edx,eax
		xor eax,eax
		.if searchstring != al
		    .if replacestring != al
			inc eax
		    .endif
		.endif
	    .endif
	    push edx
	    invoke dlclose,ebx
	    mov eax,edx
	    pop edx
	.endif
	test eax,eax
	ret
iddreplace endp

tireplace proc uses esi edi ebx
	mov esi,tinfo
	mov eax,_T_PROMPTONREP
	or  [esi].S_TINFO.ti_flag,eax
	.if iddreplace()
	    mov fsflag,edx
	    mov sflag,edx
	    .if eax == ID_CHANGEALL || !(edx & _T_PROMPTONREP)
		and [esi].S_TINFO.ti_flag,not _T_PROMPTONREP
	    .endif
	    .repeat
		.break .if tisearchcontinue(0)
		.break .if !iddreplaceprompt()
		.if eax != ID_NO
		    invoke ticlipdel			; delete text
		    mov edi,offset replacestring	; add new text
		    .repeat
			mov al,[edi]
			inc edi
			.break .if !al
			invoke tiputc
		    .until 0
		.endif
	    .until 0
	.endif
	invoke tiputs
	invoke ticlipset
	xor eax,eax
	ret
tireplace endp

	END
