; TVIEW.ASM--
; Copyright (c) 1998-2014 Hjort Nidudsson
;
; 02/10/1998
;
; Change history:
; 2013-03-06 - added Memory View (doszip)
; 12/28/2011 - removed Binary View (doszip)
;	     - removed Class View (doszip)
;	     - removed View Memory (doszip)
;	     - added zoom function (F11)
; 08/02/2010 - added Class View
; 10/10/2009 - fixed bug in Clipboard
; 10/10/2009 - new malloc() and free()
; 11/15/2008 - added function Seek
; 11/13/2008 - Moved Binary View to F4
;	     - added switch /M, view memory [00000..FFFFF]
; 09/10/2008 - Divide error in putinfo(percent)
;	     - command END  in dump text (F2) moves to top of file
;	     - command UP   in dump text (F2) moves to top of file
;	     - command PGUP in dump text (F2) moves to top of file
;	     - command END  in hex view  (F4) offset not aligned
;	     - command END  in HEX and BIN -- last offset + 1 < offset
;	     - added short key Ctrl+End -- End of line (End right)
;	     - added IO Bit Stream
; 04/20/2007 - added switch /O<offset>
; 03/15/2007 - fixed Short-Key ESC on zero byte files
; 03/12/2007 - added Binary View
;
include alloc.inc
include string.inc
include stdio.inc
include stdlib.inc
include io.inc
include dir.inc
include errno.inc
include iost.inc
include clip.inc
include conio.inc
include keyb.inc
include math.inc
include ini.inc
include time.inc
include tview.inc

externdef	tvflag: byte
externdef	fsflag: byte
externdef	IDD_TVCopy:dword
externdef	IDD_TVSeek:dword
public		format_lu

tvhelp		proto
tvabout		proto
cmsearchidd	proto :dword

MAXLINES	equ 256

S_TVIEW		STRUC
tv_filename	dd ?
tv_offset	dd ?
tv_dialog	dd ?		; main dialog pointer
tv_rowcnt	dd ?		; max lines (23/48)
tv_lcount	dd ?		; lines on screen
tv_scount	dd ?		; bytes on screen
tv_maxcol	dd ?		; max linesize on screen
tv_curcol	dd ?		; current line offset (col)
tv_screen	dd ?		; screen buffer
tv_menusline	dd ?
tv_statusline	dd ?
tv_switch	dd ?		; main switch
tv_cursor	S_CURSOR <>	; cursor (old)
tv_bsize	dd ?		; buffer size
tv_xpos		dd ?		; temp (mouse)
tv_ypos		dd ?		; temp (mouse)
tv_zpos		dd ?		; temp (mouse)
tv_tmp		dd ?		; temp 32
tv_static_count dd ?		; line count
tv_line_table	dd 256 dup(?)	; line offset in file
tv_static_table dd MAXLINES dup(?) ; offset of first <MAXLINES> lines
S_TVIEW		ENDS

.data

cp_deci		db 'Dec'
cp_hex		db 'Hex  '
cp_ascii	db 'Ascii'
cp_wrap		db 'Wrap  '
cp_unwrap	db 'Unwrap'
cp_byte		db 'byte',0

key_global label size_t
	dd KEY_F1,KEY_F2,KEY_F3,KEY_F4,KEY_F5,KEY_F6,KEY_F7,KEY_F10,KEY_ESC
	dd KEY_ALTX,KEY_CTRLF5,KEY_ALTF5,KEY_CTRLB
	dd KEY_CTRLM,KEY_CTRLS,KEY_F11
global_count = (($ - offset key_global) / size_l)
key_local label size_t
	dd KEY_UP,KEY_DOWN,KEY_PGUP,KEY_PGDN,KEY_LEFT,KEY_RIGHT
	dd KEY_HOME,KEY_END,KEY_CTRLE,KEY_CTRLX,KEY_CTRLR,KEY_CTRLC
	dd KEY_MOUSEUP,KEY_MOUSEDN,KEY_CTRLLEFT,KEY_CTRLRIGHT
	dd KEY_SHIFTF3,KEY_CTRLL,KEY_CTRLEND,KEY_CTRLHOME
local_count = (($ - offset key_global) / size_l)

proc_label label size_t
	dd tvhelp,cmwrap,cmsearch,cmhex,cmcopy,cmoffset,cmseek,cmquit,cmquit
	dd cmquit,cmcolor,cmconsole,cmconsole
	dd event_togglemline,event_togglesline,event_togglesize
	dd event_UP,event_DOWN,event_PGUP,event_PGDN,event_LEFT,event_RIGHT
	dd event_HOME,event_END,event_UP,event_DOWN,event_PGUP,event_PGDN
	dd event_MOUSEUP,event_MOUSEDN,event_PGLEFT,event_PGRIGHT
	dd event_search,event_search,event_toend,event_tostart

label_scroll label size_t
	dd mouse_scroll_delay
	dd mouse_scroll_up
	dd mouse_scroll_down
	dd mouse_scroll_left
	dd mouse_scroll_right

DLG_Textview	S_DOBJ <?>
UseClipboard	db ?
cp_Attrib	db 'TVColor',0
Attrib_00	db 17h
Attrib_01	db 1Fh
rsrows		db 24

format_lu	db "%u",0
format_08Xh	db "%08Xh",0

;******** Resource begin TVStatusline *
;	{ 0x0054,   0,	 0, { 0,24,80, 1} },
;******** Resource data  *******************
Statusline_RC	dw 0200h,0054h,0000h
		db 0
Statusline_Y	db 24
Statusline_C0	db 80,1
		dw 03F3Ch,0F03Fh,03C07h,03F3Fh
		dw 09F0h,3F3Ch,0F03Fh,03C09h,03F3Fh,008F0h,03F3Ch,0F03Fh
		dw 03C07h,03F3Fh,006F0h,03F3Ch,0F03Fh,03C0Ah,03F0h
		db 3Fh,0F0h
Statusline_C1	db 6,3Ch
		dw 04620h,02031h,06548h,0706Ch,02020h,03246h,05720h
		dw 06172h,0F070h,02004h,03346h,05320h,06165h,06372h,02068h
		dw 04620h,02034h,06548h,0F078h,02004h,03546h,04320h,0706Fh
		dw 02079h,04620h,02036h,06544h,02063h,04620h,02037h,06553h
		dw 06B65h,005F0h,04520h,06373h,05120h,06975h
		db 74h
		db 0F0h
Statusline_C2	db 1,' '
IDD_Statusline  dd Statusline_RC

;******** Resource begin TVMenusline *
;	{ 0x0050,   0,	 0, { 0, 0,80, 1} },
;******** Resource data  *******************
Menusline_RC	dw 0200h,0050h,0000h,0000h
Menusline_C0	db 80,1,0F0h
Menusline_C1	db 80,3Ch,0F0h
Menusline_C2	db 80,' '
IDD_Menusline	dd Menusline_RC

.code

	ASSUME  ebp:ptr S_TVIEW

cmp_bbscount1_fsize:
	mov	eax,[ebp].tv_scount
	add	eax,STDI.ios_bb
	inc	eax
	cmp	eax,dword ptr STDI.ios_fsize
	ret

add_offset:
	push	edx
	mov	eax,[ebp].tv_lcount
	inc	[ebp].tv_lcount
	lea	edx,[ebp+eax*4].tv_line_table
	mov	eax,[ebp].tv_offset
	mov	[edx],eax
	pop	edx
	ret

getc:
	call	ogetc
	jz	getc_clc	; eof
	inc	[ebp].S_TVIEW.tv_offset
    getc_cmp:
	cmp	al,13
	je	getc_stc
	cmp	al,10
	je	getc_stc
    getc_clc:	; CF clear: normal byte or eof
	clc
	ret
    getc_stc:	; CF set: new line
	inc	ah
	stc
	ret

ungetc:
	call	oungetc
	jz	getc_clc
	dec	[ebp].tv_offset
	jmp	getc_cmp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

read_static_table:	; offset of first <MAXLINES> lines
	push	edi
	lea	edi,[ebp].tv_static_table
	sub	eax,eax
	stosd
	mov	[ebp].tv_offset,eax
	mov	[ebp].tv_static_count,1
	invoke  oseekl,eax,SEEK_SET
	jz	sttable_end
    sttable_loop:
	call	getc
	jc	sttable_crlf
	jnz	sttable_loop
    sttable_add2:
	call	sttable_add
	call	sttable_add
	dec	[ebp].tv_static_count
	jmp	sttable_break
    sttable_crlf:
	call	getc
	jz	sttable_add2
	jc	@F
	call	ungetc
      @@:
	call	sttable_add
	mov	eax,[ebp].tv_static_count
	cmp	eax,MAXLINES-3
	jna	sttable_loop
    sttable_break:
	dec	[ebp].tv_static_count
    sttable_end:
	pop	edi
	ret
    sttable_add:
	mov	eax,[ebp].tv_offset
	mov	[edi],eax
	add	edi,4
	inc	[ebp].tv_static_count
	ret

read_line_table:; read line offset in file
	push	esi
	mov	[ebp].tv_lcount,1
	mov	eax,STDI.ios_bb
	mov	[ebp].tv_line_table,eax
	mov	[ebp].tv_offset,eax
	mov	cl,tvflag
	test	cl,_TV_HEXVIEW
	jz	line_table_txt
	jmp	line_table_hex
    line_table_txt:
	test	cl,_TV_WRAPLINES
	jnz	line_table_end
	lea	edx,[ebp].tv_static_table
	mov	ecx,[ebp].tv_static_count
    line_table_static:
	cmp	eax,[edx]
	je	line_table_stfound
	add	edx,4
	dec	ecx
	jnz	line_table_static
	xor	edx,edx
    line_table_stfound:
	test	edx,edx
	jz	line_table_read
    line_table_add:
	add	edx,4
	mov	eax,[edx]
	mov	[ebp].tv_offset,eax
	call	add_offset
	mov	eax,[ebp].tv_lcount
	cmp	eax,[ebp].tv_rowcnt
	ja	line_table_max
	dec	ecx
	jnz	line_table_add
	mov	eax,[ebp].tv_offset
	cmp	eax,dword ptr STDI.ios_fsize
	je	line_table_max
    line_table_read:
	invoke  oseekl,eax,SEEK_SET
	jz	line_table_end
	mov	esi,8000h
    line_table_getc:
	call	ogetc
	jz	line_table_eof
	inc	[ebp].tv_offset
	cmp	al,0Dh
	je	line_table_crlf
	cmp	al,0Ah
	je	line_table_crlf
	dec	esi
	jz	line_table_crlf
	jmp	line_table_getc
    line_table_eof:
	call	add_offset
	call	add_offset
	dec	[ebp].tv_lcount
    line_table_max:
	dec	[ebp].tv_lcount
    line_table_end:
	pop	esi
	jnz	init_screenbuf
	ret
    line_table_hex:
	invoke  oseekl,eax,SEEK_SET
	jz	line_table_end
	mov	esi,16
	xor	ecx,ecx
    line_table_loop:
	mov	eax,[ebp].tv_offset
	add	eax,esi
	mov	[ebp].tv_offset,eax
	cmp	eax,dword ptr STDI.ios_fsize
	ja	line_table_beof
	call	add_offset
	inc	ecx
	cmp	ecx,[ebp].tv_rowcnt
	jb	line_table_loop
	jmp	line_table_eof
    line_table_beof:
	mov	eax,dword ptr STDI.ios_fsize
	mov	[ebp].tv_offset,eax
	jmp	line_table_eof
    line_table_crlf:
	call	getc
	jz	line_table_eof
	jc	line_table_14
	call	ungetc
    line_table_14:
	call	add_offset
	mov	eax,[ebp].tv_lcount
	cmp	eax,[ebp].tv_rowcnt
	ja	line_table_max
	jmp	line_table_getc

init_screenbuf:
	push	edi
	mov	eax,_scrcol
	mul	[ebp].tv_rowcnt
	mov	ecx,eax
	mov	edi,[ebp].tv_screen
	mov	eax,20h
	rep	stosb
	pop	edi
	mov	eax,STDI.ios_bb
	mov	[ebp].tv_offset,eax
	invoke  oseekl,eax,SEEK_SET
	ret

parse_line:
	push	esi
	push	edi
	xor	esi,esi
    parse_line_00:
	call	getc
	jz	parse_line_02
	jc	parse_line_04
	cmp	al,9
	je	parse_line_TAB
	mov	[edi],al
	.if !al
	    mov byte ptr [edi],' '
	.endif
	inc	edi
	inc	esi
    parse_line_01:
	cmp	esi,_scrcol
	je	parse_line_07
	jb	parse_line_00
    parse_line_02:
	pop	edi
	pop	esi
	jz	parse_line_03
	add	edi,_scrcol
    parse_line_03:
	ret
    parse_line_04:
	call	getc
	jna	parse_line_02
    parse_line_05:
	dec	[ebp].tv_offset
	dec	STDI.ios_i
	jmp	parse_line_02
    parse_line_TAB:
	mov	eax,esi
	add	eax,[ebp].tv_curcol
	add	eax,8
	and	eax,-8
	sub	eax,esi
	sub	eax,[ebp].tv_curcol
	add	esi,eax
	add	edi,eax
	jmp	parse_line_01
    parse_line_07:
	call	getc
	jz	parse_line_02
	jc	parse_line_04
	jmp	parse_line_05

read_wrap:
	call	read_line_table
	jz	read_wrap_02
	push	edi
	mov	edi,[ebp].tv_screen
	xor	eax,eax
	mov	[ebp].tv_bsize,eax
	mov	[ebp].tv_lcount,eax
    read_wrap_00:
	mov	eax,[ebp].tv_bsize
	inc	[ebp].tv_bsize
	cmp	eax,[ebp].tv_rowcnt
	jnc	read_wrap_01
	call	add_offset
	call	parse_line
	jnz	read_wrap_00
    read_wrap_01:
	mov	eax,[ebp].tv_offset
	sub	eax,STDI.ios_bb
	mov	[ebp].tv_scount,eax
	or	eax,1
	pop	edi
	ret
    read_wrap_02:
	xor	eax,eax
	ret

read_text:
	push edi
	call read_line_table
	jz  @F
	mov edx,[ebp].tv_maxcol
	mov eax,[ebp].tv_lcount
	.while eax
	    mov ecx,[ebp+eax*4].tv_line_table
	    dec eax
	    sub ecx,[ebp+eax*4].tv_line_table
	    .if ecx > edx
		mov edx,ecx
	    .endif
	.endw
	mov [ebp].tv_maxcol,edx
	mov edi,[ebp].tv_screen
	mov [ebp].tv_bsize,0
	.repeat
	    mov eax,[ebp].tv_bsize
	    inc [ebp].tv_bsize
	    .break .if eax >= [ebp].tv_lcount
	    lea edx,[ebp+eax*4].tv_line_table
	    mov eax,[edx+4]
	    sub eax,[edx]
	    add [ebp].tv_scount,eax
	    .if eax <= [ebp].tv_curcol
		add edi,_scrcol
	    .else
		mov eax,[edx]
		add eax,[ebp].tv_curcol
		invoke oseekl,eax,SEEK_SET
		jz @F
		call parse_line
	    .endif
	.until ZERO?
	or eax,1
      @@:
	pop edi
	ret

mk_hexword:
	mov ah,al
	and ax,0FF0h
	shr al,04h
	add ax,3030h
	.if ah > 39h
	    add ah,07h
	.endif
	.if al > 39h
	    add al,07h
	.endif
	ret

read_hex:
	push esi
	push edi
	push ebx
	call read_line_table
	.if !ZERO?
	    call ogetc
	    .if !ZERO?
		dec STDI.ios_i
		push STDI.ios_c
		mov eax,16
		mul [ebp].tv_rowcnt
		.if eax < STDI.ios_c
		    mov STDI.ios_c,eax
		.endif
		mov eax,STDI.ios_c
		xor ecx,ecx
		mov [ebp].tv_scount,eax
		mov esi,[ebp].tv_screen
		.repeat
		    mov edi,esi
		    lea ebx,[ebp+ecx*4+3].tv_line_table
		    .if !(tvflag & _TV_HEXOFFSET)
			invoke sprintf,edi,"%010u  ",[ebx-3]
			add edi,9
		    .else
			mov edx,4
			.repeat
			    mov al,[ebx]
			    call mk_hexword
			    stosw
			    dec ebx
			    dec edx
			.until !edx
			inc edi
		    .endif
		    mov edx,STDI.ios_c
		    mov eax,16
		    add edi,3
		    .if edx >= eax
			mov edx,eax
		    .endif
		    .break .if !edx
		    sub STDI.ios_c,edx
		    mov ebx,edi
		    add ebx,51
		    push ecx
		    mov ecx,edx
		    xor edx,edx
		    .repeat
			.if edx == 8
			    mov al,179
			    stosb
			    inc edi
			.endif
			mov eax,STDI.ios_i
			.break .if eax >= STDI.ios_size
			add eax,STDI.ios_bp
			mov al,[eax]
			inc STDI.ios_i
			mov [ebx],al
			.if !al
			    mov byte ptr [ebx],' '
			.endif
			call mk_hexword
			stosw
			inc edi
			inc ebx
			inc edx
		    .untilcxz
		    pop ecx
		    add esi,_scrcol
		    inc ecx
		.until ecx >= [ebp].tv_lcount
		pop eax
		mov STDI.ios_c,eax
		mov eax,1
	    .endif
	.endif
	pop ebx
	pop edi
	pop esi
	ret

previous_line:
	mov	eax,STDI.ios_bb
	mov	[ebp].tv_offset,eax
	test	eax,eax
	jnz	prevline_size?
    prevline_00:
	xor	eax,eax
	ret
    prevline_size?:
	cmp	eax,dword ptr STDI.ios_fsize
	jbe	prevline_hex?
    fsize_to_bb:
	mov	eax,dword ptr STDI.ios_fsize
	mov	STDI.ios_bb,eax
	ret
    prevline_hex?:
	xor	ecx,ecx
	mov	bl,tvflag
	test	bl,_TV_HEXVIEW
	jz	previous_text
	mov	ebx,16
    previous_hex_00:
	cmp	eax,ebx
	jbe	prevline_00
	sub	eax,ebx
	ret
    previous_text:
	mov	eax,[ebp].tv_static_count
	mov	eax,[ebp+eax*4].tv_static_table ; get last offset
	cmp	eax,[ebp].tv_offset
	jb	previous_seek_back
	mov	eax,[ebp].tv_offset
	mov	ecx,[ebp].tv_static_count
	dec	ecx
    previous_static_00:
	lea	edx,[ebp+ecx*4].tv_static_table
	cmp	eax,[edx]
	ja	previous_static_01
	test	ecx,ecx
	jz	prevline_00
	dec	ecx
	jmp	previous_static_00
    previous_static_01:
	mov	eax,[edx]
	jmp	prevline_wrap?
    previous_seek_back:
	mov	eax,[ebp].tv_offset
	invoke  oseekl,eax,SEEK_SET
	jz	previous_seek_00
	call	ungetc
	jz	previous_seek_00
	push	esi
	mov	esi,8000h
	jnc	previous_back_01
	call	ungetc
	jz	prevline_si00
    previous_back_01:
	call	oungetc
	jz	prevline_si00
	dec	[ebp].tv_offset
	cmp	al,0Dh
	je	prevline_seek_01
	cmp	al,0Ah
	je	prevline_seek_01
	dec	esi
	jz	prevline_seek_01
	jmp	previous_back_01
    prevline_si00:
	pop	esi
    previous_seek_00:
	jmp	prevline_00
    prevline_seek_01:
	pop	esi
	mov	eax,[ebp].tv_offset
	inc	eax
    prevline_wrap?:
	test	tvflag,_TV_WRAPLINES
	jnz	prevline_wrap
	ret
    prevline_wrap:
	cmp	eax,STDI.ios_bb
	ja	prevline_wrap_home
	mov	edx,STDI.ios_bb
	sub	edx,eax
	cmp	edx,8000h
	jb	prevline_wrap_01
    prevline_wrap_00:
	add	eax,edx
	sub	eax,_scrcol
    prevline_wrap_01:
	mov	[ebp].tv_offset,eax
	mov	[ebp].tv_tmp,eax
	invoke  oseekl,eax,SEEK_SET
	jz	prevline_wrap_home
	push	edi
    prevline_wrap_02:
	mov	edi,[ebp].tv_screen
	call	parse_line
	jz	prevline_wrap_end
	mov	eax,[ebp].tv_offset
	cmp	eax,STDI.ios_bb
	jae	prevline_wrap_end
	mov	[ebp].tv_tmp,eax
	jmp	prevline_wrap_02
    prevline_wrap_home:
	jmp	prevline_00
    prevline_wrap_end:
	pop	edi
	mov	eax,[ebp].tv_tmp
	ret

tvread:
	mov [ebp].tv_scount,0
	.if tvflag & _TV_HEXVIEW
	    call read_hex
	.elseif tvflag & _TV_WRAPLINES
	    call read_wrap
	.else
	    call read_text
	.endif
	ret

reread:
	.if tvread()
	    call putscreen
	    mov eax,1
	.endif
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

putscreenb proc private uses esi edi ebx y:dword, row:dword, lp:dword
local co:COORD
local bz:COORD
local rect:SMALL_RECT
local lbuf[TIMAXSCRLINE]:CHAR_INFO
	lea edi,lbuf
	xor eax,eax
	mov ecx,sizeof lbuf/4
	rep stosd
	mov esi,lp
	mov ebx,row
	.repeat
	    lea edi,lbuf
	    mov ecx,_scrcol
	    mov ah,Attrib_00
	    .if tvflag & _TV_HIGHCOLOR
		mov ah,Attrib_01
	    .endif
	    .repeat
		lodsb
		mov [edi],al
		mov [edi+2],ah
		add edi,SIZE CHAR_INFO
	    .untilcxz
	    mov eax,_scrcol
	    mov bz.co_x,ax
	    mov bz.co_y,1
	    mov rect.Left,0
	    mov rect.Right,ax
	    mov eax,y
	    add eax,row
	    sub eax,ebx
	    mov rect.Top,ax
	    mov rect.Bottom,ax
	    mov co.co_x,0
	    mov co.co_y,0
	    .break .if !WriteConsoleOutput(hStdOutput,
		addr lbuf,dword ptr bz,dword ptr co,addr rect)
	    dec ebx
	.until !ebx
	ret
putscreenb endp

putscreen:
	.if tvflag & _TV_USEMLINE
	    mov eax,[ebp].tv_scount
	    add eax,STDI.ios_bb
	    .if eax
		mov ecx,100
		mul ecx
		mov ecx,dword ptr STDI.ios_fsize
		div ecx
		and eax,007Fh
		.if eax > 100
		    mov eax,100
		.endif
	    .else
		mov eax,100
	    .endif
	    mov edx,_scrcol
	    sub edx,5
	    invoke scputf,edx,0,0,0,"%3d",eax
	    sub edx,10
	    invoke scputf,edx,0,0,0,"%-8d",[ebp].tv_curcol
	.endif
	mov eax,dword ptr STDI.ios_fsize
	.if eax
	    sub eax,eax
	    .if tvflag & _TV_USEMLINE
		inc eax
	    .endif
	    invoke putscreenb,eax,[ebp].tv_rowcnt,[ebp].tv_screen
	.endif
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

event_HOME:
	sub eax,eax
	mov STDI.ios_bb,eax
	mov [ebp].S_TVIEW.tv_curcol,eax
	jmp reread

event_END:
	mov ecx,dword ptr STDI.ios_fsize
	mov edx,[ebp].S_TVIEW.tv_rowcnt
	.if tvflag & _TV_HEXVIEW
	    mov eax,edx
	    shl eax,4
	    inc eax
	    .if eax < ecx
		sub eax,ecx
		not eax
		add eax,18
		and al,0F0h
		mov STDI.ios_bb,eax
		jmp reread
	    .endif
	.else
	    mov eax,[ebp].S_TVIEW.tv_lcount
	    .if eax >= edx
		mov eax,[ebp].S_TVIEW.tv_scount
		add eax,STDI.ios_bb
		inc eax
		.if eax < ecx
		    mov STDI.ios_bb,ecx
		    jmp event_PGUP_text
		.endif
	    .endif
	.endif
	ret

event_UP:
	.if previous_line() != STDI.ios_bb
	    mov STDI.ios_bb,eax
	    jmp reread
	.endif
	ret

event_DOWN:
	.if tvflag & _TV_HEXVIEW
	    mov eax,[ebp].S_TVIEW.tv_scount
	    add eax,STDI.ios_bb
	    inc eax
	    .if eax < dword ptr STDI.ios_fsize
		add eax,15
		.if eax >= dword ptr STDI.ios_fsize
		    jmp event_END
		.endif
		add STDI.ios_bb,16
		jmp reread
	    .endif
	.else
	    mov eax,[ebp].S_TVIEW.tv_lcount
	    .if eax >= [ebp].S_TVIEW.tv_rowcnt
		mov eax,[ebp+4].S_TVIEW.tv_line_table
		mov STDI.ios_bb,eax
		jmp reread
	    .endif
	.endif
	sub eax,eax
	ret

event_MOUSEUP:
	call	event_UP
	call	event_UP
	call	event_UP
	ret
event_MOUSEDN:
	call	event_DOWN
	call	event_DOWN
	call	event_DOWN
	ret

event_PGUP:
	mov	cl,tvflag
	mov	eax,STDI.ios_bb
	test	eax,eax
	jz	event_PGUP_04
	test	cl,_TV_HEXVIEW
	jz	event_PGUP_text
	mov	eax,[ebp].S_TVIEW.tv_rowcnt
	shl	eax,4
	cmp	eax,STDI.ios_bb
	jnb	@F
	sub	STDI.ios_bb,eax
	jmp	event_PGUP_03
      @@:
	xor	eax,eax
	mov	STDI.ios_bb,eax
    event_PGUP_03:
	jmp	reread
    event_PGUP_04:
	ret

    event_PGUP_text:
	push	edi
	mov	edi,1
	test	tvflag,_TV_WRAPLINES
	jnz	event_PGUP_wrap
    event_PGUP_06:
	call	previous_line
	cmp	eax,STDI.ios_bb
	je	event_PGUP_08
	mov	STDI.ios_bb,eax
	inc	edi
	cmp	edi,[ebp].S_TVIEW.tv_rowcnt
	jnz	event_PGUP_06
    event_PGUP_08:
	pop	edi
	jmp	reread
    event_PGUP_wrap:
	cmp	eax,dword ptr STDI.ios_fsize
	jne	event_PGUP_06
	mov	edi,[ebp].S_TVIEW.tv_rowcnt
	dec	edi
    event_PGUP_10:
	call	previous_line
	mov	STDI.ios_bb,eax
	dec	edi
	jnz	event_PGUP_10
	jmp	event_PGUP_08

event_PGDN:
	mov	al,tvflag
	call	cmp_bbscount1_fsize
	jnb	event_PGDN_03
	test	tvflag,_TV_HEXVIEW
	jz	event_PGDN_01
	mov	ebx,eax
	mov	eax,[ebp].S_TVIEW.tv_rowcnt
	shl	eax,4
	add	ebx,eax
	cmp	ebx,dword ptr STDI.ios_fsize
	jnc	event_PGDN_02
	add	STDI.ios_bb,eax
	jmp	reread
    event_PGDN_01:
	mov	eax,[ebp].S_TVIEW.tv_lcount
	cmp	eax,[ebp].S_TVIEW.tv_rowcnt
	jne	event_PGDN_03
	dec	eax
	shl	eax,2
	lea	ebx,[ebp].S_TVIEW.tv_line_table
	add	ebx,eax
	mov	eax,[ebx]
	cmp	eax,dword ptr STDI.ios_fsize
	jnb	event_PGDN_02
	mov	STDI.ios_bb,eax
	jmp	reread
    event_PGDN_02:
	jmp	event_END
    event_PGDN_03:
	ret

event_LEFT:
	test tvflag,_TV_HEXVIEW or _TV_WRAPLINES
	jnz @F
	.if [ebp].S_TVIEW.tv_curcol
	    dec [ebp].S_TVIEW.tv_curcol
	    jmp reread
	.endif
      @@:
	ret

event_PGLEFT:
	test tvflag,_TV_HEXVIEW or _TV_WRAPLINES
	jnz @F
	mov eax,[ebp].S_TVIEW.tv_curcol
	.if eax
	    .if eax >= _scrcol
		sub eax,_scrcol
	    .else
		xor eax,eax
	    .endif
	    mov [ebp].S_TVIEW.tv_curcol,eax
	    jmp reread
	.endif
      @@:
	ret

event_RIGHT:
	.if !(tvflag & _TV_HEXVIEW or _TV_WRAPLINES)
	    mov eax,[ebp].S_TVIEW.tv_curcol
	    .if eax < [ebp].S_TVIEW.tv_maxcol
		inc [ebp].S_TVIEW.tv_curcol
		jmp reread
	    .endif
	.endif
	ret

event_PGRIGHT:
	.if !(tvflag & _TV_HEXVIEW or _TV_WRAPLINES)
	    mov eax,[ebp].S_TVIEW.tv_curcol
	    .if eax < [ebp].S_TVIEW.tv_maxcol
		add eax,_scrcol
		.if eax > [ebp].S_TVIEW.tv_maxcol
		    mov eax,[ebp].S_TVIEW.tv_maxcol
		.endif
		mov [ebp].S_TVIEW.tv_curcol,eax
		jmp reread
	    .endif
	.endif
	ret

event_toend:
	test	tvflag,_TV_HEXVIEW or _TV_WRAPLINES
	jnz	event_toend_00
	mov	eax,[ebp].S_TVIEW.tv_maxcol
	cmp	eax,_scrcol
	jae	event_toend_01
    event_toend_00:
	ret
    event_toend_01:
	sub	eax,20

event_toend_curcol:
	mov	[ebp].S_TVIEW.tv_curcol,eax
	jmp	reread

event_tostart:
	sub	eax,eax
	jmp	event_toend_curcol

event_togglemline:
	xor	tvflag,_TV_USEMLINE
	test	tvflag,_TV_USEMLINE
	jnz	@F
	invoke  dlhide,[ebp].S_TVIEW.tv_menusline
	inc	[ebp].S_TVIEW.tv_rowcnt
	jmp	reread
      @@:
	invoke  dlshow,[ebp].S_TVIEW.tv_menusline
	dec	[ebp].S_TVIEW.tv_rowcnt
	jmp	reread

event_togglesize:
	mov al,tvflag
	.if al & (_TV_USESLINE or _TV_USEMLINE)
	    .if al & _TV_USEMLINE
		call event_togglemline
	    .endif
	    .if !(tvflag & _TV_USESLINE)
		ret
	    .endif
	.else
	    call event_togglemline
	.endif

event_togglesline:
	xor tvflag,_TV_USESLINE
	.if tvflag & _TV_USESLINE
	    invoke dlshow,[ebp].S_TVIEW.tv_statusline
	    dec [ebp].S_TVIEW.tv_rowcnt
	.else
	    invoke dlhide,[ebp].S_TVIEW.tv_statusline
	    inc [ebp].S_TVIEW.tv_rowcnt
	.endif
	jmp reread

event_search:
	call	continuesearch
	test	eax,eax
	jnz	event_tostart
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

cmsearch:
	and	STDI.ios_flag,not IO_SEARCHMASK
	mov	al,fsflag
	and	eax,IO_SEARCHMASK
	or	STDI.ios_flag,eax
	sub	eax,eax
	cmp	dword ptr STDI.ios_fsize,16
	jb	@F
	invoke  cmsearchidd,STDI.ios_flag
	jz	@F
	mov	STDI.ios_flag,edx
	and	edx,IO_SEARCHCUR or IO_SEARCHSET
	push	edx
	call	continuesearch
	pop	edx
	or	STDI.ios_flag,edx
     @@:
	push	eax
	and	fsflag,not IO_SEARCHMASK
	mov	eax,STDI.ios_flag
	and	STDI.ios_flag,not (IO_SEARCHSET or IO_SEARCHCUR)
	and	al,IO_SEARCHMASK
	or	fsflag,al
	pop	eax
	test	eax,eax
	jz	@F
	jmp	reread
      @@:
	ret

cmseek_offset:
	mov	edx,STDI.ios_bb
	add	edx,[ebp].S_TVIEW.tv_curcol
	mov	[ebp].S_TVIEW.tv_curcol,0
	mov	eax,offset format_08Xh
	test	tvflag,_TV_HEXOFFSET
	jnz	cmseek_offset_hex
	mov	eax,offset format_lu
    cmseek_offset_hex:
	invoke  sprintf,[ebx+24],eax,edx
	invoke  dlinit,ebx
	ret

cmseek:
	push ebx
	.if rsopen(IDD_TVSeek)
	    mov ebx,eax
	    call cmseek_offset
	    .if rsevent(IDD_TVSeek,ebx)
		invoke strtol,[ebx+24]
		.if eax <= dword ptr STDI.ios_fsize
		    mov STDI.ios_bb,eax
		    invoke dlclose,ebx
		    pop ebx
		    jmp reread
		.endif
	    .endif
	    invoke dlclose,ebx
	    xor eax,eax
	.endif
	pop ebx
	ret

cmcopy:
	push ebx
	.if rsopen(IDD_TVCopy)
	    mov ebx,eax
	    .if UseClipboard
		or byte ptr [ebx+4*16],_O_FLAGB
	    .endif
	    call cmseek_offset
	    .if rsevent(IDD_TVCopy,ebx)
		mov UseClipboard,0
		.if byte ptr [ebx+4*16] & _O_FLAGB
		    mov UseClipboard,1
		.endif
		.if strtol([ebx+24]) >= dword ptr STDI.ios_fsize
		    sub eax,eax
		.else
		    invoke oseek,eax,SEEK_SET
		    .if !ZERO?
			sub eax,eax
			.if UseClipboard
			    .if strtol([ebx+40])
				mov edx,eax
				.if oread()
				    invoke ClipboardCopy,eax,edx
				    call ClipboardFree
				    mov eax,1
				.endif
			    .endif
			.else
			    .if oinitst(addr STDO,8000h)
				.if ogetouth([ebx+56],M_WRONLY) != -1
				    mov STDO.ios_file,eax
				    invoke strtol,[ebx+40]
				    sub edx,edx
				    invoke ocopyst,addr STDO,addr STDI,edx::eax
				    invoke oflushst,addr STDO
				    invoke oclose,addr STDO
				    mov eax,1
				.else
				    invoke ofreest,addr STDO
				    sub eax,eax
				.endif
			    .endif
			.endif
		    .endif
		.endif
	    .endif
	    invoke dlclose,ebx
	    mov eax,edx
	.endif
	test eax,eax
	pop ebx
	ret

cmmcopy proc private uses edi ebx
local lb[128]:byte
local x,y:dword
	lea  edi,lb
	call mousex
	mov  ebx,eax
	call mousey
	mov  ecx,eax
	.while ebx < _scrcol
	    invoke getxyc,ebx,ecx
	    stosb
	    inc ebx
	.endw
	sub eax,eax
	stosb
	lea edi,lb
	.if strtrim(edi)
	    invoke ClipboardCopy,edi,eax
	    invoke ClipboardFree
	.endif
	ret
cmmcopy endp

update_dialog:
	push edi
	push ebx
	xor ebx,ebx
	mov edi,_scrrow
	.if tvflag & _TV_USESLINE
	    mov bl,35
	    mov ecx,5
	    mov eax,offset cp_hex
	    .if tvflag & _TV_HEXVIEW
		mov eax,offset cp_ascii
	    .endif
	    invoke scputs,ebx,edi,0,ecx,eax
	    mov bl,13
	    inc cl
	    mov eax,offset cp_unwrap
	    .if tvflag & _TV_WRAPLINES
		mov eax,offset cp_wrap
	    .endif
	    invoke scputs,ebx,edi,0,ecx,eax
	    mov bl,54
	    mov cl,3
	    mov eax,offset cp_deci
	    .if tvflag & _TV_HEXOFFSET
		mov eax,offset cp_hex
	    .endif
	    invoke scputs,ebx,edi,0,ecx,eax
	.endif
	pop ebx
	pop edi
	ret

update_reread:
	call	update_dialog
	jmp	reread

if_fsize:
	sub eax,eax
	.if eax == dword ptr STDI.ios_fsize
	    add esp,4
	.endif
	ret

cmwrap:
	call	if_fsize
	test	tvflag,_TV_HEXVIEW
	jnz	cmwrap_00
	xor	tvflag,_TV_WRAPLINES
	jmp	update_reread
    cmwrap_00:
	xor	eax,eax
	ret

cmoffset:
	call	if_fsize
	xor	tvflag,_TV_HEXOFFSET
	jmp	update_reread

cmhex:
	call if_fsize
	mov al,tvflag
	mov ah,al
	and al,not _TV_HEXVIEW
	.if !(ah & _TV_HEXVIEW)
	    or al,_TV_HEXVIEW
	.endif
	mov tvflag,al
	and al,_TV_HEXVIEW
	.if ZERO?
	    mov eax,[ebp].S_TVIEW.tv_curcol
	    .if eax <= STDI.ios_bb
		sub STDI.ios_bb,eax
	    .endif
	.else
	    mov eax,[ebp].S_TVIEW.tv_curcol
	    add STDI.ios_bb,eax
	    xor eax,eax
	    mov [ebp].S_TVIEW.tv_curcol,eax
	.endif
	jmp update_reread

cmcolor:
	push esi
	push edi
	sub esi,esi
	sub edi,edi
	.if tvflag & _TV_USEMLINE
	    inc esi
	.endif
	xor tvflag,_TV_HIGHCOLOR
	mov ecx,[ebp].S_TVIEW.tv_rowcnt
	mov edx,_scrcol
	mov al,Attrib_00
	.if tvflag & _TV_HIGHCOLOR
	    mov al,Attrib_01
	.endif
	.repeat
	    invoke scputa,edi,esi,edx,eax
	    inc esi
	.untilcxz
	mov eax,1
	pop edi
	pop esi
	ret

cmquit:
	mov	eax,1
	mov	[ebp].S_TVIEW.tv_switch,eax
	dec	eax
	ret

cmconsole:
	invoke  dlhide,[ebp].S_TVIEW.tv_dialog
      @@:
	call	getkey
	test	eax,eax
	jz	@B
	invoke  dlshow,[ebp].S_TVIEW.tv_dialog
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

mouse_scroll:
	xor	ecx,ecx
	cmp	edx,8
	jb	mouse_scroll_07
	cmp	edx,edi
	ja	mouse_scroll_06
	mov	ebx,esi
	sub	ebx,9
	cmp	eax,ebx
	jb	mouse_scroll_05
	add	ebx,9+10
	cmp	eax,ebx
	ja	mouse_scroll_04
	cmp	edx,12
	jnz	mouse_scroll_01
	cmp	eax,esi
	ja	mouse_scroll_04
	jmp	mouse_scroll_05
    mouse_scroll_01:
	cmp	edx,11
	jb	mouse_scroll_02
	cmp	edx,13
	ja	mouse_scroll_02
	mov	ebx,esi
	sub	ebx,4
	cmp	eax,ebx
	jb	mouse_scroll_05
	add	ebx,4+5
	cmp	eax,45
	ja	mouse_scroll_04
    mouse_scroll_02:
	cmp	edx,12
	jb	mouse_scroll_07
	ja	mouse_scroll_06
    mouse_scroll_03:
	ret
    mouse_scroll_04:
	inc	ecx
    mouse_scroll_05:
	inc	ecx
    mouse_scroll_06:
	inc	ecx
    mouse_scroll_07:
	inc	ecx
	push	ecx
	mov	ebx,esi
	sub	ebx,3
	cmp	eax,ebx
	jb	mouse_scroll_09
	add	ebx,3+3
	cmp	eax,ebx
	jb	mouse_scroll_08
	mov	ecx,_scrcol
	dec	ecx
	sub	ecx,eax
	mov	eax,ecx
	jmp	mouse_scroll_09
    mouse_scroll_08:
	xor	eax,eax
    mouse_scroll_09:
	shl	eax,2
	cmp	edx,12
	je	mouse_scroll_10
	jb	mouse_scroll_11
	mov	ecx,_scrrow
	sub	ecx,edx
	mov	edx,ecx
	jmp	mouse_scroll_11
    mouse_scroll_10:
	xor	edx,edx
    mouse_scroll_11:
	shl	edx,2
	pop	ecx
	ret
    mouse_scroll_proc:
	push	esi
	push	edi
	push	ebx
	mov	esi,_scrcol
	mov	edi,_scrrow
	inc	edi
	shr	esi,1
	shr	edi,1
	call	mousey
	push	eax
	call	mousex
	pop	edx
	call	mouse_scroll
	pop	ebx
	pop	edi
	pop	esi
	ret
    mouse_scroll_up:
	mov	eax,KEY_UP
	jmp	mouse_scroll_updn
    mouse_scroll_down:
	mov	eax,KEY_DOWN
    mouse_scroll_updn:
	push	edx
	jmp	mouse_scroll_event
    mouse_scroll_left:
	push	eax
	mov	eax,KEY_LEFT
	jmp	mouse_scroll_event
    mouse_scroll_right:
	push	eax
	mov	eax,KEY_RIGHT
    mouse_scroll_event:
	call	tview_event
	pop	eax
	mov	edi,eax
    mouse_scroll_delay:
	test	edi,edi
	jz	@F
	invoke  delay,edi
      @@:
	ret
    scroll:
	push	edi
	xor	edi,edi
	call	mouse_scroll_proc
	call	label_scroll[ecx*4]
	pop	edi
	ret

mouse_event:
	call	mousep
	jz	mouse_event_07
	cmp	eax,2
	je	mouse_event_09
	call	mousex
	mov	[ebp].S_TVIEW.tv_xpos,eax
	call	mousey
	mov	[ebp].S_TVIEW.tv_ypos,eax
	inc	eax
	cmp	al,rsrows
	jne	mouse_event_08
	test	tvflag,_TV_USESLINE
	jz	mouse_event_08
	call	msloop
	mov	eax,[ebp].S_TVIEW.tv_xpos
	cmp	al,9
	jnb	mouse_event_00
	jmp	tvhelp
    mouse_event_00:
	je	mouse_event_07
	cmp	al,20
	jnb	mouse_event_01
	jmp	cmwrap
    mouse_event_01:
	jz	mouse_event_07
	cmp	al,31
	jnb	mouse_event_02
	jmp	cmsearch
    mouse_event_02:
	je	mouse_event_07
	cmp	al,41
	jnb	mouse_event_03
	jmp	cmhex
    mouse_event_03:
	je	mouse_event_07
	cmp	al,50
	jnb	mouse_event_04
	jmp	cmcopy
    mouse_event_04:
	je	mouse_event_07
	cmp	al,58
	jnb	mouse_event_05
	jmp	cmoffset
    mouse_event_05:
	je	mouse_event_07
	cmp	al,66
	jnbe	mouse_event_06
	jmp	cmseek
    mouse_event_06:
	cmp	al,70
	jbe	mouse_event_07
	call	cmquit
    mouse_event_07:
	xor	eax,eax
	ret
    mouse_event_08:
	call	mousep
	cmp	eax,1
	jne	mouse_event_07
	call	scroll
	jmp	mouse_event_08
    mouse_event_09:
	call	cmmcopy
	call	msloop
	ret

tview_event:
	xor edx,edx
	mov ecx,local_count
	.if edx == dword ptr STDI.ios_fsize
	    mov ecx,global_count
	.endif
	.repeat
	    .if eax == key_global[edx]
		jmp proc_label[edx]
	    .endif
	    add edx,4
	.untilcxz
	ret

modal:
	sub	eax,eax
	cmp	[ebp].S_TVIEW.tv_switch,eax
	je	@F
	ret
     @@:
	call	tgetevent
ifdef __MOUSE__
	cmp	eax,MOUSECMD
	jne	@F
	call	mouse_event
	call	msloop
	jmp	modal
     @@:
endif
	call	tview_event
	jmp	modal

tview_update:
	sub	eax,eax
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

tview proc uses esi edi ebx ebp filename:dword, offs:dword
local	tv:S_TVIEW
	mov	STDI.ios_flag,0
	mov	eax,_scrcol
	mov	Statusline_C0,al
	mov	Menusline_C0,al
	mov	Menusline_C1,al
	mov	Menusline_C2,al
	mov	Statusline_C1,6
	mov	Statusline_C2,1
	sub	al,80
	add	Statusline_C1,al
	add	Statusline_C2,al
	mov	esi,STDI.ios_flag
	mov	eax,offs
	mov	tv.tv_offset,eax
	mov	eax,filename
	mov	tv.tv_filename,eax
	lea	ebp,tv
	lea	eax,[ebp+8]
	invoke  memzero,eax,SIZE S_TVIEW - 8
	.if inientryid(addr cp_Attrib,0)
	    invoke xtol,eax
	    mov Attrib_00,al
	.endif
	.if inientryid(addr cp_Attrib,1)
	    invoke xtol,eax
	    mov Attrib_01,al
	.endif
	mov eax,[ebp].S_TVIEW.tv_offset
	mov STDI.ios_bb,eax
	mov eax,_scrrow
	mov ebx,IDD_Statusline
	mov [ebx+7],al
	inc al
	mov rsrows,al
	.if tvflag & _TV_USEMLINE
	    dec al
	.endif
	.if tvflag & _TV_USESLINE
	    dec al
	.endif
	mov [ebp].S_TVIEW.tv_rowcnt,eax ; adapt to current screen size
	add eax,2
	mul _scrcol
	.if !malloc(eax)
	    jmp tview_end
	.endif
	mov [ebp].S_TVIEW.tv_screen,eax
	.if !(esi & IO_MEMBUF)
	    mov ebx,[ebp].S_TVIEW.tv_offset
	    .if oopen([ebp].S_TVIEW.tv_filename,M_RDONLY,0) == -1 || \
		dword ptr STDI.ios_fsize[4]
		invoke free,[ebp].S_TVIEW.tv_screen
		jmp tview_end
	    .endif
	    mov STDI.ios_bb,ebx
	    .if !(STDI.ios_flag & IO_MEMBUF)
		mov eax,8000h
		mov STDI.ios_c,eax
		mov STDI.ios_size,eax
	    .endif
	.endif
	mov al,Attrib_00
	.if !dlscreen(addr DLG_Textview,eax)
	    invoke free,[ebp].S_TVIEW.tv_screen
	    invoke close,STDI.ios_file
	    mov eax,1
	    jmp tview_end
	.endif
	mov [ebp].S_TVIEW.tv_dialog,eax
	invoke dlshow,eax
	invoke rsopen,IDD_Menusline
	mov [ebp].S_TVIEW.tv_menusline,eax
	invoke dlshow,eax
	invoke rsopen,IDD_Statusline
	mov [ebp].S_TVIEW.tv_statusline,eax
	.if tvflag & _TV_USESLINE
	    invoke dlshow,eax
	.endif
	invoke scpath,1,0,41,[ebp].S_TVIEW.tv_filename
	mov eax,_scrcol
	sub eax,38
	mov edx,dword ptr STDI.ios_fsize
	invoke scputf,eax,0,0,0,"%12u byte",edx
	mov edx,_scrcol
	sub edx,5
	invoke scputs,edx,0,0,0,"100%"
	sub edx,14
	invoke scputs,edx,0,0,0,"col"
	.if !(tvflag & _TV_USEMLINE)
	    invoke dlhide,[ebp].S_TVIEW.tv_menusline
	.endif

	invoke  cursorget,addr [ebp].S_TVIEW.tv_cursor
	invoke  gotoxy,0,1
	invoke  cursoroff
	push	tupdate
	mov	tupdate,tview_update
	call	update_dialog
	call	msloop
	call	read_static_table
	call	reread
	call	modal
	invoke  oclose,addr STDI
	invoke  free,[ebp].S_TVIEW.tv_screen
	invoke  dlclose,[ebp].S_TVIEW.tv_statusline
	invoke  dlclose,[ebp].S_TVIEW.tv_menusline
	invoke  dlclose,[ebp].S_TVIEW.tv_dialog
	invoke  cursorset,addr [ebp].S_TVIEW.tv_cursor
	pop	eax
	mov	tupdate,eax
	sub	eax,eax
	mov	STDI.ios_flag,eax
    tview_end:
	ret
tview endp

	END
