include iost.inc
include unzip.inc
include string.inc
include errno.inc
include math.inc
include conio.inc
include fblk.inc

externdef	odecrypt:dword
externdef	password:byte
externdef	enterpassword:byte
externdef	cp_warning:byte
externdef	IDD_UnzipCRCError:dword

.data
key0		dd 0
key1		dd 0
key2		dd 0
format_sL_02X	db "%s",10,"'%02X'",0

.code

_CRC32:
	xor	eax,edx
	and	eax,000000FFh
	mov	eax,crctab[eax*4]
	shr	edx,8
	xor	eax,edx
	ret

update_keys:
	push	eax
	mov	edx,key0
	call	_CRC32
	mov	key0,eax
	and	eax,000000FFh
	add	eax,key1
	mov	edx,134775813
	mul	edx
	inc	eax
	mov	key1,eax
	mov	edx,key2
	shr	eax,24
	call	_CRC32
	mov	key2,eax
	pop	eax
	ret

decryptbyte:
	push	ebx
	mov	ebx,key2
	or	ebx,2
	mov	edx,ebx
	xor	edx,1
	mov	eax,ebx
	mul	edx
	mov	al,ah
	pop	ebx
	ret

init_keys:
	mov key0,12345678h
	mov key1,23456789h
	mov key2,34567890h
	push esi
	mov esi,offset password
	.repeat
	    xor eax,eax
	    mov al,[esi]
	    inc esi
	    .break .if !al
	    call update_keys
	.until 0
	pop esi
	ret

decrypt:
	push	esi
	push	ebx
	xor	esi,esi
      @@:
	call	decryptbyte
	mov	ebx,STDI.S_IOST.ios_bp
	add	ebx,esi
	xor	[ebx],al
	mov	al,[ebx]
	call	update_keys
	inc	esi
	cmp	esi,STDI.S_IOST.ios_c
	jl	@B
	pop	ebx
	pop	esi
	ret

test_password proc private uses esi edi string:dword
local b[12]:byte
	call	init_keys
	lea	edi,b
	invoke  memcpy,edi,string,12
	xor	esi,esi
	.repeat
	    call decryptbyte
	    xor [edi],al
	    mov al,[edi]
	    call update_keys
	    inc edi
	    inc esi
	.until esi == 12
	lea edi,b
	mov ax,zip_local.lz_time
	.if !(zip_attrib & _FB_ZEXTLOCHD)
	    mov ax,word ptr zip_local.lz_crc+2
	.endif
	.if ah != [edi+11]
	    xor eax,eax
	.else
	    mov ecx,STDI.S_IOST.ios_c
	    sub ecx,12
	    mov esi,STDI.S_IOST.ios_bp
	    add esi,12
	    .repeat
		call decryptbyte
		xor [esi],al
		mov al,[esi]
		call update_keys
		inc esi
	    .untilcxz
	    mov eax,ecx
	    inc eax
	.endif
	ret
test_password endp

zip_decrypt proc private uses esi edi
local b[12]:byte
	mov esi,12
	lea edi,b
      @@:
	call ogetc
	mov [edi],al
	inc edi
	dec esi
	jnz @B
	.if !test_password(addr b)
	    mov password,0
	    .if tgetline(addr enterpassword,addr password,32,80)
		xor eax,eax
		.if password != al
		    invoke test_password,addr b
		.endif
	    .endif
	.endif
	test eax,eax
	ret
zip_decrypt endp

unzip	proc
	push	esi
	mov	esi,ER_MEM
	mov	STDI.ios_file,eax	; zip file handle
	mov	STDO.ios_file,edx	; out file handle
	invoke  oinitst,addr STDO,WSIZE
	jz	mem_error
	invoke  oinitst,addr STDI,-1
	jz	mem_error2
	mov	esi,-1
	mov	STDI.S_IOST.ios_flag,IO_USEBITS
	mov	STDO.S_IOST.ios_flag,IO_UPDTOTAL or IO_USEUPD or IO_USECRC
	test	zip_attrib,_FB_ZENCRYPTED
	jz	method
	invoke  ogetc
	jz	done
	dec	STDI.S_IOST.ios_i
	invoke  zip_decrypt
	test	eax,eax
	jz	done
	or	STDI.S_IOST.ios_flag,IO_CRYPT
    method:
	sub	eax,eax
	or	ax,zip_local.lz_method
	jz	store
	cmp	eax,8
	je	inflate
	cmp	eax,6
	je	explode
	jmp	method_error
    store:
	mov	STDI.S_IOST.ios_flag,IO_USECRC
	sub	edx,edx
	mov	eax,zip_local.lz_fsize
	invoke  ocopyst,addr STDO,addr STDI,edx::eax
	mov	esi,eax
	invoke  oflushst,addr STDO
	dec	esi
	jmp	done
    explode:
	invoke  zip_explode
	mov	esi,eax
	jmp	done
    inflate:
	invoke  zip_inflate
	mov	esi,eax
    done:
	invoke  ofreest,addr STDI
    mem_error2:
	invoke  ofreest,addr STDO
    mem_error:
	test	STDO.S_IOST.ios_flag,IO_ERROR
	jz	@F
	mov	esi,ER_DISK
      @@:
	test	esi,esi
	jnz	toend
	mov	eax,STDO.S_IOST.ios_bb
	not	eax
	cmp	eax,zip_local.lz_crc
	je	toend
	invoke  rsmodal,IDD_UnzipCRCError
	jnz	toend
	mov	esi,ER_CRCERR
    toend:
	mov	eax,esi
	pop	esi
	ret
method_error:
	invoke  ermsg,addr cp_warning,addr format_sL_02X,
		zip_local.lz_method,sys_errlist[ENOSYS*4]
	mov	esi,ERROR_INVALID_FUNCTION
	jmp	toend
unzip	endp

Install:
	mov	eax,decrypt
	mov	odecrypt,eax
	ret

pragma_init	Install,100

	END
