include io.inc
include iost.inc
include dir.inc
include errno.inc
include string.inc
include wsub.inc
include unzip.inc
include time.inc
include fblk.inc
include confirm.inc
include syserrls.inc
include doserrls.inc
include conio.inc
include progress.inc

USE_DEFLATE	equ 1
ISIZE		equ 10000h

	extrn	cp_ziptemp:byte
	extrn	arc_flength:dword
	extrn	cp_emarchive:byte
	extrn	copy_fast:byte
	extrn	entryname:byte
  if USE_DEFLATE
	_C_BEST		equ 0300h
	_C_FASTEST	equ 0200h
	_C_SMALLEST	equ 0100h
	extrn	file_method:byte
	extrn	compresslevel:byte
  endif

.data

ocentral	S_IOST <>

centtmp db 'centtmp.$$$',0

	.code

display_error proc private
	mov	eax,offset CP_ENOSPC
	mov	edx,offset CP_ENOMEM
	test	STDO.ios_flag,IO_ERROR
	jnz	@F
	mov	ecx,errno
	mov	eax,offset CP_ENOMEM
	cmp	ecx,ENOMEM
	je	@F
	mov	eax,offset cp_emarchive
	mov	edx,offset CP_EIO
	test	ecx,ecx
	jz	@F
	mov	edx,sys_errlist[ecx*4]
     @@:
	invoke  ermsg,edx,eax
	ret
display_error endp

zip_renametemp proc private
	invoke  oclose,addr STDI
	invoke  oclose,addr STDO
	invoke  filexist,edi	; 1 file, 2 subdir
	cmp	eax,1
	jne	@F
	invoke  remove,esi
	invoke  rename,edi,esi  ; 0 or -1
	ret
      @@:
	mov	eax,-1
	ret
zip_renametemp endp

zip_copyendcentral proc uses esi edi
	mov	esi,eax
	mov	edi,edx
	invoke  otell
	sub	eax,zip_endcent.ze_off_cent
	mov	zip_endcent.ze_size_cent,eax
	mov	eax,SIZE S_ZEND
	invoke  oread
	jz	copyendcentral_fail
	invoke  memcpy,eax,addr zip_endcent,SIZE S_ZEND
	sub	edx,edx
	movzx	eax,zip_endcent.ze_comment_size
	add	eax,SIZE S_ZEND
	invoke  ocopyst,addr STDO,addr STDI,edx::eax
	jz	copyendcentral_fail
	invoke  oflush
	jz	copyendcentral_fail
	mov	eax,dword ptr STDO.ios_total
	mov	arc_flength,eax
	invoke  zip_renametemp		; 0 or -1
      @@:
	ret
    copyendcentral_fail:
	dec	eax			; -1
	jmp	@B
zip_copyendcentral endp

cmpmm	macro	des,src
	mov	eax,des
	cmp	eax,src
	endm

update_local proc private
	mov	eax,zip_central.cz_off_local
	cmp	eax,dword ptr STDO.ios_total
	jb	@F
	sub	eax,dword ptr STDO.ios_total
	add	eax,STDO.ios_bp
	invoke  memcpy,eax,addr zip_local,SIZE S_LZIP
	ret
      @@:
	invoke  oflush
	jz	@F
	invoke  lseek,STDO.ios_file,zip_central.cz_off_local,SEEK_SET
	invoke  oswrite,STDO.ios_file,addr zip_local,SIZE S_LZIP
	invoke  lseek,STDO.ios_file,0,SEEK_END
      @@:
	ret
update_local endp

mkarchivetmp proc private
	invoke  strcpy,eax,addr __outfile
	invoke  setfext,eax,addr cp_ziptemp
	ret
mkarchivetmp endp

set_progress proc private
	sub	ecx,ecx
	invoke  progress_set,addr __outfile,ebx,ecx::eax
	mov	STDO.ios_flag,IO_USEUPD or IO_UPDTOTAL
	ret
set_progress endp

initentry proc private			; EAX	offset file name buffer
	push	eax			; BX	time
	mov	zip_local.lz_time,bx	; EDX	size
	mov	zip_central.cz_time,bx  ; SI	attrib
	mov	zip_local.lz_date,di	; DI	date
	mov	zip_central.cz_date,di
	mov	eax,edx
	mov	zip_local.lz_fsize,eax
	mov	zip_local.lz_csize,eax
	mov	zip_central.cz_fsize,eax
	mov	zip_central.cz_csize,eax
	mov	eax,esi
	and	eax,_A_FATTRIB
	mov	zip_central.cz_ext_attrib,ax
	pop	eax
	invoke  strcpy,eax,addr __outpath
	test	esi,_A_SUBDIR
	jnz	@F
	invoke  unixtodos,eax
	push	eax
	invoke  strfn,addr __srcfile
	pop	ecx
	invoke  strfcat,ecx,0,eax
	invoke  dostounix,eax
      @@:
	invoke  strlen,eax
	mov	zip_local.lz_fnsize,ax
	mov	zip_central.cz_fnsize,ax
	ret
initentry endp

clearentry proc private
	invoke  memzero,addr zip_local,SIZE S_LZIP
	invoke  memzero,addr zip_central,SIZE S_CZIP
	mov	zip_local.lz_pkzip,ZIPHEADERID
	mov	zip_local.lz_zipid,ZIPLOCALID
	mov	byte ptr zip_local.lz_version,20
	mov	zip_central.cz_pkzip,ZIPHEADERID
	mov	zip_central.cz_zipid,ZIPCENTRALID
	mov	byte ptr zip_central.cz_version_made,20
	mov	byte ptr zip_central.cz_version_need,10
	ret
clearentry endp

compress proc private
	cmp	zip_local.lz_fsize,2
	jb	@F
  if USE_DEFLATE
	cmp	compresslevel,0
	je	@F
	mov	STDI.ios_size,8000h
	invoke  zip_deflate,compresslevel
	ret
  endif
      @@:
	sub	edx,edx
	mov	eax,zip_local.lz_fsize
	invoke  ocopyst,addr STDO,addr STDI,edx::eax
	ret
compress endp

initcrc proc private
  if USE_DEFLATE
	movzx	eax,file_method
	mov	zip_local.lz_method,ax
	mov	zip_central.cz_method,ax
  endif
	mov	eax,STDI.ios_bb
	not	eax
	mov	zip_local.lz_crc,eax
	mov	zip_central.cz_crc,eax
	invoke  oclose,addr STDI
	ret
initcrc endp

popstdi proc private
	lea	eax,STDI
	invoke  memcpy,eax,esi,SIZE S_IOST
	sub	eax,eax
	ret
popstdi endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; This is the fast compression startup
;
; The stratagy is to have two buffered files open
; - one for the local directory (compressed data)
; - and one for the central directory
;

wzipopen proc uses esi edi ebx
local arch[384]:byte
	invoke  clearentry
	mov	esi,offset entryname
	invoke  strcpy,esi,addr __outfile	; the <archive>.zip file (read)
	lea	eax,arch
	mov	edi,eax
	invoke  mkarchivetmp			; the <archive>.$$$ file (write) - 8M
	invoke  strfn,esi
	invoke  strcpy,eax,addr centtmp		; the <centtmp.$$$> file (write) - 1M
	mov	eax,offset __outfile
	mov	edx,edi
	invoke  wscopy_open			; open <archive> and <temp> file
	inc	eax				; (-1) -> (0)
	jz	wzipopen_end			; error open...
	dec	eax				; (1) --> (0)
	jnz	wzipopen_openc			; == cancel
    wzipopen_end:
	test	eax,eax
	ret
    wzipopen_ioerror:
	invoke  oclose,addr ocentral
	invoke  remove,esi
    wzipopen_eropen:
	mov	eax,edi
	invoke  wscopy_remove
	sub	eax,eax
	jmp	wzipopen_end
    wzipopen_openc:				; open the <centtmp.$$$> file
	invoke  oopenst,addr ocentral,esi,M_RDWR,100000h
	cmp	eax,1
	jl	wzipopen_eropen
	lea	ebx,arch			; init progress for copy...
	mov	eax,arc_flength
	invoke  set_progress
	mov	eax,zip_endcent.ze_off_cent	; == size of compressed data to copy
	sub	edx,edx
	invoke  ocopyst,addr STDO,addr STDI,edx::eax
	jz	wzipopen_ioerror
    wzipopen_lzero:
	mov	eax,zip_endcent.ze_size_cent	; copy central directory
	sub	edx,edx
	invoke  ocopyst,addr ocentral,addr STDI,edx::eax
	jz	wzipopen_errcpy
    wzipopen_zero:
	mov	STDO.ios_flag,0			; clear flag for compression
	invoke  oclose,addr STDI		; close <archive> file
	mov	eax,1
	jmp	wzipopen_end
    wzipopen_errcpy:
	jmp	wzipopen_ioerror
wzipopen endp

;
; This is called when the copy loop ends
;
wzipclose proc uses esi edi ebx
local arch[384]:byte
	mov	esi,eax				; result
	lea	eax,arch
	mov	edi,eax
	invoke  mkarchivetmp			; problems ?
	test	esi,esi
	jnz	wzipclose_remove		; then remove temp files
	invoke  otellst,addr ocentral		; get size of central directory
	mov	zip_endcent.ze_size_cent,eax	; update end-central info
	lea	ebx,arch			; set progress for last copy
	invoke  set_progress
	sub	eax,eax
	cmp	dword ptr ocentral.ios_total,eax
	je	@F
	invoke  oflushst,addr ocentral		; flush the <ocentral.$$$> buffer
	invoke  oseekst,addr ocentral,0,SEEK_SET
	jmp	copyc
     @@:
	mov	ecx,ocentral.ios_i
	mov	ocentral.ios_c,ecx
	mov	ocentral.ios_i,eax
  copyc:
	mov	eax,zip_endcent.ze_size_cent
	sub	edx,edx
	invoke  ocopyst,addr STDO,addr ocentral,edx::eax
	jz	wzipclose_close
	invoke  owritest,addr STDO,addr zip_endcent,SIZE S_ZEND
	jz	wzipclose_close
	movzx	esi,zip_endcent.ze_comment_size
	test	esi,esi
	jz	wzipclose_rename
	invoke  close,ocentral.ios_file		; add zip-comment to the end
	invoke  openfile,addr __outfile,M_RDONLY,A_OPEN
	mov	ocentral.ios_file,eax
	mov	ebx,eax
	inc	eax
	jz	wzipclose_close
	sub	eax,eax
	sub	eax,esi
	invoke  lseek,ebx,eax,SEEK_END
	inc	eax
	jz	wzipclose_close
	sub	eax,eax
	mov	ocentral.ios_c,eax
	mov	ocentral.ios_i,eax
	invoke  ocopyst,addr STDO,addr ocentral,eax::esi
	jz	wzipclose_close
    wzipclose_rename:
	invoke  oflushst,addr STDO		; flush the <achive>.$$$ buffer
	jz	wzipclose_close
	invoke  oclose,addr ocentral		; close files
	invoke  oclose,addr STDO
	mov	esi,offset __outfile
	invoke  filexist,edi			; 1 file, 2 subdir
	cmp	eax,1
	jne	wzipclose_remove
	invoke  remove,esi			; remove the <archive>.zip file
	invoke  rename,edi,esi			; rename <achive>.$$$ to <achive>.zip
    wzipclose_remcent:
	invoke  remove,addr entryname		; remove the <centtmp.$$$> file
    wzipclose_end:
	ret
    wzipclose_remove:
	mov	eax,edi
	invoke  wscopy_remove
	invoke  display_error
	jmp	wzipclose_remcent
    wzipclose_close:
	invoke  oclose,addr ocentral
	jmp	wzipclose_remove
wzipclose endp

wzipadd proc uses esi edi ebx fsize:qword, ftime:dword, fattrib:size_t
local ios:S_IOST
local ztemp[384]:byte
local zpath[384]:byte
local local_size:dword
local result_copyl:dword
local offset_local:dword
local deflate_begin:dword
	movzx	edi,word ptr ftime+2
	mov	esi,fattrib
	xor	eax,eax
	mov	errno,eax
  if USE_DEFLATE
	mov	file_method,al
  endif
	;
	; Skip files > 4G...
	;
	cmp	eax,dword ptr fsize[4]
	jne	wzipfast_end

	cmp	copy_fast,al
	je	wzipadd_slow

	lea	eax,zpath
	movzx	ebx,word ptr ftime
	mov	edx,dword ptr fsize
	invoke  initentry
	xor	eax,eax
	mov	zip_local.lz_crc,eax
	mov	zip_central.cz_crc,eax
	mov	zip_central.cz_off_local,eax
	test	esi,_A_SUBDIR
	jnz	wzipfast_subdir
	invoke  otell
	mov	zip_central.cz_off_local,eax
	invoke  oopen,addr __srcfile,M_RDONLY,-1
  if USE_DEFLATE
	mov	STDI.ios_size,8000h
  endif
	inc	eax
	jnz	@F
	;
	; v2.33 continue if error open source
	;
	jmp	wzipfast_end
    wzipfast_error:
	invoke  oclose,addr STDO
	invoke  oclose,addr ocentral
	invoke  remove,addr entryname
	mov	eax,-1
	jmp	wzipfast_end
    wzipfast_ercopy:
	invoke  oclose,addr STDI
	jmp	wzipfast_error
     @@:
	invoke  owritest,addr STDO,addr zip_local,SIZE S_LZIP
	jz	wzipfast_ercopy
	movzx	ecx,zip_local.lz_fnsize
	invoke  owritest,addr STDO,addr zpath,ecx
	jz	wzipfast_ercopy
	mov	STDI.ios_flag,IO_USECRC or IO_USEUPD or IO_UPDTOTAL
	invoke  otell
	mov	deflate_begin,eax
	invoke  compress
	test	eax,eax
	jz	wzipfast_ercopy
	invoke  initcrc
    wzipfast_subdir:
	invoke  otell
	mov	zip_endcent.ze_off_cent,eax
	test	byte ptr fattrib,_A_SUBDIR
	jnz	@F
	sub	eax,deflate_begin
	mov	zip_local.lz_csize,eax
	mov	zip_central.cz_csize,eax
	invoke  update_local
     @@:
	invoke  owritest,addr ocentral,addr zip_central,SIZE S_CZIP
	jz	wzipfast_error
	invoke  owritest,addr ocentral,addr zpath,zip_central.cz_fnsize
	jz	wzipfast_error
	inc	zip_endcent.ze_entry_cur
	inc	zip_endcent.ze_entry_dir
	sub	eax,eax
	jmp	wzipfast_end
    ;--------------------------------------------------------------
    ; do slow copy
    ;--------------------------------------------------------------
    wzipadd_slow:
	mov	eax,arc_flength
	mov	dword ptr progress_size,eax
	mov	dword ptr progress_size[4],0
	invoke  clearentry
	invoke  strcpy, addr zpath, addr __outpath
	mov	eax,offset __outpath
	movzx	ebx,word ptr ftime
	mov	edx,dword ptr fsize
	invoke  initentry
	lea	eax,ztemp
	invoke  mkarchivetmp
	mov	edx,eax
	mov	eax,offset __outfile
	invoke  wscopy_open
	cmp	eax,-1
	jne	@F
	jmp	wzipfast_end
      @@:
	mov	STDO.ios_flag,IO_USEUPD or IO_UPDTOTAL
	test	eax,eax
	jnz	@F
	inc	eax
	jmp	wzipfast_end
      @@:
	xor	eax,eax
	mov	local_size,eax
	invoke  zip_copylocal,1
	mov	result_copyl,eax	; result: 1 found, 0 not found, -1 error
	mov	offset_local,edx	; offset local directory if found
	mov	ecx,eax
	inc	eax
	jz	wzipadd_error
	invoke  otell
	mov	zip_central.cz_off_local,eax
      @@:
	dec	ecx
	jnz	@F
	mov	ecx,zip_endcent.ze_off_cent
	sub	ecx,eax
	mov	local_size,ecx
      @@:
	invoke  memcpy,addr ios,addr STDI,SIZE S_IOST
	test	esi,_A_SUBDIR
	lea	esi,ios
	jnz	@F;wzipslow_subdir
  if USE_DEFLATE
	mov	file_method,0
  endif
	invoke  oopen,addr __srcfile,M_RDONLY,-1
  if USE_DEFLATE
	mov	STDI.ios_size,8000h
  endif
	cmp	eax,-1
	jne	@F
	invoke  popstdi
	;
	; v2.33 continue if error open source
	;
	jmp	wzipadd_skip
      @@:
	invoke  owritest,addr STDO,addr zip_local,SIZE S_LZIP
	jz	wzipadd_ersource
	movzx	ecx,zip_local.lz_fnsize
	invoke  owritest,addr STDO,addr __outpath,ecx
	jz	wzipadd_ersource
	mov	STDI.ios_flag,IO_USECRC or IO_USEUPD or IO_UPDTOTAL
	and	STDO.ios_flag,not IO_USEUPD
	invoke  otell
	mov	deflate_begin,eax
	invoke  progress_set,addr __srcfile,addr __outfile,fsize
	jnz	wzipadd_ersource
	test	byte ptr fattrib,_A_SUBDIR
	jnz	wzipslow_subdir
	invoke  compress
	test	eax,eax
	jnz	wzipadd_zerofile
   wzipadd_ersource:
	invoke  oclose,addr STDI
	invoke  popstdi
	jmp	wzipadd_error
   wzipadd_zerofile:
	invoke  initcrc
	invoke  popstdi
	lea	ebx,ztemp
	mov	eax,arc_flength
	invoke  set_progress
    wzipslow_subdir:
	invoke  otell
	mov	zip_endcent.ze_off_cent,eax
	sub	eax,deflate_begin
	mov	zip_local.lz_csize,eax
	mov	zip_central.cz_csize,eax
	add	dword ptr progress_size,eax
	adc	dword ptr progress_size[4],0
	invoke  update_local
      @@:
	invoke  zip_copycentral,offset_local,local_size,1
	inc	eax
	jz	wzipadd_ioerror
	dec	eax			; if file or directory deleted
	jz	@F			; -- ask user to overwrite
	dec	zip_endcent.ze_entry_dir
	dec	zip_endcent.ze_entry_cur
	invoke  confirm_delete_file,addr __outpath,zip_central.cz_ext_attrib
	inc	eax
	jz	wzipadd_ioerror		; Cancel (-1)
	dec	eax
	jz	wzipadd_skip		; Jump (0)
	jmp	wzipslow_czip
      @@:
	cmp	result_copyl,eax
	je	wzipslow_czip
	jmp	wzipadd_ioerror ; found local, not central == error
    wzipslow_czip:
	invoke  owritest,addr STDO,addr zip_central,SIZE S_CZIP
	jz	wzipadd_ioerror
	movzx	ecx,zip_central.cz_fnsize
	invoke  owritest,addr STDO,addr __outpath,ecx
	jz	wzipadd_ioerror
	inc	zip_endcent.ze_entry_cur
	inc	zip_endcent.ze_entry_dir
	mov	eax,offset __outfile
	lea	edx,ztemp
	invoke  zip_copyendcentral
	inc	eax
	jz	wzipadd_ioerror
	jmp	wzipadd_ok
    wzipfast_end:
	test	eax,eax
	ret
    wzipadd_skip:
	invoke  oclose,addr STDI
	lea	eax,ztemp
	invoke  wscopy_remove
    wzipadd_ok:
	invoke  strcpy,addr __outpath,addr zpath
	sub	eax,eax
	jmp	wzipfast_end
    wzipadd_ioerror:
	sub	eax,eax
    wzipadd_error:
	mov	edi,eax
	invoke  oclose,addr STDI
	lea	eax,ztemp
	invoke  wscopy_remove
	mov	eax,edi
	inc	edi
	jz	wzipfast_end
	invoke  display_error
	dec	eax
	jmp	wzipfast_end
wzipadd endp

	END
