include io.inc
include iost.inc
include wsub.inc
include fblk.inc
include string.inc
include unzip.inc

	.code

zip_copylocal proc uses esi edi ebx exact_match:dword
local extsize_local:dword
local offset_local:dword
	invoke  strlen,addr __outpath
	mov	edi,eax
	sub	eax,eax
	mov	esi,eax
	mov	extsize_local,eax
	dec	eax
	mov	offset_local,eax
    copylocal_loop:
	mov	eax,SIZE S_ZEND
	invoke  oread
	mov	ebx,eax
	jnz	copylocal_test_local
    copylocal_error:
	mov	eax,-1
	jmp	copylocal_end
    copylocal_test_local:
	cmp	word ptr [ebx],ZIPHEADERID
	jne	copylocal_error
	mov	eax,esi
	cmp	word ptr [ebx+2],ZIPLOCALID
	jne	copylocal_end
	mov	eax,SIZE S_LZIP
	add	eax,edi
    copylocal_oread:
	invoke  oread
	mov	ebx,eax
	jz	copylocal_error
	mov	eax,SIZE S_LZIP
	add	ax,[ebx].S_LZIP.lz_fnsize
	cmp	ecx,eax
	jb	copylocal_oread
	add	ax,[ebx].S_LZIP.lz_extsize
	add	eax,[ebx].S_LZIP.lz_csize
	push	eax
	test	esi,esi
	jnz	copylocal_copy
	movzx	eax,[ebx].S_LZIP.lz_fnsize
	cmp	exact_match,0
	je	copylocal_subdir
	cmp	edi,eax
	je	copylocal_compare
    copylocal_copy:
	sub	edx,edx
	pop	eax
	invoke  ocopyst,addr STDO,addr STDI,edx::eax
	jz	copylocal_error
    copylocal_next:
	jmp	copylocal_loop
    copylocal_subdir:
	cmp	eax,edi
	jbe	copylocal_copy
    copylocal_compare:
	invoke  strnicmp,addr __outpath,addr [ebx+SIZE S_LZIP],edi
	jnz	copylocal_copy
    copylocal_found:
	inc	esi
	movzx	eax,[ebx].S_LZIP.lz_extsize
	mov	extsize_local,eax
	mov	ax,[ebx].S_LZIP.lz_fnsize
	push	eax
	add	ebx,SIZE S_LZIP
	and	eax,01FFh
	invoke  memcpy,addr entryname,ebx,eax
	pop	ebx
	add	ebx,eax
	mov	byte ptr [ebx],0
	mov	eax,dword ptr STDO.ios_total
	add	eax,STDO.ios_i
	mov	offset_local,eax
	pop	ecx
	add	eax,ecx
	invoke  oseek,eax,SEEK_SET
	jnz	copylocal_next
	mov	eax,-1
    copylocal_end:
	mov	edx,offset_local
	mov	ecx,extsize_local
	ret
zip_copylocal endp

zip_copycentral proc uses esi edi ebx loffset:dword, lsize:dword, exact_match:dword
	invoke  strlen,addr __outpath
	mov	edi,eax
	xor	esi,esi
    copycentral_loop:
	mov	eax,SIZE S_ZEND
	invoke  oread
	mov	ebx,eax
	jnz	copycentral_03
    copycentral_error:
	mov	esi,-1
    copycentral_end:
	mov	eax,esi
	ret
    copycentral_03:
	cmp	[ebx].S_CZIP.cz_pkzip,ZIPHEADERID	; 'PK'  4B50h
	jne	copycentral_error
	cmp	[ebx].S_CZIP.cz_zipid,ZIPCENTRALID	; 1,2	0201h
	jne	copycentral_end
	mov	eax,SIZE S_CZIP
	invoke  oread
	mov	ebx,eax
	jz	copycentral_error
	mov	eax,SIZE S_CZIP
	add	ax,[ebx].S_CZIP.cz_fnsize
	invoke  oread
	mov	ebx,eax
	jz	copycentral_error
	mov	eax,SIZE S_CZIP		; Central directory
	add	ax,[ebx].S_CZIP.cz_fnsize	; file name length (*this)
	add	ax,[ebx].S_CZIP.cz_extsize
	add	ax,[ebx].S_CZIP.cz_cmtsize
	push	eax			; = size of this record
	mov	eax,loffset		; Update local offset if above
	cmp	[ebx].S_CZIP.cz_off_local,eax
	jb	copycentral_06
	mov	eax,lsize
	sub	[ebx].S_CZIP.cz_off_local,eax
    copycentral_06:
	test	esi,esi
	jnz	copycentral_copy	; already found -- deleted
	movzx	eax,[ebx].S_CZIP.cz_fnsize
	cmp	exact_match,0
	je	copycentral_subdir
	cmp	edi,eax
	jne	copycentral_copy
    copycentral_subdir:
	cmp	edi,eax
	ja	copycentral_copy
	add	ebx,SIZE S_CZIP
	invoke  strnicmp,addr __outpath,ebx,edi
	test	eax,eax
	jz	copycentral_delete
    copycentral_copy:
	pop	eax
	sub	edx,edx
	invoke  ocopyst,addr STDO,addr STDI,edx::eax
	jnz	copycentral_loop
	jmp	copycentral_error
    copycentral_delete:
	pop	eax
	inc	esi
	invoke  oseek,eax,SEEK_CUR
	jnz	copycentral_loop
	jmp	copycentral_error
zip_copycentral endp

	END
