{         Duplicit - hledac duplicitnich souboru na disku                    }
{                                                                            }
{ Pro kompilaci pouzij FPC 2.2.2                                             }
{ autor: Laaca (laaca@seznam.cz)                                             }
{                                                                            }
{ Tento program muze byt siren a modifikovan podle podminek GNU/GPL licence, }
{ jejiz text je prilozen.                                                    }
{                                                                            }
{ This program can be used, spread and modified under conditions of GNU/GPL  }
{ license, which is included in separate file.                               }
{----------------------------------------------------------------------------}

uses DOS,Vaznik,Md5;
type

    PZaznam = ^Tzaznam;
    Tzaznam = record
    hash:TMD5digest;
    soubor:string;
    end;

var hashe:PVaznik;
    pomoc:ansistring;
    zaindexoval:ansistring;
    souboru:ansistring;

const

    vystup:string = '';
    DolniLimit:longint = 0;
    HorniLimit:longint = 0;
    Hlasky:byte = 0;
    ukazovatko:longint = 0;


Procedure VytvorHash(s:string);
var zaznam:PZaznam;
    i:longint;
begin
i:=Length(s)+SizeOf(TMD5digest)+1;
GetMem(zaznam,i);
zaznam^.hash:=MD5file(s);
zaznam^.soubor:=s;
hashe^.InitNext(zaznam);
end;


Function VyhovujeLimitum(f:Searchrec):boolean;
begin
VyhovujeLimitum:=(f.size>=DolniLimit) and ((Hornilimit=0) or (f.size<=Hornilimit))
end;


Procedure SeekIT(maska:string);
var f:Searchrec;
    m,s1,s2,s3:string;
begin
m:=FExpand(maska);
FSplit(m,s1,s2,s3);
if Hlasky=0 then writeln(s1,'...');
findfirst(m,readonly+directory+sysfile+archive,f);
while doserror=0 do   {dokud je neco nalezeno...}
   begin
   if (f.attr and directory)=0 then
      begin
      {jedna se o soubor?}
      if VyhovujeLimitum(f) then VytvorHash(Lowercase(s1+f.name));
      end
      else begin
      {jedna se o adresar?}
      if (f.name<>'.') and (f.name<>'..') then
         SeekIt(s1+f.name+'\'+s2+s3);
      end;
   findnext(f);
   end;{while}
FindClose(f);
end;

Function NaPstring(s:string):pointer;
var p:pointer;
    l:longint;
begin
l:=Length(s)+1;
GetMem(p,l);
Move(s,p^,l);
NaPstring:=p;
end;

Function ZrusPstring(p:pstring):pointer;
var l:longint;
begin
if p<>nil then
   begin
   l:=Length(p^)+1;
   FreeMem(p,l);
   end;
ZrusPstring:=nil;
end;


Function Porovnej(p,q:pointer):boolean;
begin
Porovnej:=string(p^)<>string(q^);
end;

Procedure Zlikviduj(var p:pointer);
begin
ZrusPString(p);
p:=nil;
end;


Procedure ProhledavejHashe;
var u,u2,v1,v2:PUzel;
    Shody:PVaznik;
    z1,z2:PZaznam;
    s:^string;
    b:boolean;
    i,n:longint;
    vs:text;
begin
if hashe^.pocet<2 then Exit;
Assign(vs,vystup);
Rewrite(vs);
i:=0;
repeat
Shody:=NovyVaznik;
Shody^.akce:=@Zlikviduj;
procCompMydata:=@Porovnej;
z1:=hashe^.first^.vazba;
u:=hashe^.first^.dalsi;
Shody^.InitNext(NaPString(z1^.soubor));
while u<>nil do
   begin
   z2:=u^.vazba;
   u2:=u^.dalsi;
   if MD5match(z1^.hash,z2^.hash) then
      begin
      Shody^.InitNext(NaPString(z2^.soubor));
      FreeMem(z2);
      hashe^.ZrusUzel(u);
      end;
   u:=u2;
   end;
FreeMem(z1);
hashe^.ZrusUzel(hashe^.first);

{Mam nalezene shody hashu. Musim ale napred proverit, zda se nejedna}
{o duplicitne specifikovane soubory}

Shody^.ZrusDuplicity;

if shody^.pocet>1 then
   begin
   inc(i);
   writeln(vs,'#',i);
   Shody^.Reset;
   n:=0;
   while not Shody^.Konec do
      begin
      inc(n);
      s:=Shody^.Nacti;
      writeln(vs,n,') ',s^);
      end;
   end;
Dispose(Shody,Done);
until hashe^.pocet=0;
Close(vs);
end;

Procedure ReadStr(p:pchar;var s:string);
begin
s:='';
repeat
if p[ukazovatko]=#13 then
   begin
   if p[ukazovatko+1]=#10 then inc(ukazovatko,2) else inc(ukazovatko,1);
   Exit;
   end
   else begin
   s:=s+p[ukazovatko];
   inc(ukazovatko);
   if Length(s)=255 then Exit;
   end;
until 1=2;
end;


Function SearchBuf(s:string;p:pchar;i:longint):longint;
var a,b,n:longint;
    shoda:boolean;
begin
n:=Length(s);
b:=0;

repeat
shoda:=true;
if b+n>i then Exit(-1);
for a:=1 to n do
    if p[b+a-1]<>s[a] then
       begin
       shoda:=false;
       inc(b,2);
       Break;
       end;

until shoda;
SearchBuf:=b;
end;


Procedure ZeSouboru(so:string);
var t:file;
    s:string;
    i,j:longint;
    q:pchar;
begin
Assign(t,so);
Reset(t,1);
i:=FileSize(t);
GetMem(q,i);
BlockRead(t,q^,i);
Close(t);
ukazovatko:=SearchBuf(Lowercase('##STARTTEXTU'),q,i);
pomoc:='';
repeat readstr(q,s);until s='#napoveda';
repeat
readstr(q,s);
if s<>'#hotovo' then pomoc:=pomoc+s+#13#10;
until s='#hotovo';

zaindexoval:='';
repeat
readstr(q,s);
if s<>'#souboru' then zaindexoval:=zaindexoval+#13#10+s;
until s='#souboru';

souboru:='';
repeat
readstr(q,s);
if s<>'#konec' then souboru:=souboru+s;
until s='#konec';
FreeMem(q);
end;


Procedure NactiHlasky;
var nlspath,lang:string;
    n,m,a1,prg,a3:string;
begin
n:=Paramstr(0);
FSplit(n,a1,prg,a3);

nlspath:=GetEnv('NLSPATH');
lang:=GetEnv('LANG');

if nlspath<>'' then
   if nlspath[Length(nlspath)]<>'\' then nlspath:=nlspath+'\';

if (nlspath<>'') and (lang<>'') then
   begin
   m:=nlspath+prg+'.'+lang;
   ZeSouboru(m);
   end
   else ZeSouboru(n);
end;


Procedure WriteHelp;
begin
writeln(pomoc);
Halt;
end;


Procedure Zavinac(s:string);
var fq:text;
     t:string;
     p:pchar;
begin
t:=Copy(s,2,Length(s)-1);
Assign(fq,t);
Reset(fq);
while not Eof(fq) do
  begin
  Readln(fq,t);
  SeekIt(t);
  end;
Close(fq);
end;


Function PrevedNaCislo(s:string):longint;
var i,j:longint;
begin
Val(s,i,j);
if j=0 then Exit(i);
if j<>Length(s) then WriteHelp;
if s[j]='k' then Exit(i*1024);
if s[j]='m' then Exit(i*1024*1024);
WriteHelp;
end;


Procedure Pomlcka(s:string);
var i:longint;
begin
if (s='h') or (s='?') then WriteHelp;
case s[2] of
  'o':begin delete(s,1,2);vystup:=s;end;
  'l':begin
      delete(s,1,2);
      DolniLimit:=PrevedNaCislo(s);
      end;
  'p':begin
      delete(s,1,2);
      HorniLimit:=PrevedNaCislo(s);
      end;
  'v':begin
      case s[3] of
         '0':Hlasky:=0;      {vsechny hlasky}
         '1':Hlasky:=1;      {nevypisuje prohlizne adresare}
         '2':Hlasky:=2;      {nevypisuje nic}
         else WriteHelp;
      end;
      end;
else WriteHelp;

end;  { Case }
end;

Procedure Parser;
var a,b:byte;
        s:string;
begin
b:=ParamCount;
if b=0 then WriteHelp;
for a:=1 to b do
   begin
   s:=Lowercase(ParamStr(a));
   if s[1] in ['/','-'] then Pomlcka(s);
   end;

for a:=1 to b do
   begin
   s:=Lowercase(ParamStr(a));
   if not (s[1] in ['/','-']) then
      if s[1]='@' then Zavinac(s) else SeekIt(s);
   end;
end;



{-------------------------- hlavni program -----------------------------}
begin
filemode:=0;
hashe:=NovyVaznik;
NactiHlasky;
Parser;
if Hlasky<2 then
   writeln(zaindexoval,' ',hashe^.pocet,' ',souboru);
ProhledavejHashe;
end.
