;Phenom P-State setting 1.2 by Falcosoft

.586p
PWR SEGMENT PUBLIC USE16
assume cs:PWR,ds:PWR,ss:PWR
org 100h
START:

	    mov ax,offset prog
            call show
            mov ax,offset eol
            call show
       	    mov ax,offset usage
            call show
            mov ax,offset eol
            call show
   
	    mov ax,0F000h ;386+ detect
	    push ax
	    popf
	    pushf
	    pop ax
	    and ah,0F0h
	    sti
	    jz @nosupport

            pushfd       ;cpuid detect
            pop eax
            mov ebx,eax
            btc eax,21
            push eax
            popfd
            pushfd
            pop eax
            cmp eax,ebx
            jz @nosupport

	    mov eax,80000000h ;required extended function detect
            cpuid
            cmp eax,80000007h
            jb @nosupport

	    mov eax,80000007h ;HW P-state detect
            cpuid
            test edx,128
            jz @nosupport

            mov si,82h   ;get command line parameter

	    mov bl,"0"
            cmp bl,[si]
            jnz @nonull
            mov eax,0
	    jmp @ready
@nonull:
            mov bl,"1"
            cmp bl,[si]
            jnz @noone
            mov eax,1
	    jmp @ready
@noone:
            mov bl,"2"
            cmp bl,[si]
            jnz @notwo
            mov eax,2
	    jmp @ready

@notwo:
	    mov bl,"3"
            cmp bl,[si]
            jnz @nothree
            mov eax,3
            jmp @ready
@nothree:                 ; if no valid parameter print current mhz and P-state

            mov ax, offset cpumhz
            call show
            mov ecx,0C0010063h   ; get current P-state
            rdmsr
            push eax
            mov ecx,0C0010064h   ; get P-state information for current P-state
            add ecx,eax          ; P-state MSR offset
            rdmsr
            mov ecx,eax          ; calculate MHz
            and eax,3Fh          ;Mhz=(refclock/2)*(fid+10h)/power(2,did)
            and ecx,1C0h
            shr ecx,6
            add eax,10h
            mov ebx,100          ;!default refclock=200MHz!
            mul ebx	         ;!CPU knows nothing about modified reflock!
            mov edx,1            ;!if you modified it, you have to correct this value!
            shl edx,cl
            mov ecx,edx
            xor edx,edx
            div ecx
            call PrintNumber     ;Print current MHz

            mov ax,offset curpstate ;Print current P-state
            call show
            mov ah,2
            pop edx
            add dl,'0'
            int 21h
            jmp @exitp


@ready:
	    push eax               ;Set new P-state
            mov ecx,0C0010062h
	    mov edx,0
            wrmsr
            mov ax,offset newpstate
            call show
            mov ah,2               ;Print new P-state
            pop edx
            add dl,'0'
            int 21h
	    jmp @exitp

@nosupport:
	    mov ax,offset nosup
            call show

@exitp:     xor eax,eax
            mov ax,4c00h
            INT 21h

	    show proc
             mov dx,ax
             mov ah,9
             int 21h
             ret
            show endp

            PrintNumber proc
    	     mov ecx, 0
    	     mov ebx, 10
	     @@loophere:
    	     mov edx, 0
    	     div ebx             ;divide by ten

                                 ; now eax <-- eax/10
                                 ;     edx <-- eax % 10

                                 ; this is one digit we have to convert to ASCII
  	     push eax
    	     add dl, '0'         ;convert dl to ascii

	     pop eax
    	     push edx            ;digits are in reversed order
    	     inc ecx             ;remember how many digits we pushed to stack
    	     cmp eax, 0
	     jnz @@loophere

	    ;ecx is already set
    	    mov ah, 2
	    @@loophere2:
    	    pop edx              ;restore digits from last to first
    	    int 21h
    	    loop @@loophere2

	    ret
           PrintNumber endp


prog       db "Phenom P-State setting 1.2 by Falcosoft","$"
usage	   db "Usage: PWR [P-state number] - without parameter shows current MHz and P-state","$"
nosup  	   db "CPU does not support HW P-states!","$"
curpstate  db " Current P-state:","$"
cpumhz     db "Current frequency im MHz:","$"
newpstate  db "New P-state:","$"
eol        db 10,13,"$"


PWR ENDS
END START