/*
  pg.c    1.13

  (c) 1995-1998 Bill Weinman, wew@bearnet.com

  Generic Screen Pager for FreeDOS

  This program was coded particularly for use with my FreeDOS help
  system.  I am making it available as a module for general use because
  it's generally useful.  It is not intended to be the pager-to-beat-
  all-pagers because I don't need that.  If you do, you can either
  suggest enhancements--and if I think they're really kewl and feel
  like coding them I will--or you can code them yourself and submit
  them to me; but please, if you want me to continue to support this
  code then please don't enhance the code without letting me know.
                      --BearHeart, Phoenix, AZ
                        wew@bearnet.com

  Maintained by BAHCL


  Programming Environment:
    Please read pg.man section "INSTALL PG"


  Legal Stuff

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dir.h>
#include <process.h>
#include "pg.h"

#define setattr(attr) (curatt = attr)

/* Globals */

char *stat[] =
{
  "     ",
  "<top>",
  "<end>"
};

char *plugin[] =
{
   "SVHEX.COM",
   "SVTXT.COM"
};

struct {                                        /* file list */
  char filename[12];                            /* file name */
  unsigned long start;                          /* display line */
} *filelist, *fl;


FILE *infile;                                   /* input file pointer */
FILE *pgsav=NULL;                               /* save file */
int  xpos = 0;
int  pathlen;
int  groupid;                                   /* active group id */
int  filenum, totfile;                          /* infile number, total files */
int  sense;                                     /* case sensitivity flag */
int  lpg = LINEADDRS;                           /* Lines per group */
int  Color = false;                             /* color flag */
int  mouse = 0;                                 /* mouse driver ok? */
int  tabstops = TABSTOPS;                       /* should be run-time switch */
int  argi, args;                                /* index of argc, argc */
int  nff = 0;                                   /* new files flag */
int  quit;                                      /* (jh) flag, for the exit condition */
int  error;                                     /* error flag */
char pgman[65];                                 /* path for PG.MAN */
char searchstr[21];                             /* search string */
char buffer[256];                               /* scratch buffer */
char linebuf[MAXSIZELINE+1];                    /* buffer for reading lines */
char *newfile = buffer+127;                     /* new path and files */
char **argvptr;                                 /* make argv[] global */
char *cmd;                                      /* path of COMMAND.COM */
char *filemark;                                 /* 5 filemarks */
char *recover;                                  /* path for recovery */
char *infilename;                               /* input file name */
unsigned int  VideoRegen;                       /* video regen pointer */
unsigned int  RegenSize;                        /* in words  */
unsigned int  DispCols;                         /* display cols (from BIOS) */
unsigned char DispMode;                         /* display adapter mode */
unsigned char DispRows;                         /* display rows (from BIOS) */
unsigned char curatt;                           /* current attribute */
unsigned char attr_status, attr_lo_status, attr_text;
unsigned char bit7 = 0xFF;                      /* all bits on */
unsigned long lineaddr[LINEADDRS];              /* offset of a line in file */
unsigned long groups[GROUPS];                   /* offset of the first line in the group */
unsigned long bookmark[5];                      /* 5 bookmarks */
unsigned long searchline;                       /* search line number */
unsigned long numlines;                         /* num of lines in the file */
unsigned long cursor = 0;                       /* set cursor to where search ok */
unsigned long showline;                         /* show top line */
unsigned long offset;                           /* infile offset */
long topline;
extern unsigned _heaplen = MAX_FILE * 16 + (LINEADDRS + GROUPS) * 4; /* memory saver */


int
main(int argc, char **argv)
{
  int i;

  argvptr = argv;
  args    = argc-1;
  argi    = 1;
  strcpy(pgman,argv[0]);
  cmd     =  strchr(pgman,'.');                     /* to find */
  strcpy(cmd,".MAN");                               /* PG.MAN */
  InitVideo();                                      /* Init & get screen info */
  if (argc == 1)                                    /* no file name */
    {
      iaca(0L,0);
      i = execlp(plugin[1], plugin[1], NULL);       /* use svtxt.com */
    }
  else if (strcmp(argv[1], "/?") == 0)              /* basic help */
    {
      usage();
    }
  else                                              /* get ready */
    {
      for (i=1; i<argc; i++)
      {
        if (check_filespec(argv[i]))
          {
            errorexit(1, strcat("PG cannot read file ", argv[i]));
          }
      }
      cmd = getenv("COMSPEC");                      /* find COMMAND.COM */
      filemark = malloc(PATHLEN*5);                 /* 5 paths can be saved */
      filelist = malloc(MAX_FILE*sizeof(*filelist));/* allocate mem. for */
                                                    /* max. 256 filenames */
      if (filelist==NULL)
        {
          errorexit(2, "pg: Not enough memory! Abort!");
        }
      recover = buffer+181;
      pathlen = newpath(argv[1]);
      totfile = countfile(argv[1], 1L);
      check_mouse();
      searchline = 1L;
      for (i=0; i<5; i++)
      {
        strcpy(filemark+PATHLEN*i,infilename);
        strcat(filemark+PATHLEN*i,filelist->filename);
        memcpy(filemark+PATHLEN*(i+1)-5,&searchline,sizeof(long));
      }
    }
  filenum = 1;
  while (filenum <= totfile)                        /* process individual file */
    {
      fl = filelist+filenum-1;
      strncpy(infilename + pathlen, fl->filename, 12);
      infilename[pathlen + 12] = '\0';
      groupid = 0;
      for (i = 0; i < 5; i++)
        {
          bookmark[i] = 0L;
        }
      numlines = 0;
      read_infile();                                /* assembly routines */

      infile = fopen(infilename, "rb");
      clearscreen();
      showline = fl->start;
      offset = 0L;

      display(showline, 0);                         /* instant display file content */
      filenum = pagefile(showline);                 /* page thru the file */

      fl->start = showline;
      setattr(attr_text);                           /* reset video attribute */
      fclose(infile);
    }
  free(filemark);
  free(filelist);
  if (mouse)
    {
      reset_mouse();
    }
  clearscreen();
  move(0,0);
  return(0);
}

/*
  break down a full path into dirve, path, filename, extension
*/
int
newpath(char *fullpath)
{
  char *drive     = buffer+20;
  char *path      = buffer+23;
  char *filename  = buffer+90;
  char *extension = buffer+100;

  fnsplit(fullpath, drive, path, filename, extension);
  strcat(drive, path);
  infilename = drive;
  return(strlen(infilename));
}

/*
  Count number of files as accepted
*/
int
countfile(char *filespec, long showline)
{
  struct ffblk ffblk;
  int error = 0;                                /* error flag */
  filenum   = 0;                                /* number of files */
  fl = filelist;                                /* pointer to first struc */
  filenum = findfirst(filespec,&ffblk,0);       /* find if filespec valid */
  while((!error) & (filenum < MAX_FILE))
    {
      strncpy(fl->filename, ffblk.ff_name, 12);
      fl->start = showline;
      ++fl;                                     /* next struct */
      ++filenum;
      error = findnext(&ffblk);
    }
  if (filenum > 0)
    {
      strcpy(recover,filespec);
    }
  return filenum;
}

/*
   getline() -  Find a line of text from the line buffer. Returns
   pointer to linebuf or zero if cannot find
*/
int
getline(long linenum)
{
  linebuf[0] = NULL;
  if (linenum > numlines)
    {
      return 0;                                 /* error */
    }
  else
    {
      line2offset(linenum);
      fseek(infile, offset, SEEK_SET);
      fgets(linebuf, MAXSIZELINE+1, infile);
      return 1;
    }
}

/*
   exptabs() -  Expand tabs in the line buffer.
   (Added 21 aug 98, wew)
   BAHCL : handles LF,CR as Turbo C 'gets' does not remove them;
           also SPACE => space
*/
void
exptabs(void)
{
  register i;
  register o;
  char out[MAXSIZELINE+1];
  char *in;
  char space;

  in = linebuf;
  memset(out, 0, MAXSIZELINE+1);
  space = '\x20';
  for(i = o = 0; (o < MAXSIZELINE) && in[i]; i++, o++)
    {
      switch(in[i])
        {
          case TAB:
            out[o] = space;
            while((o+1) % tabstops && (o < (MAXSIZELINE)))
              {
                out[++o] = space;
              }
            break;
          case '\xD':                               /* replace linefeed */
            out[o] = space;
            break;
          case '\xA':                               /* replace return */
            out[o] = NULL;
            break;
          case '\x8':                               /* backspace */
            if (o) o-=2;
            break;
          default:
            out[o] = in[i] & bit7;
            break;
        }
    }
  memcpy(linebuf, out, MAXSIZELINE+1);
}

/* display lines to screen */
void
display(long topline, int pancolumn)
{

  int lineno;                   /* current line number */
  int botline;                  /* bottom screen line */
  int screenline;               /* current screenline */
  int pageoffset;               /* offset into page */
  long templine;
  char *str;

  /* Initialize variables */
  botline    = DispRows - 2;
  templine   = topline;
  pageoffset = 0;
  lineno     = 0;

  if (botline > numlines) botline = numlines;

  headline(topline);                        /* show file information */
  setattr(attr_status);
  while(lineno < botline)                   /* display loop */
    {
      screenline = ++lineno;              /* where are we on the screen? */
      line2offset(topline);
      fseek(infile, offset, SEEK_SET);
      ++topline;
      str = fgets(linebuf, MAXSIZELINE+1, infile);
      if(str)
        {
          exptabs();                         /* expand the tabs (21 aug 98 wew) */
          clearline(screenline, attr_text);
          setattr(attr_text);
          mvaddnstr(screenline, 0, DispCols, linebuf+pageoffset+pancolumn);
        }
    } /* while */
  setattr(attr_status);
  if (pancolumn > 0)
    {
      itoa(pancolumn, buffer,10);
      mvaddnstr(0, 56, 4, "+   ");
      mvaddnstr(0, 57, 3, buffer);
    }
  topline = templine;
  if (cursor)
    {
      move((int)(cursor-topline+1),0);       /* show cursor */
      mvaddnstr((int) DispRows-1, DispCols-20, 19, "                   ");
      ltoa(cursor, buffer, 10);              /* tell where string found */
      mvaddnstr((int) DispRows-1, DispCols-strlen(buffer)-1, 8, buffer);
      ltoa(xpos, buffer, 10);                /* tell where string found */
      mvaddnstr((int) DispRows-1, DispCols-strlen(buffer)-10, 8, buffer);
    }
  else
    {
      mvaddnstr((int) DispRows-1, DispCols-20, 19, "                   ");
      move(DispRows,0);                      /* hide cursor */
    }
  cursor = 0;
  xpos = 0;
  line2offset(topline);
}

/* user interface here */
int
pagefile(long line)
{
  int i;
  int  pagesize;                /* vert size of display area */
  int  pancolumn;               /* pan columns */
  int  scanascii;
  char asciicode;
  char sdf = 'F';               /* search direction flag assumed forward */

  /* Initialize variables */
  pancolumn  = 0;
  searchline = 0;
  topline    = line;
  pagesize   = DispRows - 2;
  quit       = 0;               /* (jh) */

  headline(topline);                        /* show file information */
  clearline(DispRows - 1, attr_status);

  while (!quit)
    {
      scanascii = mouseorkey();
      switch(scanascii)
        {
          case ESC:                         /* Esc=Quit */
            quit = 1;
            filenum = totfile + 1;
            break;
          case PG_UP:
            topline -= pagesize;
            break;
          case SPACE:                       /* (jh) */
          case PG_DN:                       /* scroll down by one screen */
            topline += pagesize;
            break;
          case KEY_HOME:
            topline = 1;
            break;
          case KEY_END:
            topline = numlines - pagesize + 1;
            break;
          case KEY_UP:
            --topline;
            break;
          case RETURN:                      /* scroll down one line only */
          case KEY_DN:
            ++topline;
            break;
          case KEY_LT:                      /* Left key */
            pancolumn -= 30;                /* pan left */
            if (pancolumn < 0)
              {
                pancolumn = 0;
              }
            break;
          case KEY_RT:                      /* Right key */
            pancolumn += 30;                /* pan right */
            if (pancolumn > PANLIMIT)
              {
                pancolumn = PANLIMIT;
              }
            break;
          case KEY_LFILE:                   /* Last file */
            last_file();
            break;
          case KEY_NFILE:                   /* Next file */
            next_file();
            break;
          case DOSSHELL:
            clearscreen();
            move(0,0);
            spawnl(P_WAIT, cmd, "COMMAND.COM", NULL);
            clearline((int) DispRows - 1, attr_status);
            break;
          case JUMPTO:                              /* Backspace=Jump to line */
            clearline((int) DispRows - 1, attr_status);
            mvaddnstr((int) DispRows - 1, 0, 8, "Jump to:");
            move(DispRows-1,9);
            buffer[0]=19;
            getstr(buffer);
            if (buffer[1])
              {
                topline = atol(buffer + 2);
                cursor = topline;
              }
            clearline((int) DispRows - 1, attr_status);
            break;
          case NEW_FILE:                            /* path + file name 64 */
            new_file();
            break;
          case JBM_A1:                              /* Jump to bookmark #1 */
            topline = bookmark[0];
            break;
          case JBM_A2:
            topline = bookmark[1];
            break;
          case JBM_A3:
            topline = bookmark[2];
            break;
          case JBM_A4:
            topline = bookmark[3];
            break;
          case JBM_A5:
            topline = bookmark[4];
            break;
          case LFP_A6:                                /* ReLoad File Mark */
            reload_filemark(0);
            break;
          case LFP_A7:
            reload_filemark(1);
            break;
          case LFP_A8:
            reload_filemark(2);
            break;
          case LFP_A9:
            reload_filemark(3);
            break;
          case LFP_A0:
            reload_filemark(4);
            break;
          case KEY_F1:                                /* On-line help */
            iaca(0L,scanascii);
            spawnlp(P_WAIT, plugin[1], plugin[1], pgman, NULL);
            clearline((int) DispRows - 1, attr_status);
            break;
          case KEY_SF2:                               /* cont. search backward (S) */
          case KEY_F2:                                /* cont. search backward */
            if (searchstr[1])
            {
              if (sdf == 'F')
                {
                  searchline -= 2;
                }
              sense = (scanascii == KEY_SF2 ? 1 : 0);
              if (strrfind(linebuf, searchstr+2))
                {
                  topline = searchline+1;
                  cursor = topline;
                }
              sdf = 'R';                            /* reverse search */
            }
            break;
          case KEY_SF3:                             /* cont. search forward (S) */
          case KEY_F3:                              /* cont. search forward */
            if (searchstr[1])
            {
              if (sdf == 'R')
                {
                  searchline += 2;
                }
              sense = (scanascii == KEY_SF3 ? 1 : 0);
              if (strfind(linebuf, searchstr+2))
                {
                  topline = searchline-1;
                  cursor = topline;
                }
              sdf = 'F';                            /* forward search */
            }
            break;
          case KEY_F4:                              /* Search mode */
            clearline((int) DispRows-1, attr_status);
            mvaddnstr((int) DispRows-1, 0, 7, "Search:");
            searchstr[0]=19;
            searchstr[1]=0;
            if (mouse)          /* mouse pickup string */
              {
                 pickup_string(searchstr);
                 mvaddnstr((int) DispRows-1,8,18,searchstr+2);
              }
            if (searchstr[1]==0)
              {
                move(DispRows-1,8);
                getstr(searchstr);
              }
            strcpy(buffer+105,searchstr+2);
            strlwr(buffer+105);
            if (searchstr[1])
            {
              searchline = topline;
              sense = 0;
              if (strfind(linebuf, searchstr+2))
                {
                  topline = searchline-1;
                  cursor = topline;
                }
              sdf = 'F';
            }
            break;
          case KEY_F5:                              /* save screen to file */
            save_screen(topline, topline + pagesize);
            break;
          case KEY_F6:                              /* Change foreground color */
            chg_fg_color();
            break;
          case KEY_SF6:                             /* Change background color */
            chg_bg_color();
            break;
          case KEY_F9:                              /* reload files from prev. argv[] */
            reload_argv_prev();
            break;
          case KEY_F10:                             /* reload files from next argv[] */
            reload_argv_next();
            break;
          default:
            asciicode = scanascii & 0xFF;
            switch (asciicode)
              {
                 case SBM_1:                        /* save Bookmark #1 */
                   bookmark[0] = topline;
                   break;
                 case SBM_2:
                   bookmark[1] = topline;
                   break;
                 case SBM_3:
                   bookmark[2] = topline;
                   break;
                 case SBM_4:
                   bookmark[3] = topline;
                   break;
                 case SBM_5:
                   bookmark[4] = topline;
                   break;
                 case SFP_1:                        /* Save file mark */
                   save_filemark(0);
                   break;
                 case SFP_2:
                   save_filemark(1);
                   break;
                 case SFP_3:
                   save_filemark(2);
                   break;
                 case SFP_4:
                   save_filemark(3);
                   break;
                 case SFP_5:
                   save_filemark(4);
                   break;
                 case 'b':
                 case BITON:
                   bit7 = bit7 ^ 0xFF;
                   bit7 = bit7 | 0x7F;
                   break;
                 case 'h':
                 case HEX:     /* Display in HEX. format */
                   iaca(offset,scanascii);
                   spawnlp(P_WAIT, plugin[0], plugin[0], infilename, NULL);
                   clearline((int) DispRows - 1, attr_status);
                   break;
                 case 'w':
                 case WRAP:    /* Wrap long line */
                   iaca(offset,scanascii);
                   spawnlp(P_WAIT, plugin[1], plugin[1], infilename, NULL);
                   clearline((int) DispRows - 1, attr_status);
                   break;
                 case 'p':                         /* Last file */
                   last_file();
                   break;
                 case 'n':                         /* Next file */
                   next_file();
                   break;
                 case 'q':
                 case QUIT:
                   quit = 1;
                   filenum = totfile + 1;
                   break;
              }
            break;
         } /* switch */

       if (topline < 1)                         /* alert top of file? */
         {
           topline = 1;
         }
       else if (topline > (numlines - pagesize))    /* alert bot of file? */
         {
           topline = numlines - pagesize +1;
         }
       if (topline < 1) topline = 1;           /* alert top of file? */
       if (numlines < pagesize) topline = 1;
       if (quit != 1)
         {
           line2offset(topline);
           display(topline, pancolumn);
         }
    }   /* !Quit */
    showline = topline;
    return filenum;
}

/* load last file, if exhausted, load files from previous argv */
void
last_file()
{
  if (filenum > 1)
    {
      --filenum;
      quit = 1;
    }
  else if (argi > 1)
         {
           reload_argv_prev();
           filenum = totfile;
           quit = 1;
         }
}

/* load next file, if exhausted, load files from next argv */
void
next_file()
{
  if (filenum < totfile)
    {
      ++filenum;
      quit = 1;
    }
  else if (argi < (args+nff))
         {
           reload_argv_next();
           filenum = 1;
           quit = 1;
         }
}

/* save file to filemark */
void
save_filemark(int i)
{
  strcpy(filemark+PATHLEN*i,infilename);
  memcpy(filemark+PATHLEN*(i+1)-5,&topline,sizeof(topline));
}

/* reload file from filemark */
void
reload_filemark(int i)
{
  pathlen = newpath(filemark+PATHLEN*i);
  memcpy(&topline,filemark+PATHLEN*(i+1)-5,sizeof(topline));
  totfile = countfile(filemark+PATHLEN*i,topline);
  quit = 1;
  filenum = 1;
}

/* set background color */
void chg_bg_color()
{
  char attr;

  attr = attr_text;
  attr_text &= 0x0F;
  attr = attr >> 4;
  attr++;
  attr &= 0x7;
  attr = attr << 4;
  attr_text |= attr;
}

/* set foreground color */
void
chg_fg_color()
{
  char attr;

  attr = attr_text;
  attr_text &= 0x0F;
  attr &= 0xF0;
  attr_text++;
  attr_text &= 0x0F;
  attr_text |= attr;
}

/* user input a new file path and file name */
void
new_file()
{
  int i,j;
  char *errmsg = "PG: cannot open ";

  i = filenum;
  clearline((int) DispRows-1, attr_status);
  mvaddnstr((int) DispRows-1, 0, 9, "New File:");
  move(DispRows-1,10);
  buffer[125]=65;
  getstr(newfile-2);
  if (buffer[126])
  {
    error = check_filespec(newfile);
    if (error)
      {
        j = strlen(errmsg);
        mvaddnstr((int) DispRows-1,0,j , errmsg);
        mvaddnstr((int) DispRows-1,j,50, newfile);
        mvaddnstr(DispRows-1,j+strlen(newfile),27, "! Press any key to continue.");
        kbget();
        filenum = i;
        quit = 1;
        nff = 0;
      }
    else
      {
        pathlen = newpath(newfile);
        totfile = countfile(newfile,1L);
        filenum = 1;
        quit = 1;
        nff  = 1;
        argi = args + nff;
      }

  }
}

/* reload file from previous argument in command line */
void
reload_argv_prev()
{
  quit = 1;
  if (--argi == 0) argi = 1;
  pathlen = newpath(argvptr[argi]);
  totfile = countfile(argvptr[argi],1L);
  filenum = 1;
}

/* reload file from next argument in command line */
void
reload_argv_next()
{
  quit = 1;
  if ((++argi) > args)
    {
      if (nff)
        {
          pathlen = newpath(newfile);
          totfile = countfile(newfile,1L);
        }
      if (argi > (args+nff)) argi = args+nff;
    }
  else
    {
      pathlen = newpath(argvptr[argi]);
      totfile = countfile(argvptr[argi],1L);
    }
  filenum = 1;
}

/* Get display adaptor info. and initialize */
void
InitVideo(void)
{
  getbiosinfo();
  RegenSize = DispRows * DispCols;     /* for use in asm functions */
  VideoRegen = (DispMode == MONO ? 0xb000 : 0xb800);
  Color = (DispMode == MONO ? false : true);

/* BAHCL moved from main() */
#ifdef USE_COLOR_MODE                   /* (jh) */
  if(Color)
    {
      attr_status    = CO_STATUS;
      attr_lo_status = CO_LO_STATUS;
      attr_text      = CO_TEXT;
    }
  else
    {
      attr_status    = MO_STATUS;
      attr_lo_status = MO_LO_STATUS;
      attr_text      = MO_TEXT;
    }
#else
  attr_status    = ATTR (BLACK, WHITE);                 /* (jh) */
  attr_lo_status = ATTR (BLACK, WHITE);                 /* (jh) */
  attr_text      = ATTR (WHITE, BLACK);                 /* (jh) */
#endif /* USE_COLOR_MODE */

  setattr(attr_text);

}

/* BAHCL: useful as the one in Linux ncurses */
void
mvaddnstr(int prow, int pcol, int n, char *s)
{
  int i,j;
  i = 0;
  j = (prow * DispCols + pcol) * 2;
  while (s[i] && (i < n))
    {
      mvaddch(j, s[i++], curatt);
      j += 2;
    }
}

/* error exit */
void
errorexit(int pcode, char *args)
{
    mvaddnstr((int) DispRows-1,0,80,args);
    exit(pcode);
}

/* program usage */
void
usage(void)
{
  /* (jh) I moved all the usage text here so that the text wasn't
     separated from the usage() function */

  /* (jh) I moved the VERSION text here, since it is not used
     anywhere else. */

  /* (jh) Most DOS programs just show the name and usage, but you can
     build with the GNU 'copying' statement anyway by using
     -DSHOW_GNU_COPYING */

  char *usage = "PG, version 1.0 (c) 1995-1998 Bill Weinman, wew@bearnet.com\xD\xA\
PG, version 1.01 - 1.13 2005 Enhanced by BAHCL\xD\xA\xD\xA\
usage:  PG [/?] [filename ...]\xD\xA\
  /?       - display this help screen.\xD\xA\
  filename - page through filename on the PC screen\xD\xA\
\t     filename may be in wildcard format\xD\xA\
\t     if filename is omitted, assume piping from <stdin>\xD\xA\
  Read pg.man for details.\xD\xA";

#ifdef SHOW_GNU_COPYING
  char *gnu = "\xD\xAPG is distributed under the terms of the GNU General Public License.\xD\xA\
See the file COPYING for details.\xD\xA";
#endif

  write(1, usage, strlen(usage));
#ifdef SHOW_GNU_COPYING
  write(1, gnu, strlen(gnu));
#endif
  exit(0);
}

/* Clear the entire screen */
void
clearscreen()
{
  scroll_up((int) 0, 0, DispCols, (int) DispRows, (int) DispRows);
}

/* Just a blank line with status attribute */
void
clearline(int lin, char attr)
{
  int i;

  setattr(attr);
  for (i = 0; i < DispCols; i++)
    {
      mvaddnstr(lin, i, 1, " ");
    }
}

/* PG -- headline of file information */
void
headline(long line)
{
  int pgstat;

  clearline(0, attr_status);
  mvaddnstr(0, 1, 6, "PG -- ");
  mvaddnstr(0, 7, 40, infilename);
  pgstat = STATOK;

  if (line <= 1)
    {
      pgstat = STATTOP;
    }

  if ((line + DispRows - 2) > numlines)
    {
      pgstat = STATBOT;
    }

  mvaddnstr(0, 50, 5, stat[pgstat]);
  ltoa(numlines, buffer, 10);
  mvaddnstr(0, DispCols-strlen(buffer)-10, 6, buffer);      /* total lines */
  ltoa(line, buffer, 10);
  mvaddnstr(0, DispCols-strlen(buffer)-1, 6, buffer);       /* top line */
}

/* convert from line number to line address and the group  */
void
line2offset(long line)
{
  int linenum, group;

  --line;                                           /* adjust for zero based */
  linenum = line % LINEADDRS;
  group   = line / GROUPS;
  if (groupid != group)                             /* not in current group */
    {
      load_grp_li_addr(group);
      groupid = group;
    }
  offset = lineaddr[linenum];
}

/* load line addresses within a group */
void
load_grp_li_addr(int group)
{                                       /* this routine may be wrong if */
  int  i;                               /* its length is > 256 bytes */
  char *str;

  offset = groups[group];
  fseek(infile, offset, SEEK_SET);
  for (i = 0; i < LINEADDRS; i++)
  {
    lineaddr[i] = offset;
    str = fgets(linebuf, MAXSIZELINE+1, infile);
    if (str == NULL) break;                       /* end of file */
    offset = ftell(infile);
  }
}

/* save screen to a save file */
void
save_screen(long saveline, long toline)
{
  long seekpos, pos1, pos2;
  char *savefile = "C:\\PG.SAV";

  clearline((int) DispRows-1, attr_status);
  mvaddnstr((int) DispRows-1, 0, 10, "Save to...");
  move(DispRows-1,10);                          /* move cursor */
  if (pgsav == NULL)                            /* if not open yet */
    {
      buffer[0]=2;                              /* get the drive letter only */
      getstr(buffer);
      savefile[0] = buffer[2];
    }

  if ((pgsav = fopen(savefile, "ab")) == NULL)  /* append data */
    {
      return;
    }
  strcpy(linebuf, "!!! Copy from ");            /* indentify copy info */
  strcat(linebuf, infilename);
  strcat(linebuf, " line ");
  strcat(linebuf, ltoa(saveline, buffer,10));
  strcat(linebuf, " !!! ");
  fwrite(linebuf, strlen(linebuf), 1, pgsav);

  if (toline > numlines)
    toline = numlines+1;
  line2offset(saveline);
  fseek(infile, offset, SEEK_SET);
  pos1 = ftell(infile);
  while (--toline - (saveline-1))
    {
      fgets(linebuf, MAXSIZELINE+1, infile);
      pos2 = ftell(infile);
      fwrite(linebuf, pos2 - pos1, 1, pgsav);
      pos1 = pos2;
    }
  fclose(pgsav);
  mvaddnstr((int) DispRows-1, 9, 10, savefile);
}

/* find sub-string in forward manner */
char
*strfind(char *str1, char *str2)
{
  char *ptr, *cis;

  cis = buffer+105;                 /* case insensitive search */
  if (searchline > numlines)
    {
      searchline = 1;
    }
  do
  {
    getline(searchline++);
    if (sense)                      /* case sensitive search */
      {
        ptr = strstr(str1, str2);
      }
    else
      {
        /* convert to lower case before the search */
        ptr = strstr(strlwr(str1), cis);
      }
  } while((searchline <= numlines) && (ptr == NULL));
  if (ptr)
    {
      exptabs();
      if (sense)
        {
          xpos = cursor_x(str1, str2, (int) searchstr[1]);
        }
      else
        {
          xpos = cursor_x(strlwr(str1), cis, (int) searchstr[1]);
        }
    }
  return ptr;
}

/* find sub-string in backward manner */
char
*strrfind(char *str1, char *str2)
{
  char *ptr, *cis;

  cis = buffer+105;                 /* case insensitive search */
  if (searchline > numlines)
    {
      searchline = numlines;
    }
  do
  {
    getline(searchline--);
    if (sense)                      /* case sensitive search */
      {
        ptr = strstr(str1, str2);
      }
    else
      {
        /* convert to lower case before the search */
        ptr = strstr(strlwr(str1), cis);
      }
  } while((searchline <= numlines) && (ptr == NULL));
  if (ptr)
    {
      exptabs();
      if (sense)
        {
          xpos = cursor_x(str1, str2, (int) searchstr[1]);
        }
      else
        {
          xpos = cursor_x(strlwr(str1), cis, (int) searchstr[1]);
        }
    }
  return ptr;
}


