       PAGE    ,80                    ; P
; #############################################################################
;
;    EUROFONT V1.01 Eurocurrency bitmap definitions for display and printing
;
;    Copyright (C) 1998-2000 by Matthias Paul
;                               Ubierstrae 28
;                               D-50321 Brhl
;                               GERMANY
;
;    All rights reserved (except those detailed below).
;
;    Registered trademarks and tradenames mentioned inhere are owned
;    by their respective owners.
;
;    EMail: <Matthias.Paul@post.rwth-aachen.de>
;    Web:   http://www.rhrz.uni-bonn.de/~uzs180/mpdokeng.html
;           http://www.freedos.org/
;
;    Last edit: 2000-10-25 MPAUL
;
; #############################################################################
;
;    This program is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    This program is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with this program (see LICENSE.TXT or http://www.gnu.org);
;    if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
;    Cambridge, MA 02139, USA.
;
; #############################################################################
;
;    History:
;    ========
;
;    1.00 1998-05-01 MPAUL Display and printer bitmaps originally created for
;                          inclusion with DR-DOS 7.02+, but for some reason
;                          they were only used internally and never made it
;                          into the distributed EGA.CPI files.  Please note,
;                          that these bitmaps were independently developed
;                          by me (not Caldera), so you are free to use them
;                          in your software without worrying about any
;                          copyright infringements.
;    1.01 2000-10-25 MPAUL For compatibility with INT 10h character recognition
;                          in graphics mode, I modified the display bitmaps to
;                          be 100% compatible with the shapes provided by
;                          PC DOS 2000 (EGA.CPI as of 1998-06-01).  For
;                          reference, the old bitmaps are available under
;                          alternative "_OBSOLETE" names, now.
;                          Thereby I also incorporated the shapes developed
;                          for 24 dot matrix printers as used by my NECPINW.CPI
;                          since 2000-09-28, and the 16x8 bitmap used by
;                          Aitor Santamara's EURO/EUROTSR (under GPL), so
;                          that EUROFONT.INC may serve as a reference file
;                          for any kind of Eurocurrency bitmaps.
;                          I put this file unter GNU GPL version 2 to include
;                          it in my NECPINW.ZIP distribution, and for possible
;                          use with FreeDOS. Although I prefer open source,
;                          I still personally reserve the right to continue to
;                          use these bitmaps in any kind of closed sourced
;                          software (like possibly future DR-DOS files).
;
; #############################################################################

; --- Eurocurrency bitmaps for display ----------------------------------------

EURO_6x8        macro
        db      00011100b               ;  1 NB. - This Eurocurrency shape is
        db      00100010b               ;  2       only a proposal for a 6x8
        db      01111000b               ;  3       display font.
        db      01110000b               ;  4     - It may also be used by
        db      00100010b               ;  5       future DR-DOS 7.0x+ files.
        db      00011100b               ;  6     - To be viewed horizontally!
        endm

EURO_6x8_OBSOLETE macro
        db      00111000b               ;  1 NB. - This shape was added to
        db      01000100b               ;  2       the DR-DOS 7.02/7.03 font
        db      11110000b               ;  3       database on 1998-05-01.
        db      11100000b               ;  4     - It was replaced by EURO_6x8
        db      01000100b               ;  5       on 2000-10-25.
        db      00111000b               ;  6     - To be viewed horizontally!
        endm

; -----------------------------------------------------------------------------

EURO_8x8        macro
        db      00011110b               ;  1 NB. - This shape is designed to
        db      00100001b               ;  2       be compatible with the shape
        db      01111100b               ;  3       provided by PC DOS 2000
        db      00100000b               ;  4       EGA.CPI (1998-06-01) for
        db      01111100b               ;  5       Code Page 850 Character D5h.
        db      00100001b               ;  6     - It may also be used by
        db      00011110b               ;  7       future DR-DOS 7.0x+ files.
        db      00000000b               ;  8     - To be viewed horizontally!
        endm

EURO_8x8_OBSOLETE macro
        db      00111100b               ;  1 NB. - This shape was added to
        db      01000010b               ;  2       the DR-DOS 7.02/7.03 font
        db      11111000b               ;  3       database on 1998-05-01.
        db      01000000b               ;  4     - It was replaced by EURO_8x8
        db      11111000b               ;  5       on 2000-10-25.
        db      01000010b               ;  6     - To be viewed horizontally!
        db      00111100b               ;  7
        db      00000000b               ;  8
        endm

; -----------------------------------------------------------------------------

EURO_14x8       macro
        db      00000000b               ;  1 NB. - This shape is designed to
        db      00000000b               ;  2       be compatible with the shape
        db      00000000b               ;  3       provided by PC DOS 2000
        db      00011110b               ;  4       EGA.CPI (1998-06-01) for
        db      00110011b               ;  5       Code Page 850 Character D5h.
        db      01100000b               ;  6     - It may also be used by
        db      11111110b               ;  7       future DR-DOS 7.0x+ files.
        db      01100000b               ;  8     - To be viewed horizontally!
        db      11111100b               ;  9
        db      01100000b               ; 10
        db      00110011b               ; 11
        db      00011110b               ; 12
        db      00000000b               ; 13
        db      00000000b               ; 14
        endm

EURO_14x8_OBSOLETE macro
        db      00000000b               ;  1 NB. - This shape was added to
        db      00000000b               ;  2       the DR-DOS 7.02/7.03 font
        db      00111100b               ;  3       database on 1998-05-01.
        db      01100010b               ;  4     - It was replaced by EURO_14x8
        db      01000000b               ;  5       on 2000-10-25.
        db      11111100b               ;  6     - To be viewed horizontally!
        db      01000000b               ;  7
        db      11111000b               ;  8
        db      01000000b               ;  9
        db      01100010b               ; 10
        db      00111100b               ; 11
        db      00000000b               ; 12
        db      00000000b               ; 13
        db      00000000b               ; 14
        endm

; -----------------------------------------------------------------------------

EURO_16x8       macro
        db      00000000b               ;  1 NB. - This shape is designed to
        db      00000000b               ;  2       be compatible with the shape
        db      00000000b               ;  3       provided by PC DOS 2000
        db      00011110b               ;  4       EGA.CPI (1998-06-01) for
        db      00110011b               ;  5       Code Page 850 Character D5h.
        db      01100000b               ;  6     - It may also be used by
        db      11111110b               ;  7       future DR-DOS 7.0x+ files.
        db      01100000b               ;  8     - To be viewed horizontally!
        db      11111100b               ;  9
        db      01100000b               ; 10
        db      00110011b               ; 11
        db      00011110b               ; 12
        db      00000000b               ; 13
        db      00000000b               ; 14
        db      00000000b               ; 15
        db      00000000b               ; 16
        endm

EURO_16x8_OBSOLETE macro
        db      00000000b               ;  1 NB. - This shape was added to
        db      00000000b               ;  2       the DR-DOS 7.02/7.03 font
        db      00000000b               ;  3       database on 1998-05-01.
        db      00111100b               ;  4     - It was replaced by EURO_16x8
        db      01100010b               ;  5       on 2000-10-25.
        db      01000000b               ;  6     - To be viewed horizontally!
        db      11111100b               ;  7
        db      01000000b               ;  8
        db      11111000b               ;  9
        db      01000000b               ; 10
        db      01100010b               ; 11
        db      00111100b               ; 12
        db      00000000b               ; 13
        db      00000000b               ; 14
        db      00000000b               ; 15
        db      00000000b               ; 16
        endm

EURO_16x8_OBSOLETE2 macro
        db      00000000b               ;  1 00h NB. - This shape was used
        db      00000000b               ;  2 00h       by Aitor Santamara's
        db      00011110b               ;  3 1Eh       EUROTSR extension
        db      00100001b               ;  4 21h       0.5 BETA (2000-05-07)
        db      01000001b               ;  5 41h       for FreeDOS.
        db      01000000b               ;  6 40h     - It should be replaced
        db      11111110b               ;  7 FEh       by EURO_16x8!
        db      01000000b               ;  8 40h     - To be viewed
        db      11111100b               ;  9 FCh       horizontally!
        db      01000000b               ; 10 40h
        db      01000000b               ; 11 40h
        db      00100001b               ; 12 21h
        db      00011110b               ; 13 1Eh
        db      00000000b               ; 14 00h
        db      00000000b               ; 15 00h
        db      00000000b               ; 16 00h
        endm

; -----------------------------------------------------------------------------

EURO_19x8       macro
        db      00000000b               ;  1 NB. - This Eurocurrency shape is
        db      00000000b               ;  2       only a proposal for a 19x8
        db      00000000b               ;  3       display font.
        db      00000000b               ;  4     - To be viewed horizontally!
        db      00011110b               ;  5
        db      00110011b               ;  6
        db      01100000b               ;  7
        db      11111110b               ;  8
        db      01100000b               ;  9
        db      01100000b               ; 10
        db      11111100b               ; 11
        db      01100000b               ; 12
        db      00110011b               ; 13
        db      00011110b               ; 14
        db      00000000b               ; 15
        db      00000000b               ; 16
        db      00000000b               ; 17
        db      00000000b               ; 18
        db      00000000b               ; 19
        endm

EURO_19x16_LE   macro
        dw      0000000000000000b       ;  1 NB. - This Eurocurrency shape is
        dw      0000000000000000b       ;  2       only a proposal for a 19x16
        dw      0000000000000000b       ;  3       display font.
        dw      0000000000000000b       ;  4     - It is the same as the 19x8
        dw      0000001111111100b       ;  5       font but with all the bits
        dw      0000111100001111b       ;  6       doubled intentiously.
        dw      0011110000000000b       ;  7     - The order of bytes is
        dw      1111111111111100b       ;  8       Little Endian (Intel style).
        dw      0011110000000000b       ;  9     - To be viewed horizontally!
        dw      0011110000000000b       ; 10
        dw      1111111111110000b       ; 11
        dw      0011110000000000b       ; 12
        dw      0000111100001111b       ; 13
        dw      0000001111111100b       ; 14
        dw      0000000000000000b       ; 15
        dw      0000000000000000b       ; 16
        dw      0000000000000000b       ; 17
        dw      0000000000000000b       ; 18
        dw      0000000000000000b       ; 19
        endm

EURO_19x16_BE   macro
        db      00000000b,00000000b     ;  1 NB. - This Eurocurrency shape is
        db      00000000b,00000000b     ;  2       only a proposal for a 19x16
        db      00000000b,00000000b     ;  3       display font.
        db      00000000b,00000000b     ;  4     - It is the same as the 19x8
        db      00000011b,11111100b     ;  5       font but with all the bits
        db      00001111b,00001111b     ;  6       doubled intentiously.
        db      00111100b,00000000b     ;  7     - The order of bits is
        db      11111111b,11111100b     ;  8       Big Endian (Motorola style).
        db      00111100b,00000000b     ;  9     - To be viewed horizontally!
        db      00111100b,00000000b     ; 10
        db      11111111b,11110000b     ; 11
        db      00111100b,00000000b     ; 12
        db      00001111b,00001111b     ; 13
        db      00000011b,11111100b     ; 14
        db      00000000b,00000000b     ; 15
        db      00000000b,00000000b     ; 16
        db      00000000b,00000000b     ; 17
        db      00000000b,00000000b     ; 18
        db      00000000b,00000000b     ; 19
        endm

; --- Eurocurrency bitmaps for printing ---------------------------------------


EURO_PRN_8x11_Draft macro
                                        ;               1
                                        ;      12345678901
                                        ;
                                        ;  1   00101010100   MSB 7
                                        ;  2   01000000010    |
                                        ;  3   10101010000    |
                                        ;  4   01000000000    |
                                        ;  5   10101010000    |
                                        ;  6   01000000010    |
                                        ;  7   00101010100    |
                                        ;  8 _ 00000000000 _ LSB 0
                                        ;
        db      00101000b               ;  1 NB. - This Eurocurrency shape was
        db      01010100b               ;  2       added to the DR-DOS 7.02+
        db      10101010b               ;  3       printer font database on
        db      00000000b               ;  4       1998-05-01.
        db      10101010b               ;  5     - It is designed for 9 dot
        db      00000000b               ;  6       matrix printers such as the
        db      10101010b               ;  7       Epson FX-850/FX-1050 and
        db      00000000b               ;  8       Epson compatible printers.
        db      10000010b               ;  9       It can also be used for
        db      01000100b               ; 10       9 dot matrix printers such
        db      00000000b               ; 11       as the IBM Proprinter Model
        endm                            ;          4201 & XL Model 4202 in
                                        ;          Draft modes.
                                        ;        - For print head hardware
                                        ;          reasons, no two horizontally
                                        ;          consecutive needles may be
                                        ;          set at the same time!
                                        ;        - To be viewed vertically!

; -----------------------------------------------------------------------------

EURO_PRN_16x23_NLQ macro               
                        ;               1         2
                        ;      12345678901234567890123
                        ;
                        ;  1 v 00000000000000000000000 v Byte 1 Bit 7
                        ;  2   00000000111111110000000   Byte 2 Bit 7
                        ;  3   00000011000000001100000   Byte 1 Bit 6
                        ;  4   00000100000000000010000   Byte 2 Bit 6
                        ;  5   00000100000000000000000   Byte 1 Bit 5
                        ;  6   00001000000000000000000   Byte 2 Bit 5
                        ;  7   00111111111111111000000   Byte 1 Bit 4
                        ;  8   00001000000000000000000   Byte 2 Bit 4
                        ;  9   00001000000000000000000   Byte 1 Bit 3
                        ; 10   00111111111111100000000   Byte 2 Bit 3
                        ; 11   00001000000000000000000   Byte 1 Bit 2
                        ; 12   00000100000000000000000   Byte 2 Bit 2
                        ; 13   00000100000000000010000   Byte 1 Bit 1
                        ; 14   00000011000000001100000   Byte 2 Bit 1
                        ; 15   00000000111111110000000   Byte 1 Bit 0
                        ; 16 _ 00000000000000000000000 _ Byte 2 Bit 0

        ;  Byte 1     Byte 2
        db 00000000b, 00000000b         ;  1 NB. - This Eurocurrency shape was
        db 00000000b, 00000000b         ;  2       added to the DR-DOS 7.02+
        db 00010000b, 00001000b         ;  3       printer font database on
        db 00010000b, 00001000b         ;  4       1998-05-01.
        db 00011100b, 00111000b         ;  5     - It is designed for 9 dot
        db 00110010b, 01001100b         ;  6       matrix printers such as the
        db 01010000b, 00001010b         ;  7       IBM Proprinter Model 4201 &
        db 01010000b, 00001010b         ;  8       XL Model 4202 (in NLQ
        db 00010001b, 10001000b         ;  9       modes).
        db 00010001b, 10001000b         ; 10     - To be viewed vertically with
        db 00010001b, 10001000b         ; 11       the two bytes interwoven
        db 00010001b, 10001000b         ; 12       on a bit-by-bit basis!
        db 00010001b, 10001000b         ; 13
        db 00010001b, 10001000b         ; 14
        db 00010001b, 10001000b         ; 15
        db 00010001b, 10000000b         ; 16
        db 01010000b, 00000010b         ; 17
        db 01000000b, 00000010b         ; 18
        db 00000010b, 01000000b         ; 19
        db 00000000b, 00000000b         ; 20
        db 00000000b, 00000000b         ; 21
        db 00000000b, 00000000b         ; 22
        db 00000000b, 00000000b         ; 23
        endm

; -----------------------------------------------------------------------------

EURO_PRN_24x9_Draft macro
                                        ;      123456789
                                        ;
                                        ;  1   000000000   1 Byte 1 MSB 7
                                        ;  2   000000000   2         |
                                        ;  3   000000000   3         |
                                        ;  4 v 000000000 v 4         |
                                        ;  5   000000000             |
                                        ;  6   000010100             |
                                        ;  7   000101010             |
                                        ;  8   001000001     Byte 1 LSB 0
                                        ;  9   010000000     Byte 2 MSB 7
                                        ; 10   101010100             |
                                        ; 11   101010000             |
                                        ; 12   010000000             |
                                        ; 13   010000000             |
                                        ; 14   101010100             |
                                        ; 15   101010000             |
                                        ; 16   010000000     Byte 2 LSB 0
                                        ; 17   001000001     Byte 3 MSB 7
                                        ; 18   000101010             |
                                        ; 19   000010100             |
                                        ; 20 ^ 000000000 ^ 4         |
                                        ; 21   000000000   3         |
                                        ; 22   000000000   2         |
                                        ; 23   000000000   1         |
                                        ; 24 _ 000000000 _   Byte 3 LSB 0

        ; Byte: 1    2    3
        db      00h, 66h, 00h           ;  1 NB. - This Eurocurrency shape
        db      00h, 99h, 00h           ;  2       is used by my NECPINW.CPI
        db      01h, 66h, 80h           ;  3       since 2.00+ (2000-09-28).
        db      02h, 00h, 40h           ;  4     - It is designed for 24 dot
        db      04h, 66h, 20h           ;  5       matrix printers such as
        db      02h, 00h, 40h           ;  6       the NEC Pinwriter family
        db      04h, 44h, 20h           ;  7       (in Draft modes).
        db      02h, 00h, 40h           ;  8     - For print head hardware
        db      01h, 00h, 80h           ;  9       reasons, no two horizontally
        endm                            ;          consecutive needles may be
                                        ;          set at the same time!
                                        ;        - To be viewed vertically!

; -----------------------------------------------------------------------------

EURO_PRN_24x22_LQ macro
                        ;               1         2
                        ;      1234567890123456789012
                        ;
                        ;  1   0000000000000000000000   1 Byte 1 MSB 7
                        ;  2   0000000000000000000000   2         |
                        ;  3   0000000000000000000000   3         |
                        ;  4 v 0000000000000000000000 v 4         |
                        ;  5   0000000000000000000000             |
                        ;  6   0000000000101010000000             |
                        ;  7   0000000101010101010000             |
                        ;  8   0000010100000000010100     Byte 1 LSB 0
                        ;  9   0000101000000000000101     Byte 2 MSB 7
                        ; 10   1010101010101010000000             |
                        ; 11   0101010101010000000000             |
                        ; 12   0010100000000000000000             |
                        ; 13   0010100000000000000000             |
                        ; 14   1010101010101000000000             |
                        ; 15   0101010101000000000000             |
                        ; 16   0000101000000000000101     Byte 2 LSB 0
                        ; 17   0000010100000000010100     Byte 3 MSB 7
                        ; 18   0000000101010101010000             |
                        ; 19   0000000000101010000000             |
                        ; 20 ^ 0000000000000000000000 ^ 4         |
                        ; 21   0000000000000000000000   3         |
                        ; 22   0000000000000000000000   2         |
                        ; 23   0000000000000000000000   1         |
                        ; 24 _ 0000000000000000000000 _   Byte 3 LSB 0

        ; Byte: 1    2    3
        db      00h, 44h, 00h           ;  1 NB. - This Eurocurrency shape
        db      00h, 22h, 00h           ;  2       is used by my NECPINW.CPI
        db      00h, 5Ch, 00h           ;  3       since 2.00+ (2000-09-28).
        db      00h, 22h, 00h           ;  4     - It is designed for 24 dot
        db      00h,0DDh, 00h           ;  5       matrix printers such as
        db      01h, 22h, 80h           ;  6       the NEC Pinwriter family
        db      00h,0C5h, 00h           ;  7       (in LQ modes, e.g. Elite).
        db      03h, 22h,0C0h           ;  8     - For print head hardware
        db      00h, 44h, 00h           ;  9       reasons, no two horizontally
        db      02h, 22h, 40h           ; 10       consecutive needles may be
        db      04h, 44h, 20h           ; 11       set at the same time!
        db      02h, 20h, 40h           ; 12     - To be viewed vertically!
        db      04h, 44h, 20h           ; 13
        db      02h, 00h, 40h           ; 14
        db      04h, 40h, 20h           ; 15
        db      02h, 00h, 40h           ; 16
        db      00h, 00h, 00h           ; 17
        db      03h, 00h,0C0h           ; 18
        db      00h, 00h, 00h           ; 19
        db      01h, 81h, 80h           ; 20
        db      00h, 00h, 00h           ; 21
        db      00h, 81h, 00h           ; 22
        endm

; -----------------------------------------------------------------------------

EURO_PRN_24x28_LQ macro ;               1         2
                        ;      1234567890123456789012345678
                        ;
                        ;  1   0000000000000000000000000000   1 Byte 1 MSB 7
                        ;  2   0000000000000000000000000000   2         |
                        ;  3   0000000000000000000000000000   3         |
                        ;  4 v 0000000000000000000000000000 v 4         |
                        ;  5   0000000000000000000000000000             |
                        ;  6   0000000000001010101010000000             |
                        ;  7   0000000001010101010101010000             |
                        ;  8   0000000101000000000000010100     Byte 1 LSB 0
                        ;  9   0000010100000000000000000101     Byte 2 MSB 7
                        ; 10   1010101010101010101000000000             |
                        ; 11   0101010101010101000000000000             |
                        ; 12   0001010000000000000000000000             |
                        ; 13   0001010000000000000000000000             |
                        ; 14   1010101010101010100000000000             |
                        ; 15   0101010101010100000000000000             |
                        ; 16   0000010100000000000000000101     Byte 2 LSB 0
                        ; 17   0000000101000000000000010100     Byte 3 MSB 7
                        ; 18   0000000001010101010101010000             |
                        ; 19   0000000000001010101010000000             |
                        ; 20 ^ 0000000000000000000000000000 ^ 4         |
                        ; 21   0000000000000000000000000000   3         |
                        ; 22   0000000000000000000000000000   2         |
                        ; 23   0000000000000000000000000000   1         |
                        ; 24 _ 0000000000000000000000000000 _   Byte 3 LSB 0

        ; Byte: 1    2    3
        db      00h, 44h, 00h           ;  1 NB. - This Eurocurrency shape
        db      00h, 22h, 00h           ;  2       is used by my NECPINW.CPI
        db      00h, 44h, 00h           ;  3       since 2.00+ (2000-09-28).
        db      00h, 3Ah, 00h           ;  4     - It is designed for 24 dot
        db      00h, 44h, 00h           ;  5       matrix printers such as
        db      00h,0BBh, 00h           ;  6       the NEC Pinwriter family
        db      00h, 44h, 00h           ;  7       (in LQ modes, e.g. Pica).
        db      01h,0A3h, 80h           ;  8     - For print head hardware
        db      00h, 44h, 00h           ;  9       reasons, no two horizontally
        db      03h, 22h,0C0h           ; 10       consecutive needles may be
        db      00h, 44h, 00h           ; 11       set at the same time!
        db      02h, 22h, 40h           ; 12     - To be viewed vertically!
        db      04h, 44h, 20h           ; 13
        db      02h, 22h, 40h           ; 14
        db      04h, 44h, 20h           ; 15
        db      02h, 20h, 40h           ; 16
        db      04h, 44h, 20h           ; 17
        db      02h, 00h, 40h           ; 18
        db      04h, 40h, 20h           ; 19
        db      02h, 00h, 40h           ; 20
        db      04h, 00h, 20h           ; 21
        db      02h, 00h, 40h           ; 22
        db      00h, 00h, 00h           ; 23
        db      03h, 00h,0C0h           ; 24
        db      00h, 00h, 00h           ; 25
        db      01h, 81h, 80h           ; 26
        db      00h, 00h, 00h           ; 27
        db      00h, 81h, 00h           ; 28
        endm

; #############################################################################

; End of file                           ; 

