_seg    segment byte public
	assume cs:_seg
        MASM
        JUMPS
        LOCALS

        .386c

timer   equ 46Ch
motoroff equ 440h
CallBackSig     equ 35ECCA11h

	org 100h
start:  jmp init

seg35sec dw 0
Config  dw 0

; Used keys
; 
; Q2 W4 E6 R8 t  y  u  i  o  p  [  ]
;  A1 S3 D5 F7 g  h  j  k  l  ;  '
;   Z9 X0 C0 V0 Bc n  m  ,  .  /


; Needed actions
; 
;                                                           A: B:
; Allocate memory & read disk from A:/B: to buffer       ... A  Q  *  1 2
; Set active buffer for A:/B: to buffer                  ... S  W  *  3 4
; Free memory for buffer                                 ... Z     *  9
; Write changed fields from buffer to A:/B:              ... D  E  *  5 6
; Write whole buffer to A:/B:                            ... F  R  *  7 8
; Report current operation                               ... X

; Cancel current operation                               ... C     *  A
;(Future) Write buffer for to hard-disk file 1..0                ... V     *  B
;(Future) Read buffer for from hard-disk file 1..0               ... B     *  C
; Help

IF ScrVer
buffer dw 80*3 dup (255)
ENDIF

CmdTable:
        db 2,4,6,8
        db 1,3,5,7
        db 9,80h,81h,82h,11

lo1     equ 10h ;Q
hi1     equ 13h ;R

lo2     equ 30  ;A
hi2     equ 33  ;F

lo3     equ 44  ;Z
hi3     equ 48  ;B

key_mask  dw 00h


IF ScrVer
startpos equ (10*80 + 20)*2
frame1  db '35 secondsDisk cacheͻ'
frame2  db '                                      '
frame3  db 'Keyͼ'
Report    db 'Report: Cyl 00'
RepCyl    db ' Head 0'
RepHead   db ' Sector 00'
RepSec    db 0

ReportFunc dw 0
ENDIF

InitInt macro Num,New,Old
        mov ax,3500h + Num
	int 21h
        mov word ptr cs:[Old+1],bx
        mov word ptr cs:[Old+3],es

        mov ax,2500h + Num
	push cs
	pop ds
        mov dx, offset New
	int 21h
        endm

IF BEEPVER
  INCLUDE 35beep.asm
ENDIF

INCLUDE 35keys.asm

IF SCRVER
  INCLUDE 35scr.asm
  INCLUDE 35err.asm
ELSE

txtNotImpl   :
txtFreeErr   :
txtFree      :
txtWorking   :
txtBufEmpty  :
txtBadBoot   :
txtBadBuffer :
txtNoMem     :
txtBadForm   :
txtOKRW      :
txtReadBoot  :
txtBufSet    :
txtBufReset  :
txtNoDrive   :
txtCantCancel:
txtCanceled  :

txtOpDone       :
txtOpDoneError  :
txtRWWorking    :

ENDIF

LastText  dw 0

;
; 0..Pause
; 1..Beep1
; 2..Beep2
;

RetTable:
  dw offset txtNotImpl
  dw 0001h + 0002h shl 4
  dw offset txtFreeErr
  dw 0001h + 0002h shl 4
  dw offset txtFree
  dw 0001h + 0001h shl 4
  dw offset txtWorking
  dw 0011h + 0002h shl 4
  dw offset txtBufEmpty
  dw 0021h + 0002h shl 4
  dw offset txtBadBoot
  dw 0012h + 0001h shl 4
  dw offset txtBadBuffer
  dw 0011h + 0002h shl 4
  dw offset txtNoMem
  dw 0011h + 0022h shl 4
  dw offset txtBadForm
  dw 0021h + 0012h shl 4
  dw offset txtOKRW
  dw 0001h + 0001h shl 4
  dw offset txtReadBoot
  dw 0011h + 0012h shl 4
  dw offset txtBufSet
  dw 0001h + 0001h shl 4
  dw offset txtBufReset
  dw 0001h + 0002h shl 4
  dw offset txtNoDrive
  dw 0021h + 0012h shl 4
  dw offset txtCantCancel
  dw 0001h + 0002h shl 4
  dw offset txtCanceled
  dw 0001h + 0001h shl 4

CallBack:
  dw offset txtOpDone
  dw 0001h + 0001h shl 4
  dw offset txtOpDoneError
  dw 0001h + 0002h shl 4
  dw offset txtRWWorking
  dw 0                    ;001h + 0002h shl 4

;
; StartTsr - stisknuta klavesa, ktera nepotrebuje parametr
;

StartTsr:
        cmp CmdPhase,82h
        je CancelIt
IF SCRVER
        pusha
        cmp CmdPhase,81h
        je RepLastText

        call DoReportFunc
        mov ax,offset DoReportFunc
        mov ReportFunc,ax

        mov dx,offset Report
        call Error
        xor ax,ax
        mov ReportFunc,ax
RepDone:
        popa
ENDIF
        retn

IF SCRVER
RepLastText:
        test LastText,0FFFFh
        jz @@1
        mov dx,LastText
        call Error
@@1:    jmp RepDone
ENDIF

CancelIt:
        push ax
        mov al,1
        mov CmdPhase,10
        call StartCmd
        pop ax
        retn

;
; StartCmd - v al parametr ( 1 = klavesa 1 )
;

StartCmd:
        push eax ebx cx edx bp
        mov bl,CmdPhase
        xor bh,bh
        mov cl,al
        mov eax,0EABECEDAh
        int 13h
        shl bx,2
        mov ebx,dword ptr cs:RetTable[bx]
        call Generic
        pop bp edx cx ebx eax
        retn

;
; Nova obsluha 13h - chytat callbacky
;

new13:
        cmp eax,35EC1515h
        jne @@1
        or bl,4
@@1:    cmp eax,CallBackSig
        jne old13
        sti
;        push bx
        pushad
        shr bx,8
        shl bx,2
        mov ebx,dword ptr cs:CallBack[bx]
        call Generic
;        pop bx
        popad
        clc
        retf 2

old13:  db 0EAh,0,0,0,0


IF ScrVer
;
; Report funkce
;
RetCode

DoReportFunc:
        mov ax,'00'
        mov word ptr cs:[offset RepSec-2],ax
        mov word ptr cs:[offset RepCyl-2],ax
        mov cs:[offset RepHead-1],al

        push ds
        mov ax,seg35sec
        mov ds,ax

        xor ax,ax
        mov bl,10
        mov al,ds:[108h]
        mov si,offset RepCyl - 1
        call Number
        mov al,ds:[107h]
        shr al,2d
        mov si,offset RepHead - 1
        call Number
        mov al,ds:[109h]
        mov si,offset RepSec - 1
        call Number
        pop ds
        retn
ENDIF

;
; Generic - nejak oznamit akci (v EBX co oznamit)
;

IF BeepVer
        INCLUDE genb.asm
ENDIF

Generic:
IF BeepVer
        push ebx
        Call GenB
        pop ebx
ENDIF
IF ScrVer

        test Config,0010h
        jz @@1
        mov dx,bx
        or bx,bx
        jz @@1
        call Error
@@1:
        mov LastText,bx
ENDIF
        retn

Install db '35cache 1.40 - cache interface for 35sec',13,10
        db '  1995 Pavel Machek',13,10,13,10
        db '  - reporting action by '
IF ScrVer - BothVer
        db 'texts'
ENDIF

IF BothVer
        db 'beeps & texts'
ENDIF

IF BeepVer - BothVer
        db 'beeps'
ENDIF
        db 13,10,'$'


nl      equ 13,10

errNo35sec db '35cache - Error: 35sec not found. Aborting.',13,10,'$'
errAlreadyThere db '35cache - Error: 35cache already loaded. ( /I overrides ) Aborting.',13,10,'$'
ErrHelp db nl,'Syntax:',nl
        db '  35cache? [/][options]',nl
        db 'Options:',nl
        db '',nl
        db '  CARL - specifies shift-keys to be pressed with hot key',nl
        db '         other shift keys may be pressed, too',nl
        db '          (Ctrl, Alt, Left shift, Right shift)',nl
        db '  T    - text always',nl
        db '  I    - install even if another copy of 35cache? is resident',nl
        db 'At least one of CARL options must be specified.',nl
        db 'Example:',nl
        db ' 35cacheo ca  - loads 35cache with Alt-Ctrl-?? as hotkeys.',nl,nl,'$'

Options db 'i',20h,'t',10h,'a',08h,'c',04h,'l',02h,'r',01h,'/',00h,'-',00h,' ',00h,0

;
;  ********     Inicializace      **********
;
init:
        mov eax,0EABECEDAh
        int 13h
        cmp eax,35EC35ECh
        jne no35sec
        mov ax,ds
        mov seg35sec,ax

        xor bx,bx

        call Parse

        or bx,bx
        jz Help
        mov Config,bx
        and bx,00Fh
        mov Key_Mask,bx

        mov eax,035EC1515h
        xor bx,bx
        int 13h
        test bx,4
        jnz AlreadyThere

Cont:
        InitInt 09h New09 Old09
        InitInt 13h New13 Old13

        push cs
        pop ds
        mov dx,offset Install
        mov ah,09h
        int 21h

        mov dx,offset Install+1
	int 27h

Parse:
        push cs
        pop ds
        mov ax,81h
        mov si,ax

@@2:
        lodsb           ; TACLR
        or al,20h
        lea di,Options-2
@@1:    add di,2
        cmp byte ptr cs:[di],0
        je ParseDone
        cmp al,cs:[di]
        jne @@1
        inc di
        or bl,cs:[di]
        jmp @@2
ParseDone:
        retn

AlreadyThere:
        test Config,20h
        jnz Cont
        mov dx,offset errAlreadyThere
        jmp WHalt

no35sec:
        mov dx,offset errNo35Sec
WHalt:
        push cs
        pop ds
        mov ah,09
        int 21h

        mov ax,4C01h
        int 21h

Help:
        lea dx,errHelp
        jmp WHalt

_seg	ends
	end start
