Program Mon35;

{$define NoLogo}

uses Crt, Dos, XMSovl, Screen, Logo;

const Reg = 2; {2...Registered}
               {1...Shareware}
               {3...Unknown}

const Norm = $1F;
      Nums = $1F-4;
      NGreen = $1A;
      NRed   = $1C;
      Ver    = '1.41';

{type TWordAr = array[0..256] of word;
     PWordAr = ^TWordAr;}

const Inter :boolean = false;

var PasBuf : array[1..512] of byte;

Function SearchMCBs( Name :PChar; Offs, Len :word ):pointer;
  var Res :pointer;

  Procedure IsFound(p :PChar);
    var i :integer;
        p1:PChar;
    begin
    word(p):=Offs;
    p1     :=Name;
    for i:=1 to Len do
      begin
      if UpCase(p1^)<>UpCase(p^) then exit;
      Inc(p);
      Inc(p1);
      end;
    Pointer(Res) := Pointer(p);
    end;

  type MCB       = record                                   { creates an MCB }
                     IdCode : char;   { "M" = another MCB follows, "Z" = end }
                     PSP : word;                { segment address of the PSP }
                     Paras : word; { number of paragraphs in controlled area }
                   end;
       MCBPTR    = ^MCB;                                 { pointer to an MCB }
       MCBPTRPTR = ^MCBPTR;                 { pointer to a pointer to an MCB }

  var Regs     : Registers;         { processor registers for interrupt call }
      CurMCB   : MCBPTR;                            { pointer to current MCB }
      EndIt     : boolean;                                { last MCB reached }

  begin
  {-- determine pointer to first MCB in memory ----------------------------}

  Res     := nil;
  Regs.AH := $52;                { function $52 returns address of the DIB }
  MsDos( Regs );
  CurMCB := MCBPTRPTR( ptr( Regs.ES, Regs.BX-4 ) )^;

  {-- process individual MCBs in memory -----------------------------------}

  EndIt     := FALSE;

  repeat
    {-- Determine if memory controlled by MCB has the ID string at the  ---}
    {-- same location as this program and it is not the current program.---}
    if (CurMCB^.PSP <> PrefixSeg) and
       (CurMCB^.PSP <> 0) then IsFound(Pointer(CurMCB));
    if ( CurMCB^.IDCode = 'Z' ) then        { is the current MCB the last? }
      EndIt := TRUE                                      { yes, end search }
    else                   { no, set pointer CurMCB to next MCB in storage }
      CurMCB := ptr( Seg(CurMCB^) + CurMCB^.Paras + 1, 0 );
  until ( Res <> nil ) or EndIt;

  SearchMCBs := Res;
  end;

Function GetAdr :pointer;
  const Sign :array[1..6] of char ='35SEC'#0;
  begin
  GetAdr := SearchMCBs(@Sign, 8, 5);
  end;

type TBitField = packed array[0..65534] of byte;
     PBitField = ^TBitField;

     PAr20 = ^TAr20;
     TAr20 = TBitField;
     Plongint = ^LongInt;

Function GetBit(What :Plongint; At :byte; Num :byte):longint;
  begin
  GetBit := (What^ shr At) and ((1 shl Num)-1) and $FFFF;
  end;

Procedure SetBit(Where :Plongint; How :longint; At :word);
  begin
  Where^ := (How shl At) or Where^;
  end;

Function GetBitArray(var Ar :Tar20; At :word; Num :byte):longint;
  var i,j :byte;
  begin
  i := At div 8;
  j := At mod 8;
  GetBitArray:=GetBit(@(Ar[i]), j, Num);
  end;

Procedure SetBitArray(var Ar :Tar20; How :LongInt; At :word);
  var i,j :byte;
  begin
  i := At div 8;
  j := At mod 8;
  SetBit(@(Ar[i]), How, j);
  end;

{$I-}
function GetExeBaseName : String;
  var ExeFileName: string;
  const ExeName = '35MON.EXE';
  begin
  ExeFileName := ParamStr(0);
  if ExeFileName = '' then
    ExeFileName := FSearch(EXEName, GetEnv('PATH'));
  ExeFileName := FExpand(ExeFileName);
  GetExeBaseName := ExeFileName;
  end;

Function XLoadScreen( s :string ):integer;
  var F :File;
  begin
  assign(F, s);
  Reset(F,1);
  Seek(F, FileSize(F)-4000);
  BlockRead(F, Ptr($B800,0)^, 4000);
  Close(F);
  XLoadScreen:=IOResult;
  end;

Procedure LoadScreen;
  begin
  if XLoadScreen( '35LOGO.BIN' )<>0 then
    XLoadScreen( GetExeBaseName );
  end;

{
olinadr  equ 0
ohandle  equ 4
olen     equ 6
ohead    equ 8
osec     equ 9
ocyl     equ 10
otable   equ 11
}

{$I E:\asm\35sec\35mon.inc}

Procedure DrawSlot( Slot :PSlot; y :byte; Num :byte );
  var Table :PAr20;
      XPos,x,i  :integer;
  begin
  GotoXY(25,y);
  TextAttr := NGreen;
  if Slot^.Handle <> 0 then
    begin
    Write('Buffer ',Num,' ');
    GotoXY(34,y);
    TextAttr := Nums;
    Write(' ( ',(Slot^.Cyl*Slot^.Head*Slot^.Sec div 2):4,' KB, ',
          Slot^.Cyl:2,' tracks, ',Slot^.Sec:2,' sectors, ',Slot^.Head,' sides )');
    end
                       else Write('Free slot ',Num,'                                           ');

  TextAttr := NRed;

  Table := @Slot^.Table;
  GotoXY(25,y+1); XPos := 25;
  if Slot^.Handle = 0 then i := -1
                      else i := Slot^.Cyl;
  for x := 0 to i-1 do
    begin
    Inc(XPos);
    if XPos = 80 then GotoXY(25,y+2);
    case GetBitArray( PAr20( Table )^, x*2, 2) and 3 of
      0: Write('|');
      1: Write(#$18);
      2: Write(#$19);
      3: Write(#$12);
      end;
    end;

  if i = -1 then i:=0;
  for x := i to 2*(80-25)-3 do
    begin
    Inc(XPos);
    if XPos = 80 then GotoXY(25,y+2);
    Write('');
    end;

  end;

Function XChr( X :byte ):Char;
  begin
  if X < 32 then XChr := '.'
            else XChr := Chr( X );
  end;

Procedure LookIntoXMS;

  Procedure Inspect( b :byte );
    var Slot :PSlot;
        i,j  :integer;
        SPFat:word;
    begin
    Slot := @Bufs^.BufSlot[b*32];
    ClrScr;
    GotoXY(1,1);
    if Slot^.Handle = 0 then begin WriteLn('<<< Slot is free >>>'); exit; end;
    MoveFromEMB( Slot^.Handle, 0, PasBuf, 512 );
    for i:=1 to 512 do Write(PasBuf[i],' ');
    WriteLn;
    ReadKey;

    MoveFromEMB( Slot^.Handle, 512, PasBuf, 512 );
    WriteLn('Boot record');
    WriteLn;
    WriteLn('OEM Name   :');
    for i:=3 to 10 do Write( XChr(PasBuf[i+1]) );
    SPFat := PWord( @PasBuf[$16+1] )^;
    WriteLn;
    WriteLn('Sec per FAT:',SPFat);
    ReadKey;
    j := 2;
    MoveFromEMB( Slot^.Handle, 512*(2*SPFat+j), PasBuf, 512 );
    for i:=1 to 512 do Write( XChr(PasBuf[i]) );
    WriteLn('This is sector ',j);
    ReadKey;
    end;

  begin
  case ReadKey of
    '1': Inspect(0);
    '2': Inspect(1);
    '3': Inspect(2);
    '4': Inspect(3);
    end;
  end;

Procedure MAt( b :byte; a :string );
  begin
  a := a +'                                                        ';
  a[0] := #44;
  TAt( 24, 1+b, NGreen, a );
  end;

Procedure Message( s :string );
  begin
  if Inter then
    begin
    s := s +'                                                        ';
    s[0] := #48;
    TAt( 33-8, 22, Nums, s );
    end
  else WriteLn('Message: '+s);
  end;

Procedure Parameters;
  var i,j :integer;
      s :string;
  begin
  for i:=1 to ParamCount do
    begin
    s := ParamStr(i);
    for j:=1 to length(s) do s[j]:=UpCase(s[j]);
    if Pos('/?',s) or Pos('/H',s) >0 then
      begin
{$ifndef nologo}
      PrintLogo('35 Monitor', Ver, 'Utility for 35sec', Reg);
{$endif}
      WriteLn('Command line switches');
      WriteLn('----------------------');
      WriteLn;
      WriteLn('  Without parameters - enter interactive mode');
      WriteLn('  /?   display this help screen');
      WriteLn('n = A,B m = 1..9[,0 for assign operations]');
      WriteLn('  /Rnm Read disk in drive n into buffer m');
      WriteLn('  /Wnm Write changed parts of buffer m onto disk in drive n');
      WriteLn('  /Fm  Free buffer number m');
      WriteLn('  /Anm Assign logical drive n to buffer m (using m=0..deassign)');
      WriteLn('  /Hnm write wHole memory image of buffer m onto disc in drive n');
      WriteLn('  /Snx Set sector sliding of drive n to x (x = 0..9)');
      WriteLn('  /C   Cancel current operation');
      WriteLn('  /!   Don''t enter interactive mode');
      Halt;
      end;
    s := s + '                ';
    if s[1] = '/' then
      case s[2] of
        'R': Oper( 1, s[3], s[4] );
        'W': Oper( 5, s[3], s[4] );
        'A': Oper( 3, s[3], s[4] );
        'H': Oper( 7, s[3], s[4] );
        'F': Oper( 9, 'A', s[3] );
        'C': Oper($A, 'A', '1' );
        'S': if (s[3] in ['A'..'B']) and (s[4] in ['0'..'9']) and (Rez<>nil) then
               begin
               Rez^.SecSlid0[ Ord(s[3])-Ord('@') ] := Ord(s[4])-Ord('0');
               end;
        '!': begin
{$ifndef nologo}
             PrintLogo('35 Monitor', Ver, 'Utility for 35sec', Reg);
             ReadKey;
             DoneLogo;
{$endif}
             Halt;
             end;
        '-': Halt;
        end;
    end;
  end;

var Table :Pointer;
const Name : PChar = '';
var x,y,i :integer;
    KRead, KMax :LongInt;
    KTrack      :LongInt;
    z           :integer;
    Max,Mem     :LongInt;
    StartMem    :LongInt;
    PrevPhase   :byte;
    GetTicks   :LongInt absolute 0:$46C;
    s          :string;
    c,d,e      :char;
    Cursor     :word;

begin
WriteLn('35mon - monitor of 35sec floppy accelerator');
WriteLn(' (c) 1995 Pavel Machek');
WriteLn;
{Rez := P35sec( GetAdr );}
Rez := P35sec( Ptr( Detect, $100 ) );
Pointer( Bufs ):= Rez;
Word( Bufs ) := Rez^.offBufs;
if ( Seg( Rez^ ) = 0 ) then Rez := nil;
if Rez = nil then WriteLn('Error: 35sec accelerator not installed.')
             else WriteLn('35sec accelerator found.');
if ParamCount > 0 then Parameters;

for i:=1 to 512 do PasBuf[i]:=0;
LoadScreen;

  asm
{  mov ax,01}
{  int 33h}
  mov ah,3
  mov bh,0
  int 10h
  mov Cursor,cx

  mov ah,01
  mov cx,2000h
  int 10h
  end;

HideCursor;
MAt(1, ' 35 Monitor version '+Ver+' - 1995 Pavel Machek' );
Inter := true;
Message(' Welcome... in world of Fast programs!');

{if Rez = nil then Message('Error: 35sec not loaded.')
             else Message('35sec loaded.');;}

if Rez = nil then TAt( 3,6, $CF, ' *** NOT FOUND *** ');

while true do
  begin
  if Rez <> nil then
    begin
    TextAttr:=$C0;
    case Rez^.Phase of
     0:   TAt(13,6,Nums,'  Ready  ');
     1:   TAt(13,6,$C0 ,' SEEKING ');
     2,3: case Rez^.WriteEn of
            0 : TAt(13,6,$C0 ,' READING ');
            1 : TAt(13,6,$C0 ,' WRITING ');
            2 : TAt(13,6,$C0 ,' Writing ');
            end;

     4,5: TAt(13,6,$C0 ,' CleanUp ');
     $80: TAt(13,6,Nums,'  Done   ');
     else TAt(13,6,$C0 ,' ??????? ');
     end;

    TextAttr:=Nums;
    {Sector Head Track}
    z := -1;
    WriteChar(10, 7+z, Nums, 1, Chr(Ord('A')+Rez^.Disk ));

    NAt(13, 8+z, Nums, Rez^.Sec    ,3);
    NAt(19, 8+z, Nums, Rez^.NumSec ,3);

    NAt(13, 9+z, Nums, Rez^.Head shr 2  ,3);
    NAt(19, 9+z, Nums, Rez^.NumHead     ,3);

    NAt(13,10+z, Nums, Rez^.Cyl         ,3);
    NAt(19,10+z, Nums, Rez^.NumCyl      ,3);

    KTrack := Rez^.NumSec * 5;
    KRead := (Rez^.NumSec - Rez^.Sec2R)*5 + (Rez^.Head shr 2)*KTrack + (Rez^.Cyl*KTrack*2);

{    if ((Rez^.Phase and $7F)>0) and ((PrevPhase and $7F)=0) then
      begin
      StartTime := GetTicks;
      StartMem  := KRead;
      end;}
    PrevPhase := Rez^.Phase;

    NAt(13,11+z, Nums, KRead div 10  ,4);
    NAt(18,11+z, Nums, KRead mod 10  ,1);

    z:=0;
    for i:=1 to 2 do
      begin
      NAt( 6+((i-1)*10),13 , Nums, Rez^.SecSlid0[i]  ,2 );
      end;

    TextAttr := NRed;
    for i:=1 to 2 do
      begin
      case Rez^.CurBuf0[i] of
        0 :    TAt( 6, 13+2+i, NRed  , ' Unassigned ');
        1..4 : begin
               TAt( 6, 13+2+i, NGreen, ' Buffer     ');
               NAt(15, 13+2+i, NGreen, Rez^.CurBuf0[i]   ,1);
               end;
        else   TAt( 6, 13+2+i, NRed  , ' ?? Error ??');
        end;
      end;

{    Max := XMSMaxAvail;
    Mem := XMSMemAvail;}
    Mem := Rez^.TSecBad;
    Max := 0;
    if Max = Mem then
      TAt( 12, 19, Nums, '= ' )
    else
      TAt( 12, 19, Nums, '> ' );
    NAt( 14, 19, Nums, Max ,5 );

    if PrevPhase and $7F <> 0 then
      begin
      RAt( 13, 20, Nums, (GetTicks - Rez^.TimeStart)/18.2  ,5,2 );
      if GetTicks - Rez^.TimeStart <> 0 then
        RAt( 11, 21, Nums, Trunc( KRead / ( (GetTicks - Rez^.TimeStart)/18.2 ) ) ,5,0);
      end
    else
      begin
      RAt( 13, 20, Nums, (Rez^.TimeEnd - Rez^.TimeStart)/18.2  ,5,2 );
      if Rez^.TimeEnd - Rez^.TimeStart <> 0 then
        RAt( 11, 21, Nums, Trunc( KRead / ( (Rez^.TimeEnd - Rez^.TimeStart)/18.2 ) ) ,5,0);
      end;


{    KMax  := (Rez^.NumCyl*KTrack*2);

    GotoXY(12,12+z); Write(' ',(KMax) div 10 :4);
    GotoXY(18,12+z); Write(KMax mod 10);}

    for y:=0 to 3 do
      DrawSlot( @Bufs^.BufSlot[y*32], y*4 + 6, y+1);

    Message( GetErrText( Rez^.LastErr ) );
    end;
  if KeyPressed then
    begin
    c := UpCase(ReadKey);
    case c of
      'X',#27 : begin
                CursorXY(1,24);
                TextColor(White);
                TextBackground(0);
                  asm
                  mov ah,01
                  mov cx,Cursor
                  int 10h
                  end;
                ClrScr;
{$ifndef nologo}
                PrintLogo('35 Monitor', Ver, 'Utility for 35sec', Reg);
                ReadKey;
                DoneLogo;
{$endif}
                Halt;
                end;
      'L': begin LoadScreen; end;
      'O': Rez := nil;
      'A': Rez^.SecSlid0[1]:=(Rez^.SecSlid0[1]+1) mod 7;
      'B': Rez^.SecSlid0[2]:=(Rez^.SecSlid0[2]+1) mod 7;

      'R','W','P','S':
           begin
           case c of
             'R': s := 'Read';
             'W': s := 'Write whole';
             'R': s := 'Write part';
             'S': s := 'Assign';
             end;
           Message( s+ ': Press A or B to select drive.' );

           d := UpCase( ReadKey );
           if not (d in ['A','B']) then
             begin
             Message( s+ ': Cancelled. (Key)');
             ReadKey;
             end
           else
             begin
             if c <> 'S' then
               Message( s+ ': Press 1..9 to select buffer.' )
             else
               Message( s+ ': Press 1..9 to assign, 0 to deassign.');
             e := UpCase( ReadKey );
             if not (e in ['1'..'9','0']) then
               begin
               Message( s+ ': Cancelled. (Key)');
               ReadKey;
               end
             else
               case c of
                 'R': Oper( 1, d, e );
                 'P': Oper( 5, d, e );
                 'W': Oper( 7, d, e );
                 'S': Oper( 3, d, e );
                 end;
             end;
           end;
      'F': begin
           Message('Free: Press 1..9 to select buffer.' );
           e := UpCase( ReadKey );
           if not (e in ['1'..'9']) then
             begin
             Message( s+ ': Cancelled. (Key)');
             ReadKey;
             end;
           Oper( 9, 'A', e );
           end;
      'C': Oper( $A, 'A', '1' );
      end;
    end;
  end;

end.

