;
;           User interface
;           Part of "The Super Console Defender"
;           Copyright (c) RaMax (Rayevskiy Maxim) 1994-1996            
;                                                          
dialog:                                                    
            cli                                            
            mov    cs:keep_sp,sp ; Freeze an old stack
            mov    cs:keep_ss,ss ; and create a new one
            mov    ax,  cs                             
            mov    ss,  ax                             
            mov    sp,  100h                           
            sti                                        
                                                       
irp         register, bx,cx,dx,si,di,bp,ds,es 
            push register                     
endm                                          
            mov    ds,  ax ; make data addressable
            mov    es,  ax                        
            inc    status  ; set the "in dialog" flag
                                                     
            mov    ax,  0002h ;mouse off (dirty direct call)
            pushf                                           
            call   far ptr cs:mousedrv                      
                                                            
            mov    ah,  15    ; get the video mode
            int    10h                                      
            cmp    al,  3     ; Is it text mode?
            jbe    @go        ; Yes, continue   
            or     options,graphics; No, set the "graphics" flag
            jmp    @graphic   ; Skip the code for the text mode
@go:                                                           
            and    options, NOT graphics;clear the "graphics" flag 
                                        ; (just in case)
;Now, open the window                                 
            Open_Window video_page,  @nontext, box, begin, left, right, top, bottom, 0ch
            mov    ah,  1 ;Set the cursor to the blinking underscore 
            mov    cx,  0e0fh 
            int    10h       
            mov    ah,  2 ;Position the cursor to the beginning of the input line
            mov    bh,  video_page                                               
            mov    dx,  0b1ch  
            int    10h                                                           
                             
@txt:                        
            mov    ax,  1300h; Display the status info
            mov    bh,  video_page                    
            mov    bl,  15; White on black            
            mov    cx,  28; Length of the string
            mov    dx,  0c1ah; Position for output (dh=row,dl=column)
            test   status,closed; Depending on the status, select the approproate
            jnz    @closed      ; message                
            mov    bp,  offset enter2close            
            int    10h                                
            jmp    @dr2                               
@closed:                                              
            mov    bp,  offset enter2open             
            int    10h                                
            mov    ax,  1300h; If the console is locked, display
            mov    bh,  video_page; additional message
            mov    bl,  15        ; White on black
            mov    cx,  14        ; Length                    
            mov    dx,  0d20h     ; Position                    
            mov    bp,  offset closedmess   
            int    10h                      
                                            
@graphic:                                   
@dr2:       mov    count,  0; Reset the temporary buffer
@10:        mov    ah,  0      ;Wait the symbol
            int    16h                      
            call   UpCase      
            mov    dh,  al     ; Save the letter code
            cmp    al,  1bh    ; if Esc then leave the dialog
            jne    @enter                                    
            test   options,graphics                          
            jz     b60               
            jmp    @70               
@enter:     cmp    al,  13 ; Enter ? 
            jne    @mor    ; No, some more checking
            jmp    @check  ; Yes, check the password  
@mor:                                               
            cmp    al,  8  ; Backspace ?            
            jne    @allow  ; No, check the validity of the symbol
            cmp    count,1 ; Yes, delete last symbol (if any)
            jl     @10      
            dec    count               
            mov    ah,  3  ; And move the cursor one position back in the row
            mov    bh,  video_page                                        
            test   options,graphics                          
            jnz    @10     
            int    10h     
            dec    dl    
            mov    ah,  2  
            int    10h     
            mov    ax,  0920h
            mov    bl,  15   
            mov    cx,  1    
            int    10h       
            jmp    @10  ; And back to wainting the symbol
                                                         
b60:        jmp    a60                                   
                                                         
@nontext:                                                
            or     options,graphics ; set the "graphics" flag
            ; This regulat verification allows the "Defender" to run 
            ; in the background of the programs which change the video mode
            jmp    @10                                                     
                                                                           
;           The validity check                                 
@allow:                                                                    
            cmp    al,  20
            jb     @10        
            cmp    al,  ''
            ja     @10     
                           
;           At this point all the symbols are valid
            cmp    count,24 ; The limit is 25 symbols
            ja     @10                               
            mov    al,  dh  ; The symbol is stored in the buffer
            mov    dx,  count                                   
            mov    di,  dx                                      
            mov    byte ptr [offset password + di], al          
            inc    count    ; increment the counter               
            test   options,graphics ; if the video card is not in graphics mode                
            jnz    @10              ; display the 'star' symbol and move the cursor
            mov    ah,  09h                       
            mov    al,  '*'                                                         
            mov    bh,  video_page  
            mov    bl,  15          
            mov    cx,  1           
            int    10h              
            mov    ah,  3           
            mov    bh,  video_page  
            int    10h              
            mov    ah,  2           
            inc    dl               
            int    10h              
            jmp    @10              ; Wait the next symbol
@check:                                                   
            cld    ; Data transfer
            cmp    count, 0          ; If the buffer is empty, then wait the next symbol
            ja     @smthtocheck                                                         
            jmp    @10                                                                  
@smthtocheck:
            test   status,closed     ; If the console is locked, then compare the 
            jnz    @checkrights      ; passwords                                             
            mov    cx,  count        ; If not, transfer the pass to the main buffer
            mov    passcount,cx                                                    
            lea    di,  userpass                                                   
            lea    si,  password                                                   
            rep    movsb                                                           
            call   lock              ; Lock the console                             
            jmp    a60               ; Close the window                                      
                                                       
@checkrights:                                          
            mov    cx,  count        ; If the lengths of two passwords are not equal 
                                     ; try the backdoor                          
            cmp    cx,  passcount                      
            jne    @error
            lea    si,  userpass     ; Load the registers
            lea    di,  password                         
@docheck:                                     
            repe   cmpsb            ; Compare
            jne    @error;Not equal? Too bad, display the message
            call   unlock;All correct? What are you wainting for? Unlock!   
            jmp    a60   ; And leave the dialog                            
@error:                                        
            test   options,graphics
            jnz    @70                         
            mov    ax,  1300h; Display the message
            mov    bh,  video_page                
            mov    bl,  15                        
            mov    cx,  18                        
            mov    dx,  0d21h                     
            mov    bp,  offset incorrect          
            int    10h                            
            mov    ah,  2                         
            mov    dx,  0c19h                     
            int    10h                            
            mov    ah,  09        
            mov    al,  ' '                       
            mov    cx,  31
            int    10h    
            mov    ah,  0 ; And wait for any key
            int    16h                                   
;                                               
;           Close the window                      
;                                               
                                                
                                                
                            
a60:                        
            test   options,graphics
            jnz    @70             
            Close_Window video_page,begin,left,right,top,bottom
@70:                               
            mov    ax,  0001h ; Mouse on
            pushf                       
            call   far ptr cs:mousedrv  
            xor    al,  al    ; Frame off
            call   border                
            cli                          
            and    status, NOT indialog; Clear the "in dialog" flag
            and    options, NOT graphics                           
      irp   register, es,ds,bp,di,si,dx,cx,bx                      
            pop    register              
      endm                                                         
            mov    ss,cs:keep_ss    ;Restore the previous stack
            mov    sp,cs:keep_sp               
            sti                     
            pop    ax               
            iret 
