/*
 * This file is part of fdnpkg
 * Copyright (C) Mateusz Viste 2012
 * 
 * It contains a few helper function...
 */


#include <ctype.h>  /* tolower() */
#include <string.h> /* */
#include "helpers.h"


/* change all / to \ in a string */
void slash2backslash(char *str) {
  int x;
  for (x = 0; str[x] != 0; x++) {
    if (str[x] == '/') str[x] = '\\';
  }
}


/* converts a string to all lowercase */
void strtolower(char *mystring) {
  int x;
  for (x = 0; mystring[x] != 0; x++) mystring[x] = tolower(mystring[x]);
}


/* Find the first occurrence of find in s, ignore case. */
char *fdnpkg_strcasestr(const char *s, const char *find) {
  char c, sc;
  size_t len;
  if ((c = *find++) != 0) {
    c = tolower((unsigned char)c);
    len = strlen(find);
    do {
      do {
        if ((sc = *s++) == 0) return(NULL);
      } while ((char)tolower((unsigned char)sc) != c);
    } while (strncasecmp(s, find, len) != 0);
    s--;
  }
  return ((char *)s);
}
