/*
   This file is part of fdnpkg.
   Copyright (C) Mateusz Viste 2012
*/

#include <stdio.h>
#include <string.h>  /* strstr() */
#include <ctype.h>   /* toupper() */
#include "kprintf.h"
#include "pkgsrch.h"
#include "helpers.h" /* fdnpkg_strcasestr() */


/* #ifndef HAVE_STRCASESTR */
/* if we have no strcasestr, let's implement it now */
/*static char *strcasestr(char *haystack, char *needle) {
  char *p, *startn = 0, *np = 0;
  for (p = haystack; *p; p++) {
    if (np) {
        if (toupper(*p) == toupper(*np)) {
            if (!*++np) return startn;
          } else {
            np = 0;
        }
      } else if (toupper(*p) == toupper(*needle)) {
        np = needle + 1;
        startn = p;
    }
  }
  return(0);
}
#endif */


void pkgsearch(struct pkgdb *pkgdb, char *searchterm, int verbosemode, char **repolist) {
  int matchflag, matchtimes = 0;
  struct pkgdb *curpkg;
  struct pkgrepo *currep;
  puts("");
  for (curpkg = pkgdb->nextpkg; curpkg != NULL; curpkg = curpkg->nextpkg) {
    if (searchterm == NULL) {
        matchflag = 1;
      } else {
        matchflag = 0;
        if (fdnpkg_strcasestr(curpkg->name, searchterm) != NULL) matchflag = 1; /* look into pkg name */
        if (fdnpkg_strcasestr(curpkg->desc, searchterm) != NULL) matchflag = 1; /* look into pkg desc */
    }
    if (matchflag != 0) { /* display the package */
      printf("%s - %s\r\n", curpkg->name, curpkg->desc);
      if (verbosemode) {
        for (currep = curpkg->repolist; currep != NULL; currep = currep->nextrepo) {
          printf("  -> %s %s at %s\r\n", curpkg->name, currep->version, repolist[currep->repo]);
        }
        puts("");
      }
      matchtimes++;
    }
  }
  if (matchtimes == 0) kitten_puts(5, 0, "No package matched the search.");
}
